<?php
/**
 * Requires the WP-SCSS plugin to be installed and activated.
 */


if ( ! function_exists( 'towy_get_theme_colors_defaults' ) ) :
    /**
     * Return default values for uninitialized theme mods.
     * https://make.wordpress.org/themes/tag/theme-mods-api/
     */

    function towy_get_theme_colors_defaults() {

        $defaults = array(
            'accent_color_1' =>  '#ffc326',
            'accent_color_2' => '#e23751',
            'accent_color_3' => '#ff9402',
        );
        return apply_filters( 'towy_theme_colors_defaults', $defaults );
    }
endif;


/* towy_set_color_palette */
if ( !function_exists( 'towy_set_color_palette' ) ) {
    function towy_set_color_palette(): array {
        $color_palette = towy_get_theme_colors_defaults();
        $array = array();
        foreach($color_palette as $val) {
            $array[] = $val;
        }
        return $array;
    }
} //towy_set_color_palette

if ( ! function_exists( 'towy_get_theme_colors' ) ) :
    /**
     * Return default values for uninitialized theme mods.
     * https://make.wordpress.org/themes/tag/theme-mods-api/
     */
    function towy_get_theme_colors(): array {

        $colors = array(
            'accent_color_1' => '#ffc326',
            'accent_color_2' => '#e23751',
            'accent_color_3' => '#ff9402',
        );

        if ( function_exists(  'fw_get_db_customizer_option' ) ) :
            foreach ( $colors as $color_id => $color_value ) {
                $customizer_color = fw_get_db_customizer_option( $color_id );
                if ( ! empty( $customizer_color ) ) {
                    $colors[ $color_id ] = $customizer_color;
                }
            }
        endif;

        return $colors;
    }
endif;

if ( ! function_exists( 'towy_action_customizer_enqueue_css_variables_script' ) ) :
    function towy_action_customizer_enqueue_css_variables_script() {

        wp_register_script(
            'towy-customizer-scss',
            TOWY_THEME_URI . '/js/theme-customizer-scss.js',
            array( 'jquery','customize-preview' ),
            TOWY_THEME_VERSION,
            true
        );

        wp_enqueue_script(
            'towy-customizer-scss'
        );
    }
endif;