<?php
/**
 * Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

//load parent CSS
if ( ! function_exists( 'towy_child_enqueue_static' ) ) :
	/**
	 * towy_child_enqueue_static
	 *
	 * @return void
	 * @since 1.0.0
	 */
	function towy_child_enqueue_static() {
		wp_enqueue_style(
			'towy-child-style',
			get_stylesheet_directory_uri() . '/style.css',
			array( 'towy-main' ),
			wp_get_theme()->get( 'Version' )
		);
	}
endif;
add_action( 'wp_enqueue_scripts', 'towy_child_enqueue_static', 999 );