<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'social_icons' => array(
		'type'            => 'addable-box',
		'value'           => '',
		'label'           => esc_html__( 'Social Buttons', 'towy' ),
		'desc'            => esc_html__( 'Optional social buttons', 'towy' ),
		'template'        => '{{=icon}}',
		'box-options'     => array(
			'icon'       => array(
				'type'  => 'icon',
				'label' => esc_html__( 'Social Icon', 'towy' ),
				'set'   => 'social-icons',
			),
			'icon_class' => array(
				'type'        => 'select',
				'value'       => '',
				'label'       => esc_html__( 'Icon type', 'towy' ),
				'desc'        => esc_html__( 'Select one of predefined social button types', 'towy' ),
				'choices'     => array(
					''                                    => esc_html__( 'Default', 'towy' ),
					'border-icon'                         => esc_html__( 'Simple Bordered Icon', 'towy' ),
					'border-icon rounded-icon'            => esc_html__( 'Rounded Bordered Icon', 'towy' ),
					'bg-icon'                             => esc_html__( 'Simple Background Icon', 'towy' ),
					'bg-icon rounded-icon'                => esc_html__( 'Rounded Background Icon', 'towy' ),
					'color-icon bg-icon'                  => esc_html__( 'Color Light Background Icon', 'towy' ),
					'color-icon bg-icon rounded-icon'     => esc_html__( 'Color Light Background Rounded Icon', 'towy' ),
					'color-icon'                          => esc_html__( 'Color Icon', 'towy' ),
					'color-icon border-icon'              => esc_html__( 'Color Bordered Icon', 'towy' ),
					'color-icon border-icon rounded-icon' => esc_html__( 'Rounded Color Bordered Icon', 'towy' ),
					'color-bg-icon'                       => esc_html__( 'Color Background Icon', 'towy' ),
					'color-bg-icon rounded-icon'          => esc_html__( 'Rounded Color Background Icon', 'towy' ),

				),
				/**
				 * Allow save not existing choices
				 * Useful when you use the select to populate it dynamically from js
				 */
				'no-validate' => false,
			),
			'icon_url'   => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Icon Link', 'towy' ),
				'desc'  => esc_html__( 'Provide a URL to your icon', 'towy' ),
			)
		),
		'limit'           => 0, // limit the number of boxes that can be added
		'add-button-text' => esc_html__( 'Add', 'towy' ),
		'sortable'        => true,
	)
);