<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) {
    exit;
  }

  // Configuration sets tooltip
  if (defined('BMI_PREMIUM_TOOLTIP')) {
    $configu_sets = str_replace('"', "'", BMI_PREMIUM_TOOLTIP);
  } else $configu_sets = '';

?>
<script type="text/javascript">
  if (document.querySelector('#modal-css')) document.querySelector('#modal-css').remove();
</script>
<style>
  #wpfooter { display: none !important; }
  #wpfooter #footer-left { display: none; }
  #wpfooter #footer-upgrade { display: none; }
  #wp-auth-check-wrap { display: none !important; }
  .modal { transform: translateY(0%) !important; }
</style>
<div id="bmi-preload">
  <div class="progress">
    <div class="indeterminate"></div>
  </div>
</div>

<div id="bmi" style="display: none;">

  <!-- Translations for JS -->
  <?php require_once 'translations.php'; ?>

  <!-- Plugin Title -->
  <div class="heading f30 semibold">
    <?php _e('Welcome to Backup & Migration!', 'backup-backup'); ?>
  </div>

  <!-- TABS -->
  <div class="tabs cf shadow rbb">
    <div class="tab left semibold f22 active pointer transition" data-point="create-backup-wrapper">
      <?php _e('Create backup(s)', 'backup-backup') ?>
    </div>
    <div id="marbs" class="tab left semibold f22 pointer transition" data-point="manage-restore-wrapper">
      <?php _e('Manage & Restore Backup(s)', 'backup-backup') ?>
    </div>
  </div>

  <!-- Error handling -->
  <?php require_once 'modules/email-errors.php'; ?>

  <!-- @@TAB@@ Create backups(s) -->
  <div class="tab-wrapper" id="create-backup-wrapper">

    <!-- BACKUP BTNS -->
    <?php require_once 'modules/backup_controller.php'; ?>

    <!-- CONFIGURATION HEADER -->
    <div class="cf section-bmi lh30">
      <div class="left f20">
        <?php _e('Configuration options', 'backup-backup') ?>
      </div>
      <div class="right f18 secondary premium-wrapper" tooltip="<?php echo $configu_sets; ?>">
        <div class="premium premium-img">
          <?php _e('+ Add / manage configuration set(s)​', 'backup-backup') ?>
        </div>
      </div>
    </div>

    <!-- CONFIGURATION SECTION 1 -->
    <div class="collapser section-bmi shadow" id="exlucde-parts" group="configuration">
      <div class="header f20 pointer transition">
        <span class="bold"><?php _e('What', 'backup-backup') ?></span> <?php _e('will be backed up?​', 'backup-backup') ?>
      </div>
      <div class="content save-action f20" data-save="save-file-config">

        <?php require_once 'chapter/what_backed_up.php'; ?>

      </div>
    </div>

    <!-- CONFIGURATION SECTION 2 -->
    <div class="collapser section-bmi shadow" group="configuration">
      <div class="header f20 pointer transition">
        <span class="bold"><?php _e('Where', 'backup-backup') ?></span> <?php _e('shall the backup(s) be stored?', 'backup-backup') ?>
      </div>
      <div class="content save-action" data-save="save-storage">

        <?php require_once 'chapter/where_config.php'; ?>

      </div>
    </div>

    <!-- CONFIGURATION SECTION 3 -->
    <div class="collapser section-bmi shadow" group="configuration">
      <div class="header f20 pointer transition">
        <span class="bold"><?php _e('How', 'backup-backup') ?></span> <?php _e('shall the backup(s) be stored?', 'backup-backup') ?>
      </div>
      <div class="content save-action" data-save="store-config">

        <?php require_once 'chapter/store_config.php'; ?>

      </div>
    </div>

    <!-- SECTION DIVIDER -->
    <hr class="section-bmi">

    <!-- GLOBAL CONFIGURATION -->
    <div class="collapser section-bmi shadow" id="other-options" group="configuration">
      <div class="header f20 pointer transition"><span class="bold"><?php _e('Other options', 'backup-backup') ?></span></div>
      <div class="content save-action" data-save="save-other-options">

        <?php require_once 'chapter/other_config.php'; ?>

      </div>
    </div>

    <!-- TROUBLESHOOTING -->
    <div class="collapser section-bmi shadow" id="troubleshooting-chapter" group="configuration">
      <div class="header f20 pointer transition"><span class="bold"><?php _e('Troubleshooting', 'backup-backup') ?></span></div>
      <div class="content">

        <?php require_once 'chapter/troubleshooting.php'; ?>

      </div>
    </div>

  </div>

  <!-- @@TAB@@ Manage backups(s) -->
  <div class="tab-wrapper rbb mbl" id="manage-restore-wrapper" style="display: none;">

    <!-- Super Quick Migration -->
    <?php require_once 'modules/super-quick-migration.php'; ?>

    <div class="restore-wrapper shadow fullwidth rbb rbt">
      <div class="f22 regular m mbl"><?php _e("Your saved backups:", 'backup-backup'); ?></div>

      <!-- Super Quick Migration -->
      <div class="quick-migration m">

        <!-- Templates -->
        <div style="display: none; visibility: none;" class="hide">

          <!-- Backup Row Template -->
          <?php require_once 'templates/backup-row-template.php'; ?>

          <!-- Exclusion Rule Row Template -->
          <?php require_once 'templates/exclusion-rule-template.php'; ?>

          <!-- Dropdown Template -->
          <?php require_once 'templates/dropdown-template.php'; ?>

          <!-- Dropdown Option Template -->
          <?php require_once 'templates/option-template.php'; ?>

        </div>

        <!-- Backups TABLE -->
        <div class="">

          <div class="table-wrapper">
            <table>
              <thead>

                <!-- Table Header -->
                <?php require_once 'modules/backups-table-header.php'; ?>

              </thead>
              <tbody id="bmi_restore_tbody" data-empty="<?php _e('You have not created any backups yet.', 'backup-backup'); ?>">
                <tr>
                  <td colspan="100%"><?php _e('You have not created any backups yet.', 'backup-backup'); ?></td>
                </tr>
              </tbody>
            </table>
          </div>

          <!-- Backup options -->
          <?php require_once 'modules/backups-under-table.php'; ?>

        </div>

        <!-- Upload Backup -->
        <?php require_once 'modules/upload-backup.php'; ?>

      </div>

    </div>
  </div>

  <!-- Premium status -->
  <?php do_action('bmi_premium_status'); ?>

  <!-- Modals -->
  <?php require_once 'modals/upload-invalid-manifest-modal.php'; ?>
  <?php require_once 'modals/backup-progress-modal.php'; ?>
  <?php require_once 'modals/backup-success-modal.php'; ?>
  <?php require_once 'modals/prenotice-modal.php'; ?>
  <?php require_once 'modals/pre-restore-modal.php'; ?>
  <?php require_once 'modals/backup-error-modal.php'; ?>
  <?php require_once 'modals/restore-progress-modal.php'; ?>
  <?php require_once 'modals/restore-success-modal.php'; ?>
  <?php require_once 'modals/restore-error-modal.php'; ?>
  <?php require_once 'modals/upload-wrong-file-modal.php'; ?>
  <?php require_once 'modals/upload-exist-file-modal.php'; ?>
  <?php require_once 'modals/upload-success-modal.php'; ?>
  <?php require_once 'modals/delete-confirm-modal.php'; ?>
  <?php require_once 'modals/reset-confirm-modal.php'; ?>
  <?php require_once 'modals/bfs-modal.php'; ?>
  <?php require_once 'modals/after-logs-sent.php'; ?>
  <?php require_once 'modals/freeze-loading.php'; ?>
  <?php //require_once 'modals/logs-sharing-ask.php'; ?>
  <?php do_action('bmi_load_premium_modals'); ?>

  <!-- Other modules -->
  <?php require_once 'modules/backup-ongoing.php'; ?>
  <?php require_once 'modules/support-chat.php'; ?>

</div>

<!-- Carrousel -->
<div id="bmi_carrousel" style="display: none;">
  <?php do_action('ins_global_print_carrousel'); ?>
</div>
