<?php

  // Namespace
  namespace BMI\Plugin\Heart;

  // Allow only POST requests
  if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    exit;
  }

  // Make sure getallheaders will work
  if (!function_exists('__getallheaders')) {
    function __getallheaders() {
      $headers = [];
      foreach ($_SERVER as $name => $value) {
        if (substr($name, 0, 5) == 'HTTP_') {
          $headers[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
        }
      }
      return $headers;
    }
  }

  // Get fields from header
  if (function_exists('getallheaders')) {
    $fields = getallheaders();
  }

  // Check headers
  if (!isset($fields['Content-Content']) && !isset($fields['content-content'])) {
    $fields = __getallheaders();
  }

  // Lowercase
  foreach ($fields as $key => $value) {
    $buffer = $value;
    unset($fields[$key]);
    $fields[strtolower($key)] = $value;
  }

  // Let other files know that it's CURL request
  define('BMI_CURL_REQUEST', true);
  define('BMI_CLI_REQUEST', false);

  // Load some constants
  define('ABSPATH', $fields['content-abs']);
  if (substr($fields['content-content'], -1) != '/') {
    $fields['content-content'] = $fields['content-content'] . '/';
  }
  if (!defined('WP_CONTENT_DIR')) {
    define('WP_CONTENT_DIR', $fields['content-content']);
  }
  define('BMI_CONFIG_DIR', $fields['content-configdir']);
  define('BMI_BACKUPS', $fields['content-backups']);
  define('BMI_ROOT_DIR', $fields['content-dir']);
  // define('BMI_SHARE_LOGS_ALLOWED', $fields['content-shareallowed']);
  define('BMI_INCLUDES', BMI_ROOT_DIR . 'includes');
  define('BMI_SAFELIMIT', intval($fields['content-safelimit']));

  // Replace error-log file
  @ini_set('log_errors', 1);
  @ini_set('error_log', BMI_CONFIG_DIR . '/background-errors.log');

  // Increase max execution time
  @set_time_limit(259200);
  @ini_set('memory_limit', (BMI_SAFELIMIT * 4 + 16) . 'M');
  @ini_set('max_input_time', '259200');
  @ini_set('max_execution_time', '259200');
  @ini_set('session.gc_maxlifetime', '1200');

  // Let the server know it's server-side script
  ignore_user_abort(true);

  if (!isset($fields['content-browser'])) $fields['content-browser'] = false;
  if (!($fields['content-browser'] === 'true' || $fields['content-browser'] === true)) {

    // Also return something, so it can close the connection
    ob_start();

    // The message
    echo 'This is server side script, you will not get any response here.';

    // Don't block server handler
    session_write_close();

    // Set proper headers
    header('Content-Length: ' . ob_get_length());
    header('Connection: close');

    // End the output for user
    ob_end_flush();
    flush();

  }

  // Start output for server
  ob_start();

  // Catch anything if possible
  try {

    // Load bypasser
    require_once BMI_INCLUDES . '/bypasser.php';
    $request = new BMI_Backup_Heart(true,
      $fields['content-configdir'],
      $fields['content-content'],
      $fields['content-backups'],
      $fields['content-abs'],
      $fields['content-dir'],
      $fields['content-url'],
      [
        'identy' => $fields['content-identy'],
        'manifest' => $fields['content-manifest'],
        'safelimit' => $fields['content-safelimit'],
        'rev' => $fields['content-rev'],
        'backupname' => $fields['content-name'],
        'start' => $fields['content-start'],
        'filessofar' => $fields['content-filessofar'],
        'total_files' => $fields['content-total'],
        'browser' => $fields['content-browser']
        // 'shareallowed' => $fields['content-shareallowed']
      ],
      $fields['content-it'],
      $fields['content-dbit'],
      $fields['content-dblast']
    );

    // Handle request
    $request->handle_batch();

  } catch (\Exception $e) {

    error_log('There was an error with Backup Migration plugin: ' . $e->getMessage());
    error_log(strval($e));

  } catch (\Throwable $e) {

    error_log('There was an error with Backup Migration plugin: ' . $e->getMessage());
    error_log(strval($e));

  }

  // End the server task
  ob_end_clean(); exit;
