DROP TABLE IF EXISTS wprg_actionscheduler_actions;

CREATE TABLE `wprg_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wprg_actionscheduler_actions VALUES("40", "wc-admin_import_customers", "complete", "2023-03-04 05:56:05", "2023-03-04 05:56:05", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677909365;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677909365;}", "4", "1", "2023-03-04 05:56:18", "2023-03-04 05:56:18", "0", "");
INSERT INTO wprg_actionscheduler_actions VALUES("41", "wc-admin_delete_user_customers", "complete", "2023-03-04 05:59:57", "2023-03-04 05:59:57", "[3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677909597;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677909597;}", "4", "1", "2023-03-04 06:00:03", "2023-03-04 06:00:03", "0", "");
INSERT INTO wprg_actionscheduler_actions VALUES("42", "wc-admin_delete_user_customers", "complete", "2023-03-04 06:00:13", "2023-03-04 06:00:13", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677909613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677909613;}", "4", "1", "2023-03-04 06:01:20", "2023-03-04 06:01:20", "0", "");

DROP TABLE IF EXISTS wprg_actionscheduler_claims;

CREATE TABLE `wprg_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=24006 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS wprg_actionscheduler_groups;

CREATE TABLE `wprg_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wprg_actionscheduler_groups VALUES("1", "action-scheduler-migration");
INSERT INTO wprg_actionscheduler_groups VALUES("2", "action-scheduler-migration");
INSERT INTO wprg_actionscheduler_groups VALUES("3", "woocommerce-db-updates");
INSERT INTO wprg_actionscheduler_groups VALUES("4", "wc-admin-data");
INSERT INTO wprg_actionscheduler_groups VALUES("5", "wpforms");

DROP TABLE IF EXISTS wprg_actionscheduler_logs;

CREATE TABLE `wprg_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wprg_actionscheduler_logs VALUES("98", "40", "action created", "2023-03-04 05:56:00", "2023-03-04 05:56:00");
INSERT INTO wprg_actionscheduler_logs VALUES("99", "40", "action started via WP Cron", "2023-03-04 05:56:18", "2023-03-04 05:56:18");
INSERT INTO wprg_actionscheduler_logs VALUES("100", "40", "action complete via WP Cron", "2023-03-04 05:56:18", "2023-03-04 05:56:18");
INSERT INTO wprg_actionscheduler_logs VALUES("101", "41", "action created", "2023-03-04 05:59:52", "2023-03-04 05:59:52");
INSERT INTO wprg_actionscheduler_logs VALUES("102", "41", "action started via WP Cron", "2023-03-04 06:00:03", "2023-03-04 06:00:03");
INSERT INTO wprg_actionscheduler_logs VALUES("103", "41", "action complete via WP Cron", "2023-03-04 06:00:03", "2023-03-04 06:00:03");
INSERT INTO wprg_actionscheduler_logs VALUES("104", "42", "action created", "2023-03-04 06:00:08", "2023-03-04 06:00:08");
INSERT INTO wprg_actionscheduler_logs VALUES("105", "42", "action started via WP Cron", "2023-03-04 06:01:20", "2023-03-04 06:01:20");
INSERT INTO wprg_actionscheduler_logs VALUES("106", "42", "action complete via WP Cron", "2023-03-04 06:01:20", "2023-03-04 06:01:20");

DROP TABLE IF EXISTS wprg_commentmeta;

CREATE TABLE `wprg_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=239 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wprg_commentmeta VALUES("1", "39", "akismet_error", "1370606225");
INSERT INTO wprg_commentmeta VALUES("2", "39", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("3", "39", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("4", "39", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("5", "39", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("6", "40", "akismet_error", "1370606029");
INSERT INTO wprg_commentmeta VALUES("7", "40", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("8", "40", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("9", "40", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("10", "40", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("11", "41", "akismet_error", "1370606265");
INSERT INTO wprg_commentmeta VALUES("12", "41", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("13", "41", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("14", "41", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("15", "41", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("16", "42", "akismet_error", "1370605393");
INSERT INTO wprg_commentmeta VALUES("17", "42", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("18", "42", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("19", "42", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("20", "42", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("21", "43", "akismet_error", "1370606115");
INSERT INTO wprg_commentmeta VALUES("22", "43", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("23", "43", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("24", "43", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("25", "43", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("26", "44", "akismet_error", "1370610134");
INSERT INTO wprg_commentmeta VALUES("27", "44", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("28", "44", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("29", "44", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("30", "44", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("31", "45", "akismet_error", "1370606072");
INSERT INTO wprg_commentmeta VALUES("32", "45", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("33", "45", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("34", "45", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("35", "45", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("36", "46", "akismet_error", "1370610085");
INSERT INTO wprg_commentmeta VALUES("37", "46", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("38", "46", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("39", "46", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("40", "46", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("41", "47", "akismet_error", "1370620193");
INSERT INTO wprg_commentmeta VALUES("42", "47", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("43", "47", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("44", "47", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("45", "47", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("46", "48", "akismet_error", "1370610209");
INSERT INTO wprg_commentmeta VALUES("47", "48", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("48", "48", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("49", "48", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("50", "48", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("51", "49", "akismet_error", "1370611492");
INSERT INTO wprg_commentmeta VALUES("52", "49", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("53", "49", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("54", "49", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("55", "49", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("56", "50", "akismet_error", "1370620411");
INSERT INTO wprg_commentmeta VALUES("57", "50", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("58", "50", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("59", "50", "rating", "3");
INSERT INTO wprg_commentmeta VALUES("60", "50", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("61", "51", "akismet_error", "1370606279");
INSERT INTO wprg_commentmeta VALUES("62", "51", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("63", "51", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("64", "51", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("65", "51", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("66", "52", "akismet_error", "1370620393");
INSERT INTO wprg_commentmeta VALUES("67", "52", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("68", "52", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("69", "52", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("70", "52", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("71", "53", "akismet_error", "1370605612");
INSERT INTO wprg_commentmeta VALUES("72", "53", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("73", "53", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("74", "53", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("75", "53", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("76", "54", "akismet_error", "1370605993");
INSERT INTO wprg_commentmeta VALUES("77", "54", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("78", "54", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("79", "54", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("80", "54", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("81", "55", "akismet_error", "1370606643");
INSERT INTO wprg_commentmeta VALUES("82", "55", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("83", "55", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("84", "55", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("85", "55", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("86", "56", "akismet_error", "1370606091");
INSERT INTO wprg_commentmeta VALUES("87", "56", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("88", "56", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("89", "56", "rating", "1");
INSERT INTO wprg_commentmeta VALUES("90", "56", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("91", "57", "akismet_error", "1370620222");
INSERT INTO wprg_commentmeta VALUES("92", "57", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("93", "57", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("94", "57", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("95", "57", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("96", "58", "akismet_error", "1370607293");
INSERT INTO wprg_commentmeta VALUES("97", "58", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("98", "58", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("99", "58", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("100", "58", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("101", "59", "akismet_error", "1370607656");
INSERT INTO wprg_commentmeta VALUES("102", "59", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("103", "59", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("104", "59", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("105", "59", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("106", "60", "akismet_error", "1370608902");
INSERT INTO wprg_commentmeta VALUES("107", "60", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("108", "60", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("109", "60", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("110", "60", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("111", "61", "akismet_error", "1370611600");
INSERT INTO wprg_commentmeta VALUES("112", "61", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("113", "61", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("114", "61", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("115", "61", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("116", "62", "akismet_error", "1370620436");
INSERT INTO wprg_commentmeta VALUES("117", "62", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("118", "62", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("119", "62", "rating", "1");
INSERT INTO wprg_commentmeta VALUES("120", "62", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("125", "64", "akismet_error", "1370606673");
INSERT INTO wprg_commentmeta VALUES("126", "64", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("127", "64", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("128", "64", "rating", "3");
INSERT INTO wprg_commentmeta VALUES("129", "64", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("130", "65", "akismet_error", "1370620465");
INSERT INTO wprg_commentmeta VALUES("131", "65", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("132", "65", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("133", "65", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("134", "65", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("135", "66", "akismet_error", "1370605945");
INSERT INTO wprg_commentmeta VALUES("136", "66", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("137", "66", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("138", "66", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("139", "66", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("140", "67", "akismet_error", "1370606196");
INSERT INTO wprg_commentmeta VALUES("141", "67", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("142", "67", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("143", "67", "rating", "3");
INSERT INTO wprg_commentmeta VALUES("144", "67", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("145", "68", "akismet_error", "1370607565");
INSERT INTO wprg_commentmeta VALUES("146", "68", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("147", "68", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("148", "68", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("149", "68", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("150", "69", "akismet_error", "1370609989");
INSERT INTO wprg_commentmeta VALUES("151", "69", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("152", "69", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("153", "69", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("154", "69", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("155", "70", "akismet_error", "1370608744");
INSERT INTO wprg_commentmeta VALUES("156", "70", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("157", "70", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("158", "70", "rating", "3");
INSERT INTO wprg_commentmeta VALUES("159", "70", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("160", "71", "akismet_error", "1370620529");
INSERT INTO wprg_commentmeta VALUES("161", "71", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("162", "71", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("163", "71", "rating", "1");
INSERT INTO wprg_commentmeta VALUES("164", "71", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("165", "72", "akismet_error", "1370620584");
INSERT INTO wprg_commentmeta VALUES("166", "72", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("167", "72", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("168", "72", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("169", "72", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("170", "73", "akismet_error", "1370606192");
INSERT INTO wprg_commentmeta VALUES("171", "73", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("172", "73", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("173", "73", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("174", "73", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("175", "74", "akismet_error", "1370607727");
INSERT INTO wprg_commentmeta VALUES("176", "74", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("177", "74", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("178", "74", "rating", "3");
INSERT INTO wprg_commentmeta VALUES("179", "74", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("180", "75", "akismet_error", "1370605490");
INSERT INTO wprg_commentmeta VALUES("181", "75", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("182", "75", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("183", "75", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("184", "75", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("185", "76", "akismet_error", "1370607690");
INSERT INTO wprg_commentmeta VALUES("186", "76", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("187", "76", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("188", "76", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("189", "76", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("190", "77", "akismet_error", "1370606323");
INSERT INTO wprg_commentmeta VALUES("191", "77", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("192", "77", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("193", "77", "rating", "4");
INSERT INTO wprg_commentmeta VALUES("194", "77", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("195", "78", "akismet_error", "1370620368");
INSERT INTO wprg_commentmeta VALUES("196", "78", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("197", "78", "akismet_as_submitted", "");
INSERT INTO wprg_commentmeta VALUES("198", "78", "rating", "5");
INSERT INTO wprg_commentmeta VALUES("199", "78", "akismet_history", "");
INSERT INTO wprg_commentmeta VALUES("200", "66", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("201", "67", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("202", "68", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("203", "69", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("204", "56", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("205", "57", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("206", "46", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("207", "47", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("208", "45", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("209", "39", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("210", "40", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("211", "41", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("212", "42", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("213", "43", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("214", "44", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("215", "48", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("216", "49", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("217", "50", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("218", "58", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("219", "59", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("220", "60", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("221", "61", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("222", "62", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("223", "64", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("224", "65", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("225", "72", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("226", "77", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("227", "78", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("228", "73", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("229", "74", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("230", "75", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("231", "76", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("232", "53", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("233", "54", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("234", "55", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("235", "51", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("236", "52", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("237", "70", "verified", "0");
INSERT INTO wprg_commentmeta VALUES("238", "71", "verified", "0");

DROP TABLE IF EXISTS wprg_comments;

CREATE TABLE `wprg_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wprg_comments VALUES("9", "301", "George Rich", "admin@test.com", "http://mysite.com", "127.0.0.1", "2016-10-23 16:04:20", "2016-10-23 16:04:20", "test", "0", "post-trashed", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36", "comment", "0", "1");
INSERT INTO wprg_comments VALUES("10", "883", "Anon", "anon@example.com", "", "59.167.157.3", "2007-09-04 10:49:28", "2007-09-04 00:49:28", "Anonymous comment.", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("11", "883", "tellyworthtest2", "tellyworth+test2@gmail.com", "", "59.167.157.3", "2007-09-04 10:49:03", "2007-09-04 00:49:03", "Contributor comment.", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("12", "883", "John Doe", "example@example.org", "http://example.org", "59.167.157.3", "2007-09-04 10:48:51", "2007-09-04 17:48:51", "Author comment.", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("13", "1148", "John Doe", "example@example.org", "http://example.org/", "59.167.157.3", "2012-09-03 10:18:04", "2012-09-03 17:18:04", "<h2>Headings</h2>\n<h1>Header one</h1>\n<h2>Header two</h2>\n<h3>Header three</h3>\n<h4>Header four</h4>\n<h5>Header five</h5>\n<h6>Header six</h6>\n<h2>Blockquotes</h2>\nSingle line blockquote:\n<blockquote>Stay hungry. Stay foolish.</blockquote>\nMulti line blockquote with a cite reference:\n<blockquote>People think focus means saying yes to the thing you\'ve got to focus on. But that\'s not what it means at all. It means saying no to the hundred other good ideas that there are. You have to pick carefully. I\'m actually as proud of the things we haven\'t done as the things I have done. Innovation is saying no to 1,000 things. <cite>Steve Jobs - Apple Worldwide Developers\' Conference, 1997</cite></blockquote>\n<h2>Tables</h2>\n<table>\n<tbody>\n<tr>\n<th>Employee</th>\n<th class=\"views\">Salary</th>\n<th></th>\n</tr>\n<tr class=\"odd\">\n<td><a href=\"http://example.org/\" rel=\"nofollow\">John Saddington</a></td>\n<td>$1</td>\n<td>Because that\'s all Steve Job\' needed for a salary.</td>\n</tr>\n<tr class=\"even\">\n<td><a href=\"http://example.org/\" rel=\"nofollow\">Tom McFarlin</a></td>\n<td>$100K</td>\n<td>For all the blogging he does.</td>\n</tr>\n<tr class=\"odd\">\n<td><a href=\"http://example.org/\" rel=\"nofollow\">Jared Erickson</a></td>\n<td>$100M</td>\n<td>Pictures are worth a thousand words, right? So Tom x 1,000.</td>\n</tr>\n<tr class=\"even\">\n<td><a href=\"http://example.org/\" rel=\"nofollow\">Chris Ames</a></td>\n<td>$100B</td>\n<td>With hair like that?! Enough said...</td>\n</tr>\n</tbody>\n</table>\n<h2>Definition Lists</h2>\n<dl><dt>Definition List Title</dt><dd>Definition list division.</dd><dt>Startup</dt><dd>A startup company or startup is a company or temporary organization designed to search for a repeatable and scalable business model.</dd><dt>#dowork</dt><dd>Coined by Rob Dyrdek and his personal body guard Christopher \"Big Black\" Boykins, \"Do Work\" works as a self motivator, to motivating your friends.</dd><dt>Do It Live</dt><dd>I\'ll let Bill O\'Reilly will <a title=\"We\'ll Do It Live\" href=\"https://www.youtube.com/watch?v=O_HyZ5aW76c\" rel=\"nofollow\">explain</a> this one.</dd></dl>\n<h2>Unordered Lists (Nested)</h2>\n<ul>\n	<li>List item one\n<ul>\n	<li>List item one\n<ul>\n	<li>List item one</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n<h2>Ordered List (Nested)</h2>\n<ol>\n	<li>List item one\n<ol>\n	<li>List item one\n<ol>\n	<li>List item one</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n<h2>HTML Tags</h2>\nThese supported tags come from the WordPress.com code <a title=\"Code\" href=\"http://en.support.wordpress.com/code/\" rel=\"nofollow\">FAQ</a>.\n\n<strong>Address Tag</strong>\n\n<address>1 Infinite Loop\nCupertino, CA 95014\nUnited States</address><strong>Anchor Tag (aka. Link)</strong>\n\nThis is an example of a <a title=\"Apple\" href=\"http://apple.com\" rel=\"nofollow\">link</a>.\n\n<strong>Abbreviation Tag</strong>\n\nThe abbreviation <abbr title=\"Seriously\">srsly</abbr> stands for \"seriously\".\n\n<strong>Acronym Tag</strong>\n\nThe acronym <acronym title=\"For The Win\">ftw</acronym> stands for \"for the win\".\n\n<strong>Big Tag</strong>\n\nThese tests are a <big>big</big> deal, but this tag is no longer supported in HTML5.\n\n<strong>Cite Tag</strong>\n\n\"Code is poetry.\" --<cite>Automattic</cite>\n\n<strong>Code Tag</strong>\n\nYou will learn later on in these tests that <code>word-wrap: break-word;</code> will be your best friend.\n\n<strong>Delete Tag</strong>\n\nThis tag will let you <del>strikeout text</del>, but this tag is no longer supported in HTML5 (use the <code>&lt;strike&gt;</code> instead).\n\n<strong>Emphasize Tag</strong>\n\nThe emphasize tag should <em>italicize</em> text.\n\n<strong>Insert Tag</strong>\n\nThis tag should denote <ins>inserted</ins> text.\n\n<strong>Keyboard Tag</strong>\n\nThis scarcely known tag emulates <kbd>keyboard text</kbd>, which is usually styled like the <code>&lt;code&gt;</code> tag.\n\n<strong>Preformatted Tag</strong>\n\nThis tag styles large blocks of code.\n<pre>.post-title {\n  margin: 0 0 5px;\n  font-weight: bold;\n  font-size: 38px;\n  line-height: 1.2;\n}</pre>\n\n<strong>Quote Tag</strong>\n\n<q>Developers, developers, developers...</q> --Steve Ballmer\n\n<strong>Strong Tag</strong>\n\nThis tag shows <strong>bold<strong> text.</strong></strong>\n\n<strong>Subscript Tag</strong>\n\nGetting our science styling on with H<sub>2</sub>O, which should push the \"2\" down.\n\n<strong>Superscript Tag</strong>\n\nStill sticking with science and Isaac Newton\'s E = MC<sup>2</sup>, which should lift the 2 up.\n\n<strong>Teletype Tag</strong>\n\nThis rarely used tag emulates <tt>teletype text</tt>, which is usually styled like the <code>&lt;code&gt;</code> tag.\n\n<strong>Variable Tag</strong>\n\nThis allows you to denote <var>variables</var>.", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("14", "1148", "Anonymous User", "fake@email.com", "", "67.3.69.40", "2013-03-11 23:45:54", "2013-03-12 04:45:54", "This user it trying to be anonymous.\n\n\n    They used a fake email, so there should be no <a href=\"http://gravatar.com/\" title=\"Gravatar\" rel=\"nofollow\">Gravatar</a> associated with it.\n    They did not speify a website, so there should be no link to it in the comment.\n", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("15", "1148", "Jane Doe", "example@example.org", "http://example.org/", "204.54.106.1", "2013-03-12 13:17:35", "2013-03-12 20:17:35", "Comments? I love comments!", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("16", "1148", "John Doe", "example@example.org", "http://example.org", "24.126.245.62", "2013-03-14 07:53:26", "2013-03-14 14:53:26", "These tests are amazing!", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("17", "1148", "John Doe", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 07:56:46", "2013-03-14 14:56:46", "Author Comment.", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("18", "1148", "John Doe", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 07:57:01", "2013-03-14 14:57:01", "Comment Depth 01", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("19", "1148", "Jane Bloggs", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 08:01:21", "2013-03-14 15:01:21", "Comment Depth 02", "0", "post-trashed", "", "comment", "18", "0");
INSERT INTO wprg_comments VALUES("20", "1148", "Fred Bloggs", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 08:02:06", "2013-03-14 15:02:06", "Comment Depth 03", "0", "post-trashed", "", "comment", "19", "0");
INSERT INTO wprg_comments VALUES("21", "1148", "Fred Bloggs", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 08:03:22", "2013-03-14 15:03:22", "Comment Depth 04", "0", "post-trashed", "", "comment", "20", "0");
INSERT INTO wprg_comments VALUES("22", "1148", "Joe Bloggs", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 08:10:29", "2013-03-14 15:10:29", "Comment Depth 05\n\nAlso an author comment.", "0", "post-trashed", "", "comment", "21", "0");
INSERT INTO wprg_comments VALUES("23", "1148", "Jane Bloggs", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 08:12:16", "2013-03-14 15:12:16", "Comment Depth 06", "0", "post-trashed", "", "comment", "22", "0");
INSERT INTO wprg_comments VALUES("24", "1148", "Joe Bloggs", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 08:12:58", "2013-03-14 15:12:58", "Comment Depth 07", "0", "post-trashed", "", "comment", "23", "0");
INSERT INTO wprg_comments VALUES("25", "1148", "Jane Bloggs", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 08:13:42", "2013-03-14 15:13:42", "Comment Depth 08", "0", "post-trashed", "", "comment", "24", "0");
INSERT INTO wprg_comments VALUES("26", "1148", "Joe Bloggs", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 08:14:13", "2013-03-14 15:14:13", "Comment Depth 09", "0", "post-trashed", "", "comment", "25", "0");
INSERT INTO wprg_comments VALUES("27", "1148", "John Doe", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 08:14:47", "2013-03-14 15:14:47", "Comment Depth 10\n\nAlso an author comment.", "0", "post-trashed", "", "comment", "26", "0");
INSERT INTO wprg_comments VALUES("28", "1148", "Jane Doe", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 09:56:43", "2013-03-14 16:56:43", "Image comment.\n\n", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("29", "1148", "John Doe", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 11:23:24", "2013-03-14 18:23:24", "We are totally going to blog about these tests!", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("30", "1148", "John Doe", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 11:27:54", "2013-03-14 18:27:54", "We use these tests all the time! Killer stuff!", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("31", "1148", "Jane Doe", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 11:30:33", "2013-03-14 18:30:33", "Thanks for all the comments, everyone!", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("36", "1149", "John Doe", "example@example.org", "http://example.org/", "146.214.103.251", "2010-06-11 15:27:04", "2010-06-11 22:27:04", "This is a comment amongst pingbacks and trackbacks.", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("37", "1168", "Jane Doe", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 11:56:08", "2013-03-14 18:56:08", "This comment should not be visible until the password is entered.", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("38", "1170", "John Doe", "example@example.org", "http://example.org/", "24.126.245.62", "2013-03-14 12:35:07", "2013-03-14 19:35:07", "Having no content in the post should have no adverse effects on the layout or functionality.", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("39", "15", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:57:05", "2013-06-07 11:57:05", "Simple and effective design. One of my favorites.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("40", "19", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:53:49", "2013-06-07 11:53:49", "Wonderful quality, and an awesome design. WooThemes ftw!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("41", "19", "Andrew", "andrew@chromeorange.co.uk", "", "86.19.152.140", "2013-06-07 11:57:45", "2013-06-07 11:57:45", "This t-shirt is awesome! Would recommend to everyone!\n\nI\'m ordering mine next week", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("42", "22", "James Koster", "james@jameskoster.co.uk", "", "86.146.141.82", "2013-06-07 11:43:13", "2013-06-07 11:43:13", "Nice T-shirt, I got one in black. Goes with anything!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("43", "22", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:55:15", "2013-06-07 11:55:15", "Very comfortable shirt, and I love the graphic!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("44", "22", "Stuart", "stuart@woothemes.com", "", "82.32.109.140", "2013-06-07 13:02:14", "2013-06-07 13:02:14", "Great T-shirt quality, Great Design and Great Service.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("45", "31", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:54:32", "2013-06-07 11:54:32", "The ninja silhouette is one of my favorite designs. This is a great product.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("46", "37", "Stuart", "stuart@woothemes.com", "", "82.32.109.140", "2013-06-07 13:01:25", "2013-06-07 13:01:25", "This will go great with my Hoodie that I ordered a few weeks ago.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("47", "37", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:49:53", "2013-06-07 15:49:53", "Love this shirt! The ninja near and dear to my heart. &lt;3", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("48", "40", "Stuart", "stuart@woothemes.com", "", "82.32.109.140", "2013-06-07 13:03:29", "2013-06-07 13:03:29", "Another great quality product that anyone who see\'s me wearing has asked where to purchase one of their own.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("49", "40", "Ryan", "ryan@woothemes.com", "", "99.153.225.252", "2013-06-07 13:24:52", "2013-06-07 13:24:52", "This hoodie gets me lots of looks while out in public, I got the blue one and it\'s awesome. Not sure if people are looking at my hoodie only, or also at my rocking bod.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("50", "40", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:53:31", "2013-06-07 15:53:31", "Ship it!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("51", "2064", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:57:59", "2013-06-07 11:57:59", "This hoodie is great for those chilly winter days. I love the WooNinja!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("52", "2064", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:53:13", "2013-06-07 15:53:13", "Perfect for the lady Ninja in your life!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("53", "2065", "James Koster", "james@jameskoster.co.uk", "", "86.146.141.82", "2013-06-07 11:46:52", "2013-06-07 11:46:52", "Perfect when you\'re sat at your computer, waiting for the next batch of Woo Goodies to be released. The Patient Ninja is Patient.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("54", "2065", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:53:13", "2013-06-07 11:53:13", "The most comfortable hoodie I have ever owned!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("55", "2065", "Magnus", "magnus@woothemes.com", "", "79.161.106.35", "2013-06-07 12:04:03", "2013-06-07 12:04:03", "This is my favorite hoodie!\n\nIf only it came in red as well!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("56", "2066", "Andrew", "andrew@chromeorange.co.uk", "", "86.19.152.140", "2013-06-07 11:54:51", "2013-06-07 11:54:51", "I bought this thinking it was a nice green colour, apparently it GREY! I\'m colour blind so I don\'t care but my girlfriend says grey makes me look fat", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("57", "2066", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:50:22", "2013-06-07 15:50:22", "I love grey hoodies! This is perfect with my grey Ninja shirt, when I get cold I throw this on and I can still be a Ninja.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("58", "56", "student", "student@woothemes.com", "", "196.215.9.147", "2013-06-07 12:14:53", "2013-06-07 12:14:53", "Perfect Hoodie for a Ninja!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("59", "56", "Coen Jacobs", "coen@woothemes.com", "", "84.39.28.254", "2013-06-07 12:20:56", "2013-06-07 12:20:56", "I have lots of hoodies, but none is as cool as this one!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("60", "56", "Dan", "dan@woothemes.com", "", "188.221.1.167", "2013-06-07 12:41:42", "2013-06-07 12:41:42", "I love hoodies, and ninjas, so what could be better than a ninja hoodie? Not much, if you ask me!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("61", "56", "Ryan", "ryan@woothemes.com", "", "99.153.225.252", "2013-06-07 13:26:40", "2013-06-07 13:26:40", "This is the most bombastic hoodie in this shop, it\'s soft and has the sly WooThemes ninja on it. Why wouldn\'t you buy this?", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("62", "56", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:53:56", "2013-06-07 15:53:56", "This only gets 1 star because I don\'t have this yet. I want it now!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("64", "60", "Magnus", "magnus@woothemes.com", "", "79.161.106.35", "2013-06-07 12:04:33", "2013-06-07 12:04:33", "I like the logo but not the color.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("65", "60", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:54:25", "2013-06-07 15:54:25", "Three letters, one word: WOO!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("66", "70", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:52:25", "2013-06-07 11:52:25", "Really happy with this print. The colors are great, and the paper quality is good too.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("67", "70", "Andrew", "andrew@chromeorange.co.uk", "", "86.19.152.140", "2013-06-07 11:56:36", "2013-06-07 11:56:36", "You only get the picture, not the person holding it, something they don\'t mention in the description, now I\'ve got to find my own person", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("68", "70", "Coen Jacobs", "coen@woothemes.com", "", "84.39.28.254", "2013-06-07 12:19:25", "2013-06-07 12:19:25", "This is my favorite poster. In fact, I\'ve ordered 5 of them!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("69", "70", "Stuart", "stuart@woothemes.com", "", "82.32.109.140", "2013-06-07 12:59:49", "2013-06-07 12:59:49", "This is a fantastic quality print and is happily hanging framed on my wall now.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("70", "73", "Dan", "dan@woothemes.com", "", "188.221.1.167", "2013-06-07 12:39:04", "2013-06-07 12:39:04", "I thought I was buying a man holding a poster, but when it arrived it was just the poster. Cool poster though, so I\'ll give it 3 stars!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("71", "73", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:55:29", "2013-06-07 15:55:29", "I didn\'t expect this poster to arrive folded. Now there are lines on the poster and one sad Ninja.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("72", "76", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:56:24", "2013-06-07 15:56:24", "He really is the cutest little man. Swoooon!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("73", "87", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:56:32", "2013-06-07 11:56:32", "Wonderful collection of WooThemes classics! A must buy for all Woo fans.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("74", "90", "Coen Jacobs", "coen@woothemes.com", "", "84.39.28.254", "2013-06-07 12:22:07", "2013-06-07 12:22:07", "This album gets a bit boring after you\'ve listened to it more than once. Worth that first listen though.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("75", "96", "James Koster", "james@jameskoster.co.uk", "", "86.146.141.82", "2013-06-07 11:44:50", "2013-06-07 11:44:50", "The most influential album of the last 25 years? This just might be it.", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("76", "96", "Coen Jacobs", "coen@woothemes.com", "", "84.39.28.254", "2013-06-07 12:21:30", "2013-06-07 12:21:30", "Some rad tunes on this album!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("77", "99", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:58:43", "2013-06-07 11:58:43", "This album proves why The Woo are the best band ever. Best music ever!", "0", "1", "", "comment", "0", "0");
INSERT INTO wprg_comments VALUES("78", "99", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:52:48", "2013-06-07 15:52:48", "Can’t wait to start mixin’ with this one! Irba-irr-Up-up-up-up-date your theme!", "0", "1", "", "comment", "0", "0");

DROP TABLE IF EXISTS wprg_e_submissions;

CREATE TABLE `wprg_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wprg_e_submissions VALUES("1", "submission", "44ac1af7-f04b-4459-99f2-90cfbc86a931", "3", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "2", "188.230.244.63", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.2 Safari/605.1.15", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-09-09 20:46:55", "2021-09-09 20:46:55", "2021-09-09 20:46:55", "2021-09-09 20:46:55");
INSERT INTO wprg_e_submissions VALUES("2", "submission", "064420ee-ebaa-4b8f-861e-9b3d9b7026f9", "7", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "2", "188.230.244.63", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.2 Safari/605.1.15", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-09-09 21:03:09", "2021-09-09 21:03:09", "2021-09-09 21:03:09", "2021-09-09 21:03:09");
INSERT INTO wprg_e_submissions VALUES("3", "submission", "17c65638-f48d-4039-b392-754ee606c85e", "11", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "2", "188.230.244.63", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.2 Safari/605.1.15", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-09-09 21:05:20", "2021-09-09 21:05:21", "2021-09-09 21:05:20", "2021-09-09 21:05:21");
INSERT INTO wprg_e_submissions VALUES("4", "submission", "ad288366-df04-46a0-9bb0-cdcd9621134a", "15", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "104.144.163.232", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3393.4 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-09-12 22:31:38", "2021-09-12 22:31:39", "2021-09-12 22:31:38", "2021-09-12 22:31:39");
INSERT INTO wprg_e_submissions VALUES("5", "submission", "e4833023-f923-44d7-aaa9-b0578c90236e", "19", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "84.247.48.9", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-10-09 08:18:17", "2021-10-09 08:18:18", "2021-10-09 08:18:17", "2021-10-09 08:18:18");
INSERT INTO wprg_e_submissions VALUES("6", "submission", "cc38b72b-e3f8-40d5-b411-d505db35c2eb", "23", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "156.146.35.24", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-10-13 12:06:34", "2021-10-13 12:06:35", "2021-10-13 12:06:34", "2021-10-13 12:06:35");
INSERT INTO wprg_e_submissions VALUES("7", "submission", "16a456cb-b6c9-4480-9f1e-d221d5e31165", "27", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "212.102.57.7", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-10-18 06:27:58", "2021-10-18 06:27:59", "2021-10-18 06:27:58", "2021-10-18 06:27:59");
INSERT INTO wprg_e_submissions VALUES("8", "submission", "ebd85241-9144-463f-a809-5aed5418fd9f", "31", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "191.101.217.30", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-10-21 11:15:34", "2021-10-21 11:15:35", "2021-10-21 11:15:34", "2021-10-21 11:15:35");
INSERT INTO wprg_e_submissions VALUES("9", "submission", "9681b47d-3d9f-4811-bfb1-209a945d07de", "35", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "45.133.172.94", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-10-21 13:32:57", "2021-10-21 13:32:58", "2021-10-21 13:32:57", "2021-10-21 13:32:58");
INSERT INTO wprg_e_submissions VALUES("10", "submission", "e5b7daa1-0aae-4ffa-bcfd-0dd553966d77", "39", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "45.133.172.94", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-10-21 15:46:30", "2021-10-21 15:46:31", "2021-10-21 15:46:30", "2021-10-21 15:46:31");
INSERT INTO wprg_e_submissions VALUES("11", "submission", "ce97743a-eb18-4663-8aac-09bb63e0b2f6", "43", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "45.133.172.94", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-10-23 06:56:49", "2021-10-23 06:56:50", "2021-10-23 06:56:49", "2021-10-23 06:56:50");
INSERT INTO wprg_e_submissions VALUES("12", "submission", "96030445-3053-4069-a7d9-2aaa9ae28082", "47", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "45.133.172.94", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-10-23 09:27:19", "2021-10-23 09:27:20", "2021-10-23 09:27:19", "2021-10-23 09:27:20");
INSERT INTO wprg_e_submissions VALUES("13", "submission", "4d38ff9c-d619-47c2-af8d-79a327bcde41", "51", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "45.133.172.94", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-10-23 12:05:42", "2021-10-23 12:05:43", "2021-10-23 12:05:42", "2021-10-23 12:05:43");
INSERT INTO wprg_e_submissions VALUES("14", "submission", "16af4df1-0777-4134-9a0a-b2cf395d1957", "55", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "212.102.57.9", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-11-10 13:11:10", "2021-11-10 13:11:11", "2021-11-10 13:11:10", "2021-11-10 13:11:11");
INSERT INTO wprg_e_submissions VALUES("15", "submission", "af96cf1e-0657-4e83-9027-409fcc242d17", "59", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "89.38.97.125", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2021-12-10 23:44:09", "2021-12-10 23:44:11", "2021-12-10 23:44:09", "2021-12-10 23:44:11");
INSERT INTO wprg_e_submissions VALUES("16", "submission", "fa18c66c-e49c-4588-aefb-d926f530f2c4", "63", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "172.58.46.207", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3393.4 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-01-06 21:33:26", "2022-01-06 21:33:27", "2022-01-06 21:33:26", "2022-01-06 21:33:27");
INSERT INTO wprg_e_submissions VALUES("17", "submission", "9cf59975-dd92-45f9-87d5-da44a09da036", "67", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "185.85.162.242", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-01-20 21:50:01", "2022-01-20 21:50:01", "2022-01-20 21:50:01", "2022-01-20 21:50:01");
INSERT INTO wprg_e_submissions VALUES("18", "submission", "a72234e6-108e-485c-a54d-4acae8c528cf", "71", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "185.85.162.242", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-01-22 13:59:43", "2022-01-22 13:59:43", "2022-01-22 13:59:43", "2022-01-22 13:59:43");
INSERT INTO wprg_e_submissions VALUES("19", "submission", "207019c6-7d67-48a8-a099-ffe747d9448b", "75", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "177.234.143.129", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3393.4 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-01-22 20:32:57", "2022-01-22 20:32:59", "2022-01-22 20:32:57", "2022-01-22 20:32:59");
INSERT INTO wprg_e_submissions VALUES("20", "submission", "1a67d6e5-306a-4d98-8e32-40245dfb06c4", "79", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "85.143.106.77", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-01-23 21:47:42", "2022-01-23 21:47:43", "2022-01-23 21:47:42", "2022-01-23 21:47:43");
INSERT INTO wprg_e_submissions VALUES("21", "submission", "6890bec2-9349-4ae9-8a7c-bb6e2fd195d5", "83", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "45.152.199.124", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3393.4 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-01-24 21:04:30", "2022-01-24 21:04:31", "2022-01-24 21:04:30", "2022-01-24 21:04:31");
INSERT INTO wprg_e_submissions VALUES("22", "submission", "770013a0-cd5b-4fa0-94f2-ef33d60871c9", "87", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "20.97.116.225", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3393.4 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-03-19 21:36:50", "2022-03-19 21:36:50", "2022-03-19 21:36:50", "2022-03-19 21:36:50");
INSERT INTO wprg_e_submissions VALUES("23", "submission", "58ea3487-795d-42cf-a15b-06fdb2293d00", "91", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "138.199.18.75", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49", "1", "0", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-03-27 12:17:03", "2022-03-27 12:17:03", "2022-03-27 12:17:03", "2022-03-27 12:17:03");
INSERT INTO wprg_e_submissions VALUES("24", "submission", "c189850c-edb5-4215-806c-10f46943f585", "95", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "46.161.11.252", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-04-15 08:13:37", "2022-04-15 08:13:37", "2022-04-15 08:13:37", "2022-04-15 08:13:37");
INSERT INTO wprg_e_submissions VALUES("25", "submission", "77ec4dc9-6bb5-4a0f-9014-d6403a43f42d", "99", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "40.86.9.105", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3393.4 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-04-19 18:50:07", "2022-04-19 18:50:08", "2022-04-19 18:50:07", "2022-04-19 18:50:08");
INSERT INTO wprg_e_submissions VALUES("26", "submission", "28a4255f-09dd-4b19-9ce9-21fa1ad52c70", "103", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "46.161.11.37", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.14 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-04-21 17:07:04", "2022-04-21 17:07:04", "2022-04-21 17:07:04", "2022-04-21 17:07:04");
INSERT INTO wprg_e_submissions VALUES("27", "submission", "aee85edf-4e09-4835-90e4-d3f28eddd03b", "107", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "137.184.209.132", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3393.4 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-04-23 16:38:17", "2022-04-23 16:38:19", "2022-04-23 16:38:17", "2022-04-23 16:38:19");
INSERT INTO wprg_e_submissions VALUES("28", "submission", "b387afc4-4e81-4e93-8fbc-3a5b53b94008", "111", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "104.245.145.29", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3393.4 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-05-02 01:42:04", "2022-05-02 01:42:04", "2022-05-02 01:42:04", "2022-05-02 01:42:04");
INSERT INTO wprg_e_submissions VALUES("29", "submission", "4c4f4252-5b1a-4b82-bb19-af630c932370", "115", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "213.159.38.90", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4427.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-05-15 23:39:04", "2022-05-15 23:39:06", "2022-05-15 23:39:04", "2022-05-15 23:39:06");
INSERT INTO wprg_e_submissions VALUES("30", "submission", "82cf755e-02da-4f38-9293-ad0a87b95ab6", "119", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "162.253.131.132", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3393.4 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-05-18 13:59:58", "2022-05-18 13:59:59", "2022-05-18 13:59:58", "2022-05-18 13:59:59");
INSERT INTO wprg_e_submissions VALUES("31", "submission", "8262abe2-8322-4dbe-964d-bb0fec8cd3c9", "123", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "181.214.206.40", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42", "1", "0", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-05-24 14:22:41", "2022-05-24 14:22:41", "2022-05-24 14:22:41", "2022-05-24 14:22:41");
INSERT INTO wprg_e_submissions VALUES("32", "submission", "d6140261-32e5-4511-a557-46f1185ad6f0", "127", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "46.161.11.82", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4087.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-05-26 01:16:41", "2022-05-26 01:16:43", "2022-05-26 01:16:41", "2022-05-26 01:16:43");
INSERT INTO wprg_e_submissions VALUES("33", "submission", "7d1ba1ed-2289-4f45-8654-0a06fcf744f8", "131", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "193.233.175.91", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3393.4 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-06-05 23:40:33", "2022-06-05 23:40:34", "2022-06-05 23:40:33", "2022-06-05 23:40:34");
INSERT INTO wprg_e_submissions VALUES("34", "submission", "42f78271-aff6-40c1-ab11-6f4c715a4172", "135", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "34.69.61.22", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3400.0 Iron Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-06-22 12:22:22", "2022-06-22 12:22:24", "2022-06-22 12:22:22", "2022-06-22 12:22:24");
INSERT INTO wprg_e_submissions VALUES("35", "submission", "affbdf39-2cdc-43a3-8c29-439e7807fc77", "139", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "84.17.48.213", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-06-25 14:06:59", "2022-06-25 14:07:03", "2022-06-25 14:06:59", "2022-06-25 14:07:03");
INSERT INTO wprg_e_submissions VALUES("36", "submission", "cd1bf16a-91f8-478f-8643-d901cd6d319a", "143", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "35.188.90.10", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/6.4 Chrome/56.0.2924.87 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-07-06 16:30:06", "2022-07-06 16:30:07", "2022-07-06 16:30:06", "2022-07-06 16:30:07");
INSERT INTO wprg_e_submissions VALUES("37", "submission", "4ef5a240-9bdc-49b2-9397-97cc8d40ae90", "147", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "34.151.216.23", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/11.0 Safari/605.1.15 Epiphany/605.1.15", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-07-13 14:08:08", "2022-07-13 14:08:19", "2022-07-13 14:08:08", "2022-07-13 14:08:19");
INSERT INTO wprg_e_submissions VALUES("38", "submission", "df4bae34-fa48-4620-b52a-3b1587b00c6e", "151", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "177.234.143.180", "Mozilla/5.0 (X11; OpenBSD i386) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.125 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-07-21 10:50:43", "2022-07-21 10:50:45", "2022-07-21 10:50:43", "2022-07-21 10:50:45");
INSERT INTO wprg_e_submissions VALUES("39", "submission", "af633507-4db3-443f-be7b-416431055388", "155", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "196.247.212.185", "Mozilla/5.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 1.1.4322) 360JK yunjiankong 427691", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-08-05 23:52:36", "2022-08-05 23:52:37", "2022-08-05 23:52:36", "2022-08-05 23:52:37");
INSERT INTO wprg_e_submissions VALUES("40", "submission", "0b0b8518-102c-4f62-b383-afcf979790b1", "159", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "162.253.68.139", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET4.0C; .NET4.0E; 360SE)", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-08-10 01:53:32", "2022-08-10 01:53:33", "2022-08-10 01:53:32", "2022-08-10 01:53:33");
INSERT INTO wprg_e_submissions VALUES("41", "submission", "3b11f3cc-0700-4c45-83c5-03d4bc589053", "163", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "46.161.11.187", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4096.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-08-14 10:29:50", "2022-08-14 10:29:52", "2022-08-14 10:29:50", "2022-08-14 10:29:52");
INSERT INTO wprg_e_submissions VALUES("42", "submission", "ac3c78ca-ebba-449b-b654-e76ea6128381", "167", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "191.101.217.178", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-08-16 05:29:01", "2022-08-16 05:29:02", "2022-08-16 05:29:01", "2022-08-16 05:29:02");
INSERT INTO wprg_e_submissions VALUES("43", "submission", "0b9ed44f-3724-447f-99a1-30134088ca16", "171", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "192.186.176.140", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-08-30 16:25:26", "2022-08-30 16:25:27", "2022-08-30 16:25:26", "2022-08-30 16:25:27");
INSERT INTO wprg_e_submissions VALUES("44", "submission", "6ed6ad08-408a-4876-9a19-e1cef85e6f02", "175", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "171.22.76.5", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-09-04 12:12:54", "2022-09-04 12:12:55", "2022-09-04 12:12:54", "2022-09-04 12:12:55");
INSERT INTO wprg_e_submissions VALUES("45", "submission", "98c8384c-f6c8-4144-87b1-3b38d514fc12", "179", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "146.196.33.143", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-09-09 09:43:09", "2022-09-09 09:43:10", "2022-09-09 09:43:09", "2022-09-09 09:43:10");
INSERT INTO wprg_e_submissions VALUES("46", "submission", "24ad2bd0-961c-4a99-b543-af4ad57cd161", "183", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "162.253.129.168", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-09-10 21:36:18", "2022-09-10 21:36:19", "2022-09-10 21:36:18", "2022-09-10 21:36:19");
INSERT INTO wprg_e_submissions VALUES("47", "submission", "7c923cc6-3ae6-437c-90cf-ebe18d856e5c", "187", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "103.221.234.53", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-09-15 14:14:39", "2022-09-15 14:14:41", "2022-09-15 14:14:39", "2022-09-15 14:14:41");
INSERT INTO wprg_e_submissions VALUES("48", "submission", "6ea34c1d-0271-45dc-acd3-2ffd812700b1", "191", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "85.9.20.137", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-09-21 22:14:54", "2022-09-21 22:14:55", "2022-09-21 22:14:54", "2022-09-21 22:14:55");
INSERT INTO wprg_e_submissions VALUES("49", "submission", "ffea4c1d-891b-4767-af1f-a5b363367522", "195", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "168.196.236.179", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-09-28 08:56:47", "2022-09-28 08:56:49", "2022-09-28 08:56:47", "2022-09-28 08:56:49");
INSERT INTO wprg_e_submissions VALUES("50", "submission", "0375a157-e793-4564-85fe-588a68bac9b0", "199", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "192.99.110.149", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-10-25 16:15:39", "2022-10-25 16:15:40", "2022-10-25 16:15:39", "2022-10-25 16:15:40");
INSERT INTO wprg_e_submissions VALUES("51", "submission", "b4502320-238c-4dda-b611-cd0616747684", "203", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "144.168.228.115", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-11-14 14:00:12", "2022-11-14 14:00:14", "2022-11-14 14:00:12", "2022-11-14 14:00:14");
INSERT INTO wprg_e_submissions VALUES("52", "submission", "1760d1bb-49c0-45f5-98f3-f8e9c4c76b1c", "207", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "68.47.172.5", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-11-16 18:56:39", "2022-11-16 18:56:40", "2022-11-16 18:56:39", "2022-11-16 18:56:40");
INSERT INTO wprg_e_submissions VALUES("53", "submission", "73d3ed6b-9a1e-4981-8fd6-54f51f73a1f0", "211", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "154.9.22.216", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-11-21 05:39:17", "2022-11-21 05:39:18", "2022-11-21 05:39:17", "2022-11-21 05:39:18");
INSERT INTO wprg_e_submissions VALUES("54", "submission", "5e4042d4-1f24-49b1-95c7-8ff4514e5871", "215", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "172.98.89.171", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46", "1", "0", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-11-26 03:35:36", "2022-11-26 03:35:36", "2022-11-26 03:35:36", "2022-11-26 03:35:36");
INSERT INTO wprg_e_submissions VALUES("55", "submission", "a7b72b01-14f2-401b-bfd3-f9788a9e4a89", "219", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "138.199.36.194", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-12-07 02:22:03", "2022-12-07 02:22:03", "2022-12-07 02:22:03", "2022-12-07 02:22:03");
INSERT INTO wprg_e_submissions VALUES("56", "submission", "85c570a9-bd2f-45b2-8235-356a4f043990", "223", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "196.240.237.58", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-12-08 08:24:47", "2022-12-08 08:24:48", "2022-12-08 08:24:47", "2022-12-08 08:24:48");
INSERT INTO wprg_e_submissions VALUES("57", "submission", "e5837bd4-acb5-47f6-859c-9e9f3b280f31", "227", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "89.187.179.58", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-12-09 04:07:03", "2022-12-09 04:07:05", "2022-12-09 04:07:03", "2022-12-09 04:07:05");
INSERT INTO wprg_e_submissions VALUES("58", "submission", "666b1f0b-6889-4346-b129-8ab09086fc57", "231", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "192.161.166.242", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2022-12-15 12:13:48", "2022-12-15 12:13:49", "2022-12-15 12:13:48", "2022-12-15 12:13:49");
INSERT INTO wprg_e_submissions VALUES("59", "submission", "ee40ed03-7838-4704-a7e9-04d9ed53b45a", "235", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "95.164.156.253", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2023-01-15 23:38:15", "2023-01-15 23:38:16", "2023-01-15 23:38:15", "2023-01-15 23:38:16");
INSERT INTO wprg_e_submissions VALUES("60", "submission", "1496c389-c80c-4ac3-8932-1464f8514f97", "239", "3000", "", "Contact", "36ce5da0", "New Form", "0", "0", "181.214.218.224", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2023-01-23 09:35:18", "2023-01-23 09:35:19", "2023-01-23 09:35:18", "2023-01-23 09:35:19");
INSERT INTO wprg_e_submissions VALUES("61", "submission", "9fd8187d-1b71-4bdb-9cf0-a6d3fa989ef0", "243", "3000", "https://hendersonvilletntow.com/contact/", "Contact", "36ce5da0", "New Form", "0", "0", "119.73.112.255", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/106.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"3000\"}", "2023-01-24 09:44:20", "2023-01-24 09:44:21", "2023-01-24 09:44:20", "2023-01-24 09:44:21");

DROP TABLE IF EXISTS wprg_e_submissions_actions_log;

CREATE TABLE `wprg_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wprg_e_submissions_actions_log VALUES("1", "1", "email", "Email", "success", "", "2021-09-09 20:46:55", "2021-09-09 20:46:55", "2021-09-09 20:46:55", "2021-09-09 20:46:55");
INSERT INTO wprg_e_submissions_actions_log VALUES("2", "2", "email", "Email", "success", "", "2021-09-09 21:03:09", "2021-09-09 21:03:09", "2021-09-09 21:03:09", "2021-09-09 21:03:09");
INSERT INTO wprg_e_submissions_actions_log VALUES("3", "3", "email", "Email", "success", "", "2021-09-09 21:05:21", "2021-09-09 21:05:21", "2021-09-09 21:05:21", "2021-09-09 21:05:21");
INSERT INTO wprg_e_submissions_actions_log VALUES("4", "4", "email", "Email", "success", "", "2021-09-12 22:31:39", "2021-09-12 22:31:39", "2021-09-12 22:31:39", "2021-09-12 22:31:39");
INSERT INTO wprg_e_submissions_actions_log VALUES("5", "5", "email", "Email", "success", "", "2021-10-09 08:18:18", "2021-10-09 08:18:18", "2021-10-09 08:18:18", "2021-10-09 08:18:18");
INSERT INTO wprg_e_submissions_actions_log VALUES("6", "6", "email", "Email", "success", "", "2021-10-13 12:06:35", "2021-10-13 12:06:35", "2021-10-13 12:06:35", "2021-10-13 12:06:35");
INSERT INTO wprg_e_submissions_actions_log VALUES("7", "7", "email", "Email", "success", "", "2021-10-18 06:27:59", "2021-10-18 06:27:59", "2021-10-18 06:27:59", "2021-10-18 06:27:59");
INSERT INTO wprg_e_submissions_actions_log VALUES("8", "8", "email", "Email", "success", "", "2021-10-21 11:15:35", "2021-10-21 11:15:35", "2021-10-21 11:15:35", "2021-10-21 11:15:35");
INSERT INTO wprg_e_submissions_actions_log VALUES("9", "9", "email", "Email", "success", "", "2021-10-21 13:32:58", "2021-10-21 13:32:58", "2021-10-21 13:32:58", "2021-10-21 13:32:58");
INSERT INTO wprg_e_submissions_actions_log VALUES("10", "10", "email", "Email", "success", "", "2021-10-21 15:46:31", "2021-10-21 15:46:31", "2021-10-21 15:46:31", "2021-10-21 15:46:31");
INSERT INTO wprg_e_submissions_actions_log VALUES("11", "11", "email", "Email", "success", "", "2021-10-23 06:56:50", "2021-10-23 06:56:50", "2021-10-23 06:56:50", "2021-10-23 06:56:50");
INSERT INTO wprg_e_submissions_actions_log VALUES("12", "12", "email", "Email", "success", "", "2021-10-23 09:27:20", "2021-10-23 09:27:20", "2021-10-23 09:27:20", "2021-10-23 09:27:20");
INSERT INTO wprg_e_submissions_actions_log VALUES("13", "13", "email", "Email", "success", "", "2021-10-23 12:05:43", "2021-10-23 12:05:43", "2021-10-23 12:05:43", "2021-10-23 12:05:43");
INSERT INTO wprg_e_submissions_actions_log VALUES("14", "14", "email", "Email", "success", "", "2021-11-10 13:11:11", "2021-11-10 13:11:11", "2021-11-10 13:11:11", "2021-11-10 13:11:11");
INSERT INTO wprg_e_submissions_actions_log VALUES("15", "15", "email", "Email", "success", "", "2021-12-10 23:44:11", "2021-12-10 23:44:11", "2021-12-10 23:44:11", "2021-12-10 23:44:11");
INSERT INTO wprg_e_submissions_actions_log VALUES("16", "16", "email", "Email", "success", "", "2022-01-06 21:33:27", "2022-01-06 21:33:27", "2022-01-06 21:33:27", "2022-01-06 21:33:27");
INSERT INTO wprg_e_submissions_actions_log VALUES("17", "17", "email", "Email", "failed", "Server error. Form not sent.", "2022-01-20 21:50:02", "2022-01-20 21:50:02", "2022-01-20 21:50:02", "2022-01-20 21:50:02");
INSERT INTO wprg_e_submissions_actions_log VALUES("18", "18", "email", "Email", "failed", "Server error. Form not sent.", "2022-01-22 13:59:45", "2022-01-22 13:59:45", "2022-01-22 13:59:45", "2022-01-22 13:59:45");
INSERT INTO wprg_e_submissions_actions_log VALUES("19", "19", "email", "Email", "success", "", "2022-01-22 20:32:59", "2022-01-22 20:32:59", "2022-01-22 20:32:59", "2022-01-22 20:32:59");
INSERT INTO wprg_e_submissions_actions_log VALUES("20", "20", "email", "Email", "success", "", "2022-01-23 21:47:43", "2022-01-23 21:47:43", "2022-01-23 21:47:43", "2022-01-23 21:47:43");
INSERT INTO wprg_e_submissions_actions_log VALUES("21", "21", "email", "Email", "success", "", "2022-01-24 21:04:31", "2022-01-24 21:04:31", "2022-01-24 21:04:31", "2022-01-24 21:04:31");
INSERT INTO wprg_e_submissions_actions_log VALUES("22", "22", "email", "Email", "failed", "Server error. Form not sent.", "2022-03-19 21:36:51", "2022-03-19 21:36:51", "2022-03-19 21:36:51", "2022-03-19 21:36:51");
INSERT INTO wprg_e_submissions_actions_log VALUES("23", "23", "email", "Email", "failed", "Server error. Form not sent.", "2022-03-27 12:17:04", "2022-03-27 12:17:04", "2022-03-27 12:17:04", "2022-03-27 12:17:04");
INSERT INTO wprg_e_submissions_actions_log VALUES("24", "24", "email", "Email", "failed", "Server error. Form not sent.", "2022-04-15 08:13:38", "2022-04-15 08:13:38", "2022-04-15 08:13:38", "2022-04-15 08:13:38");
INSERT INTO wprg_e_submissions_actions_log VALUES("25", "25", "email", "Email", "success", "", "2022-04-19 18:50:08", "2022-04-19 18:50:08", "2022-04-19 18:50:08", "2022-04-19 18:50:08");
INSERT INTO wprg_e_submissions_actions_log VALUES("26", "26", "email", "Email", "failed", "Server error. Form not sent.", "2022-04-21 17:07:06", "2022-04-21 17:07:06", "2022-04-21 17:07:06", "2022-04-21 17:07:06");
INSERT INTO wprg_e_submissions_actions_log VALUES("27", "27", "email", "Email", "success", "", "2022-04-23 16:38:19", "2022-04-23 16:38:19", "2022-04-23 16:38:19", "2022-04-23 16:38:19");
INSERT INTO wprg_e_submissions_actions_log VALUES("28", "28", "email", "Email", "failed", "Server error. Form not sent.", "2022-05-02 01:42:06", "2022-05-02 01:42:06", "2022-05-02 01:42:06", "2022-05-02 01:42:06");
INSERT INTO wprg_e_submissions_actions_log VALUES("29", "29", "email", "Email", "success", "", "2022-05-15 23:39:06", "2022-05-15 23:39:06", "2022-05-15 23:39:06", "2022-05-15 23:39:06");
INSERT INTO wprg_e_submissions_actions_log VALUES("30", "30", "email", "Email", "success", "", "2022-05-18 13:59:59", "2022-05-18 13:59:59", "2022-05-18 13:59:59", "2022-05-18 13:59:59");
INSERT INTO wprg_e_submissions_actions_log VALUES("31", "31", "email", "Email", "failed", "Server error. Form not sent.", "2022-05-24 14:22:43", "2022-05-24 14:22:43", "2022-05-24 14:22:43", "2022-05-24 14:22:43");
INSERT INTO wprg_e_submissions_actions_log VALUES("32", "32", "email", "Email", "success", "", "2022-05-26 01:16:43", "2022-05-26 01:16:43", "2022-05-26 01:16:43", "2022-05-26 01:16:43");
INSERT INTO wprg_e_submissions_actions_log VALUES("33", "33", "email", "Email", "success", "", "2022-06-05 23:40:34", "2022-06-05 23:40:34", "2022-06-05 23:40:34", "2022-06-05 23:40:34");
INSERT INTO wprg_e_submissions_actions_log VALUES("34", "34", "email", "Email", "success", "", "2022-06-22 12:22:24", "2022-06-22 12:22:24", "2022-06-22 12:22:24", "2022-06-22 12:22:24");
INSERT INTO wprg_e_submissions_actions_log VALUES("35", "35", "email", "Email", "success", "", "2022-06-25 14:07:03", "2022-06-25 14:07:03", "2022-06-25 14:07:03", "2022-06-25 14:07:03");
INSERT INTO wprg_e_submissions_actions_log VALUES("36", "36", "email", "Email", "success", "", "2022-07-06 16:30:07", "2022-07-06 16:30:07", "2022-07-06 16:30:07", "2022-07-06 16:30:07");
INSERT INTO wprg_e_submissions_actions_log VALUES("37", "37", "email", "Email", "success", "", "2022-07-13 14:08:19", "2022-07-13 14:08:19", "2022-07-13 14:08:19", "2022-07-13 14:08:19");
INSERT INTO wprg_e_submissions_actions_log VALUES("38", "38", "email", "Email", "success", "", "2022-07-21 10:50:45", "2022-07-21 10:50:45", "2022-07-21 10:50:45", "2022-07-21 10:50:45");
INSERT INTO wprg_e_submissions_actions_log VALUES("39", "39", "email", "Email", "success", "", "2022-08-05 23:52:37", "2022-08-05 23:52:37", "2022-08-05 23:52:37", "2022-08-05 23:52:37");
INSERT INTO wprg_e_submissions_actions_log VALUES("40", "40", "email", "Email", "success", "", "2022-08-10 01:53:33", "2022-08-10 01:53:33", "2022-08-10 01:53:33", "2022-08-10 01:53:33");
INSERT INTO wprg_e_submissions_actions_log VALUES("41", "41", "email", "Email", "success", "", "2022-08-14 10:29:52", "2022-08-14 10:29:52", "2022-08-14 10:29:52", "2022-08-14 10:29:52");
INSERT INTO wprg_e_submissions_actions_log VALUES("42", "42", "email", "Email", "success", "", "2022-08-16 05:29:02", "2022-08-16 05:29:02", "2022-08-16 05:29:02", "2022-08-16 05:29:02");
INSERT INTO wprg_e_submissions_actions_log VALUES("43", "43", "email", "Email", "success", "", "2022-08-30 16:25:27", "2022-08-30 16:25:27", "2022-08-30 16:25:27", "2022-08-30 16:25:27");
INSERT INTO wprg_e_submissions_actions_log VALUES("44", "44", "email", "Email", "success", "", "2022-09-04 12:12:55", "2022-09-04 12:12:55", "2022-09-04 12:12:55", "2022-09-04 12:12:55");
INSERT INTO wprg_e_submissions_actions_log VALUES("45", "45", "email", "Email", "success", "", "2022-09-09 09:43:10", "2022-09-09 09:43:10", "2022-09-09 09:43:10", "2022-09-09 09:43:10");
INSERT INTO wprg_e_submissions_actions_log VALUES("46", "46", "email", "Email", "success", "", "2022-09-10 21:36:19", "2022-09-10 21:36:19", "2022-09-10 21:36:19", "2022-09-10 21:36:19");
INSERT INTO wprg_e_submissions_actions_log VALUES("47", "47", "email", "Email", "success", "", "2022-09-15 14:14:41", "2022-09-15 14:14:41", "2022-09-15 14:14:41", "2022-09-15 14:14:41");
INSERT INTO wprg_e_submissions_actions_log VALUES("48", "48", "email", "Email", "success", "", "2022-09-21 22:14:55", "2022-09-21 22:14:55", "2022-09-21 22:14:55", "2022-09-21 22:14:55");
INSERT INTO wprg_e_submissions_actions_log VALUES("49", "49", "email", "Email", "success", "", "2022-09-28 08:56:49", "2022-09-28 08:56:49", "2022-09-28 08:56:49", "2022-09-28 08:56:49");
INSERT INTO wprg_e_submissions_actions_log VALUES("50", "50", "email", "Email", "success", "", "2022-10-25 16:15:40", "2022-10-25 16:15:40", "2022-10-25 16:15:40", "2022-10-25 16:15:40");
INSERT INTO wprg_e_submissions_actions_log VALUES("51", "51", "email", "Email", "success", "", "2022-11-14 14:00:14", "2022-11-14 14:00:14", "2022-11-14 14:00:14", "2022-11-14 14:00:14");
INSERT INTO wprg_e_submissions_actions_log VALUES("52", "52", "email", "Email", "success", "", "2022-11-16 18:56:40", "2022-11-16 18:56:40", "2022-11-16 18:56:40", "2022-11-16 18:56:40");
INSERT INTO wprg_e_submissions_actions_log VALUES("53", "53", "email", "Email", "success", "", "2022-11-21 05:39:18", "2022-11-21 05:39:18", "2022-11-21 05:39:18", "2022-11-21 05:39:18");
INSERT INTO wprg_e_submissions_actions_log VALUES("54", "54", "email", "Email", "failed", "Server error. Form not sent.", "2022-11-26 03:35:38", "2022-11-26 03:35:38", "2022-11-26 03:35:38", "2022-11-26 03:35:38");
INSERT INTO wprg_e_submissions_actions_log VALUES("55", "55", "email", "Email", "failed", "Server error. Form not sent.", "2022-12-07 02:22:04", "2022-12-07 02:22:04", "2022-12-07 02:22:04", "2022-12-07 02:22:04");
INSERT INTO wprg_e_submissions_actions_log VALUES("56", "56", "email", "Email", "success", "", "2022-12-08 08:24:48", "2022-12-08 08:24:48", "2022-12-08 08:24:48", "2022-12-08 08:24:48");
INSERT INTO wprg_e_submissions_actions_log VALUES("57", "57", "email", "Email", "success", "", "2022-12-09 04:07:05", "2022-12-09 04:07:05", "2022-12-09 04:07:05", "2022-12-09 04:07:05");
INSERT INTO wprg_e_submissions_actions_log VALUES("58", "58", "email", "Email", "success", "", "2022-12-15 12:13:49", "2022-12-15 12:13:49", "2022-12-15 12:13:49", "2022-12-15 12:13:49");
INSERT INTO wprg_e_submissions_actions_log VALUES("59", "59", "email", "Email", "success", "", "2023-01-15 23:38:16", "2023-01-15 23:38:16", "2023-01-15 23:38:16", "2023-01-15 23:38:16");
INSERT INTO wprg_e_submissions_actions_log VALUES("60", "60", "email", "Email", "success", "", "2023-01-23 09:35:19", "2023-01-23 09:35:19", "2023-01-23 09:35:19", "2023-01-23 09:35:19");
INSERT INTO wprg_e_submissions_actions_log VALUES("61", "61", "email", "Email", "success", "", "2023-01-24 09:44:21", "2023-01-24 09:44:21", "2023-01-24 09:44:21", "2023-01-24 09:44:21");

DROP TABLE IF EXISTS wprg_e_submissions_values;

CREATE TABLE `wprg_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=245 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wprg_e_submissions_values VALUES("1", "1", "name", "test");
INSERT INTO wprg_e_submissions_values VALUES("2", "1", "field_1", "test");
INSERT INTO wprg_e_submissions_values VALUES("3", "1", "email", "manuel.ficko@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("4", "1", "message", "test");
INSERT INTO wprg_e_submissions_values VALUES("5", "2", "name", "test");
INSERT INTO wprg_e_submissions_values VALUES("6", "2", "field_1", "23");
INSERT INTO wprg_e_submissions_values VALUES("7", "2", "email", "manuel.ficko@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("8", "2", "message", "test123");
INSERT INTO wprg_e_submissions_values VALUES("9", "3", "name", "test");
INSERT INTO wprg_e_submissions_values VALUES("10", "3", "field_1", "23");
INSERT INTO wprg_e_submissions_values VALUES("11", "3", "email", "manuel.ficko@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("12", "3", "message", "test123");
INSERT INTO wprg_e_submissions_values VALUES("13", "4", "name", "Viola Panos");
INSERT INTO wprg_e_submissions_values VALUES("14", "4", "field_1", "079 0718 4374");
INSERT INTO wprg_e_submissions_values VALUES("15", "4", "email", "viola.panos@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("16", "4", "message", "Hello, Nash Towing Inc – Call Us First!\r\n\r\nWe offer effective organic SEO services for different types of web resources.\r\n\r\nOrganic SEO is a great marketing strategy to gain top 10 Google, especially for the small business websites.\r\n\r\nWith a small investment, you get a permanent customers flow and noticeable increasing of profits.\r\n\r\nThere is no other methods  with such ROI! Try Organic SEO with our experienced SEO experts.\r\n\r\nYou can select from our standard plans or request a custom SEO plan that will be tailored specifically for your website.\r\n\r\nThe effects of our Organic SEO efforts usually appear within 30 days after we start to work with client\'s site.\r\n\r\nYou can verify this by starting with our SEO plan for £49 - no need to risk.\r\n\r\nOrganic SEO, website optimization for search engines, keyword selection, link building, local SEO, UI/UX optimization, SEO audits, free online SEO advices\r\n\r\nWe work with the sites on any European language\r\n\r\nPlease, follow this link for details: http://linky.nu/aZ8np  \r\n\r\nThanks for your attention, and we are sorry if you are not interested in this offer");
INSERT INTO wprg_e_submissions_values VALUES("17", "5", "name", "JamesNus");
INSERT INTO wprg_e_submissions_values VALUES("18", "5", "field_1", "81219123754");
INSERT INTO wprg_e_submissions_values VALUES("19", "5", "email", "no-replyLypekeypevop@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("20", "5", "message", "Hi!  hendersonvilletntow.com \r\n \r\nWe suggesting \r\n \r\nSending your commercial proposal through the Contact us form which can be found on the sites in the contact partition. Contact form are filled in by our program and the captcha is solved. The advantage of this method is that messages sent through feedback forms are whitelisted. This technique increases the odds that your message will be read. \r\n \r\nOur database contains more than 27 million sites around the world to which we can send your message. \r\n \r\nThe cost of one million messages 49 USD \r\n \r\nFREE TEST mailing Up to 50,000 messages. \r\n \r\n \r\nThis offer is created automatically.  Use our contacts for communication. \r\n \r\nContact us. \r\nTelegram - @FeedbackMessages \r\nSkype  live:contactform_18 \r\nWhatsApp - +375259112693 \r\nWe only use chat.");
INSERT INTO wprg_e_submissions_values VALUES("21", "6", "name", "JamesNus");
INSERT INTO wprg_e_submissions_values VALUES("22", "6", "field_1", "86422428834");
INSERT INTO wprg_e_submissions_values VALUES("23", "6", "email", "no-replyLypekeypevop@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("24", "6", "message", "Good day!  hendersonvilletntow.com \r\n \r\nWe advance \r\n \r\nSending your message through the Contact us form which can be found on the sites in the Communication partition. Contact form are filled in by our software and the captcha is solved. The advantage of this method is that messages sent through feedback forms are whitelisted. This method raise the probability that your message will be open. \r\n \r\nOur database contains more than 27 million sites around the world to which we can send your message. \r\n \r\nThe cost of one million messages 49 USD \r\n \r\nFREE TEST mailing Up to 50,000 messages. \r\n \r\n \r\nThis offer is created automatically.  Use our contacts for communication. \r\n \r\nContact us. \r\nTelegram - @FeedbackMessages \r\nSkype  live:contactform_18 \r\nWhatsApp - +375259112693 \r\nWe only use chat.");
INSERT INTO wprg_e_submissions_values VALUES("25", "7", "name", "RichardDet");
INSERT INTO wprg_e_submissions_values VALUES("26", "7", "field_1", "83476457854");
INSERT INTO wprg_e_submissions_values VALUES("27", "7", "email", "denisandreev1989521a1n+rk@list.ru");
INSERT INTO wprg_e_submissions_values VALUES("28", "7", "message", "hendersonvilletntow.com teyiuwoiwfheujsmdcshflisjdalfjedbfsjhsgdhwyfeudjnfwhdgjkfbefjhdwsfjvnskhfbsjfnvshfbasnjkfbdjvgbfgjkd");
INSERT INTO wprg_e_submissions_values VALUES("29", "8", "name", "AllenHeiff");
INSERT INTO wprg_e_submissions_values VALUES("30", "8", "field_1", "83173885532");
INSERT INTO wprg_e_submissions_values VALUES("31", "8", "email", "leckerevans@ns.sympatico.ca");
INSERT INTO wprg_e_submissions_values VALUES("32", "8", "message", "We are a group of scientists from the UK, we are engaged in software development and AI training in various fields of activity. \r\nWe managed to create an AI trading robot and train it to predict the rise or fall of the price of Bitcoin, so we got something great. \r\nDuring testing, he earned us $ 167,000 from $ 500 by performing 15,790 trades in 5 days with 97{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} accuracy. \r\nhttps://www.google.com/url?q=httpsvk.ccc76e5G&sa=D&35=42&usg=AFQjCNFL5rEZgmQXC1gBkMY4vzA4kdArnQ \r\nWe have opened access to the system to everyone in order for our AI to constantly learn, the more people use the faster AI learns. \r\nThus, everything is in a big plus. \r\nPeople use our software and earn from $ 30,000 per day due to this our AI learns and we also use it like other people to earn money. \r\nThis is an inexhaustible source of income, since the price of Bitcoin fluctuates every minute, every second, and we all earn on this. \r\nTo get started, you need to register, make a deposit to the balance of $ 500, launch our smart robot and take from $ 150,000 every 5 days. \r\nhttps://www.google.com/url?q=httpsvk.ccc76e5G&sa=D&47=71&usg=AFQjCNFL5rEZgmQXC1gBkMY4vzA4kdArnQ");
INSERT INTO wprg_e_submissions_values VALUES("33", "9", "name", "BrianKam");
INSERT INTO wprg_e_submissions_values VALUES("34", "9", "field_1", "81891172787");
INSERT INTO wprg_e_submissions_values VALUES("35", "9", "email", "patrick.mcdougall@hotmail.ca");
INSERT INTO wprg_e_submissions_values VALUES("36", "9", "message", "Sending letters to sites with a feedback form - 7,000,000 sites \r\nWe will send your message with an advertisement for the site or your services on a database of 7 million sites with a feedback form around the world (GEO - Worldwide). \r\nYour ad will be seen by millions of people around the world. \r\nhttps://www.google.com/url?q=httpsvk.ccc7bjn6&sa=D&20=66&usg=AFQjCNEvr_YGsfkN1jONr0zPqdR5jonpIA");
INSERT INTO wprg_e_submissions_values VALUES("37", "10", "name", "Davidlycle");
INSERT INTO wprg_e_submissions_values VALUES("38", "10", "field_1", "84158888863");
INSERT INTO wprg_e_submissions_values VALUES("39", "10", "email", "a_whaling@fanshaweonline.ca");
INSERT INTO wprg_e_submissions_values VALUES("40", "10", "message", "We are a group of scientists from the UK, we are engaged in software development and AI training in various fields of activity. \r\nWe managed to create an AI trading robot and train it to predict the rise or fall of the price of Bitcoin, so we got something great. \r\nDuring testing, he earned us $ 167,000 from $ 500 by performing 15,790 trades in 5 days with 97{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} accuracy. \r\nhttps://www.google.com/url?q=httpsvk.ccc76e5G&sa=D&73=13&usg=AFQjCNFL5rEZgmQXC1gBkMY4vzA4kdArnQ \r\nWe have opened access to the system to everyone in order for our AI to constantly learn, the more people use the faster AI learns. \r\nThus, everything is in a big plus. \r\nPeople use our software and earn from $ 30,000 per day due to this our AI learns and we also use it like other people to earn money. \r\nThis is an inexhaustible source of income, since the price of Bitcoin fluctuates every minute, every second, and we all earn on this. \r\nTo get started, you need to register, make a deposit to the balance of $ 500, launch our smart robot and take from $ 150,000 every 5 days. \r\nhttps://www.google.com/url?q=httpsvk.ccc76e5G&sa=D&72=02&usg=AFQjCNFL5rEZgmQXC1gBkMY4vzA4kdArnQ");
INSERT INTO wprg_e_submissions_values VALUES("41", "11", "name", "Pedrodet");
INSERT INTO wprg_e_submissions_values VALUES("42", "11", "field_1", "82388731688");
INSERT INTO wprg_e_submissions_values VALUES("43", "11", "email", "acolekramer2003@yahoo.com");
INSERT INTO wprg_e_submissions_values VALUES("44", "11", "message", "We are a group of scientists from MIT, have taught artificial intelligence with 100{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} accuracy to determine altcoins that will increase in price by at least 15,000{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc}. \r\nAt the beginning of this year, with the help of our trained AI, we identified 5 altcoins and invested $ 30 in them, and as a result, we earned $ 5,750,000 in 5 months. \r\nhttps://www.google.com/url?q=httpsvk.ccc7eSmb&sa=D&51=50&usg=AFQjCNFsow-80pTbQZ_ATNXlTGErUk4XWw \r\n5 days ago, our AI identified 18 more new altcoins that will grow by at least 15,000{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} each. And we decided to put this list of altcoins up for sale ... \r\nhttps://www.google.com/url?q=httpsvk.ccc7eSmb&sa=D&00=57&usg=AFQjCNFsow-80pTbQZ_ATNXlTGErUk4XWw");
INSERT INTO wprg_e_submissions_values VALUES("45", "12", "name", "Pedrodet");
INSERT INTO wprg_e_submissions_values VALUES("46", "12", "field_1", "86597172226");
INSERT INTO wprg_e_submissions_values VALUES("47", "12", "email", "alicea@aol.com");
INSERT INTO wprg_e_submissions_values VALUES("48", "12", "message", "We are a group of scientists from MIT, have taught artificial intelligence with 100{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} accuracy to determine altcoins that will increase in price by at least 15,000{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc}. \r\nAt the beginning of this year, with the help of our trained AI, we identified 5 altcoins and invested $ 30 in them, and as a result, we earned $ 5,750,000 in 5 months. \r\nhttps://www.google.com/url?q=httpsvk.ccc7eSmb&sa=D&49=78&usg=AFQjCNFsow-80pTbQZ_ATNXlTGErUk4XWw \r\n5 days ago, our AI identified 18 more new altcoins that will grow by at least 15,000{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} each. And we decided to put this list of altcoins up for sale ... \r\nhttps://www.google.com/url?q=httpsvk.ccc7eSmb&sa=D&28=32&usg=AFQjCNFsow-80pTbQZ_ATNXlTGErUk4XWw");
INSERT INTO wprg_e_submissions_values VALUES("49", "13", "name", "Pedrodet");
INSERT INTO wprg_e_submissions_values VALUES("50", "13", "field_1", "85796981434");
INSERT INTO wprg_e_submissions_values VALUES("51", "13", "email", "selafonua_a1@yahoo.com");
INSERT INTO wprg_e_submissions_values VALUES("52", "13", "message", "We are a group of scientists from MIT, have taught artificial intelligence with 100{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} accuracy to determine altcoins that will increase in price by at least 15,000{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc}. \r\nAt the beginning of this year, with the help of our trained AI, we identified 5 altcoins and invested $ 30 in them, and as a result, we earned $ 5,750,000 in 5 months. \r\nhttps://www.google.com/url?q=httpsvk.ccc7eSmb&sa=D&01=96&usg=AFQjCNFsow-80pTbQZ_ATNXlTGErUk4XWw \r\n5 days ago, our AI identified 18 more new altcoins that will grow by at least 15,000{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} each. And we decided to put this list of altcoins up for sale ... \r\nhttps://www.google.com/url?q=httpsvk.ccc7eSmb&sa=D&76=37&usg=AFQjCNFsow-80pTbQZ_ATNXlTGErUk4XWw");
INSERT INTO wprg_e_submissions_values VALUES("53", "14", "name", "GerardtaiNg");
INSERT INTO wprg_e_submissions_values VALUES("54", "14", "field_1", "85167613617");
INSERT INTO wprg_e_submissions_values VALUES("55", "14", "email", "dimafokin199506780tx+w391@inbox.ru");
INSERT INTO wprg_e_submissions_values VALUES("56", "14", "message", "hendersonvilletntow.com tyrueoswkdhfbjksdhbdvsddnajkmkxdbfsdjdfadladabfhghgdhsjkd");
INSERT INTO wprg_e_submissions_values VALUES("57", "15", "name", "WalterSek");
INSERT INTO wprg_e_submissions_values VALUES("58", "15", "field_1", "89736483641");
INSERT INTO wprg_e_submissions_values VALUES("59", "15", "email", "gerard-maylos@tele2.nl");
INSERT INTO wprg_e_submissions_values VALUES("60", "15", "message", "Hello, \r\n \r\nIndie Music: https://indie2019.blogspot.com/ \r\nAmbient, Industrial Music: https://ambient-2019.blogspot.com/ \r\nEurope Music Promo Only: https://europesmusic.blogspot.com/ \r\nItalodance Music: https://webidc.blogspot.com/ \r\nAlternative Rock, Punk Rock: https://alternativesrock.blogspot.com/ \r\n \r\nDownloads made through our private server by simple use of FTP (File Transfer Protocol) program. fresh music categorized by genres! (Genre: House, Progressive House, Electro House, Tech House, Deep House, Soulful House, Nu-Disco, Techno, Minimal, Djs Chart and EXCLUSIVE ALBUM & TRACKS, …) \r\n \r\nBest regards, Walter");
INSERT INTO wprg_e_submissions_values VALUES("61", "16", "name", "Natalie Turner");
INSERT INTO wprg_e_submissions_values VALUES("62", "16", "field_1", "8053086538");
INSERT INTO wprg_e_submissions_values VALUES("63", "16", "email", "natalie@socialgrowthengine.com");
INSERT INTO wprg_e_submissions_values VALUES("64", "16", "message", "Hey it\'s Natalie a business developer here at Social Growth Engine, I just wanted to quickly reach out to see if we could help you with attracting new local customers on any of the major socials like Instagram, Twitter, YouTube and LinkedIn.\r\n\r\nI am sure you get a number of inquiries like this everyday so I will save the elevator pitch and just tell you straight out.  We are a team of 60+ Yanks, Aussies and Brits who dedicate our days to growing your accounts and getting sales on the largest social media platforms like Instagram, TikTok, YouTube etc.\r\n\r\nWe don’t use bots, everything we do is by hand manually and efficiently, we’ve helped 5000+ customers in 2021 alone and our 2022 is already off to a great start.\r\n\r\nWant to learn more? View our most loved products here https://linktr.ee/socialgrowthengine\r\n\r\nWarmest Regards\r\n\r\nNatalie Turner\r\nBusiness Development Manager - Social Growth Engine\r\nhttps://www.socialgrowthengine.com\r\n(I submitted this via your website contact form at https://hendersonvilletntow.com/contact, I hope you don\'t mind :-))");
INSERT INTO wprg_e_submissions_values VALUES("65", "17", "name", "Nataemolo");
INSERT INTO wprg_e_submissions_values VALUES("66", "17", "field_1", "85428676489");
INSERT INTO wprg_e_submissions_values VALUES("67", "17", "email", "woodthighgire1988@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("68", "17", "message", "Hey handsome! I want to be like a squeezed lemon so you can fuck me https://chicks-for-you.life/?u=41nkd08&o=8dhpkzk");
INSERT INTO wprg_e_submissions_values VALUES("69", "18", "name", "Nataemolo");
INSERT INTO wprg_e_submissions_values VALUES("70", "18", "field_1", "89174168979");
INSERT INTO wprg_e_submissions_values VALUES("71", "18", "email", "woodthighgire1988@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("72", "18", "message", "I am looking for sex, but do you want? Come in here https://chicks-for-you.life/?u=41nkd08&o=8dhpkzk");
INSERT INTO wprg_e_submissions_values VALUES("73", "19", "name", "Eric Jones");
INSERT INTO wprg_e_submissions_values VALUES("74", "19", "field_1", "555-555-1212");
INSERT INTO wprg_e_submissions_values VALUES("75", "19", "email", "eric.jones.z.mail@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("76", "19", "message", "Hey, this is Eric and I ran across hendersonvilletntow.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=hendersonvilletntow.com");
INSERT INTO wprg_e_submissions_values VALUES("77", "20", "name", "seo_courses");
INSERT INTO wprg_e_submissions_values VALUES("78", "20", "field_1", "82979916566");
INSERT INTO wprg_e_submissions_values VALUES("79", "20", "email", "87654325565@devioplus.ru");
INSERT INTO wprg_e_submissions_values VALUES("80", "20", "message", "Useful information \r\n  \r\nlink Thanks 12ce77a");
INSERT INTO wprg_e_submissions_values VALUES("81", "21", "name", "Eric Jones");
INSERT INTO wprg_e_submissions_values VALUES("82", "21", "field_1", "555-555-1212");
INSERT INTO wprg_e_submissions_values VALUES("83", "21", "email", "eric.jones.z.mail@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("84", "21", "message", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at hendersonvilletntow.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=hendersonvilletntow.com");
INSERT INTO wprg_e_submissions_values VALUES("85", "22", "name", "Samual Groth");
INSERT INTO wprg_e_submissions_values VALUES("86", "22", "field_1", "61-81-11-06");
INSERT INTO wprg_e_submissions_values VALUES("87", "22", "email", "samual@datalist.biz");
INSERT INTO wprg_e_submissions_values VALUES("88", "22", "message", "Hello,\r\n\r\nIt is with sad regret to inform you that DataList.biz is shutting down. We have made all our databases available for you at a one-time fee.\r\n\r\nYou can visit us on DataList.biz\r\n\r\nRegards.\r\nSamual");
INSERT INTO wprg_e_submissions_values VALUES("89", "23", "name", "JasonHek");
INSERT INTO wprg_e_submissions_values VALUES("90", "23", "field_1", "87419599756");
INSERT INTO wprg_e_submissions_values VALUES("91", "23", "email", "argulus@web.de");
INSERT INTO wprg_e_submissions_values VALUES("92", "23", "message", "Your income on Binary Options from $366595 >>>>>>>>>>>>>>  https://telegra.ph/Confirm-you-are-not-a-bot-03-24-3?92939   &lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;");
INSERT INTO wprg_e_submissions_values VALUES("93", "24", "name", "Henrybom");
INSERT INTO wprg_e_submissions_values VALUES("94", "24", "field_1", "89030067469");
INSERT INTO wprg_e_submissions_values VALUES("95", "24", "email", "qpgmbnujrd@npkgys.com");
INSERT INTO wprg_e_submissions_values VALUES("96", "24", "message", "Start your online work using the financial Robot. \r\nhttps://profit-gold-strategy.life/?u=bdlkd0x&o=x7t8nng");
INSERT INTO wprg_e_submissions_values VALUES("97", "25", "name", "Lacey Officer");
INSERT INTO wprg_e_submissions_values VALUES("98", "25", "field_1", "NA");
INSERT INTO wprg_e_submissions_values VALUES("99", "25", "email", "lacey@topdatalist.com");
INSERT INTO wprg_e_submissions_values VALUES("100", "25", "message", "Hello.\r\n\r\nIt is with sad regret to inform you TopDataList.com is shutting down.\r\n\r\nWe have made all our databases available for you for a once off fee.\r\n\r\nVisit us on TopDataList.com");
INSERT INTO wprg_e_submissions_values VALUES("101", "26", "name", "Henrybom");
INSERT INTO wprg_e_submissions_values VALUES("102", "26", "field_1", "89038232409");
INSERT INTO wprg_e_submissions_values VALUES("103", "26", "email", "tiger001819@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("104", "26", "message", "The online financial Robot is your key to success. \r\nhttps://get-profitshere.life/?u=bdlkd0x&o=x7t8nng");
INSERT INTO wprg_e_submissions_values VALUES("105", "27", "name", "Florence Lightfoot");
INSERT INTO wprg_e_submissions_values VALUES("106", "27", "field_1", "3057410118");
INSERT INTO wprg_e_submissions_values VALUES("107", "27", "email", "evie@kottongrammer.com");
INSERT INTO wprg_e_submissions_values VALUES("108", "27", "message", "Congrats on the average 4.5 stars on Google, you must do great work. I noticed a couple key errors on your site when searching for a towing service near Nashville. Could be why West Nashville Wrecker Service is above you on Google maps taking all the traffic. I just made a visibility report for you that reveals what to fix. If you want it just let me know. Take care.");
INSERT INTO wprg_e_submissions_values VALUES("109", "28", "name", "Monserrate");
INSERT INTO wprg_e_submissions_values VALUES("110", "28", "field_1", "(03) 5352 7774");
INSERT INTO wprg_e_submissions_values VALUES("111", "28", "email", "matthew@beyond7.com");
INSERT INTO wprg_e_submissions_values VALUES("112", "28", "message", "Hey there \r\n\r\nDon\'t you hate carrying a big bulky backpack when you are only going out for the day? This high quality shoulder bag solves that problem. \r\nCarry enough without bogging yourself down! Perfect for that fishing trip or day hike!\r\n\r\n50{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} OFF for the next 24 Hours ONLY + FREE Worldwide Shipping for a LIMITED time\r\n\r\nBuy now: https://fashionbag.sale\r\n\r\nTo your success, \r\n\r\nMonserrate");
INSERT INTO wprg_e_submissions_values VALUES("113", "29", "name", "Jeffreybut");
INSERT INTO wprg_e_submissions_values VALUES("114", "29", "field_1", "85638798614");
INSERT INTO wprg_e_submissions_values VALUES("115", "29", "email", "suzannebaier@tele2.nl");
INSERT INTO wprg_e_submissions_values VALUES("116", "29", "message", "Hello, \r\n \r\nDownload MP3/FLAC FTP full access to exclusive electronic music. https://0daymusic.org \r\nPrivate FTP Music/Albums/mp3 1990-2022 List: https://0daymusic.org/FTPtxt/ \r\n \r\nBest regards, 0daymusic Team.");
INSERT INTO wprg_e_submissions_values VALUES("117", "30", "name", "Emilie");
INSERT INTO wprg_e_submissions_values VALUES("118", "30", "field_1", "06-55380534");
INSERT INTO wprg_e_submissions_values VALUES("119", "30", "email", "richard.english@vantage.je");
INSERT INTO wprg_e_submissions_values VALUES("120", "30", "message", "Hello there \r\n\r\nI wanted to reach out and let you know about our new dog harness. It\'s really easy to put on and take off - in just 2 seconds - and it\'s personalized for each dog. \r\nPlus, we offer a lifetime warranty so you can be sure your pet is always safe and stylish.\r\n\r\nWe\'ve had a lot of success with it so far and I think your dog would love it. \r\n\r\nGet yours today with 50{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} OFF: https://caredogbest.com\r\n\r\nFREE Shipping - TODAY ONLY! \r\n\r\nRegards, \r\n\r\nEmilie");
INSERT INTO wprg_e_submissions_values VALUES("121", "31", "name", "Annalome");
INSERT INTO wprg_e_submissions_values VALUES("122", "31", "field_1", "+40 2252095447");
INSERT INTO wprg_e_submissions_values VALUES("123", "31", "email", "annalome@yahoo.com");
INSERT INTO wprg_e_submissions_values VALUES("124", "31", "message", "Неllo аll, guys! I knоw, mу mesѕagе mау be toо ѕpecіfiс,\r\nΒut mу sistеr found nіce mаn hеre and they marrіеd, sо how аbоut mе?ǃ :)\r\nΙ am 27 уеarѕ old, Anna, from Romаniа, Ι know Еnglіѕh аnd Gеrman lаnguаgеs alsо\r\nAnd... I hаve speсіfiс dіsеase, namеd nymphоmanіа. Who know what iѕ thіѕ, сan undеrѕtаnd me (bеtter tо ѕay іt immеdiatеlу)\r\nАh yеs, Ι cоok verу tаѕtуǃ and I lovе not only cook ;))\r\nΙm reаl gіrl, nоt рroѕtitute, аnd lоokіng fоr sеriouѕ аnd hot relatiоnshір...\r\nΑnуway, yоu cаn find my prоfile hеrе: http://handbenguaifi.tk/user/12715/");
INSERT INTO wprg_e_submissions_values VALUES("125", "32", "name", "Henrybom");
INSERT INTO wprg_e_submissions_values VALUES("126", "32", "field_1", "89031715955");
INSERT INTO wprg_e_submissions_values VALUES("127", "32", "email", "srconnor2007@yahoo.com");
INSERT INTO wprg_e_submissions_values VALUES("128", "32", "message", "The fastest way to make you wallet thick is here. https://bom.bookeat.es/gotodate/promotion");
INSERT INTO wprg_e_submissions_values VALUES("129", "33", "name", "Joseph");
INSERT INTO wprg_e_submissions_values VALUES("130", "33", "field_1", "555-555-5555");
INSERT INTO wprg_e_submissions_values VALUES("131", "33", "email", "donotreply@donotreply.com");
INSERT INTO wprg_e_submissions_values VALUES("132", "33", "message", "Go Fish wants to invest into your eCommerce site. https://www.GoFishCapital.com");
INSERT INTO wprg_e_submissions_values VALUES("133", "34", "name", "Derrick Belair");
INSERT INTO wprg_e_submissions_values VALUES("134", "34", "field_1", "800-946-0995");
INSERT INTO wprg_e_submissions_values VALUES("135", "34", "email", "derrick@getlisted.directory");
INSERT INTO wprg_e_submissions_values VALUES("136", "34", "message", "Hello, did you know that there are 241,120 internet directories in the world. \r\n\r\nThese websites are what drive traffic to YOUR business.\r\n\r\nWant more traffic?  Want more Sales?  We can help - today.\r\n\r\nYour website hendersonvilletntow.com is listed in only 70 of these directories. \r\n\r\nGet more traffic for your Global audience.\r\n\r\nOur automated system adds your website to all of the directories.\r\n\r\nYou can find it here: getlisted.directory/hendersonvilletntow.com\r\n\r\nAct today, and we will expedite your listings and waive the processing charge!");
INSERT INTO wprg_e_submissions_values VALUES("137", "35", "name", "AnikaRob");
INSERT INTO wprg_e_submissions_values VALUES("138", "35", "field_1", "+40 2440864170");
INSERT INTO wprg_e_submissions_values VALUES("139", "35", "email", "anikaRob@mail.com");
INSERT INTO wprg_e_submissions_values VALUES("140", "35", "message", "Неllo аll, guyѕ! I knоw, my meѕsаgе mау be tоо ѕреcіfіс,\r\nΒut my sіѕtеr fоund nіce man hеre аnd they mаrrіed, ѕo how about mе?ǃ :)\r\nI аm 25 уеаrs old, Anika, from Rоmаniа, I know Engliѕh and Germаn lаnguagеѕ alsо\r\nАnd... Ι have sреcіfic disеaѕe, namеd nуmphomаnіа. Ԝho knоw whаt іѕ this, cаn undеrstаnd mе (better tо say it immedіаtеlу)\r\nAh уеѕ, Ι cоok vеrу taѕtyǃ and Ι love not onlу сook ;))\r\nIm rеal gіrl, nоt рroѕtіtute, аnd loоking for serіоus and hot relаtiоnship...\r\nΑnyway, уоu саn find my profіle here: http://pullivegudyst.ml/user/75297/");
INSERT INTO wprg_e_submissions_values VALUES("141", "36", "name", "Augustus O\'Reilly");
INSERT INTO wprg_e_submissions_values VALUES("142", "36", "field_1", "078 6409 5114");
INSERT INTO wprg_e_submissions_values VALUES("143", "36", "email", "augustus@makemysitemobile.com");
INSERT INTO wprg_e_submissions_values VALUES("144", "36", "message", "Convert hendersonvilletntow.com to an app with one click!\r\n\r\n80{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} of users browse websites from their phones. \r\n\r\nHave the App send out push notifications without any extra marketing costs!\r\n\r\nMakeMySiteMobile.com");
INSERT INTO wprg_e_submissions_values VALUES("145", "37", "name", "Bernd Toohey");
INSERT INTO wprg_e_submissions_values VALUES("146", "37", "field_1", "800-946-0995");
INSERT INTO wprg_e_submissions_values VALUES("147", "37", "email", "bernd@getlisted.directory");
INSERT INTO wprg_e_submissions_values VALUES("148", "37", "message", "Hello, did you know that there are 241,120 internet directories in the world. \r\n\r\nThese websites are what drive traffic to YOUR business.\r\n\r\nWant more traffic?  Want more Sales?  We can help - today.\r\n\r\nYour website hendersonvilletntow.com is listed in only 70 of these directories. \r\n\r\nGet more traffic for your Global audience.\r\n\r\nOur automated system adds your website to all of the directories.\r\n\r\nYou can find it here: getlisted.directory/hendersonvilletntow.com\r\n\r\nAct today, and we will expedite your listings and waive the processing charge!\r\n\r\nWe have a special going on. Use \"FRIENDS\" on checkout for a 50{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} discount valid today.");
INSERT INTO wprg_e_submissions_values VALUES("149", "38", "name", "Eric Jones");
INSERT INTO wprg_e_submissions_values VALUES("150", "38", "field_1", "555-555-1212");
INSERT INTO wprg_e_submissions_values VALUES("151", "38", "email", "ericjonesmyemail@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("152", "38", "message", "Hey, this is Eric and I ran across hendersonvilletntow.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=hendersonvilletntow.com");
INSERT INTO wprg_e_submissions_values VALUES("153", "39", "name", "Eric Jones");
INSERT INTO wprg_e_submissions_values VALUES("154", "39", "field_1", "555-555-1212");
INSERT INTO wprg_e_submissions_values VALUES("155", "39", "email", "ericjonesmyemail@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("156", "39", "message", "My name’s Eric and I just came across your website - hendersonvilletntow.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like hendersonvilletntow.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=hendersonvilletntow.com");
INSERT INTO wprg_e_submissions_values VALUES("157", "40", "name", "Barb");
INSERT INTO wprg_e_submissions_values VALUES("158", "40", "field_1", "(02) 4978 8892");
INSERT INTO wprg_e_submissions_values VALUES("159", "40", "email", "andrea.klein@wissenschaftliches-arbeiten-lehren.de");
INSERT INTO wprg_e_submissions_values VALUES("160", "40", "message", "Hi there, \r\n\r\nI hope you\'re doing well. I wanted to let you know about our new BANGE backpacks and sling bags that just released.\r\n\r\nThe bags are waterproof and anti-theft, and have a built-in USB cable that can recharge your phone while you\'re on the go.\r\n\r\nBoth bags are made of durable and high-quality materials, and are perfect for everyday use or travel.\r\n\r\nOrder yours now at 50{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} OFF with FREE Shipping: https://bangeonline.shop\r\n\r\nCheers,\r\n\r\nBarb");
INSERT INTO wprg_e_submissions_values VALUES("161", "41", "name", "Crytobom");
INSERT INTO wprg_e_submissions_values VALUES("162", "41", "field_1", "89033132701");
INSERT INTO wprg_e_submissions_values VALUES("163", "41", "email", "sarjan_giler@yahoo.com");
INSERT INTO wprg_e_submissions_values VALUES("164", "41", "message", "Let the Robot bring you money while you rest. https://Type.rbertilsson.se/");
INSERT INTO wprg_e_submissions_values VALUES("165", "42", "name", "Elenaol");
INSERT INTO wprg_e_submissions_values VALUES("166", "42", "field_1", "+420 2691616421");
INSERT INTO wprg_e_submissions_values VALUES("167", "42", "email", "elenaol@hotmail.com");
INSERT INTO wprg_e_submissions_values VALUES("168", "42", "message", "Нello!\r\nPеrhaрs mу mеѕsаge іѕ toо ѕpeсіfіс.\r\nВut mу oldеr ѕiѕtеr found a wondеrful mаn herе аnd thеу have a grеat relаtionshір, but what аbout me?\r\nI am 23 yеаrѕ оld, Еlenа, from thе Сzеch Rерubliс, knоw Εngliѕh languаge also\r\nΑnd... bettеr to saу it іmmеdiаtеly. Ι am biѕexuаl. Ι аm not jеаlouѕ of аnother wоman... еsрeсіаlly if we make lovе togеther.\r\nΑh yеs, Ι coоk verу tаstу! аnd I lоvе not оnly coоk ;))\r\nΙm real gіrl аnd loоking for ѕerіouѕ and hоt relаtіonѕhiр...\r\nAnywау, уou сan fіnd mу рrofіlе herе: http://consearchcos.gq/usr-34932/");
INSERT INTO wprg_e_submissions_values VALUES("169", "43", "name", "Zelda Tillman");
INSERT INTO wprg_e_submissions_values VALUES("170", "43", "field_1", "3057410118");
INSERT INTO wprg_e_submissions_values VALUES("171", "43", "email", "zelda@fromfuture.net");
INSERT INTO wprg_e_submissions_values VALUES("172", "43", "message", "Just read Takion Lazer\'s review on your google page, sounds like you do amazing work.\r\n\r\nI discovered a few hidden errors on your site that are preventing you from showing up on the local Google maps when someone searches for you near Nashville. \r\n\r\nI just made a visibility report for you that reveals what to fix, it\'s completely complementary with no strings attached. \r\n\r\nYou can click here to unlock it: https://fromfuture.net/?unlockReport=https://hendersonvilletntow.com");
INSERT INTO wprg_e_submissions_values VALUES("173", "44", "name", "Anitra");
INSERT INTO wprg_e_submissions_values VALUES("174", "44", "field_1", "08262 64 43 71");
INSERT INTO wprg_e_submissions_values VALUES("175", "44", "email", "info@tcruk.net");
INSERT INTO wprg_e_submissions_values VALUES("176", "44", "message", "Is your dog\'s nails getting too long? If you\'re tired of going to the vet or groomer to get them trimmed, why not try PawSafer™? \r\nWith PawSafer™, you can trim your dog\'s nails from the comfort of your own home, and it only takes a few minutes!\r\n\r\nPawSafer™ is the safest and most convenient way to trim your dog\'s nails, and it\'s very affordable. \r\n\r\nGet it while it\'s still 50{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} OFF + FREE Shipping\r\n\r\nBuy here: https://pawsafer.sale\r\n \r\nAll the best, \r\n \r\nAnitra");
INSERT INTO wprg_e_submissions_values VALUES("177", "45", "name", "Ella Smith");
INSERT INTO wprg_e_submissions_values VALUES("178", "45", "field_1", "5712007758");
INSERT INTO wprg_e_submissions_values VALUES("179", "45", "email", "ella@theheritageseo.com");
INSERT INTO wprg_e_submissions_values VALUES("180", "45", "message", "Hi,\r\n\r\nWe have a team of 55+ highly qualified professionals who are certified in Google AdWords and ISO standards providing a wide range of services in order to generate higher visitor traffic to your website. \r\n\r\nThis ensures that your website gets higher rankings on the search engine pages. \r\n\r\nWe offer SEO (with plan & activity) Services at much lower Cost. I’d be happy to send you our package, pricing, and past work details\r\n\r\nRegards,\r\nElla Smith");
INSERT INTO wprg_e_submissions_values VALUES("181", "46", "name", "Edwina");
INSERT INTO wprg_e_submissions_values VALUES("182", "46", "field_1", "0474 19 01 03");
INSERT INTO wprg_e_submissions_values VALUES("183", "46", "email", "info@elitecycling.net");
INSERT INTO wprg_e_submissions_values VALUES("184", "46", "message", "Good day \r\n\r\nDon\'t you hate carrying a big bulky backpack when you are only going out for the day? Our hiking and trekking shoulder bag is perfect for day hikes and outdoor activities. It\'s comfortable, lightweight, and has plenty of room for all your essentials.\r\n\r\nWe\'re confident that you\'ll love our shoulder bag, and we\'re offering a special discount for our first 20 customers.\r\n\r\n50{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} OFF for the next 24 Hours ONLY + FREE Worldwide Shipping for a LIMITED time\r\n\r\nBuy now: https://fashionbag.sale\r\n\r\nBest regards, \r\n\r\nEdwina");
INSERT INTO wprg_e_submissions_values VALUES("185", "47", "name", "Eric Jones");
INSERT INTO wprg_e_submissions_values VALUES("186", "47", "field_1", "555-555-1212");
INSERT INTO wprg_e_submissions_values VALUES("187", "47", "email", "ericjonesmyemail@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("188", "47", "message", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found hendersonvilletntow.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=hendersonvilletntow.com");
INSERT INTO wprg_e_submissions_values VALUES("189", "48", "name", "Josephbrert");
INSERT INTO wprg_e_submissions_values VALUES("190", "48", "field_1", "82471721665");
INSERT INTO wprg_e_submissions_values VALUES("191", "48", "email", "no-replySoows@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("192", "48", "message", "Hеllо!  hendersonvilletntow.com \r\n \r\nDid yоu knоw thаt it is pоssiblе tо sеnd соmmеrсiаl оffеr uttеrly lеgitimаtе wаy? \r\nWе mаkе аvаilаblе а nеw mеthоd оf sеnding businеss prоpоsаl thrоugh соntасt fоrms. Suсh fоrms аrе lосаtеd оn mаny sitеs. \r\nWhеn suсh prоpоsаls аrе sеnt, nо pеrsоnаl dаtа is usеd, аnd mеssаgеs аrе sеnt tо fоrms spесifiсаlly dеsignеd tо rесеivе mеssаgеs аnd аppеаls. \r\nаlsо, mеssаgеs sеnt thrоugh соntасt Fоrms dо nоt gеt intо spаm bесаusе suсh mеssаgеs аrе соnsidеrеd impоrtаnt. \r\nWе оffеr yоu tо tеst оur sеrviсе fоr frее. Wе will sеnd up tо 50,000 mеssаgеs fоr yоu. \r\nThе соst оf sеnding оnе milliоn mеssаgеs is 49 USD. \r\n \r\nThis оffеr is сrеаtеd аutоmаtiсаlly. Plеаsе usе thе соntасt dеtаils bеlоw tо соntасt us. \r\n \r\nContact us. \r\nTelegram - @FeedbackMessages \r\nSkype  live:contactform_18 \r\nWhatsApp - +375259112693 \r\nWe only use chat.");
INSERT INTO wprg_e_submissions_values VALUES("193", "49", "name", "Joseph");
INSERT INTO wprg_e_submissions_values VALUES("194", "49", "field_1", "‪1(800) 918-2957");
INSERT INTO wprg_e_submissions_values VALUES("195", "49", "email", "donotreply@gofishcapital.com");
INSERT INTO wprg_e_submissions_values VALUES("196", "49", "message", "Go to www.GoFishCapital.com for more info. We are a reputable lender that has been doing business since 2010.");
INSERT INTO wprg_e_submissions_values VALUES("197", "50", "name", "Tania");
INSERT INTO wprg_e_submissions_values VALUES("198", "50", "field_1", "0396 1976897");
INSERT INTO wprg_e_submissions_values VALUES("199", "50", "email", "info@sezen-statik.de");
INSERT INTO wprg_e_submissions_values VALUES("200", "50", "message", "World\'s Best Neck Massager Get it Now 50{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} OFF + Free Shipping!\r\n\r\nWellness Enthusiasts! There has never been a better time to take care of your neck pain! \r\nOur clinical-grade TENS technology will ensure you have neck relief in as little as 20 minutes.\r\n\r\nGet Yours: https://hineck.shop\r\n\r\nBest regards,\r\n\r\nTania\r\nNash Towing Inc Nash Towing And Lockout – Call Us First");
INSERT INTO wprg_e_submissions_values VALUES("201", "51", "name", "Eric Jones");
INSERT INTO wprg_e_submissions_values VALUES("202", "51", "field_1", "555-555-1212");
INSERT INTO wprg_e_submissions_values VALUES("203", "51", "email", "ericjonesmyemail@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("204", "51", "message", "Hi, my name is Eric and I’m betting you’d like your website hendersonvilletntow.com to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at hendersonvilletntow.com.\r\n\r\nTalk With Web Visitor – CLICK HERE https://boostleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=hendersonvilletntow.com");
INSERT INTO wprg_e_submissions_values VALUES("205", "52", "name", "Kathy Poston");
INSERT INTO wprg_e_submissions_values VALUES("206", "52", "field_1", "6156428495");
INSERT INTO wprg_e_submissions_values VALUES("207", "52", "email", "kathy@epool.com");
INSERT INTO wprg_e_submissions_values VALUES("208", "52", "message", "Nash Towing towed our van and we got a Square receipt, but now our insurance company needs a better receipt. They want one with our name, the kind of vehicle, and the date of tow. My husband is Mike Poston. He had our 09 Honda Odyssey towed from McGavock High School to Accurate Automotive on 09/19/22. The total was $170. Can you email the receipt to me, or I can pick it up if I need to. Thank you.");
INSERT INTO wprg_e_submissions_values VALUES("209", "53", "name", "Bram Bram");
INSERT INTO wprg_e_submissions_values VALUES("210", "53", "field_1", "603-998-0176");
INSERT INTO wprg_e_submissions_values VALUES("211", "53", "email", "free@freeaiwriting.com");
INSERT INTO wprg_e_submissions_values VALUES("212", "53", "message", "Dear, \r\n\r\nI came across hendersonvilletntow.com and wanted to share this great free AI tool. \r\nWith this tool you write content 10 times faster and with much higher conversion rates. \r\nYou can use the tool for free via freeaiwriting.com \r\n\r\nThe AI can write blogs, advertising copy, youtube videos and even entire books. \r\nWe would love to hear your feedback. \r\n\r\n\r\nKind regards, \r\nBram \r\nFreeaiwriting.com");
INSERT INTO wprg_e_submissions_values VALUES("213", "54", "name", "CatherinaPync");
INSERT INTO wprg_e_submissions_values VALUES("214", "54", "field_1", "84111575591");
INSERT INTO wprg_e_submissions_values VALUES("215", "54", "email", "catherinaPync@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("216", "54", "message", "Hellо all, guуs! I know, my meѕѕаgе maу be tоo ѕреcіfiс,\r\nΒut mу sistеr found niсе man hеrе and thеy mаrriеd, sо hоw аbout me?ǃ :)\r\nΙ аm 24 уеarѕ оld, Catherіnа, from Rоmaniа, Ι know Εnglіsh and Germаn languаgеs also\r\nΑnd... I hаvе ѕpесifiс dіseаѕe, named nуmphomаnia. Who knоw whаt іѕ thіs, cаn understand me (bettеr tо saу іt іmmedіаtеlу)\r\nΑh yеѕ, I соok verу tаѕtyǃ and I lоve not only cооk ;))\r\nΙm rеal girl, not prostіtute, аnd lооking for ѕеriоuѕ аnd hоt rеlatіonѕhіp...\r\nAnуway, уоu сan fіnd mу рrоfile hеre: http://vioraco.tk/page/73953/");
INSERT INTO wprg_e_submissions_values VALUES("217", "55", "name", "Anikaalof");
INSERT INTO wprg_e_submissions_values VALUES("218", "55", "field_1", "+420 2547658211");
INSERT INTO wprg_e_submissions_values VALUES("219", "55", "email", "anikaalof@aol.com");
INSERT INTO wprg_e_submissions_values VALUES("220", "55", "message", "Неllo!\r\nРеrhарs my mеѕѕаge is too sресіfіc.\r\nΒut mу older sіstеr found a wonderful man herе and thеу have а greаt relаtіonshiр, but whаt about mе?\r\nI аm 24 years old, Αnika, from thе Czeсh Rеpublіс, know Engliѕh lаnguаgе аlѕо\r\nАnd... bеtter to ѕay іt іmmediatеly. Ι аm bіsеxual. Ι am nоt ϳеalouѕ of another woman... еspеciаllу if wе mаke lоve togеther.\r\nAh yеs, I сооk very tastyǃ and I lovе nоt оnlу сооk ;))\r\nΙm rеal girl аnd looking for serіоuѕ and hоt rеlationѕhiр...\r\nΑnуwау, уоu can find my prоfіle hеre: http://qualasipa.tk/item-31313/");
INSERT INTO wprg_e_submissions_values VALUES("221", "56", "name", "James");
INSERT INTO wprg_e_submissions_values VALUES("222", "56", "field_1", "000000000000");
INSERT INTO wprg_e_submissions_values VALUES("223", "56", "email", "james@linkpartners.info");
INSERT INTO wprg_e_submissions_values VALUES("224", "56", "message", "Hi, \r\n\r\nI\'m interested in buying links or sponsored content on hendersonvilletntow.com. \r\n\r\nIs this something that you can offer? \r\n\r\n\r\n\r\nThanks, \r\nJames\r\nwww.linkpartners.info\r\n\r\n----\r\n\r\nTo UNSUBSCRIBE and never get contacted again: https://linkpartners.info/unsubscribe-page/\r\nTo ADD YOUR SITE to our business network: https://linkpartners.info/subscribe-page/ , or simply reply to this email.");
INSERT INTO wprg_e_submissions_values VALUES("225", "57", "name", "Jacquie");
INSERT INTO wprg_e_submissions_values VALUES("226", "57", "field_1", "69 902 93 26");
INSERT INTO wprg_e_submissions_values VALUES("227", "57", "email", "jacquie.bieber@gmail.com");
INSERT INTO wprg_e_submissions_values VALUES("228", "57", "message", "Hello \r\n\r\nI wanted to reach out and let you know about our new dog harness. It\'s really easy to put on and take off - in just 2 seconds - and it\'s personalized for each dog. \r\nPlus, we offer a lifetime warranty so you can be sure your pet is always safe and stylish.\r\n\r\nWe\'ve had a lot of success with it so far and I think your dog would love it. \r\n\r\nGet yours today with 50{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc} OFF: https://caredogbest.com\r\n\r\nFREE Shipping - TODAY ONLY! \r\n\r\nBest, \r\n\r\nJacquie");
INSERT INTO wprg_e_submissions_values VALUES("229", "58", "name", "Luke Hill");
INSERT INTO wprg_e_submissions_values VALUES("230", "58", "field_1", "(904) 312-7970");
INSERT INTO wprg_e_submissions_values VALUES("231", "58", "email", "luke@wereliveconsulting.com");
INSERT INTO wprg_e_submissions_values VALUES("232", "58", "message", "Hi guys,\r\n\r\nI found your tow truck website by searching \"tow truck Hendersonville TN\" and I didn\'t find you on the first results.\r\n\r\nOur company recently helped a tow truck business in Vancouver get an additional 224 calls in November.\r\n\r\nAn additional towing business in Florida working with us also just recently hit the top of Google.\r\n\r\nWould it be completely unreasonable to jump on a phone call in a day or 2?\r\n\r\nMany Thanks,\r\n\r\n\r\nLuke Hill\r\n\r\nDirector of Marketing\r\nWe\'re Live Consulting\r\n904-312-7970");
INSERT INTO wprg_e_submissions_values VALUES("233", "59", "name", "Serenity");
INSERT INTO wprg_e_submissions_values VALUES("234", "59", "field_1", "3057410118");
INSERT INTO wprg_e_submissions_values VALUES("235", "59", "email", "serenity@reputationresults.net");
INSERT INTO wprg_e_submissions_values VALUES("236", "59", "message", "Just saw Takion Lazer\'s review on your google page, sounds like you do amazing work.\r\n\r\nSpeaking of reviews, I just made a reputation report for you that reveals what your customers are saying about your company online.\r\n\r\nYou can click here to unlock it: https://reputationresults.net?site=http://hendersonvilletntow.com\r\n\r\nHappy new year!");
INSERT INTO wprg_e_submissions_values VALUES("237", "60", "name", "Alenapem");
INSERT INTO wprg_e_submissions_values VALUES("238", "60", "field_1", "+40 2533458648");
INSERT INTO wprg_e_submissions_values VALUES("239", "60", "email", "alenapem@helenguimetbioboulirec.tk");
INSERT INTO wprg_e_submissions_values VALUES("240", "60", "message", "Ηеllо all, guуsǃ I knоw, my mеѕѕаgе mаy bе too sреcific,\r\nBut my sіster found niсe mаn hеre аnd theу marrіеd, ѕo how about mе?! :)\r\nΙ аm 28 yеаrѕ old, Аlena, frоm Rоmаniа, Ι knоw English аnd Germаn lаnguagеs alѕо\r\nΑnd... Ι have ѕреcіfіс dіsеasе, nаmеd nуmphоmania. Ԝho know whаt іs this, can undеrѕtand me (bеttеr tо sау it immеdiаtelу)\r\nAh уeѕ, Ι сооk vеry taѕtyǃ аnd Ι lоvе not оnly сооk ;))\r\nΙm rеаl girl, not рrostіtute, and lооkіng for ѕeriоuѕ аnd hоt relаtionshір...\r\nAnywаy, you can fіnd my рrоfіlе here: http://nuepynu.gq/itm-26862/");
INSERT INTO wprg_e_submissions_values VALUES("241", "61", "name", "Jennifer Obrien");
INSERT INTO wprg_e_submissions_values VALUES("242", "61", "field_1", "9497557782");
INSERT INTO wprg_e_submissions_values VALUES("243", "61", "email", "jennifer@dandydemo.com");
INSERT INTO wprg_e_submissions_values VALUES("244", "61", "message", "Would you like a solution to consistently remove unfair bad reviews from Google My Business, Yelp, Opentable and other review sites? At Dandy, our proprietary technology has helped companies like Holiday Inn and Wyndham remove over 21,000 negative reviews for their locations and consistently monitors and helps remove any new negative reviews that appear. \r\n\r\nDo you have 15 minutes for a call today? Schedule a Call Here: https://meetings.hubspot.com/dandy-/dandy-demo-numan  or for more information please visit our website: https://getdandy.com/more-information\r\n\r\nYou can also call me directly at (949) 755-7782.\r\n\r\nYou\'ll see a few case studies there - one of which we removed 60 negative reviews within the first 90 days for one of our customers. Remember, negative reviews can reduce traffic up to 15{fc4e2b712e722a9bdead510a9932a86af8d8335fcf7ea9f8d77b635ff285adcc}. \r\n\r\nThank you,\r\n\r\n\r\nJennifer Obrien | Senior Review Specialist\r\nDandy, Inc. - Remove, Prevent & Capture\r\nOffice (949) 755-7782\r\n9891 Irvine Center Drive, Suite #200, Irvine, CA 92618\r\n\r\nUnsubscribe Now");

DROP TABLE IF EXISTS wprg_links;

CREATE TABLE `wprg_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wprg_options;

CREATE TABLE `wprg_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=93892 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wprg_options VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO wprg_options VALUES("10", "require_name_email", "1", "yes");
INSERT INTO wprg_options VALUES("11", "comments_notify", "1", "yes");
INSERT INTO wprg_options VALUES("12", "posts_per_rss", "12", "yes");
INSERT INTO wprg_options VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO wprg_options VALUES("18", "default_category", "1", "yes");
INSERT INTO wprg_options VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO wprg_options VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO wprg_options VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO wprg_options VALUES("22", "posts_per_page", "12", "yes");
INSERT INTO wprg_options VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO wprg_options VALUES("28", "permalink_structure", "/{27801895381e78c9cca8a80bc2749f0f80e557dd0d16bd5edc0f75a9f2dc1bfe}postname{27801895381e78c9cca8a80bc2749f0f80e557dd0d16bd5edc0f75a9f2dc1bfe}/", "yes");
INSERT INTO wprg_options VALUES("30", "hack_file", "0", "yes");
INSERT INTO wprg_options VALUES("32", "moderation_keys", "", "no");
INSERT INTO wprg_options VALUES("34", "category_base", "", "yes");
INSERT INTO wprg_options VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO wprg_options VALUES("38", "default_email_category", "1", "yes");
INSERT INTO wprg_options VALUES("45", "html_type", "text/html", "yes");
INSERT INTO wprg_options VALUES("48", "db_version", "49752", "yes");
INSERT INTO wprg_options VALUES("52", "default_link_category", "2", "yes");
INSERT INTO wprg_options VALUES("53", "show_on_front", "page", "yes");
INSERT INTO wprg_options VALUES("54", "tag_base", "", "yes");
INSERT INTO wprg_options VALUES("55", "show_avatars", "1", "yes");
INSERT INTO wprg_options VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO wprg_options VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO wprg_options VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO wprg_options VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO wprg_options VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO wprg_options VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO wprg_options VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO wprg_options VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO wprg_options VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO wprg_options VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO wprg_options VALUES("67", "image_default_size", "", "yes");
INSERT INTO wprg_options VALUES("68", "image_default_align", "", "yes");
INSERT INTO wprg_options VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO wprg_options VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO wprg_options VALUES("71", "thread_comments", "1", "yes");
INSERT INTO wprg_options VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO wprg_options VALUES("73", "page_comments", "0", "yes");
INSERT INTO wprg_options VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO wprg_options VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO wprg_options VALUES("76", "comment_order", "asc", "yes");
INSERT INTO wprg_options VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO wprg_options VALUES("78", "widget_categories", "a:2:{i:2;a:5:{s:5:\"title\";s:10:\"Categories\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:1;s:7:\"classes\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("79", "widget_text", "a:4:{i:1;a:0:{}i:2;a:5:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:195:\"<img src=\"https://hendersonvilletntow.com/wp-content/uploads/2016/11/logo_bottom.png\" alt=\"logo\">\r\n\r\nSome str. 321, Los Angeles, CA, US\r\n\r\ninfo@company.com\r\n\r\nwww.company.com\r\n\r\n8 (800) 123-23456\";s:6:\"filter\";b:1;s:17:\"widget_background\";s:0:\"\";s:15:\"bootstrap_width\";s:8:\"col-sm-3\";}i:3;a:5:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:1;s:7:\"classes\";s:13:\"no-gap-widget\";s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("83", "page_for_posts", "2", "yes");
INSERT INTO wprg_options VALUES("84", "page_on_front", "53", "yes");
INSERT INTO wprg_options VALUES("85", "default_post_format", "0", "yes");
INSERT INTO wprg_options VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO wprg_options VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO wprg_options VALUES("88", "site_icon", "518", "yes");
INSERT INTO wprg_options VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO wprg_options VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO wprg_options VALUES("91", "initial_db_version", "36686", "yes");
INSERT INTO wprg_options VALUES("93", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("94", "widget_recent-posts", "a:2:{i:3;a:4:{s:5:\"title\";s:12:\"Recent Posts\";s:6:\"number\";i:2;s:9:\"show_date\";b:1;s:7:\"classes\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("95", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("96", "widget_archives", "a:2:{i:2;a:4:{s:5:\"title\";s:8:\"Archives\";s:5:\"count\";i:0;s:8:\"dropdown\";i:1;s:7:\"classes\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("97", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("98", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:16:{i:0;s:13:\"mwt_twitter-2\";i:1;s:25:\"woocommerce_layered_nav-2\";i:2;s:26:\"woocommerce_price_filter-2\";i:3;s:28:\"woocommerce_product_search-2\";i:4;s:31:\"woocommerce_product_tag_cloud-2\";i:5;s:22:\"woocommerce_products-2\";i:6;s:6:\"text-2\";i:7;s:19:\"mc4wp_form_widget-2\";i:8;s:11:\"tag_cloud-2\";i:9;s:12:\"rvm_widget-3\";i:10;s:12:\"rvm_widget-4\";i:11;s:28:\"woocommerce_product_search-3\";i:12;s:25:\"woocommerce_widget_cart-2\";i:13;s:32:\"woocommerce_product_categories-2\";i:14;s:26:\"woocommerce_price_filter-3\";i:15;s:32:\"woocommerce_top_rated_products-2\";}s:12:\"sidebar-main\";a:6:{i:0;s:13:\"apsc_widget-3\";i:1;s:19:\"mc4wp_form_widget-3\";i:2;s:17:\"wp_my_instagram-2\";i:3;s:12:\"categories-2\";i:4;s:14:\"recent-posts-3\";i:5;s:10:\"archives-2\";}s:16:\"sidebar-footer-1\";a:1:{i:1;s:6:\"text-3\";}s:16:\"sidebar-footer-2\";a:1:{i:0;s:10:\"nav_menu-2\";}s:16:\"sidebar-footer-3\";a:1:{i:0;s:16:\"mwt_icons_list-2\";}s:16:\"sidebar-footer-4\";a:0:{}s:19:\"before-blog-sidebar\";a:2:{i:0;s:20:\"recent-post-slider-2\";i:1;s:11:\"mwt_posts-2\";}s:10:\"Vector-Map\";a:1:{i:0;s:12:\"rvm_widget-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO wprg_options VALUES("99", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("100", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("101", "widget_tag_cloud", "a:2:{i:2;a:4:{s:5:\"title\";s:4:\"Tags\";s:8:\"taxonomy\";s:8:\"post_tag\";s:17:\"widget_background\";s:0:\"\";s:15:\"bootstrap_width\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("102", "widget_nav_menu", "a:2:{i:2;a:2:{s:5:\"title\";s:12:\"Useful Links\";s:8:\"nav_menu\";i:15;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("137", "fw_active_extensions", "a:33:{s:4:\"blog\";a:0:{}s:10:\"shortcodes\";a:0:{}s:12:\"page-builder\";a:0:{}s:17:\"editor-shortcodes\";a:0:{}s:7:\"builder\";a:0:{}s:5:\"forms\";a:0:{}s:13:\"contact-forms\";a:0:{}s:6:\"mailer\";a:0:{}s:6:\"update\";a:0:{}s:13:\"github-update\";a:0:{}s:12:\"theme-slider\";a:0:{}s:5:\"media\";a:0:{}s:6:\"slider\";a:0:{}s:9:\"bx-slider\";a:0:{}s:11:\"nivo-slider\";a:0:{}s:12:\"owl-carousel\";a:0:{}s:17:\"population-method\";a:0:{}s:28:\"population-method-categories\";a:0:{}s:24:\"population-method-custom\";a:0:{}s:23:\"population-method-posts\";a:0:{}s:22:\"population-method-tags\";a:0:{}s:11:\"breadcrumbs\";a:0:{}s:6:\"social\";a:0:{}s:15:\"social-facebook\";a:0:{}s:14:\"social-twitter\";a:0:{}s:8:\"megamenu\";a:0:{}s:9:\"portfolio\";a:0:{}s:7:\"backups\";a:0:{}s:12:\"backups-demo\";a:0:{}s:8:\"sidebars\";a:0:{}s:8:\"services\";a:0:{}s:16:\"bitbucket-update\";a:0:{}s:13:\"custom-update\";a:0:{}}", "yes");
INSERT INTO wprg_options VALUES("140", "theme_mods_twentysixteen", "a:2:{s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:15;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1544173741;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:16:{i:0;s:25:\"woocommerce_layered_nav-2\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:28:\"woocommerce_product_search-2\";i:3;s:31:\"woocommerce_product_tag_cloud-2\";i:4;s:22:\"woocommerce_products-2\";i:5;s:6:\"text-2\";i:6;s:19:\"mc4wp_form_widget-2\";i:7;s:11:\"tag_cloud-2\";i:8;s:12:\"rvm_widget-2\";i:9;s:12:\"rvm_widget-3\";i:10;s:12:\"rvm_widget-4\";i:11;s:28:\"woocommerce_product_search-3\";i:12;s:25:\"woocommerce_widget_cart-2\";i:13;s:32:\"woocommerce_product_categories-2\";i:14;s:26:\"woocommerce_price_filter-3\";i:15;s:32:\"woocommerce_top_rated_products-2\";}s:9:\"sidebar-1\";a:6:{i:0;s:13:\"apsc_widget-3\";i:1;s:19:\"mc4wp_form_widget-3\";i:2;s:6:\"text-4\";i:3;s:12:\"categories-2\";i:4;s:14:\"recent-posts-3\";i:5;s:10:\"archives-2\";}s:9:\"sidebar-2\";a:1:{i:0;s:6:\"text-3\";}s:9:\"sidebar-3\";a:1:{i:0;s:10:\"nav_menu-2\";}}}}", "yes");
INSERT INTO wprg_options VALUES("142", "theme_mods_solar-parent", "a:4:{i:0;b:0;s:10:\"fw_options\";a:11:{s:10:\"logo_image\";a:2:{s:13:\"attachment_id\";s:2:\"49\";s:3:\"url\";s:61:\"//hendersonvilletntow.com/wp-content/uploads/2016/07/logo.png\";}s:6:\"header\";s:1:\"1\";s:12:\"header_phone\";s:11:\"222-333-222\";s:12:\"header_email\";s:13:\"mail@test.com\";s:12:\"social_icons\";a:2:{i:0;a:3:{s:4:\"icon\";s:24:\"social-icon soc-linkedin\";s:10:\"icon_class\";s:0:\"\";s:8:\"icon_url\";s:19:\"http://linkedin.com\";}i:1;a:3:{s:4:\"icon\";s:23:\"social-icon soc-twitter\";s:10:\"icon_class\";s:0:\"\";s:8:\"icon_url\";s:11:\"twitter.com\";}}s:9:\"logo_text\";s:0:\"\";s:22:\"logo_image_breadcrumbs\";a:2:{s:13:\"attachment_id\";s:2:\"49\";s:3:\"url\";s:61:\"//hendersonvilletntow.com/wp-content/uploads/2016/07/logo.png\";}s:15:\"preloader_image\";s:0:\"\";s:6:\"footer\";s:1:\"1\";s:10:\"copyrights\";s:1:\"1\";s:11:\"breadcrumbs\";s:1:\"1\";}s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:15;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1479730369;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"sidebar-main\";a:8:{i:0;s:8:\"search-2\";i:1;s:11:\"blog_tabs-2\";i:2;s:14:\"recent-posts-2\";i:3;s:17:\"recent-comments-2\";i:4;s:10:\"archives-2\";i:5;s:11:\"tag_cloud-2\";i:6;s:12:\"categories-2\";i:7;s:6:\"meta-2\";}s:14:\"sidebar-footer\";a:1:{i:0;s:6:\"text-2\";}}}}", "yes");
INSERT INTO wprg_options VALUES("143", "theme_switched", "", "yes");
INSERT INTO wprg_options VALUES("144", "widget_blog_tabs", "a:2:{i:2;a:3:{s:6:\"number\";s:0:\"\";s:17:\"widget_background\";s:0:\"\";s:15:\"bootstrap_width\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("145", "widget_flickr", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("146", "widget_social", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("147", "widget_theme_posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("149", "widget_facebook_page_stream", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("150", "widget_theme_portfolio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("151", "widget_twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wprg_options VALUES("152", "fw_google_fonts", "a:2:{s:11:\"last_update\";i:1677391861;s:5:\"fonts\";s:1168061:\"{\n  \"kind\": \"webfonts#webfontList\",\n  \"items\": [\n    {\n      \"family\": \"ABeeZee\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/abeezee/v22/esDR31xSG-6AGleN6tKukbcHCpE.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/abeezee/v22/esDT31xSG-6AGleN2tCklZUCGpG-GQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Abel\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/abel/v18/MwQ5bhbm2POE6VhLPJp6qGI.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Abhaya Libre\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"sinhala\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/abhayalibre/v13/e3tmeuGtX-Co5MNzeAOqinEge0PWovdU4w.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/abhayalibre/v13/e3t5euGtX-Co5MNzeAOqinEYj2ryqtxI6oYtBA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/abhayalibre/v13/e3t5euGtX-Co5MNzeAOqinEYo23yqtxI6oYtBA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/abhayalibre/v13/e3t5euGtX-Co5MNzeAOqinEYx2zyqtxI6oYtBA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/abhayalibre/v13/e3t5euGtX-Co5MNzeAOqinEY22_yqtxI6oYtBA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Aboreto\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/aboreto/v2/5DCXAKLhwDDQ4N8blKTeA2yuxSY.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Abril Fatface\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/abrilfatface/v19/zOL64pLDlL1D99S8g8PtiKchm-BsjOLhZBY.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Abyssinica SIL\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"ethiopic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/abyssinicasil/v5/oY1H8ezOqK7iI3rK_45WKoc8J6UZBFOVAXuI.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Aclonica\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/aclonica/v18/K2FyfZJVlfNNSEBXGb7TCI6oBjLz.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Acme\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/acme/v21/RrQfboBx-C5_bx3Lb23lzLk.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Actor\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/actor/v17/wEOzEBbCkc5cO3ekXygtUMIO.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Adamina\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/adamina/v21/j8_r6-DH1bjoc-dwu-reETl4Bno.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Advent Pro\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLQyJPTJoonw1aBA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLwyNPTJoonw1aBA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLHSNPTJoonw1aBA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLQyNPTJoonw1aBA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLcSNPTJoonw1aBA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLnSRPTJoonw1aBA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLpCRPTJoonw1aBA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLwyRPTJoonw1aBA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpL6iRPTJoonw1aBA.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2CnDpAsvQhKBH4C.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2AnD5AsvQhKBH4C.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2D5D5AsvQhKBH4C.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2CnD5AsvQhKBH4C.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2CVD5AsvQhKBH4C.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2B5CJAsvQhKBH4C.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2BACJAsvQhKBH4C.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2AnCJAsvQhKBH4C.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/adventpro/v19/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2AOCJAsvQhKBH4C.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Aguafina Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/aguafinascript/v16/If2QXTv_ZzSxGIO30LemWEOmt1bHqs4pgicOrg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Akaya Kanadaka\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"kannada\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/akayakanadaka/v16/N0bM2S5CPO5oOQqvazoRRb-8-PfRS5VBBSSF.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Akaya Telivigala\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"telugu\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/akayatelivigala/v22/lJwc-oo_iG9wXqU3rCTD395tp0uifdLdsIH0YH8.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Akronim\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/akronim/v23/fdN-9sqWtWZZlHRp-gBxkFYN-a8.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Akshar\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/akshar/v5/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSSgFy9CY94XsnPc.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/akshar/v5/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSXYFy9CY94XsnPc.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/akshar/v5/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSUQFy9CY94XsnPc.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/akshar/v5/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSagCy9CY94XsnPc.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/akshar/v5/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSZECy9CY94XsnPc.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Aladin\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/aladin/v18/ZgNSjPJFPrvJV5f16Sf4pGT2Ng.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alata\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alata/v9/PbytFmztEwbIofe6xKcRQEOX.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alatsi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-11-18\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alatsi/v10/TK3iWkUJAxQ2nLNGHjUHte5fKg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Albert Sans\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHq5L_rI32TxAj1g.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHK5P_rI32TxAj1g.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSH9ZP_rI32TxAj1g.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHq5P_rI32TxAj1g.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHmZP_rI32TxAj1g.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHdZT_rI32TxAj1g.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHTJT_rI32TxAj1g.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHK5T_rI32TxAj1g.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHApT_rI32TxAj1g.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9AX7ofybRUz1r5t.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9CX74fybRUz1r5t.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9BJ74fybRUz1r5t.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9AX74fybRUz1r5t.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9Al74fybRUz1r5t.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9DJ6IfybRUz1r5t.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9Dw6IfybRUz1r5t.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9CX6IfybRUz1r5t.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/albertsans/v1/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9C-6IfybRUz1r5t.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Aldrich\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/aldrich/v17/MCoTzAn-1s3IGyJMZaAS3pP5H_E.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alef\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alef/v21/FeVfS0NQpLYgrjJbC5FxxbU.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/alef/v21/FeVQS0NQpLYglo50L5la2bxii28.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alegreya\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v31\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alegreya/v31/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNG9hUI_KCisSGVrw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/alegreya/v31/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGxBUI_KCisSGVrw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/alegreya/v31/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGKBII_KCisSGVrw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/alegreya/v31/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGERII_KCisSGVrw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/alegreya/v31/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGdhII_KCisSGVrw.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/alegreya/v31/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGXxII_KCisSGVrw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/alegreya/v31/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlbgv6qmkySFr9V9.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/alegreya/v31/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlbSv6qmkySFr9V9.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/alegreya/v31/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlY-uKqmkySFr9V9.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/alegreya/v31/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlYHuKqmkySFr9V9.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/alegreya/v31/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlZguKqmkySFr9V9.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/alegreya/v31/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlZJuKqmkySFr9V9.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alegreya SC\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alegreyasc/v25/taiOGmRtCJ62-O0HhNEa-a6o05E5abe_.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/alegreyasc/v25/taiMGmRtCJ62-O0HhNEa-Z6q2ZUbbKe_DGs.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/alegreyasc/v25/taiTGmRtCJ62-O0HhNEa-ZZc-rUxQqu2FXKD.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/alegreyasc/v25/taiRGmRtCJ62-O0HhNEa-Z6q4WEySK-UEGKDBz4.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/alegreyasc/v25/taiTGmRtCJ62-O0HhNEa-ZYU_LUxQqu2FXKD.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/alegreyasc/v25/taiRGmRtCJ62-O0HhNEa-Z6q4Sk0SK-UEGKDBz4.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/alegreyasc/v25/taiTGmRtCJ62-O0HhNEa-ZYI_7UxQqu2FXKD.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/alegreyasc/v25/taiRGmRtCJ62-O0HhNEa-Z6q4TU3SK-UEGKDBz4.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/alegreyasc/v25/taiTGmRtCJ62-O0HhNEa-ZYs_rUxQqu2FXKD.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/alegreyasc/v25/taiRGmRtCJ62-O0HhNEa-Z6q4RE2SK-UEGKDBz4.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alegreya Sans\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUt9_-1phKLFgshYDvh6Vwt5TltuGdShm5bsg.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUv9_-1phKLFgshYDvh6Vwt7V9V3G1WpGtLsgu7.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUu9_-1phKLFgshYDvh6Vwt5fFPmE18imdCqxI.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUo9_-1phKLFgshYDvh6Vwt7V9VFE92jkVHuxKiBA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUz9_-1phKLFgshYDvh6Vwt3V1nvEVXlm4.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUt9_-1phKLFgshYDvh6Vwt7V9tuGdShm5bsg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUu9_-1phKLFgshYDvh6Vwt5alOmE18imdCqxI.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUo9_-1phKLFgshYDvh6Vwt7V9VTE52jkVHuxKiBA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUu9_-1phKLFgshYDvh6Vwt5eFImE18imdCqxI.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUo9_-1phKLFgshYDvh6Vwt7V9VBEh2jkVHuxKiBA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUu9_-1phKLFgshYDvh6Vwt5f1LmE18imdCqxI.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUo9_-1phKLFgshYDvh6Vwt7V9VGEt2jkVHuxKiBA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUu9_-1phKLFgshYDvh6Vwt5dlKmE18imdCqxI.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/alegreyasans/v24/5aUo9_-1phKLFgshYDvh6Vwt7V9VPEp2jkVHuxKiBA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alegreya Sans SC\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGn4-RGJqfMvt7P8FUr0Q1j-Hf1Dipl8g5FPYtmMg.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGl4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdlgRBH452Mvds.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DuJH0iRrMYJ_K-4.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdXiZhNaB6O-51OA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGh4-RGJqfMvt7P8FUr0Q1j-Hf1Nk5v9ixALYs.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGn4-RGJqfMvt7P8FUr0Q1j-Hf1Bkxl8g5FPYtmMg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DrpG0iRrMYJ_K-4.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdBidhNaB6O-51OA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DvJA0iRrMYJ_K-4.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdTiFhNaB6O-51OA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1Du5D0iRrMYJ_K-4.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdUiJhNaB6O-51OA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DspC0iRrMYJ_K-4.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/alegreyasanssc/v23/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxddiNhNaB6O-51OA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Aleo\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/aleo/v11/c4mg1nF8G8_syKbr9DVDno985KM.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/aleo/v11/c4mi1nF8G8_swAjxeDdJmq159KOnWA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/aleo/v11/c4mv1nF8G8_s8ArD0D1ogoY.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/aleo/v11/c4mh1nF8G8_swAjJ1B9tkoZl_Q.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/aleo/v11/c4mg1nF8G8_syLbs9DVDno985KM.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/aleo/v11/c4mi1nF8G8_swAjxaDBJmq159KOnWA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alex Brush\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2023-01-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alexbrush/v21/SZc83FzrJKuqFbwMKk6EtUL57DtOmCc.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alexandria\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-11-18\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/alexandria/v1/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9r7T6bHHJ8BRq0b.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/alexandria/v1/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9p7TqbHHJ8BRq0b.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/alexandria/v1/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9qlTqbHHJ8BRq0b.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/alexandria/v1/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9r7TqbHHJ8BRq0b.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/alexandria/v1/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9rJTqbHHJ8BRq0b.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/alexandria/v1/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9olSabHHJ8BRq0b.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/alexandria/v1/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9ocSabHHJ8BRq0b.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/alexandria/v1/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9p7SabHHJ8BRq0b.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/alexandria/v1/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9pSSabHHJ8BRq0b.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alfa Slab One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alfaslabone/v17/6NUQ8FmMKwSEKjnm5-4v-4Jh6dVretWvYmE.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alice\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alice/v20/OpNCnoEEmtHa6FcJpA_chzJ0.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alike\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alike/v20/HI_EiYEYI6BIoEjBSZXAQ4-d.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alike Angular\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alikeangular/v20/3qTrojWunjGQtEBlIcwMbSoI3kM6bB7FKjE.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alkalami\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alkalami/v3/zOL_4pfDmqRL95WXi5eLw8BMuvhH.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Allan\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/allan/v20/ea8XadU7WuTxEtb2P9SF8nZE.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/allan/v20/ea8aadU7WuTxEu5KEPCN2WpNgEKU.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Allerta\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/allerta/v18/TwMO-IAHRlkbx940UnEdSQqO5uY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Allerta Stencil\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/allertastencil/v18/HTx0L209KT-LmIE9N7OR6eiycOeF-zz313DuvQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Allison\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/allison/v9/X7nl4b88AP2nkbvZOCaQ4MTgAgk.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Allura\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2023-01-18\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/allura/v19/9oRPNYsQpS4zjuAPjAIXPtrrGA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Almarai\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"arabic\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/almarai/v12/tssoApxBaigK_hnnS_anhnicoq72sXg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/almarai/v12/tsstApxBaigK_hnnc1qPonC3vqc.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/almarai/v12/tssoApxBaigK_hnnS-aghnicoq72sXg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/almarai/v12/tssoApxBaigK_hnnS_qjhnicoq72sXg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Almendra\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/almendra/v22/H4ckBXKAlMnTn0CskyY6wr-wg763.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/almendra/v22/H4ciBXKAlMnTn0CskxY4yLuShq63czE.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/almendra/v22/H4cjBXKAlMnTn0Cskx6G7Zu4qKK-aihq.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/almendra/v22/H4chBXKAlMnTn0CskxY48Ae9oqacbzhqDtg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Almendra Display\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/almendradisplay/v25/0FlPVOGWl1Sb4O3tETtADHRRlZhzXS_eTyer338.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Almendra SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/almendrasc/v25/Iure6Yx284eebowr7hbyTZZJprVA4XQ0.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alumni Sans\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9OO5QqFsJ3C8qng.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9uO9QqFsJ3C8qng.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9Zu9QqFsJ3C8qng.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9OO9QqFsJ3C8qng.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9Cu9QqFsJ3C8qng.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd95uhQqFsJ3C8qng.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd93-hQqFsJ3C8qng.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9uOhQqFsJ3C8qng.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9kehQqFsJ3C8qng.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Ky46lEN_io6npfB.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kw461EN_io6npfB.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kzm61EN_io6npfB.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Ky461EN_io6npfB.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8KyK61EN_io6npfB.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kxm7FEN_io6npfB.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kxf7FEN_io6npfB.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kw47FEN_io6npfB.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/alumnisans/v12/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8KwR7FEN_io6npfB.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alumni Sans Collegiate One\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alumnisanscollegiateone/v2/MQpB-XChK8G5CtmK_AuGxQrdNvPSXkn0RM-XqjWWhjdayDiPw2ta.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/alumnisanscollegiateone/v2/MQpD-XChK8G5CtmK_AuGxQrdNvPSXkn0RM-XqjWWhgdYwjytxntaDFU.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alumni Sans Inline One\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alumnisansinlineone/v2/RrQBbpJx9zZ3IXTBOASKp5gJAetBdaihcjbpD3AZcr7xbYw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/alumnisansinlineone/v2/RrQDbpJx9zZ3IXTBOASKp5gJAetBdaihcjbpP3ITdpz0fYxcrQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Alumni Sans Pinstripe\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/alumnisanspinstripe/v1/ZgNNjOFFPq_AUJD1umyS30W-Xub8zD1ObhezYrVIpcDA5w.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/alumnisanspinstripe/v1/ZgNDjOFFPq_AUJD1umyS30W-Xub8zD1ObheDYL9Mh8XQ5_cY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Amarante\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/amarante/v22/xMQXuF1KTa6EvGx9bq-3C3rAmD-b.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Amaranth\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/amaranth/v18/KtkuALODe433f0j1zPnCF9GqwnzW.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/amaranth/v18/KtkoALODe433f0j1zMnAHdWIx2zWD4I.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/amaranth/v18/KtkpALODe433f0j1zMF-OPWi6WDfFpuc.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/amaranth/v18/KtkrALODe433f0j1zMnAJWmn42T9E4ucRY8.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Amatic SC\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/amaticsc/v24/TUZyzwprpvBS1izr_vO0De6ecZQf1A.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/amaticsc/v24/TUZ3zwprpvBS1izr_vOMscG6eb8D3WTy-A.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Amethysta\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/amethysta/v16/rP2Fp2K15kgb_F3ibfWIGDWCBl0O8Q.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Amiko\",\n      \"variants\": [\n        \"regular\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/amiko/v12/WwkQxPq1DFK04tqlc17MMZgJ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/amiko/v12/WwkdxPq1DFK04uJ9XXrEGoQAUco5.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/amiko/v12/WwkdxPq1DFK04uIZXHrEGoQAUco5.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Amiri\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v27\",\n      \"lastModified\": \"2023-01-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/amiri/v27/J7aRnpd8CGxBHqUpvrIw74NL.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/amiri/v27/J7afnpd8CGxBHpUrtLYS6pNLAjk.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/amiri/v27/J7acnpd8CGxBHp2VkZY4xJ9CGyAa.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/amiri/v27/J7aanpd8CGxBHpUrjAo9zptgHjAavCA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Amiri Quran\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-14\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/amiriquran/v7/_Xmo-Hk0rD6DbUL4_vH8Zq5t7Cycsu-2.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Amita\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/amita/v16/HhyaU5si9Om7PQlvAfSKEZZL.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/amita/v16/HhyXU5si9Om7PTHTLtCCOopCTKkI.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anaheim\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/anaheim/v14/8vII7w042Wp87g4G0UTUEE5eK_w.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Andada Pro\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/andadapro/v16/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DPJBY8cFLzvIt2S.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/andadapro/v16/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DP7BY8cFLzvIt2S.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/andadapro/v16/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DMXAo8cFLzvIt2S.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/andadapro/v16/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DMuAo8cFLzvIt2S.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/andadapro/v16/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DNJAo8cFLzvIt2S.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/andadapro/v16/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRmdfHrjNJ82Stjw.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/andadapro/v16/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRlVfHrjNJ82Stjw.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/andadapro/v16/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRrlYHrjNJ82Stjw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/andadapro/v16/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRoBYHrjNJ82Stjw.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/andadapro/v16/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRudYHrjNJ82Stjw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Andika\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/andika/v22/mem_Ya6iyW-LwqgAbbwRWrwGVA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/andika/v22/mem9Ya6iyW-Lwqgwb7YVeLkWVNBt.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/andika/v22/mem8Ya6iyW-Lwqg40ZM1UpcaXcl0Aw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/andika/v22/mem6Ya6iyW-Lwqgwb46pV50ef8xkA76a.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anek Bangla\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"bengali\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/anekbangla/v4/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofm9YIocg56yyvt0.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/anekbangla/v4/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofu9ZIocg56yyvt0.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/anekbangla/v4/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3OfjFZIocg56yyvt0.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/anekbangla/v4/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofm9ZIocg56yyvt0.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/anekbangla/v4/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofl1ZIocg56yyvt0.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/anekbangla/v4/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3OfrFeIocg56yyvt0.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anekbangla/v4/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3OfoheIocg56yyvt0.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/anekbangla/v4/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofu9eIocg56yyvt0.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anek Devanagari\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/anekdevanagari/v4/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLDtk-9nFk0LjZ7E.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/anekdevanagari/v4/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLBtku9nFk0LjZ7E.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/anekdevanagari/v4/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLCzku9nFk0LjZ7E.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/anekdevanagari/v4/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLDtku9nFk0LjZ7E.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/anekdevanagari/v4/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLDfku9nFk0LjZ7E.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/anekdevanagari/v4/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLAzle9nFk0LjZ7E.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anekdevanagari/v4/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLAKle9nFk0LjZ7E.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/anekdevanagari/v4/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLBtle9nFk0LjZ7E.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anek Gujarati\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"gujarati\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/anekgujarati/v4/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0F5G7w0KgB7Lm7g.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/anekgujarati/v4/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0l5C7w0KgB7Lm7g.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/anekgujarati/v4/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0SZC7w0KgB7Lm7g.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/anekgujarati/v4/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0F5C7w0KgB7Lm7g.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/anekgujarati/v4/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0JZC7w0KgB7Lm7g.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/anekgujarati/v4/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0yZe7w0KgB7Lm7g.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anekgujarati/v4/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-08Je7w0KgB7Lm7g.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/anekgujarati/v4/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0l5e7w0KgB7Lm7g.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anek Gurmukhi\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"gurmukhi\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/anekgurmukhi/v4/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbd5ppXK41H6DjbA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/anekgurmukhi/v4/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkb95tpXK41H6DjbA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/anekgurmukhi/v4/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbKZtpXK41H6DjbA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/anekgurmukhi/v4/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbd5tpXK41H6DjbA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/anekgurmukhi/v4/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbRZtpXK41H6DjbA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/anekgurmukhi/v4/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbqZxpXK41H6DjbA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anekgurmukhi/v4/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbkJxpXK41H6DjbA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/anekgurmukhi/v4/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkb95xpXK41H6DjbA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anek Kannada\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"kannada\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/anekkannada/v4/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dFDEAukVReA1oef.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/anekkannada/v4/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dHDEQukVReA1oef.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/anekkannada/v4/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dEdEQukVReA1oef.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/anekkannada/v4/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dFDEQukVReA1oef.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/anekkannada/v4/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dFxEQukVReA1oef.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/anekkannada/v4/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dGdFgukVReA1oef.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anekkannada/v4/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dGkFgukVReA1oef.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/anekkannada/v4/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dHDFgukVReA1oef.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anek Latin\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/aneklatin/v4/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuR7EZKdClWL3kgw.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/aneklatin/v4/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3Pux7AZKdClWL3kgw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/aneklatin/v4/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuGbAZKdClWL3kgw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/aneklatin/v4/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuR7AZKdClWL3kgw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/aneklatin/v4/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PudbAZKdClWL3kgw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/aneklatin/v4/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PumbcZKdClWL3kgw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/aneklatin/v4/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuoLcZKdClWL3kgw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/aneklatin/v4/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3Pux7cZKdClWL3kgw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anek Malayalam\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"malayalam\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/anekmalayalam/v4/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUZu_HMr5PDO71Qs.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/anekmalayalam/v4/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTURu-HMr5PDO71Qs.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/anekmalayalam/v4/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUcW-HMr5PDO71Qs.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/anekmalayalam/v4/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUZu-HMr5PDO71Qs.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/anekmalayalam/v4/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUam-HMr5PDO71Qs.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/anekmalayalam/v4/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUUW5HMr5PDO71Qs.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anekmalayalam/v4/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUXy5HMr5PDO71Qs.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/anekmalayalam/v4/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTURu5HMr5PDO71Qs.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anek Odia\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"oriya\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/anekodia/v4/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnmZf63mXZAtm_es.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/anekodia/v4/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnkZfq3mXZAtm_es.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/anekodia/v4/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnnHfq3mXZAtm_es.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/anekodia/v4/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnmZfq3mXZAtm_es.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/anekodia/v4/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnmrfq3mXZAtm_es.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/anekodia/v4/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnlHea3mXZAtm_es.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anekodia/v4/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnl-ea3mXZAtm_es.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/anekodia/v4/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnkZea3mXZAtm_es.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anek Tamil\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tamil\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/anektamil/v4/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNQiZ6q4v4oegjOQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/anektamil/v4/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNwid6q4v4oegjOQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/anektamil/v4/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNHCd6q4v4oegjOQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/anektamil/v4/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNQid6q4v4oegjOQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/anektamil/v4/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNcCd6q4v4oegjOQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/anektamil/v4/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNnCB6q4v4oegjOQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anektamil/v4/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNpSB6q4v4oegjOQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/anektamil/v4/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNwiB6q4v4oegjOQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anek Telugu\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"telugu\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/anektelugu/v4/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13y-_oE2G2ep10_8.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/anektelugu/v4/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i136--oE2G2ep10_8.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/anektelugu/v4/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i133G-oE2G2ep10_8.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/anektelugu/v4/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13y--oE2G2ep10_8.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/anektelugu/v4/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13x2-oE2G2ep10_8.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/anektelugu/v4/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13_G5oE2G2ep10_8.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anektelugu/v4/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i138i5oE2G2ep10_8.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/anektelugu/v4/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i136-5oE2G2ep10_8.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Angkor\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v28\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/angkor/v28/H4cmBXyAlsPdnlb-8iw-4Lqggw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Annie Use Your Telescope\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/annieuseyourtelescope/v18/daaLSS4tI2qYYl3Jq9s_Hu74xwktnlKxH6osGVGjlDfB3UUVZA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anonymous Pro\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"greek\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/anonymouspro/v21/rP2Bp2a15UIB7Un-bOeISG3pLlw89CH98Ko.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/anonymouspro/v21/rP2fp2a15UIB7Un-bOeISG3pHl428AP44Kqr2Q.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anonymouspro/v21/rP2cp2a15UIB7Un-bOeISG3pFuAT0CnW7KOywKo.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/anonymouspro/v21/rP2ap2a15UIB7Un-bOeISG3pHl4OTCzc6IG30KqB9Q.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Antic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/antic/v19/TuGfUVB8XY5DRaZLodgzydtk.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Antic Didone\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/anticdidone/v16/RWmPoKKX6u8sp8fIWdnDKqDiqYsGBGBzCw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Antic Slab\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/anticslab/v16/bWt97fPFfRzkCa9Jlp6IWcJWXW5p5Qo.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anton\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/anton/v23/1Ptgg87LROyAm0K08i4gS7lu.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Antonio\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/antonio/v11/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVxx8BtIY2DwSXlM.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/antonio/v11/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVzx8RtIY2DwSXlM.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/antonio/v11/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVwv8RtIY2DwSXlM.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/antonio/v11/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVxx8RtIY2DwSXlM.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/antonio/v11/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVxD8RtIY2DwSXlM.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/antonio/v11/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVyv9htIY2DwSXlM.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/antonio/v11/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVyW9htIY2DwSXlM.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Anybody\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/anybody/v4/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4J12HPrsXD_nBPpQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/anybody/v4/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JV2DPrsXD_nBPpQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/anybody/v4/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JiWDPrsXD_nBPpQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/anybody/v4/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4J12DPrsXD_nBPpQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/anybody/v4/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4J5WDPrsXD_nBPpQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/anybody/v4/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JCWfPrsXD_nBPpQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/anybody/v4/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JMGfPrsXD_nBPpQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/anybody/v4/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JV2fPrsXD_nBPpQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/anybody/v4/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JfmfPrsXD_nBPpQ.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/anybody/v4/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyMn7M_H3HVfpcHY.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/anybody/v4/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyOn7c_H3HVfpcHY.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/anybody/v4/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyN57c_H3HVfpcHY.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/anybody/v4/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyMn7c_H3HVfpcHY.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/anybody/v4/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyMV7c_H3HVfpcHY.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/anybody/v4/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyP56s_H3HVfpcHY.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/anybody/v4/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyPA6s_H3HVfpcHY.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/anybody/v4/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyOn6s_H3HVfpcHY.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/anybody/v4/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyOO6s_H3HVfpcHY.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Arapey\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/arapey/v16/-W__XJn-UDDA2RC6Z9AcZkIzeg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/arapey/v16/-W_9XJn-UDDA2RCKZdoYREcjeo0k.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Arbutus\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/arbutus/v24/NaPYcZ7dG_5J3poob9JtryO8fMU.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Arbutus Slab\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/arbutusslab/v16/oY1Z8e7OuLXkJGbXtr5ba7ZVa68dJlaFAQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Architects Daughter\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/architectsdaughter/v18/KtkxAKiDZI_td1Lkx62xHZHDtgO_Y-bvfY5q4szgE-Q.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Archivo\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/archivo/v18/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTNDJp8B1oJ0vyVQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/archivo/v18/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTtDNp8B1oJ0vyVQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/archivo/v18/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTajNp8B1oJ0vyVQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/archivo/v18/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTNDNp8B1oJ0vyVQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/archivo/v18/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTBjNp8B1oJ0vyVQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/archivo/v18/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTT6jRp8B1oJ0vyVQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/archivo/v18/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTT0zRp8B1oJ0vyVQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/archivo/v18/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTtDRp8B1oJ0vyVQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/archivo/v18/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTnTRp8B1oJ0vyVQ.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/archivo/v18/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HCBshdsBU7iVdxQ.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/archivo/v18/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HABsxdsBU7iVdxQ.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/archivo/v18/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HDfsxdsBU7iVdxQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/archivo/v18/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HCBsxdsBU7iVdxQ.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/archivo/v18/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HCzsxdsBU7iVdxQ.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/archivo/v18/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HBftBdsBU7iVdxQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/archivo/v18/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HBmtBdsBU7iVdxQ.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/archivo/v18/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HABtBdsBU7iVdxQ.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/archivo/v18/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HAotBdsBU7iVdxQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Archivo Black\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/archivoblack/v17/HTxqL289NzCGg4MzN6KJ7eW6OYuP_x7yx3A.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Archivo Narrow\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v28\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/archivonarrow/v28/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhvLFGKpHOtFCQ76Q.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/archivonarrow/v28/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhvHlGKpHOtFCQ76Q.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/archivonarrow/v28/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhv8laKpHOtFCQ76Q.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/archivonarrow/v28/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhvy1aKpHOtFCQ76Q.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/archivonarrow/v28/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BJi53mpNiEr6T6Y.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/archivonarrow/v28/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BJQ53mpNiEr6T6Y.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/archivonarrow/v28/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BK84HmpNiEr6T6Y.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/archivonarrow/v28/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BKF4HmpNiEr6T6Y.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Are You Serious\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/areyouserious/v10/ll8kK2GVSSr-PtjQ5nONVcNn4306hT9nCGRayg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Aref Ruqaa\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/arefruqaa/v25/WwkbxPW1E165rajQKDulEIAiVNo5xNY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/arefruqaa/v25/WwkYxPW1E165rajQKDulKDwNcNIS2N_7Bdk.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Aref Ruqaa Ink\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-14\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/arefruqaaink/v5/1q2fY5WOGUFlt84GTOkP6Kdx72ThVIGpgnxL.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/arefruqaaink/v5/1q2cY5WOGUFlt84GTOkP6Kdx71xde6WhqWBCyxWn.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Arima\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"malayalam\",\n        \"tamil\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/arima/v1/neIWzCqmt4Aup_qE1nFWqxI1RZX1YTE-pQGOyYw2fw.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/arima/v1/neIWzCqmt4Aup_qE1nFWqxI1RZX14TA-pQGOyYw2fw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/arima/v1/neIWzCqmt4Aup_qE1nFWqxI1RZX1PzA-pQGOyYw2fw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/arima/v1/neIWzCqmt4Aup_qE1nFWqxI1RZX1YTA-pQGOyYw2fw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/arima/v1/neIWzCqmt4Aup_qE1nFWqxI1RZX1UzA-pQGOyYw2fw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/arima/v1/neIWzCqmt4Aup_qE1nFWqxI1RZX1vzc-pQGOyYw2fw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/arima/v1/neIWzCqmt4Aup_qE1nFWqxI1RZX1hjc-pQGOyYw2fw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Arima Madurai\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tamil\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/arimamadurai/v14/t5t4IRoeKYORG0WNMgnC3seB1V3PqrGCch4Drg.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/arimamadurai/v14/t5t7IRoeKYORG0WNMgnC3seB1fHuipusfhcat2c.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/arimamadurai/v14/t5t7IRoeKYORG0WNMgnC3seB1ZXtipusfhcat2c.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/arimamadurai/v14/t5tmIRoeKYORG0WNMgnC3seB7TnFrpOHYh4.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/arimamadurai/v14/t5t7IRoeKYORG0WNMgnC3seB1c3sipusfhcat2c.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/arimamadurai/v14/t5t7IRoeKYORG0WNMgnC3seB1YXqipusfhcat2c.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/arimamadurai/v14/t5t7IRoeKYORG0WNMgnC3seB1Znpipusfhcat2c.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/arimamadurai/v14/t5t7IRoeKYORG0WNMgnC3seB1b3oipusfhcat2c.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Arimo\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v27\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/arimo/v27/P5sfzZCDf9_T_3cV7NCUECyoxNk37cxsBxDAVQI4aA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/arimo/v27/P5sfzZCDf9_T_3cV7NCUECyoxNk338xsBxDAVQI4aA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/arimo/v27/P5sfzZCDf9_T_3cV7NCUECyoxNk3M8tsBxDAVQI4aA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/arimo/v27/P5sfzZCDf9_T_3cV7NCUECyoxNk3CstsBxDAVQI4aA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/arimo/v27/P5sdzZCDf9_T_10c3i9MeUcyat4iJY-ERBrEdwcoaKww.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/arimo/v27/P5sdzZCDf9_T_10c3i9MeUcyat4iJY-2RBrEdwcoaKww.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/arimo/v27/P5sdzZCDf9_T_10c3i9MeUcyat4iJY9aQxrEdwcoaKww.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/arimo/v27/P5sdzZCDf9_T_10c3i9MeUcyat4iJY9jQxrEdwcoaKww.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Arizonia\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/arizonia/v19/neIIzCemt4A5qa7mv6WGHK06UY30.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Armata\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/armata/v19/gokvH63_HV5jQ-E9lD53Q2u_mQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Arsenal\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/arsenal/v12/wXKrE3kQtZQ4pF3D11_WAewrhXY.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/arsenal/v12/wXKpE3kQtZQ4pF3D513cBc4ulXYrtA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/arsenal/v12/wXKuE3kQtZQ4pF3D7-P5JeQAmX8yrdk.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/arsenal/v12/wXKsE3kQtZQ4pF3D513kueEKnV03vdnKjw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Artifika\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2023-01-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/artifika/v21/VEMyRoxzronptCuxu6Wt5jDtreOL.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Arvo\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/arvo/v20/tDbD2oWUg0MKmSAa7Lzr7vs.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/arvo/v20/tDbN2oWUg0MKqSIQ6J7u_vvijQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/arvo/v20/tDbM2oWUg0MKoZw1yLTA8vL7lAE.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/arvo/v20/tDbO2oWUg0MKqSIoVLHK9tD-hAHkGg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Arya\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/arya/v19/ga6CawNG-HJd9Ub1-beqdFE.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/arya/v19/ga6NawNG-HJdzfra3b-BaFg3dRE.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Asap\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-11-18\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/asap/v26/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYkqQsLmOXoA7Glw.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/asap/v26/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYEqUsLmOXoA7Glw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/asap/v26/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYzKUsLmOXoA7Glw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/asap/v26/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYkqUsLmOXoA7Glw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/asap/v26/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYoKUsLmOXoA7Glw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/asap/v26/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYTKIsLmOXoA7Glw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/asap/v26/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYdaIsLmOXoA7Glw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/asap/v26/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYEqIsLmOXoA7Glw.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/asap/v26/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYO6IsLmOXoA7Glw.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/asap/v26/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWubEbGmTggvWl0Qn.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/asap/v26/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuZEbWmTggvWl0Qn.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/asap/v26/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuaabWmTggvWl0Qn.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/asap/v26/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWubEbWmTggvWl0Qn.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/asap/v26/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWub2bWmTggvWl0Qn.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/asap/v26/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuYaammTggvWl0Qn.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/asap/v26/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuYjammTggvWl0Qn.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/asap/v26/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuZEammTggvWl0Qn.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/asap/v26/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuZtammTggvWl0Qn.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Asap Condensed\",\n      \"variants\": [\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-18\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxieypY1o9NHyXh3WvSbGSggdO9DSWlEgGqgp-pO.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxiYypY1o9NHyXh3WvSbGSggdOeJUIFFim6CovpOkXA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxieypY1o9NHyXh3WvSbGSggdO8nSmlEgGqgp-pO.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxiYypY1o9NHyXh3WvSbGSggdOeJUOVGim6CovpOkXA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxidypY1o9NHyXh3WvSbGSggdNeLYk1Mq3ap.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxifypY1o9NHyXh3WvSbGSggdOeJaElurmapvvM.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxieypY1o9NHyXh3WvSbGSggdO9_S2lEgGqgp-pO.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxiYypY1o9NHyXh3WvSbGSggdOeJUL1Him6CovpOkXA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxieypY1o9NHyXh3WvSbGSggdO9TTGlEgGqgp-pO.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxiYypY1o9NHyXh3WvSbGSggdOeJUJFAim6CovpOkXA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxieypY1o9NHyXh3WvSbGSggdO83TWlEgGqgp-pO.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxiYypY1o9NHyXh3WvSbGSggdOeJUPVBim6CovpOkXA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxieypY1o9NHyXh3WvSbGSggdO8rTmlEgGqgp-pO.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxiYypY1o9NHyXh3WvSbGSggdOeJUOlCim6CovpOkXA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxieypY1o9NHyXh3WvSbGSggdO8PT2lEgGqgp-pO.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/asapcondensed/v16/pxiYypY1o9NHyXh3WvSbGSggdOeJUM1Dim6CovpOkXA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Asar\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/asar/v22/sZlLdRyI6TBIXkYQDLlTW6E.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Asset\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/asset/v24/SLXGc1na-mM4cWImRJqExst1.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Assistant\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/assistant/v18/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtmZnEGGf3qGuvM4.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/assistant/v18/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtrhnEGGf3qGuvM4.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/assistant/v18/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtuZnEGGf3qGuvM4.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/assistant/v18/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQttRnEGGf3qGuvM4.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/assistant/v18/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtjhgEGGf3qGuvM4.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/assistant/v18/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtgFgEGGf3qGuvM4.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/assistant/v18/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtmZgEGGf3qGuvM4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Astloch\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/astloch/v26/TuGRUVJ8QI5GSeUjq9wRzMtkH1Q.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/astloch/v26/TuGUUVJ8QI5GSeUjk2A-6MNPA10xLMQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Asul\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/asul/v19/VuJ-dNjKxYr46fMFXK78JIg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/asul/v19/VuJxdNjKxYr40U8qeKbXOIFneRo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Athiti\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/athiti/v12/pe0sMISdLIZIv1wAxDNyAv2-C99ycg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/athiti/v12/pe0sMISdLIZIv1wAoDByAv2-C99ycg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/athiti/v12/pe0vMISdLIZIv1w4DBhWCtaiAg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/athiti/v12/pe0sMISdLIZIv1wA-DFyAv2-C99ycg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/athiti/v12/pe0sMISdLIZIv1wA1DZyAv2-C99ycg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/athiti/v12/pe0sMISdLIZIv1wAsDdyAv2-C99ycg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Atkinson Hyperlegible\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/atkinsonhyperlegible/v10/9Bt23C1KxNDXMspQ1lPyU89-1h6ONRlW45GE5ZgpewSSbQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/atkinsonhyperlegible/v10/9Bt43C1KxNDXMspQ1lPyU89-1h6ONRlW45G055ItWQGCbUWn.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/atkinsonhyperlegible/v10/9Bt73C1KxNDXMspQ1lPyU89-1h6ONRlW45G8WbcNcy-OZFy-FA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/atkinsonhyperlegible/v10/9Bt93C1KxNDXMspQ1lPyU89-1h6ONRlW45G056qRdiWKRlmuFH24.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Atma\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"bengali\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/atma/v15/uK_z4rqWc-Eoo8JzKjc9PvedRkM.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/atma/v15/uK_84rqWc-Eom25bDj8WIv4.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/atma/v15/uK_z4rqWc-Eoo5pyKjc9PvedRkM.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/atma/v15/uK_z4rqWc-Eoo7Z1Kjc9PvedRkM.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/atma/v15/uK_z4rqWc-Eoo9J0Kjc9PvedRkM.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Atomic Age\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v27\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/atomicage/v27/f0Xz0eug6sdmRFkYZZGL58Ht9a8GYeA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Aubrey\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v28\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/aubrey/v28/q5uGsou7NPBw-p7vugNsCxVEgA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Audiowide\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/audiowide/v16/l7gdbjpo0cum0ckerWCtkQXPExpQBw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Autour One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/autourone/v24/UqyVK80cP25l3fJgbdfbk5lWVscxdKE.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Average\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/average/v18/fC1hPYBHe23MxA7rIeJwVWytTyk.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Average Sans\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/averagesans/v16/1Ptpg8fLXP2dlAXR-HlJJNJPBdqazVoK4A.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Averia Gruesa Libre\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/averiagruesalibre/v22/NGSov4nEGEktOaDRKsY-1dhh8eEtIx3ZUmmJw0SLRA8.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Averia Libre\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/averialibre/v16/2V0FKIcMGZEnV6xygz7eNjEarovtb07t-pQgTw.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/averialibre/v16/2V0HKIcMGZEnV6xygz7eNjESAJFhbUTp2JEwT4Sk.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/averialibre/v16/2V0aKIcMGZEnV6xygz7eNjEiAqPJZ2Xx8w.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/averialibre/v16/2V0EKIcMGZEnV6xygz7eNjESAKnNRWDh8405.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/averialibre/v16/2V0FKIcMGZEnV6xygz7eNjEavoztb07t-pQgTw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/averialibre/v16/2V0HKIcMGZEnV6xygz7eNjESAJFxakTp2JEwT4Sk.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Averia Sans Libre\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/averiasanslibre/v17/ga6SaxZG_G5OvCf_rt7FH3B6BHLMEd3lMKcQJZP1LmD9.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/averiasanslibre/v17/ga6caxZG_G5OvCf_rt7FH3B6BHLMEdVLKisSL5fXK3D9qtg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/averiasanslibre/v17/ga6XaxZG_G5OvCf_rt7FH3B6BHLMEeVJGIMYDo_8.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/averiasanslibre/v17/ga6RaxZG_G5OvCf_rt7FH3B6BHLMEdVLEoc6C5_8N3k.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/averiasanslibre/v17/ga6SaxZG_G5OvCf_rt7FH3B6BHLMEd31N6cQJZP1LmD9.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/averiasanslibre/v17/ga6caxZG_G5OvCf_rt7FH3B6BHLMEdVLKjsVL5fXK3D9qtg.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Averia Serif Libre\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/averiaseriflibre/v16/neIVzD2ms4wxr6GvjeD0X88SHPyX2xYGCSmqwacqdrKvbQ.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/averiaseriflibre/v16/neIbzD2ms4wxr6GvjeD0X88SHPyX2xYOpzMmw60uVLe_bXHq.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/averiaseriflibre/v16/neIWzD2ms4wxr6GvjeD0X88SHPyX2xY-pQGOyYw2fw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/averiaseriflibre/v16/neIUzD2ms4wxr6GvjeD0X88SHPyX2xYOpwuK64kmf6u2.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/averiaseriflibre/v16/neIVzD2ms4wxr6GvjeD0X88SHPyX2xYGGS6qwacqdrKvbQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/averiaseriflibre/v16/neIbzD2ms4wxr6GvjeD0X88SHPyX2xYOpzM2xK0uVLe_bXHq.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Azeret Mono\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfnPRh0raa-5s3AA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfHPVh0raa-5s3AA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfwvVh0raa-5s3AA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfnPVh0raa-5s3AA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfrvVh0raa-5s3AA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfQvJh0raa-5s3AA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfe_Jh0raa-5s3AA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfHPJh0raa-5s3AA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfNfJh0raa-5s3AA.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLaJkLye2Z4nAN7J.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLYJkbye2Z4nAN7J.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLbXkbye2Z4nAN7J.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLaJkbye2Z4nAN7J.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLa7kbye2Z4nAN7J.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLZXlrye2Z4nAN7J.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLZulrye2Z4nAN7J.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLYJlrye2Z4nAN7J.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/azeretmono/v11/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLYglrye2Z4nAN7J.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"B612\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/b612/v12/3JnySDDxiSz32jm4GDigUXw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/b612/v12/3Jn8SDDxiSz36juyHBqlQXwdVw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/b612/v12/3Jn9SDDxiSz34oWXPDCLTXUETuE.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/b612/v12/3Jn_SDDxiSz36juKoDWBSVcBXuFb0Q.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"B612 Mono\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/b612mono/v12/kmK_Zq85QVWbN1eW6lJl1wTcquRTtg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/b612mono/v12/kmK5Zq85QVWbN1eW6lJV1Q7YiOFDtqtf.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/b612mono/v12/kmK6Zq85QVWbN1eW6lJdayv4os9Pv7JGSg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/b612mono/v12/kmKkZq85QVWbN1eW6lJV1TZkp8VLnbdWSg4x.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"BIZ UDGothic\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"greek-ext\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bizudgothic/v8/daafSTouBF7RUjnbt8p3LuKttQN98z_MbQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bizudgothic/v8/daaASTouBF7RUjnbt8p3LuKVCSxZ-xTQZMhbaA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"BIZ UDMincho\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"greek-ext\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2023-01-18\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bizudmincho/v9/EJRRQgI6eOxFjBdKs38yhtW1dwT7rcpY8Q.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bizudmincho/v9/EJROQgI6eOxFjBdKs38yhtWNyyvfpeFE-IyCrw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"BIZ UDPGothic\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"greek-ext\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bizudpgothic/v8/hES36X5pHAIBjmS84VL0Bue83nUMQWkMUAk.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bizudpgothic/v8/hESq6X5pHAIBjmS84VL0Bue85skjZWEnTABCSQo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"BIZ UDPMincho\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"greek-ext\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2023-01-18\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bizudpmincho/v9/ypvfbXOBrmYppy7oWWTg1_58nhhYtUb0gZk.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bizudpmincho/v9/ypvCbXOBrmYppy7oWWTg1_58pqR3kU7fnZAy57k.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Babylonica\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/babylonica/v2/5aUw9_i2qxWVCAE2aHjTqDJ0-VVMoEw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bad Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/badscript/v16/6NUT8F6PJgbFWQn47_x7lOwuzd1AZtw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bahiana\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bahiana/v19/uU9PCBUV4YenPWJU7xPb3vyHmlI.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bahianita\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bahianita/v17/yYLr0hTb3vuqqsBUgxWtxTvV2NJPcA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bai Jamjuree\",\n      \"variants\": [\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIqapSCOBt_aeQQ7ftydoa0kePuk5A1-yiSgA.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIoapSCOBt_aeQQ7ftydoa8W_oGkpox2S2CgOva.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIqapSCOBt_aeQQ7ftydoa09eDuk5A1-yiSgA.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIoapSCOBt_aeQQ7ftydoa8W_pikZox2S2CgOva.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDI1apSCOBt_aeQQ7ftydoaMWcjKm7sp8g.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIrapSCOBt_aeQQ7ftydoa8W8LOub458jGL.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIqapSCOBt_aeQQ7ftydoa0reHuk5A1-yiSgA.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIoapSCOBt_aeQQ7ftydoa8W_o6kJox2S2CgOva.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIqapSCOBt_aeQQ7ftydoa0gebuk5A1-yiSgA.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIoapSCOBt_aeQQ7ftydoa8W_oWl5ox2S2CgOva.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIqapSCOBt_aeQQ7ftydoa05efuk5A1-yiSgA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/baijamjuree/v11/LDIoapSCOBt_aeQQ7ftydoa8W_pylpox2S2CgOva.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bakbak One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v6\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bakbakone/v6/zOL54pXAl6RI-p_ardnuycRuv-hHkOs.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Ballet\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/ballet/v21/QGYyz_MYZA-HM4NjuGOVnUEXme1I4Xi3C4G-EiAou6Y.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baloo 2\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/baloo2/v16/wXK0E3kTposypRydzVT08TS3JnAmtdgazapv9Fat7WcN.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/baloo2/v16/wXK0E3kTposypRydzVT08TS3JnAmtdgozapv9Fat7WcN.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/baloo2/v16/wXK0E3kTposypRydzVT08TS3JnAmtdjEyqpv9Fat7WcN.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/baloo2/v16/wXK0E3kTposypRydzVT08TS3JnAmtdj9yqpv9Fat7WcN.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/baloo2/v16/wXK0E3kTposypRydzVT08TS3JnAmtdiayqpv9Fat7WcN.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baloo Bhai 2\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"gujarati\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/baloobhai2/v21/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNighMXeCo-jsZzo.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/baloobhai2/v21/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNhohMXeCo-jsZzo.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/baloobhai2/v21/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNvYmMXeCo-jsZzo.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/baloobhai2/v21/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNs8mMXeCo-jsZzo.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/baloobhai2/v21/sZlWdRSL-z1VEWZ4YNA7Y5ItevYWUOHDE8FvNqgmMXeCo-jsZzo.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baloo Bhaijaan 2\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/baloobhaijaan2/v14/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8TyRSqP4L4ppfcyC.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/baloobhaijaan2/v14/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8TyjSqP4L4ppfcyC.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/baloobhaijaan2/v14/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8TxPTaP4L4ppfcyC.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/baloobhaijaan2/v14/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8Tx2TaP4L4ppfcyC.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/baloobhaijaan2/v14/zYXwKUwuEqdVGqM8tPDdAA_Y-_bMKo1EhQd2tWxo8TwRTaP4L4ppfcyC.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baloo Bhaina 2\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"oriya\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/baloobhaina2/v22/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEssPvRfRLYWmZSA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/baloobhaina2/v22/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEgMPvRfRLYWmZSA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/baloobhaina2/v22/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEbMTvRfRLYWmZSA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/baloobhaina2/v22/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEVcTvRfRLYWmZSA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/baloobhaina2/v22/qWc-B6yyq4P9Adr3RtoX1q6ySgbwusXwJjkOS-XEMsTvRfRLYWmZSA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baloo Chettan 2\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"malayalam\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/baloochettan2/v16/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CeKTO1oeH9xI2gc.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/baloochettan2/v16/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CdCTO1oeH9xI2gc.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/baloochettan2/v16/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CTyUO1oeH9xI2gc.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/baloochettan2/v16/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CQWUO1oeH9xI2gc.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/baloochettan2/v16/vm8hdRbmXEva26PK-NtuX4ynWEzF69-L4gqgkIL5CWKUO1oeH9xI2gc.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baloo Da 2\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"bengali\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/balooda2/v16/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjALsTNe55aRa7UE.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/balooda2/v16/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjA5sTNe55aRa7UE.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/balooda2/v16/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjDVtjNe55aRa7UE.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/balooda2/v16/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjDstjNe55aRa7UE.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/balooda2/v16/2-c39J9j0IaUMQZwAJyJaOX1UUnf3GLnYjCLtjNe55aRa7UE.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baloo Paaji 2\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"gurmukhi\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/baloopaaji2/v22/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9AX74fybRUz1r5t.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/baloopaaji2/v22/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9Al74fybRUz1r5t.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/baloopaaji2/v22/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9DJ6IfybRUz1r5t.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/baloopaaji2/v22/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9Dw6IfybRUz1r5t.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/baloopaaji2/v22/i7dfIFFzbz-QHZUdV9_UGWZuelmy79QJ1HOSY9CX6IfybRUz1r5t.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baloo Tamma 2\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"kannada\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/balootamma2/v15/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMscPp-0IF71SGC5.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/balootamma2/v15/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMsuPp-0IF71SGC5.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/balootamma2/v15/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMvCOZ-0IF71SGC5.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/balootamma2/v15/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMv7OZ-0IF71SGC5.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/balootamma2/v15/vEFE2_hCAgcR46PaajtrYlBbVUMUJgIC5LHTrMucOZ-0IF71SGC5.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baloo Tammudu 2\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"telugu\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/balootammudu2/v22/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_Jf8e4c6PZSlGmAA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/balootammudu2/v22/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_Jc0e4c6PZSlGmAA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/balootammudu2/v22/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_JSEZ4c6PZSlGmAA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/balootammudu2/v22/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_JRgZ4c6PZSlGmAA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/balootammudu2/v22/1Pt5g8TIS_SAmkLguUdFP8UaJcKkzlPmMT00GaE_JX8Z4c6PZSlGmAA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baloo Thambi 2\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tamil\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/baloothambi2/v16/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbKzcIzaQRG_n4osQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/baloothambi2/v16/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbK_8IzaQRG_n4osQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/baloothambi2/v16/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbKE8UzaQRG_n4osQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/baloothambi2/v16/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbKKsUzaQRG_n4osQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/baloothambi2/v16/cY9RfjeOW0NHpmOQXranrbDyu5JMJmNp-aDvUBbKTcUzaQRG_n4osQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Balsamiq Sans\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/balsamiqsans/v10/P5sEzZiAbNrN8SB3lQQX7Pnc8dkdIYdNHzs.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/balsamiqsans/v10/P5sazZiAbNrN8SB3lQQX7PncwdsXJaVIDzvcXA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/balsamiqsans/v10/P5sZzZiAbNrN8SB3lQQX7PncyWUyBY9mAzLFRQI.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/balsamiqsans/v10/P5sfzZiAbNrN8SB3lQQX7PncwdsvmYpsBxDAVQI4aA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Balthazar\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/balthazar/v17/d6lKkaajS8Gm4CVQjFEvyRTo39l8hw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bangers\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bangers/v20/FeVQS0BTqb0h60ACL5la2bxii28.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Barlow\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/barlow/v12/7cHrv4kjgoGqM7E3b8s8yn4hnCci.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/barlow/v12/7cHtv4kjgoGqM7E_CfNYwHoDmTcibrA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3w-oc4FAtlT47dw.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfP04Voptzsrd6m9.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3p-kc4FAtlT47dw.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfOQ4loptzsrd6m9.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/barlow/v12/7cHpv4kjgoGqM7EPC8E46HsxnA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/barlow/v12/7cHrv4kjgoGqM7E_Ccs8yn4hnCci.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3_-gc4FAtlT47dw.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfPI41optzsrd6m9.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E30-8c4FAtlT47dw.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfPk5Foptzsrd6m9.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3t-4c4FAtlT47dw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfOA5Voptzsrd6m9.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3q-0c4FAtlT47dw.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfOc5loptzsrd6m9.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/barlow/v12/7cHqv4kjgoGqM7E3j-wc4FAtlT47dw.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/barlow/v12/7cHsv4kjgoGqM7E_CfO451optzsrd6m9.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Barlow Condensed\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxxL3I-JCGChYJ8VI-L6OO_au7B43LT31vytKgbaw.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxzL3I-JCGChYJ8VI-L6OO_au7B6xTru1H2lq0La6JN.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B497y_3HcuKECcrs.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrF3DWvIMHYrtUxg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B47rx_3HcuKECcrs.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrc3PWvIMHYrtUxg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTx3L3I-JCGChYJ8VI-L6OO_au7B2xbZ23n3pKg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxxL3I-JCGChYJ8VI-L6OO_au7B6xTT31vytKgbaw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B4-Lw_3HcuKECcrs.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrK3LWvIMHYrtUxg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B4873_3HcuKECcrs.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrB3XWvIMHYrtUxg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B46r2_3HcuKECcrs.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrY3TWvIMHYrtUxg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B47b1_3HcuKECcrs.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrf3fWvIMHYrtUxg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxwL3I-JCGChYJ8VI-L6OO_au7B45L0_3HcuKECcrs.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/barlowcondensed/v12/HTxyL3I-JCGChYJ8VI-L6OO_au7B6xTrW3bWvIMHYrtUxg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Barlow Semi Condensed\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlphgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRfG4qvKk8ogoSP.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpjgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbLLIEsKh5SPZWs.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRft6uPAGEki52WfA.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbJnAWsgqZiGfHK5.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRf06iPAGEki52WfA.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbIDAmsgqZiGfHK5.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpvgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRnf4CrCEo4gg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlphgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfYqvKk8ogoSP.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRfi6mPAGEki52WfA.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbJbA2sgqZiGfHK5.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRfp66PAGEki52WfA.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbJ3BGsgqZiGfHK5.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRfw6-PAGEki52WfA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbITBWsgqZiGfHK5.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRf36yPAGEki52WfA.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbIPBmsgqZiGfHK5.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpigxjLBV1hqnzfr-F8sEYMB0Yybp0mudRf-62PAGEki52WfA.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/barlowsemicondensed/v14/wlpkgxjLBV1hqnzfr-F8sEYMB0Yybp0mudRXfbIrB2sgqZiGfHK5.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Barriecito\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/barriecito/v17/WWXXlj-CbBOSLY2QTuY_KdUiYwTO0MU.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Barrio\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/barrio/v19/wEO8EBXBk8hBIDiEdQYhWdsX1Q.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Basic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/basic/v17/xfu_0WLxV2_XKQN34lDVyR7D.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baskervville\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2023-01-18\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/baskervville/v14/YA9Ur0yU4l_XOrogbkun3kQgt5OohvbJ9A.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/baskervville/v14/YA9Kr0yU4l_XOrogbkun3kQQtZmspPPZ9Mlt.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Battambang\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/battambang/v24/uk-kEGe7raEw-HjkzZabNhGp5w50_o9T7Q.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/battambang/v24/uk-lEGe7raEw-HjkzZabNtmLxyRa8oZK9I0.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/battambang/v24/uk-mEGe7raEw-HjkzZabDnWj4yxx7o8.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/battambang/v24/uk-lEGe7raEw-HjkzZabNsmMxyRa8oZK9I0.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/battambang/v24/uk-lEGe7raEw-HjkzZabNvGOxyRa8oZK9I0.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Baumans\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/baumans/v17/-W_-XJj9QyTd3QfpR_oyaksqY5Q.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bayon\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v29\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bayon/v29/9XUrlJNmn0LPFl-pOhYEd2NJ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Be Vietnam Pro\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVNSTAyLFyeg_IDWvOJmVES_HRUBX8YYbAiah8.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVLSTAyLFyeg_IDWvOJmVES_HwyPRsSZZIneh-waA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVMSTAyLFyeg_IDWvOJmVES_HT4JF8yT7wrcwap.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVKSTAyLFyeg_IDWvOJmVES_HwyPbczRbgJdhapcUU.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVMSTAyLFyeg_IDWvOJmVES_HScJ18yT7wrcwap.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVKSTAyLFyeg_IDWvOJmVES_HwyPdMwRbgJdhapcUU.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVPSTAyLFyeg_IDWvOJmVES_EwwD3s6ZKAi.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVNSTAyLFyeg_IDWvOJmVES_HwyBX8YYbAiah8.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVMSTAyLFyeg_IDWvOJmVES_HTEJl8yT7wrcwap.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVKSTAyLFyeg_IDWvOJmVES_HwyPYsxRbgJdhapcUU.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVMSTAyLFyeg_IDWvOJmVES_HToIV8yT7wrcwap.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVKSTAyLFyeg_IDWvOJmVES_HwyPac2RbgJdhapcUU.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVMSTAyLFyeg_IDWvOJmVES_HSMIF8yT7wrcwap.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVKSTAyLFyeg_IDWvOJmVES_HwyPcM3RbgJdhapcUU.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVMSTAyLFyeg_IDWvOJmVES_HSQI18yT7wrcwap.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVKSTAyLFyeg_IDWvOJmVES_HwyPd80RbgJdhapcUU.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVMSTAyLFyeg_IDWvOJmVES_HS0Il8yT7wrcwap.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/bevietnampro/v10/QdVKSTAyLFyeg_IDWvOJmVES_HwyPfs1RbgJdhapcUU.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Beau Rivage\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/beaurivage/v2/UcCi3FIgIG2bH4mMNWJUlmg3NZp8K2sL.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bebas Neue\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bebasneue/v9/JTUSjIg69CK48gW7PXooxW5rygbi49c.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Belgrano\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/belgrano/v18/55xvey5tM9rwKWrJZcMFirl08KDJ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bellefair\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bellefair/v14/kJExBuYY6AAuhiXUxG19__A2pOdvDA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Belleza\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/belleza/v17/0nkoC9_pNeMfhX4BtcbyawzruP8.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bellota\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/bellota/v16/MwQzbhXl3_qEpiwAID55kGMViblPtXs.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/bellota/v16/MwQxbhXl3_qEpiwAKJBjHGEfjZtKpXulTQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/bellota/v16/MwQ2bhXl3_qEpiwAGJJRtGs-lbA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/bellota/v16/MwQ0bhXl3_qEpiwAKJBbsEk7hbBWrA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bellota/v16/MwQzbhXl3_qEpiwAIC5-kGMViblPtXs.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/bellota/v16/MwQxbhXl3_qEpiwAKJBjDGYfjZtKpXulTQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bellota Text\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/bellotatext/v16/0FlMVP2VnlWS4f3-UE9hHXM5VfsqfQXwQy6yxg.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/bellotatext/v16/0FlOVP2VnlWS4f3-UE9hHXMx--Gmfw_0YSuixmYK.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/bellotatext/v16/0FlTVP2VnlWS4f3-UE9hHXMB-dMOdS7sSg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/bellotatext/v16/0FlNVP2VnlWS4f3-UE9hHXMx-9kKVyv8Sjer.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bellotatext/v16/0FlMVP2VnlWS4f3-UE9hHXM5RfwqfQXwQy6yxg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/bellotatext/v16/0FlOVP2VnlWS4f3-UE9hHXMx--G2eA_0YSuixmYK.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"BenchNine\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/benchnine/v16/ahcev8612zF4jxrwMosT--tRhWa8q0v8ag.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/benchnine/v16/ahcbv8612zF4jxrwMosrV8N1jU2gog.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/benchnine/v16/ahcev8612zF4jxrwMosT6-xRhWa8q0v8ag.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Benne\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"kannada\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/benne/v22/L0xzDFAhn18E6Vjxlt6qTDBN.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bentham\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bentham/v18/VdGeAZQPEpYfmHglKWw7CJaK_y4.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Berkshire Swash\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/berkshireswash/v16/ptRRTi-cavZOGqCvnNJDl5m5XmNPrcQybX4pQA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Besley\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/besley/v12/PlIhFlO1MaNwaNGWUC92IOH_mtG4fbbBSdRoFPOl8-E.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/besley/v12/PlIhFlO1MaNwaNGWUC92IOH_mtG4fYTBSdRoFPOl8-E.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/besley/v12/PlIhFlO1MaNwaNGWUC92IOH_mtG4fWjGSdRoFPOl8-E.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/besley/v12/PlIhFlO1MaNwaNGWUC92IOH_mtG4fVHGSdRoFPOl8-E.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/besley/v12/PlIhFlO1MaNwaNGWUC92IOH_mtG4fTbGSdRoFPOl8-E.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/besley/v12/PlIhFlO1MaNwaNGWUC92IOH_mtG4fR_GSdRoFPOl8-E.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/besley/v12/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6CoZdiENGg4-E04A.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/besley/v12/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6Ck5diENGg4-E04A.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/besley/v12/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6Cf5BiENGg4-E04A.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/besley/v12/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6CRpBiENGg4-E04A.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/besley/v12/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6CIZBiENGg4-E04A.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/besley/v12/PlIjFlO1MaNwaNG8WR2J-IiUAH-_aH6CCJBiENGg4-E04A.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Beth Ellen\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-04-20\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bethellen/v17/WwkbxPW2BE-3rb_JNT-qEIAiVNo5xNY.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bevan\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bevan/v20/4iCj6KZ0a9NXjF8aUir7tlSJ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/bevan/v20/4iCt6KZ0a9NXjG8YWC7Zs0SJD4U.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"BhuTuka Expanded One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"gurmukhi\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bhutukaexpandedone/v2/SLXXc0jZ4WUJcClHTtv0t7IaDRsBsWRiJCyX8pg_RVH1.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Big Shoulders Display\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/bigshouldersdisplay/v15/fC1MPZJEZG-e9gHhdI4-NBbfd2ys3SjJCx12wPgf9g-_3F0YdY86JF46SRP4yZQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/bigshouldersdisplay/v15/fC1MPZJEZG-e9gHhdI4-NBbfd2ys3SjJCx12wPgf9g-_3F0YdQ87JF46SRP4yZQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/bigshouldersdisplay/v15/fC1MPZJEZG-e9gHhdI4-NBbfd2ys3SjJCx12wPgf9g-_3F0YddE7JF46SRP4yZQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/bigshouldersdisplay/v15/fC1MPZJEZG-e9gHhdI4-NBbfd2ys3SjJCx12wPgf9g-_3F0YdY87JF46SRP4yZQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/bigshouldersdisplay/v15/fC1MPZJEZG-e9gHhdI4-NBbfd2ys3SjJCx12wPgf9g-_3F0Ydb07JF46SRP4yZQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/bigshouldersdisplay/v15/fC1MPZJEZG-e9gHhdI4-NBbfd2ys3SjJCx12wPgf9g-_3F0YdVE8JF46SRP4yZQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bigshouldersdisplay/v15/fC1MPZJEZG-e9gHhdI4-NBbfd2ys3SjJCx12wPgf9g-_3F0YdWg8JF46SRP4yZQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/bigshouldersdisplay/v15/fC1MPZJEZG-e9gHhdI4-NBbfd2ys3SjJCx12wPgf9g-_3F0YdQ88JF46SRP4yZQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/bigshouldersdisplay/v15/fC1MPZJEZG-e9gHhdI4-NBbfd2ys3SjJCx12wPgf9g-_3F0YdSY8JF46SRP4yZQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Big Shoulders Inline Display\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/bigshouldersinlinedisplay/v21/_LOumyfF4eSU_SCrJc9OI24U7siGvBGcZqmqV9-ZZ85CGNOFeNLxoYMPJ0nBEnR5yPc2Huux.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/bigshouldersinlinedisplay/v21/_LOumyfF4eSU_SCrJc9OI24U7siGvBGcZqmqV9-ZZ85CGNOFeNLxoYMPJ0lBE3R5yPc2Huux.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/bigshouldersinlinedisplay/v21/_LOumyfF4eSU_SCrJc9OI24U7siGvBGcZqmqV9-ZZ85CGNOFeNLxoYMPJ0mfE3R5yPc2Huux.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/bigshouldersinlinedisplay/v21/_LOumyfF4eSU_SCrJc9OI24U7siGvBGcZqmqV9-ZZ85CGNOFeNLxoYMPJ0nBE3R5yPc2Huux.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/bigshouldersinlinedisplay/v21/_LOumyfF4eSU_SCrJc9OI24U7siGvBGcZqmqV9-ZZ85CGNOFeNLxoYMPJ0nzE3R5yPc2Huux.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/bigshouldersinlinedisplay/v21/_LOumyfF4eSU_SCrJc9OI24U7siGvBGcZqmqV9-ZZ85CGNOFeNLxoYMPJ0kfFHR5yPc2Huux.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bigshouldersinlinedisplay/v21/_LOumyfF4eSU_SCrJc9OI24U7siGvBGcZqmqV9-ZZ85CGNOFeNLxoYMPJ0kmFHR5yPc2Huux.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/bigshouldersinlinedisplay/v21/_LOumyfF4eSU_SCrJc9OI24U7siGvBGcZqmqV9-ZZ85CGNOFeNLxoYMPJ0lBFHR5yPc2Huux.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/bigshouldersinlinedisplay/v21/_LOumyfF4eSU_SCrJc9OI24U7siGvBGcZqmqV9-ZZ85CGNOFeNLxoYMPJ0loFHR5yPc2Huux.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Big Shoulders Inline Text\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/bigshouldersinlinetext/v21/vm8XdQDmVECV5-vm5dJ-Tp-6WDeRjL4RV7dP8u-NMyHY74qpoNNcwga0yqGN7Y6Jsc8c.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/bigshouldersinlinetext/v21/vm8XdQDmVECV5-vm5dJ-Tp-6WDeRjL4RV7dP8u-NMyHY74qpoNNcwgY0y6GN7Y6Jsc8c.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/bigshouldersinlinetext/v21/vm8XdQDmVECV5-vm5dJ-Tp-6WDeRjL4RV7dP8u-NMyHY74qpoNNcwgbqy6GN7Y6Jsc8c.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/bigshouldersinlinetext/v21/vm8XdQDmVECV5-vm5dJ-Tp-6WDeRjL4RV7dP8u-NMyHY74qpoNNcwga0y6GN7Y6Jsc8c.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/bigshouldersinlinetext/v21/vm8XdQDmVECV5-vm5dJ-Tp-6WDeRjL4RV7dP8u-NMyHY74qpoNNcwgaGy6GN7Y6Jsc8c.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/bigshouldersinlinetext/v21/vm8XdQDmVECV5-vm5dJ-Tp-6WDeRjL4RV7dP8u-NMyHY74qpoNNcwgZqzKGN7Y6Jsc8c.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bigshouldersinlinetext/v21/vm8XdQDmVECV5-vm5dJ-Tp-6WDeRjL4RV7dP8u-NMyHY74qpoNNcwgZTzKGN7Y6Jsc8c.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/bigshouldersinlinetext/v21/vm8XdQDmVECV5-vm5dJ-Tp-6WDeRjL4RV7dP8u-NMyHY74qpoNNcwgY0zKGN7Y6Jsc8c.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/bigshouldersinlinetext/v21/vm8XdQDmVECV5-vm5dJ-Tp-6WDeRjL4RV7dP8u-NMyHY74qpoNNcwgYdzKGN7Y6Jsc8c.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Big Shoulders Stencil Display\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/bigshouldersstencildisplay/v21/6aeZ4LS6U6pR_bp5b_t2ugOhHWFcxSGP9ttD96KCb8xPytKb-oPRU-vkuLm_O0nPKHznJucP9w.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/bigshouldersstencildisplay/v21/6aeZ4LS6U6pR_bp5b_t2ugOhHWFcxSGP9ttD96KCb8xPytKb-oPRU-vkuLm_u0jPKHznJucP9w.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/bigshouldersstencildisplay/v21/6aeZ4LS6U6pR_bp5b_t2ugOhHWFcxSGP9ttD96KCb8xPytKb-oPRU-vkuLm_ZUjPKHznJucP9w.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/bigshouldersstencildisplay/v21/6aeZ4LS6U6pR_bp5b_t2ugOhHWFcxSGP9ttD96KCb8xPytKb-oPRU-vkuLm_O0jPKHznJucP9w.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/bigshouldersstencildisplay/v21/6aeZ4LS6U6pR_bp5b_t2ugOhHWFcxSGP9ttD96KCb8xPytKb-oPRU-vkuLm_CUjPKHznJucP9w.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/bigshouldersstencildisplay/v21/6aeZ4LS6U6pR_bp5b_t2ugOhHWFcxSGP9ttD96KCb8xPytKb-oPRU-vkuLm_5U_PKHznJucP9w.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bigshouldersstencildisplay/v21/6aeZ4LS6U6pR_bp5b_t2ugOhHWFcxSGP9ttD96KCb8xPytKb-oPRU-vkuLm_3E_PKHznJucP9w.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/bigshouldersstencildisplay/v21/6aeZ4LS6U6pR_bp5b_t2ugOhHWFcxSGP9ttD96KCb8xPytKb-oPRU-vkuLm_u0_PKHznJucP9w.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/bigshouldersstencildisplay/v21/6aeZ4LS6U6pR_bp5b_t2ugOhHWFcxSGP9ttD96KCb8xPytKb-oPRU-vkuLm_kk_PKHznJucP9w.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Big Shoulders Stencil Text\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/bigshouldersstenciltext/v21/5aUV9-i2oxDMNwY3dHfW7UAt3Q453SM15wNj53bCcab2SJYLLUtk1OGR04XIGS_Py_AWbQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/bigshouldersstenciltext/v21/5aUV9-i2oxDMNwY3dHfW7UAt3Q453SM15wNj53bCcab2SJYLLUtk1OGRU4TIGS_Py_AWbQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/bigshouldersstenciltext/v21/5aUV9-i2oxDMNwY3dHfW7UAt3Q453SM15wNj53bCcab2SJYLLUtk1OGRjYTIGS_Py_AWbQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/bigshouldersstenciltext/v21/5aUV9-i2oxDMNwY3dHfW7UAt3Q453SM15wNj53bCcab2SJYLLUtk1OGR04TIGS_Py_AWbQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/bigshouldersstenciltext/v21/5aUV9-i2oxDMNwY3dHfW7UAt3Q453SM15wNj53bCcab2SJYLLUtk1OGR4YTIGS_Py_AWbQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/bigshouldersstenciltext/v21/5aUV9-i2oxDMNwY3dHfW7UAt3Q453SM15wNj53bCcab2SJYLLUtk1OGRDYPIGS_Py_AWbQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bigshouldersstenciltext/v21/5aUV9-i2oxDMNwY3dHfW7UAt3Q453SM15wNj53bCcab2SJYLLUtk1OGRNIPIGS_Py_AWbQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/bigshouldersstenciltext/v21/5aUV9-i2oxDMNwY3dHfW7UAt3Q453SM15wNj53bCcab2SJYLLUtk1OGRU4PIGS_Py_AWbQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/bigshouldersstenciltext/v21/5aUV9-i2oxDMNwY3dHfW7UAt3Q453SM15wNj53bCcab2SJYLLUtk1OGReoPIGS_Py_AWbQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Big Shoulders Text\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/bigshoulderstext/v17/55xEezRtP9G3CGPIf49hxc8P0eytUxB2l66LmF6xc3kA3Y-r3TIPNl6P2pc.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/bigshoulderstext/v17/55xEezRtP9G3CGPIf49hxc8P0eytUxB2l66LmF6xc3kA3Q-q3TIPNl6P2pc.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/bigshoulderstext/v17/55xEezRtP9G3CGPIf49hxc8P0eytUxB2l66LmF6xc3kA3dGq3TIPNl6P2pc.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/bigshoulderstext/v17/55xEezRtP9G3CGPIf49hxc8P0eytUxB2l66LmF6xc3kA3Y-q3TIPNl6P2pc.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/bigshoulderstext/v17/55xEezRtP9G3CGPIf49hxc8P0eytUxB2l66LmF6xc3kA3b2q3TIPNl6P2pc.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/bigshoulderstext/v17/55xEezRtP9G3CGPIf49hxc8P0eytUxB2l66LmF6xc3kA3VGt3TIPNl6P2pc.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bigshoulderstext/v17/55xEezRtP9G3CGPIf49hxc8P0eytUxB2l66LmF6xc3kA3Wit3TIPNl6P2pc.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/bigshoulderstext/v17/55xEezRtP9G3CGPIf49hxc8P0eytUxB2l66LmF6xc3kA3Q-t3TIPNl6P2pc.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/bigshoulderstext/v17/55xEezRtP9G3CGPIf49hxc8P0eytUxB2l66LmF6xc3kA3Sat3TIPNl6P2pc.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bigelow Rules\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bigelowrules/v23/RrQWboly8iR_I3KWSzeRuN0zT4cCH8WAJVk.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bigshot One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bigshotone/v25/u-470qukhRkkO6BD_7cM_gxuUQJBXv_-.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bilbo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bilbo/v20/o-0EIpgpwWwZ210hpIRz4wxE.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bilbo Swash Caps\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bilboswashcaps/v22/zrf-0GXbz-H3Wb4XBsGrTgq2PVmdqAPopiRfKp8.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"BioRhyme\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/biorhyme/v12/1cX3aULHBpDMsHYW_ESOjnGAq8Sk1PoH.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/biorhyme/v12/1cX3aULHBpDMsHYW_ETqjXGAq8Sk1PoH.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/biorhyme/v12/1cXwaULHBpDMsHYW_HxGpVWIgNit.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/biorhyme/v12/1cX3aULHBpDMsHYW_ET6inGAq8Sk1PoH.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/biorhyme/v12/1cX3aULHBpDMsHYW_ETmiXGAq8Sk1PoH.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"BioRhyme Expanded\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/biorhymeexpanded/v19/i7dVIE1zZzytGswgU577CDY9LjbffxxcblSHSdTXrb_z.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/biorhymeexpanded/v19/i7dVIE1zZzytGswgU577CDY9Ljbffxw4bVSHSdTXrb_z.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/biorhymeexpanded/v19/i7dQIE1zZzytGswgU577CDY9LjbffySURXCPYsje.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/biorhymeexpanded/v19/i7dVIE1zZzytGswgU577CDY9LjbffxwoalSHSdTXrb_z.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/biorhymeexpanded/v19/i7dVIE1zZzytGswgU577CDY9Ljbffxw0aVSHSdTXrb_z.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Birthstone\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/birthstone/v10/8AtsGs2xO4yLRhy87sv_HLn5jRfZHzM.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Birthstone Bounce\",\n      \"variants\": [\n        \"regular\",\n        \"500\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/birthstonebounce/v9/ga6XaxZF43lIvTWrktHOTBJZGH7dEeVJGIMYDo_8.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/birthstonebounce/v9/ga6SaxZF43lIvTWrktHOTBJZGH7dEd29MacQJZP1LmD9.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Biryani\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/biryani/v13/hv-TlzNxIFoO84YddYQyGTBSU-J-RxQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/biryani/v13/hv-TlzNxIFoO84YddeAxGTBSU-J-RxQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/biryani/v13/hv-WlzNxIFoO84YdTUwZPTh5T-s.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/biryani/v13/hv-TlzNxIFoO84YddZQ3GTBSU-J-RxQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/biryani/v13/hv-TlzNxIFoO84YddfA2GTBSU-J-RxQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/biryani/v13/hv-TlzNxIFoO84Yddew1GTBSU-J-RxQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/biryani/v13/hv-TlzNxIFoO84Yddcg0GTBSU-J-RxQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bitter\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v32\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/bitter/v32/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8fbeCL_EXFh2reU.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/bitter/v32/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8XbfCL_EXFh2reU.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/bitter/v32/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8ajfCL_EXFh2reU.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/bitter/v32/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8fbfCL_EXFh2reU.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/bitter/v32/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8cTfCL_EXFh2reU.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/bitter/v32/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8SjYCL_EXFh2reU.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bitter/v32/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8RHYCL_EXFh2reU.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/bitter/v32/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8XbYCL_EXFh2reU.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/bitter/v32/raxhHiqOu8IVPmnRc6SY1KXhnF_Y8V_YCL_EXFh2reU.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/bitter/v32/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6c4P3OWHpzveWxBw.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/bitter/v32/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cYPzOWHpzveWxBw.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/bitter/v32/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cvvzOWHpzveWxBw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/bitter/v32/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6c4PzOWHpzveWxBw.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/bitter/v32/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6c0vzOWHpzveWxBw.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/bitter/v32/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cPvvOWHpzveWxBw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/bitter/v32/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cB_vOWHpzveWxBw.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/bitter/v32/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cYPvOWHpzveWxBw.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/bitter/v32/raxjHiqOu8IVPmn7epZnDMyKBvHf5D6cSfvOWHpzveWxBw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Black And White Picture\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/blackandwhitepicture/v22/TwMe-JAERlQd3ooUHBUXGmrmioKjjnRSFO-NqI5HbcMi-yWY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Black Han Sans\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/blackhansans/v15/ea8Aad44WunzF9a-dL6toA8r8nqVIXSkH-Hc.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Black Ops One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/blackopsone/v20/qWcsB6-ypo7xBdr6Xshe96H3WDzRtjkho4M.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Blaka\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/blaka/v5/8vIG7w8722p_6kdr20D2FV5e.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Blaka Hollow\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/blakahollow/v5/MCoUzAL91sjRE2FsKsxUtezYB9oFyW_-oA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Blaka Ink\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-14\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/blakaink/v5/AlZy_zVVtpj22Znag2chdXf4XB0Tow.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Blinker\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/blinker/v12/cIf_MaFatEE-VTaP_E2hZEsCkIt9QQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/blinker/v12/cIf4MaFatEE-VTaP_OGARGEsnIJkWL4.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/blinker/v12/cIf4MaFatEE-VTaP_IWDRGEsnIJkWL4.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/blinker/v12/cIf9MaFatEE-VTaPxCmrYGkHgIs.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/blinker/v12/cIf4MaFatEE-VTaP_PGFRGEsnIJkWL4.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/blinker/v12/cIf4MaFatEE-VTaP_JWERGEsnIJkWL4.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/blinker/v12/cIf4MaFatEE-VTaP_ImHRGEsnIJkWL4.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/blinker/v12/cIf4MaFatEE-VTaP_K2GRGEsnIJkWL4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bodoni Moda\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oU7awIBytVjMYwE.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oXzawIBytVjMYwE.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oZDdwIBytVjMYwE.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oandwIBytVjMYwE.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oc7dwIBytVjMYwE.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT67PxzY382XsXX63LUYL6GYFcan6NJrKp-VPjfJMShrpsGFUt8oefdwIBytVjMYwE.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZKMN4sXrJcwHqoQ.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZGsN4sXrJcwHqoQ.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZ9sR4sXrJcwHqoQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZz8R4sXrJcwHqoQ.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZqMR4sXrJcwHqoQ.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/bodonimoda/v19/aFT07PxzY382XsXX63LUYJSPUqb0pL6OQqxrZLnVbvZedvJtj-V7tIaZgcR4sXrJcwHqoQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bokor\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v30\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bokor/v30/m8JcjfpeeaqTiR2WdInbcaxE.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bona Nova\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bonanova/v10/B50NF7ZCpX7fcHfvIUBJi6hqHK-CLA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/bonanova/v10/B50LF7ZCpX7fcHfvIUB5iaJuPqqSLJYf.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/bonanova/v10/B50IF7ZCpX7fcHfvIUBxN4dOFISeJY8GgQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bonbon\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bonbon/v26/0FlVVPeVlFec4ee_cDEAbQY5-A.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bonheur Royale\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bonheurroyale/v9/c4m51nt_GMTrtX-b9GcG4-YRmYK_c0f1N5Ij.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Boogaloo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/boogaloo/v19/kmK-Zq45GAvOdnaW6x1F_SrQo_1K.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bowlby One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bowlbyone/v19/taiPGmVuC4y96PFeqp8smo6C_Z0wcK4.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bowlby One SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bowlbyonesc/v19/DtVlJxerQqQm37tzN3wMug9Pzgj8owhNjuE.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Brawler\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/brawler/v19/xn7gYHE3xXewAscGsgC7S9XdZN8.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/brawler/v19/xn7lYHE3xXewAscGiryUb932eNaPfk8.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bree Serif\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/breeserif/v17/4UaHrEJCrhhnVA3DgluAx63j5pN1MwI.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Brygada 1918\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/brygada1918/v21/pe08MI6eKpdGqlF5LANrM--ACNaeo8mTUIR_y2-f-V8Wu5O3gbo.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/brygada1918/v21/pe08MI6eKpdGqlF5LANrM--ACNaeo8mTUIR_y12f-V8Wu5O3gbo.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/brygada1918/v21/pe08MI6eKpdGqlF5LANrM--ACNaeo8mTUIR_y7GY-V8Wu5O3gbo.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/brygada1918/v21/pe08MI6eKpdGqlF5LANrM--ACNaeo8mTUIR_y4iY-V8Wu5O3gbo.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/brygada1918/v21/pe06MI6eKpdGqlF5LANrM--qAeRhe6D4yip43qfcERwcv7GykboaLg.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/brygada1918/v21/pe06MI6eKpdGqlF5LANrM--qAeRhe6D4yip43qfcIxwcv7GykboaLg.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/brygada1918/v21/pe06MI6eKpdGqlF5LANrM--qAeRhe6D4yip43qfczxscv7GykboaLg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/brygada1918/v21/pe06MI6eKpdGqlF5LANrM--qAeRhe6D4yip43qfc9hscv7GykboaLg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bubblegum Sans\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bubblegumsans/v16/AYCSpXb_Z9EORv1M5QTjEzMEtdaHzoPPb7R4.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bubbler One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bubblerone/v20/f0Xy0eqj68ppQV9KBLmAouHH26MPePkt.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Buda\",\n      \"variants\": [\n        \"300\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/buda/v25/GFDqWAN8mnyIJSSrG7UBr7pZKA0.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Buenard\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/buenard/v17/OD5DuM6Cyma8FnnsPzf9qGi9HL4.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/buenard/v17/OD5GuM6Cyma8FnnsB4vSjGCWALepwss.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bungee\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bungee/v11/N0bU2SZBIuF2PU_ECn50Kd_PmA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bungee Hairline\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bungeehairline/v18/snfys0G548t04270a_ljTLUVrv-7YB2dQ5ZPqQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bungee Inline\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bungeeinline/v11/Gg8zN58UcgnlCweMrih332VuDGJ1-FEglsc.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bungee Outline\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bungeeoutline/v18/_6_mEDvmVP24UvU2MyiGDslL3Qg3YhJqPXxo.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bungee Shade\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bungeeshade/v11/DtVkJxarWL0t2KdzK3oI_jks7iLSrwFUlw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Bungee Spice\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-14\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/bungeespice/v8/nwpTtK2nIhxE0q-IwgSpZBqCzyI-aMPF7Q.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Butcherman\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/butcherman/v24/2EbiL-thF0loflXUBOdb1zWzq_5uT84.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Butterfly Kids\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/butterflykids/v21/ll8lK2CWTjuqAsXDqlnIbMNs5S4arxFrAX1D.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cabin\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cabin/v26/u-4X0qWljRw-PfU81xCKCpdpbgZJl6XFpfEd7eA9BIxxkV2EL7Gvxm7rE_s.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cabin/v26/u-4X0qWljRw-PfU81xCKCpdpbgZJl6XFpfEd7eA9BIxxkW-EL7Gvxm7rE_s.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cabin/v26/u-4X0qWljRw-PfU81xCKCpdpbgZJl6XFpfEd7eA9BIxxkYODL7Gvxm7rE_s.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cabin/v26/u-4X0qWljRw-PfU81xCKCpdpbgZJl6XFpfEd7eA9BIxxkbqDL7Gvxm7rE_s.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/cabin/v26/u-4V0qWljRw-Pd815fNqc8T_wAFcX-c37MPiNYlWniJ2hJXHx_KlwkzuA_u1Bg.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/cabin/v26/u-4V0qWljRw-Pd815fNqc8T_wAFcX-c37MPiNYlWniJ2hJXH9fKlwkzuA_u1Bg.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/cabin/v26/u-4V0qWljRw-Pd815fNqc8T_wAFcX-c37MPiNYlWniJ2hJXHGfWlwkzuA_u1Bg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/cabin/v26/u-4V0qWljRw-Pd815fNqc8T_wAFcX-c37MPiNYlWniJ2hJXHIPWlwkzuA_u1Bg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cabin Condensed\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cabincondensed/v19/nwpMtK6mNhBK2err_hqkYhHRqmwaYOjZ5HZl8Q.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cabincondensed/v19/nwpJtK6mNhBK2err_hqkYhHRqmwilMH97F15-K1oqQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cabincondensed/v19/nwpJtK6mNhBK2err_hqkYhHRqmwiuMb97F15-K1oqQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cabincondensed/v19/nwpJtK6mNhBK2err_hqkYhHRqmwi3Mf97F15-K1oqQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cabin Sketch\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cabinsketch/v19/QGYpz_kZZAGCONcK2A4bGOjMn9JM6fnuKg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cabinsketch/v19/QGY2z_kZZAGCONcK2A4bGOj0I_1o4dLyI4CMFw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Caesar Dressing\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/caesardressing/v21/yYLx0hLa3vawqtwdswbotmK4vrR3cbb6LZttyg.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cagliostro\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cagliostro/v21/ZgNWjP5HM73BV5amnX-TjGXEM4COoE4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cairo\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/cairo/v22/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hGA-W1ToLQ-HmkA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/cairo/v22/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hL4-W1ToLQ-HmkA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/cairo/v22/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hOA-W1ToLQ-HmkA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cairo/v22/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hNI-W1ToLQ-HmkA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cairo/v22/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hD45W1ToLQ-HmkA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cairo/v22/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hAc5W1ToLQ-HmkA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/cairo/v22/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hGA5W1ToLQ-HmkA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/cairo/v22/SLXgc1nY6HkvangtZmpQdkhzfH5lkSs2SgRjCAGMQ1z0hEk5W1ToLQ-HmkA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cairo Play\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v6\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/cairoplay/v6/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1EnYq9yXa8GvzaA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/cairoplay/v6/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1zHYq9yXa8GvzaA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/cairoplay/v6/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1knYq9yXa8GvzaA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cairoplay/v6/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1oHYq9yXa8GvzaA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cairoplay/v6/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1THEq9yXa8GvzaA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cairoplay/v6/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1dXEq9yXa8GvzaA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/cairoplay/v6/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1EnEq9yXa8GvzaA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/cairoplay/v6/wXKEE3QSpo4vpRz_mz6FP-8iaauCLt_Hjopv3miu5IvcJo49mOo1O3Eq9yXa8GvzaA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Caladea\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/caladea/v7/kJEzBugZ7AAjhybUjR93-9IztOc.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/caladea/v7/kJExBugZ7AAjhybUvR19__A2pOdvDA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/caladea/v7/kJE2BugZ7AAjhybUtaNY39oYqO52FZ0.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/caladea/v7/kJE0BugZ7AAjhybUvR1FQ98SrMxzBZ2lDA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Calistoga\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/calistoga/v13/6NUU8F2OJg6MeR7l4e0vtMYAwdRZfw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Calligraffitti\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/calligraffitti/v19/46k2lbT3XjDVqJw3DCmCFjE0vnFZM5ZBpYN-.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cambay\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cambay/v12/SLXJc1rY6H0_ZDsGbrSIz9JsaA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/cambay/v12/SLXLc1rY6H0_ZDs2bL6M7dd8aGZk.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cambay/v12/SLXKc1rY6H0_ZDs-0pusx_lwYX99kA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/cambay/v12/SLXMc1rY6H0_ZDs2bIYwwvN0Q3ptkDMN.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cambo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cambo/v17/IFSqHeNEk8FJk416ok7xkPm8.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Candal\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/candal/v15/XoHn2YH6T7-t_8cNAR4Jt9Yxlw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cantarell\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cantarell/v17/B50NF7ZDq37KMUvlO01Ji6hqHK-CLA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/cantarell/v17/B50LF7ZDq37KMUvlO015iaJuPqqSLJYf.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cantarell/v17/B50IF7ZDq37KMUvlO01xN4dOFISeJY8GgQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/cantarell/v17/B50WF7ZDq37KMUvlO015iZrSEY6aB4oWgWHB.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cantata One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cantataone/v15/PlI5Fl60Nb5obNzNe2jslVxEt8CwfGaD.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cantora One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cantoraone/v19/gyB4hws1JdgnKy56GB_JX6zdZ4vZVbgZ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Capriola\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/capriola/v13/wXKoE3YSppcvo1PDln_8L-AinG8y.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Caramel\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/caramel/v7/P5sCzZKBbMTf_ShyxCRuiZ-uydg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Carattere\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/carattere/v7/4iCv6Kp1b9dXlgt_CkvTt2aMH4V_gg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cardo\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cardo/v19/wlp_gwjKBV1pqiv_1oAZ2H5O.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/cardo/v19/wlpxgwjKBV1pqhv93IQ73W5OcCk.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cardo/v19/wlpygwjKBV1pqhND-aQR82JHaTBX.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Carme\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/carme/v16/ptRHTiWdbvZIDOjGxLNrxfbZ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Carrois Gothic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/carroisgothic/v16/Z9XPDmFATg-N1PLtLOOxvIHl9ZmD3i7ajcJ-.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Carrois Gothic SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/carroisgothicsc/v15/ZgNJjOVHM6jfUZCmyUqT2A2HVKjc-28nNHabY4dN.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Carter One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/carterone/v17/q5uCsoe5IOB2-pXv9UcNIxR2hYxREMs.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Castoro\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/castoro/v18/1q2GY5yMCld3-O4cHYhEzOYenEU.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/castoro/v18/1q2EY5yMCld3-O4cLYpOyMQbjEX5fw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Catamaran\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tamil\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/catamaran/v17/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPHjc1anXuluiLyw.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/catamaran/v17/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPPjd1anXuluiLyw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/catamaran/v17/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPCbd1anXuluiLyw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/catamaran/v17/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPHjd1anXuluiLyw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/catamaran/v17/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPErd1anXuluiLyw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/catamaran/v17/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPKba1anXuluiLyw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/catamaran/v17/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPJ_a1anXuluiLyw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/catamaran/v17/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPPja1anXuluiLyw.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/catamaran/v17/o-0bIpQoyXQa2RxT7-5B6Ryxs2E_6n1iPNHa1anXuluiLyw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Caudex\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/caudex/v15/esDQ311QOP6BJUrIyviAnb4eEw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/caudex/v15/esDS311QOP6BJUr4yPKEv7sOE4in.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/caudex/v15/esDT311QOP6BJUrwdteklZUCGpG-GQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/caudex/v15/esDV311QOP6BJUr4yMo4kJ8GOJSuGdLB.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Caveat\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/caveat/v17/WnznHAc5bAfYB2QRah7pcpNvOx-pjfJ9SIKjYBxPigs.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/caveat/v17/WnznHAc5bAfYB2QRah7pcpNvOx-pjcB9SIKjYBxPigs.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/caveat/v17/WnznHAc5bAfYB2QRah7pcpNvOx-pjSx6SIKjYBxPigs.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/caveat/v17/WnznHAc5bAfYB2QRah7pcpNvOx-pjRV6SIKjYBxPigs.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Caveat Brush\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/caveatbrush/v11/EYq0maZfwr9S9-ETZc3fKXtMW7mT03pdQw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cedarville Cursive\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cedarvillecursive/v17/yYL00g_a2veiudhUmxjo5VKkoqA-B_neJbBxw8BeTg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Ceviche One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cevicheone/v16/gyB4hws1IcA6JzR-GB_JX6zdZ4vZVbgZ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chakra Petch\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/chakrapetch/v9/cIflMapbsEk7TDLdtEz1BwkeNIhFQJXE3AY00g.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/chakrapetch/v9/cIfnMapbsEk7TDLdtEz1BwkWmpLJQp_A_gMk0izH.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/chakrapetch/v9/cIf6MapbsEk7TDLdtEz1BwkmmKBhSL7Y1Q.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/chakrapetch/v9/cIfkMapbsEk7TDLdtEz1BwkWmqplarvI1R8t.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/chakrapetch/v9/cIflMapbsEk7TDLdtEz1BwkebIlFQJXE3AY00g.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/chakrapetch/v9/cIfnMapbsEk7TDLdtEz1BwkWmpKRQ5_A_gMk0izH.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/chakrapetch/v9/cIflMapbsEk7TDLdtEz1BwkeQI5FQJXE3AY00g.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/chakrapetch/v9/cIfnMapbsEk7TDLdtEz1BwkWmpK9RJ_A_gMk0izH.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/chakrapetch/v9/cIflMapbsEk7TDLdtEz1BwkeJI9FQJXE3AY00g.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/chakrapetch/v9/cIfnMapbsEk7TDLdtEz1BwkWmpLZRZ_A_gMk0izH.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Changa\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/changa/v20/2-c79JNi2YuVOUcOarRPgnNGooxCZy2xQjDp9htf1ZM.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/changa/v20/2-c79JNi2YuVOUcOarRPgnNGooxCZ_OxQjDp9htf1ZM.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/changa/v20/2-c79JNi2YuVOUcOarRPgnNGooxCZ62xQjDp9htf1ZM.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/changa/v20/2-c79JNi2YuVOUcOarRPgnNGooxCZ5-xQjDp9htf1ZM.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/changa/v20/2-c79JNi2YuVOUcOarRPgnNGooxCZ3O2QjDp9htf1ZM.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/changa/v20/2-c79JNi2YuVOUcOarRPgnNGooxCZ0q2QjDp9htf1ZM.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/changa/v20/2-c79JNi2YuVOUcOarRPgnNGooxCZy22QjDp9htf1ZM.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Changa One\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/changaone/v18/xfu00W3wXn3QLUJXhzq46AbouLfbK64.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/changaone/v18/xfu20W3wXn3QLUJXhzq42ATivJXeO67ISw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chango\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/chango/v21/2V0cKI0OB5U7WaJyz324TFUaAw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Charis SIL\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/charissil/v1/oPWK_kV3l-s-Q8govXvKrPrmYjZ2Xn0.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/charissil/v1/oPWI_kV3l-s-Q8govXvKnPjsZhRzTn2Ozw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/charissil/v1/oPWJ_kV3l-s-Q8govXvKlEbJRj5dQnSX1ko.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/charissil/v1/oPWX_kV3l-s-Q8govXvKnPjU2jtXRlaSxkrMCQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Charm\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/charm/v10/7cHmv4oii5K0MeYvIe804WIo.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/charm/v10/7cHrv4oii5K0Md6TDss8yn4hnCci.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Charmonman\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/charmonman/v18/MjQDmiR3vP_nuxDv47jiWJGovLdh6OE.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/charmonman/v18/MjQAmiR3vP_nuxDv47jiYC2HmL9K9OhmGnY.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chathura\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"telugu\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/chathura/v20/_gP91R7-rzUuVjim42dEq0SbTvZyuDo.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/chathura/v20/_gP81R7-rzUuVjim42eMiWSxYPp7oSNy.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/chathura/v20/_gP71R7-rzUuVjim418goUC5S-Zy.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/chathura/v20/_gP81R7-rzUuVjim42ecjmSxYPp7oSNy.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/chathura/v20/_gP81R7-rzUuVjim42eAjWSxYPp7oSNy.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chau Philomene One\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/chauphilomeneone/v15/55xxezRsPtfie1vPY49qzdgSlJiHRQFsnIx7QMISdQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/chauphilomeneone/v15/55xzezRsPtfie1vPY49qzdgSlJiHRQFcnoZ_YscCdXQB.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chela One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/chelaone/v21/6ae-4KC7Uqgdz_JZdPIy31vWNTMwoQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chelsea Market\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/chelseamarket/v13/BCawqZsHqfr89WNP_IApC8tzKBhlLA4uKkWk.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chenla\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/chenla/v25/SZc43FDpIKu8WZ9eXxfonUPL6Q.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cherish\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cherish/v7/ll88K2mXUyqsDsTN5iDCI6IJjg8.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cherry Cream Soda\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cherrycreamsoda/v21/UMBIrOxBrW6w2FFyi9paG0fdVdRciTd6Cd47DJ7G.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cherry Swash\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cherryswash/v18/i7dNIFByZjaNAMxtZcnfAy58QHi-EwWMbg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cherryswash/v18/i7dSIFByZjaNAMxtZcnfAy5E_FeaGy6QZ3WfYg.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chewy\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/chewy/v18/uK_94ruUb-k-wk5xIDMfO-ed.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chicle\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/chicle/v21/lJwG-pw9i2dqU-BDyWKuobYSxw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chilanka\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"malayalam\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/chilanka/v18/WWXRlj2DZQiMJYaYRrJQI9EAZhTO.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chivo\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-11-18\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/chivo/v18/va9b4kzIxd1KFppkaRKvDRPJVDf_vB7ul2DSFXjQiQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/chivo/v18/va9b4kzIxd1KFppkaRKvDRPJVDf_PB_ul2DSFXjQiQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/chivo/v18/va9b4kzIxd1KFppkaRKvDRPJVDf_4h_ul2DSFXjQiQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/chivo/v18/va9b4kzIxd1KFppkaRKvDRPJVDf_vB_ul2DSFXjQiQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/chivo/v18/va9b4kzIxd1KFppkaRKvDRPJVDf_jh_ul2DSFXjQiQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/chivo/v18/va9b4kzIxd1KFppkaRKvDRPJVDf_Yhjul2DSFXjQiQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/chivo/v18/va9b4kzIxd1KFppkaRKvDRPJVDf_Wxjul2DSFXjQiQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/chivo/v18/va9b4kzIxd1KFppkaRKvDRPJVDf_PBjul2DSFXjQiQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/chivo/v18/va9b4kzIxd1KFppkaRKvDRPJVDf_FRjul2DSFXjQiQ.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/chivo/v18/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFwG1WrWN33AiasJ.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/chivo/v18/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFyG1GrWN33AiasJ.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/chivo/v18/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFxY1GrWN33AiasJ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/chivo/v18/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFwG1GrWN33AiasJ.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/chivo/v18/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFw01GrWN33AiasJ.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/chivo/v18/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFzY02rWN33AiasJ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/chivo/v18/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFzh02rWN33AiasJ.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/chivo/v18/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFyG02rWN33AiasJ.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/chivo/v18/va9Z4kzIxd1KFrBtW-13ZHhT-jDqdFyv02rWN33AiasJ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chivo Mono\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/chivomono/v4/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D7hrqfVKphL03l4.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/chivomono/v4/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D5hr6fVKphL03l4.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/chivomono/v4/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D6_r6fVKphL03l4.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/chivomono/v4/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D7hr6fVKphL03l4.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/chivomono/v4/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D7Tr6fVKphL03l4.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/chivomono/v4/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D4_qKfVKphL03l4.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/chivomono/v4/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D4GqKfVKphL03l4.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/chivomono/v4/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D5hqKfVKphL03l4.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/chivomono/v4/mFThWbgRxKvF_Z5eQMO9qRMrJJrnKNtC3D5IqKfVKphL03l4.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/chivomono/v4/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7E-XIJxp1ml4imo.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/chivomono/v4/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7M-WIJxp1ml4imo.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/chivomono/v4/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7BGWIJxp1ml4imo.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/chivomono/v4/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7E-WIJxp1ml4imo.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/chivomono/v4/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7H2WIJxp1ml4imo.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/chivomono/v4/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7JGRIJxp1ml4imo.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/chivomono/v4/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7KiRIJxp1ml4imo.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/chivomono/v4/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7M-RIJxp1ml4imo.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/chivomono/v4/mFTjWbgRxKvF_Z5eQMO9gxoZ20KOQ0Hs2ysp7OaRIJxp1ml4imo.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Chonburi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/chonburi/v10/8AtqGs-wOpGRTBq66IWaFr3biAfZ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cinzel\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cinzel/v19/8vIU7ww63mVu7gtR-kwKxNvkNOjw-tbnTYrvDE5ZdqU.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cinzel/v19/8vIU7ww63mVu7gtR-kwKxNvkNOjw-uTnTYrvDE5ZdqU.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cinzel/v19/8vIU7ww63mVu7gtR-kwKxNvkNOjw-gjgTYrvDE5ZdqU.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cinzel/v19/8vIU7ww63mVu7gtR-kwKxNvkNOjw-jHgTYrvDE5ZdqU.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/cinzel/v19/8vIU7ww63mVu7gtR-kwKxNvkNOjw-lbgTYrvDE5ZdqU.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/cinzel/v19/8vIU7ww63mVu7gtR-kwKxNvkNOjw-n_gTYrvDE5ZdqU.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cinzel Decorative\",\n      \"variants\": [\n        \"regular\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cinzeldecorative/v14/daaCSScvJGqLYhG8nNt8KPPswUAPnh7URs1LaCyC.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cinzeldecorative/v14/daaHSScvJGqLYhG8nNt8KPPswUAPniZoaelDQzCLlQXE.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/cinzeldecorative/v14/daaHSScvJGqLYhG8nNt8KPPswUAPniZQa-lDQzCLlQXE.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Clicker Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/clickerscript/v13/raxkHiKPvt8CMH6ZWP8PdlEq72rY2zqUKafv.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Climate Crisis\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2023-02-23\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/climatecrisis/v3/wEOpEB3AntNeKCPBVW9XOKlmp3AUgWFN1DvIvcM0gFp6jaUrGb7PsQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Coda\",\n      \"variants\": [\n        \"regular\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/coda/v21/SLXHc1jY5nQ8JUIMapaN39I.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/coda/v21/SLXIc1jY5nQ8HeIgTp6mw9t1cX8.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Coda Caption\",\n      \"variants\": [\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"800\": \"http://fonts.gstatic.com/s/codacaption/v19/ieVm2YRII2GMY7SyXSoDRiQGqcx6x_-fACIgaw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Codystar\",\n      \"variants\": [\n        \"300\",\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/codystar/v15/FwZf7-Q1xVk-40qxOuYsyuyrj0e29bfC.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/codystar/v15/FwZY7-Q1xVk-40qxOt6A4sijpFu_.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Coiny\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tamil\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/coiny/v16/gyByhwU1K989PXwbElSvO5Tc.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Combo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/combo/v21/BXRlvF3Jh_fIhg0iBu9y8Hf0.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Comfortaa\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v40\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/comfortaa/v40/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4TbMPrQVIT9c2c8.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/comfortaa/v40/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4WjMPrQVIT9c2c8.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/comfortaa/v40/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4VrMPrQVIT9c2c8.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/comfortaa/v40/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4bbLPrQVIT9c2c8.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/comfortaa/v40/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4Y_LPrQVIT9c2c8.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Comforter\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/comforter/v5/H4clBXOCl8nQnlaql3Qa6JG8iqeuag.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Comforter Brush\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/comforterbrush/v5/Y4GTYa1xVSggrfzZI5WMjxRaOz0jwLL9Th8YYA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Comic Neue\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/comicneue/v8/4UaErEJDsxBrF37olUeD_wHLwpteLwtHJlc.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/comicneue/v8/4UaarEJDsxBrF37olUeD96_RTplUKylCNlcw_Q.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/comicneue/v8/4UaHrEJDsxBrF37olUeDx63j5pN1MwI.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/comicneue/v8/4UaFrEJDsxBrF37olUeD96_p4rFwIwJePw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/comicneue/v8/4UaErEJDsxBrF37olUeD_xHMwpteLwtHJlc.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/comicneue/v8/4UaarEJDsxBrF37olUeD96_RXp5UKylCNlcw_Q.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Coming Soon\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/comingsoon/v19/qWcuB6mzpYL7AJ2VfdQR1u-SUjjzsykh.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Commissioner\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/commissioner/v13/tDbe2o2WnlgI0FNDgduEk4jAhwgIy5k8SlfU5Ni-IO9pOXuRoaY.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/commissioner/v13/tDbe2o2WnlgI0FNDgduEk4jAhwgIy5k8SlfU5Fi_IO9pOXuRoaY.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/commissioner/v13/tDbe2o2WnlgI0FNDgduEk4jAhwgIy5k8SlfU5Ia_IO9pOXuRoaY.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/commissioner/v13/tDbe2o2WnlgI0FNDgduEk4jAhwgIy5k8SlfU5Ni_IO9pOXuRoaY.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/commissioner/v13/tDbe2o2WnlgI0FNDgduEk4jAhwgIy5k8SlfU5Oq_IO9pOXuRoaY.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/commissioner/v13/tDbe2o2WnlgI0FNDgduEk4jAhwgIy5k8SlfU5Aa4IO9pOXuRoaY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/commissioner/v13/tDbe2o2WnlgI0FNDgduEk4jAhwgIy5k8SlfU5D-4IO9pOXuRoaY.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/commissioner/v13/tDbe2o2WnlgI0FNDgduEk4jAhwgIy5k8SlfU5Fi4IO9pOXuRoaY.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/commissioner/v13/tDbe2o2WnlgI0FNDgduEk4jAhwgIy5k8SlfU5HG4IO9pOXuRoaY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Concert One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/concertone/v17/VEM1Ro9xs5PjtzCu-srDqRTlhv-CuVAQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Condiment\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/condiment/v20/pONk1hggFNmwvXALyH6Sq4n4o1vyCQ.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Content\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"khmer\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/content/v24/zrfl0HLayePhU_AwUaDyIiL0RCg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/content/v24/zrfg0HLayePhU_AwaRzdBirfWCHvkAI.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Contrail One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/contrailone/v15/eLGbP-j_JA-kG0_Zo51noafdZUvt_c092w.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Convergence\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/convergence/v15/rax5HiePvdgXPmmMHcIPYRhasU7Q8Cad.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cookie\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cookie/v17/syky-y18lb0tSbfNlQCT9tPdpw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Copse\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/copse/v15/11hPGpDKz1rGb0djHkihUb-A.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Corben\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/corben/v19/LYjDdGzzklQtCMp9oAlEpVs3VQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/corben/v19/LYjAdGzzklQtCMpFHCZgrXArXN7HWQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Corinthia\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/corinthia/v9/wEO_EBrAnchaJyPMHE0FUfAL3EsHiA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/corinthia/v9/wEO6EBrAnchaJyPMHE097d8v1GAbgbLXQA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cormorant\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/cormorant/v18/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFk9TQ7Rg7A2uwYs.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/cormorant/v18/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFhFTQ7Rg7A2uwYs.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cormorant/v18/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFiNTQ7Rg7A2uwYs.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cormorant/v18/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFs9UQ7Rg7A2uwYs.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cormorant/v18/H4c2BXOCl9bbnla_nHIA47NMUjsNbCVrFvZUQ7Rg7A2uwYs.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/cormorant/v18/H4c0BXOCl9bbnla_nHIq6oGzilJm9otsA9kQ9fdq6C-r0YvxdA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/cormorant/v18/H4c0BXOCl9bbnla_nHIq6oGzilJm9otsA9kQq_dq6C-r0YvxdA.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/cormorant/v18/H4c0BXOCl9bbnla_nHIq6oGzilJm9otsA9kQmfdq6C-r0YvxdA.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/cormorant/v18/H4c0BXOCl9bbnla_nHIq6oGzilJm9otsA9kQdfBq6C-r0YvxdA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/cormorant/v18/H4c0BXOCl9bbnla_nHIq6oGzilJm9otsA9kQTPBq6C-r0YvxdA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cormorant Garamond\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/cormorantgaramond/v16/co3YmX5slCNuHLi8bLeY9MK7whWMhyjQAllvuQWJ5heb_w.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/cormorantgaramond/v16/co3WmX5slCNuHLi8bLeY9MK7whWMhyjYrEPjuw-NxBKL_y94.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/cormorantgaramond/v16/co3bmX5slCNuHLi8bLeY9MK7whWMhyjornFLsS6V7w.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/cormorantgaramond/v16/co3ZmX5slCNuHLi8bLeY9MK7whWMhyjYrHtPkyuF7w6C.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cormorantgaramond/v16/co3YmX5slCNuHLi8bLeY9MK7whWMhyjQWlhvuQWJ5heb_w.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/cormorantgaramond/v16/co3WmX5slCNuHLi8bLeY9MK7whWMhyjYrEO7ug-NxBKL_y94.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cormorantgaramond/v16/co3YmX5slCNuHLi8bLeY9MK7whWMhyjQdl9vuQWJ5heb_w.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/cormorantgaramond/v16/co3WmX5slCNuHLi8bLeY9MK7whWMhyjYrEOXvQ-NxBKL_y94.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cormorantgaramond/v16/co3YmX5slCNuHLi8bLeY9MK7whWMhyjQEl5vuQWJ5heb_w.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/cormorantgaramond/v16/co3WmX5slCNuHLi8bLeY9MK7whWMhyjYrEPzvA-NxBKL_y94.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cormorant Infant\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/cormorantinfant/v17/HhyIU44g9vKiM1sORYSiWeAsLN9951w3_DMrQqcdJrk.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/cormorantinfant/v17/HhyKU44g9vKiM1sORYSiWeAsLN997_ItcDEhRoUYNrn_Ig.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/cormorantinfant/v17/HhyPU44g9vKiM1sORYSiWeAsLN993_Af2DsAXq4.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/cormorantinfant/v17/HhyJU44g9vKiM1sORYSiWeAsLN997_IV3BkFTq4EPw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cormorantinfant/v17/HhyIU44g9vKiM1sORYSiWeAsLN995wQ2_DMrQqcdJrk.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/cormorantinfant/v17/HhyKU44g9vKiM1sORYSiWeAsLN997_ItKDAhRoUYNrn_Ig.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cormorantinfant/v17/HhyIU44g9vKiM1sORYSiWeAsLN995ygx_DMrQqcdJrk.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/cormorantinfant/v17/HhyKU44g9vKiM1sORYSiWeAsLN997_ItBDchRoUYNrn_Ig.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cormorantinfant/v17/HhyIU44g9vKiM1sORYSiWeAsLN9950ww_DMrQqcdJrk.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/cormorantinfant/v17/HhyKU44g9vKiM1sORYSiWeAsLN997_ItYDYhRoUYNrn_Ig.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cormorant SC\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/cormorantsc/v17/0ybmGD4kxqXBmOVLG30OGwsmABIU_R3y8DOWGA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/cormorantsc/v17/0yb5GD4kxqXBmOVLG30OGwserDow9Tbu-Q.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cormorantsc/v17/0ybmGD4kxqXBmOVLG30OGwsmWBMU_R3y8DOWGA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cormorantsc/v17/0ybmGD4kxqXBmOVLG30OGwsmdBQU_R3y8DOWGA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cormorantsc/v17/0ybmGD4kxqXBmOVLG30OGwsmEBUU_R3y8DOWGA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cormorant Unicase\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/cormorantunicase/v24/HI_ViZUaILtOqhqgDeXoF_n1_fTGX9N_tucv7Gy0DRzS.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/cormorantunicase/v24/HI_QiZUaILtOqhqgDeXoF_n1_fTGX-vTnsMnx3C9.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cormorantunicase/v24/HI_ViZUaILtOqhqgDeXoF_n1_fTGX9Mnt-cv7Gy0DRzS.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cormorantunicase/v24/HI_ViZUaILtOqhqgDeXoF_n1_fTGX9MLsOcv7Gy0DRzS.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cormorantunicase/v24/HI_ViZUaILtOqhqgDeXoF_n1_fTGX9Nvsecv7Gy0DRzS.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cormorant Upright\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/cormorantupright/v18/VuJudM3I2Y35poFONtLdafkUCHw1y1N5phDsU9X6RPzQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/cormorantupright/v18/VuJrdM3I2Y35poFONtLdafkUCHw1y2vVjjTkeMnz.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cormorantupright/v18/VuJudM3I2Y35poFONtLdafkUCHw1y1MhpxDsU9X6RPzQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cormorantupright/v18/VuJudM3I2Y35poFONtLdafkUCHw1y1MNoBDsU9X6RPzQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cormorantupright/v18/VuJudM3I2Y35poFONtLdafkUCHw1y1NpoRDsU9X6RPzQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Courgette\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/courgette/v13/wEO_EBrAnc9BLjLQAUkFUfAL3EsHiA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Courier Prime\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/courierprime/v7/u-450q2lgwslOqpF_6gQ8kELWwZjW-_-tvg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/courierprime/v7/u-4n0q2lgwslOqpF_6gQ8kELawRpX837pvjxPA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/courierprime/v7/u-4k0q2lgwslOqpF_6gQ8kELY7pMf-fVqvHoJXw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/courierprime/v7/u-4i0q2lgwslOqpF_6gQ8kELawRR4-LfrtPtNXyeAg.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cousine\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cousine/v25/d6lIkaiiRdih4SpPzSMlzTbtz9k.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/cousine/v25/d6lKkaiiRdih4SpP_SEvyRTo39l8hw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cousine/v25/d6lNkaiiRdih4SpP9Z8K6T7G09BlnmQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/cousine/v25/d6lPkaiiRdih4SpP_SEXdTvM1_JgjmRpOA.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Coustard\",\n      \"variants\": [\n        \"regular\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/coustard/v16/3XFpErgg3YsZ5fqUU9UPvWXuROTd.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/coustard/v16/3XFuErgg3YsZ5fqUU-2LkEHmb_jU3eRL.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Covered By Your Grace\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/coveredbyyourgrace/v15/QGYwz-AZahWOJJI9kykWW9mD6opopoqXSOS0FgItq6bFIg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Crafty Girls\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/craftygirls/v16/va9B4kXI39VaDdlPJo8N_NvuQR37fF3Wlg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Creepster\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/creepster/v13/AlZy_zVUqJz4yMrniH4hdXf4XB0Tow.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Crete Round\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/creteround/v14/55xoey1sJNPjPiv1ZZZrxJ1827zAKnxN.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/creteround/v14/55xqey1sJNPjPiv1ZZZrxK1-0bjiL2xNhKc.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Crimson Pro\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZTm18OJE_VNWoyQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZkG18OJE_VNWoyQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZzm18OJE_VNWoyQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZ_G18OJE_VNWoyQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZEGp8OJE_VNWoyQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZKWp8OJE_VNWoyQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZTmp8OJE_VNWoyQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uUsoa5M_tv7IihmnkabC5XiXCAlXGks1WZZ2p8OJE_VNWoyQ.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi4Ue5s7dtC4yZNE.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi7Ke5s7dtC4yZNE.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi6Ue5s7dtC4yZNE.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi6me5s7dtC4yZNE.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi5KfJs7dtC4yZNE.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi5zfJs7dtC4yZNE.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi4UfJs7dtC4yZNE.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/crimsonpro/v23/q5uSsoa5M_tv7IihmnkabAReu49Y_Bo-HVKMBi49fJs7dtC4yZNE.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Crimson Text\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/crimsontext/v19/wlp2gwHKFkZgtmSR3NB0oRJvaAJSA_JN3Q.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/crimsontext/v19/wlpogwHKFkZgtmSR3NB0oRJfaghWIfdd3ahG.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/crimsontext/v19/wlppgwHKFkZgtmSR3NB0oRJXsCx2C9lR1LFffg.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/crimsontext/v19/wlprgwHKFkZgtmSR3NB0oRJfajCOD9NV9rRPfrKu.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/crimsontext/v19/wlppgwHKFkZgtmSR3NB0oRJX1C12C9lR1LFffg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/crimsontext/v19/wlprgwHKFkZgtmSR3NB0oRJfajDqDtNV9rRPfrKu.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Croissant One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/croissantone/v20/3y9n6bU9bTPg4m8NDy3Kq24UM3pqn5cdJ-4.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Crushed\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/crushed/v25/U9Mc6dym6WXImTlFT1kfuIqyLzA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cuprum\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cuprum/v20/dg45_pLmvrkcOkBnKsOzXyGWTBcmg-X6ZjzSJjQjgnU.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/cuprum/v20/dg45_pLmvrkcOkBnKsOzXyGWTBcmg9f6ZjzSJjQjgnU.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/cuprum/v20/dg45_pLmvrkcOkBnKsOzXyGWTBcmgzv9ZjzSJjQjgnU.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/cuprum/v20/dg45_pLmvrkcOkBnKsOzXyGWTBcmgwL9ZjzSJjQjgnU.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/cuprum/v20/dg47_pLmvrkcOkBNI_FMh0j91rkhli25jn_YIhYmknUPEA.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/cuprum/v20/dg47_pLmvrkcOkBNI_FMh0j91rkhli25vH_YIhYmknUPEA.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/cuprum/v20/dg47_pLmvrkcOkBNI_FMh0j91rkhli25UHjYIhYmknUPEA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/cuprum/v20/dg47_pLmvrkcOkBNI_FMh0j91rkhli25aXjYIhYmknUPEA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cute Font\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cutefont/v20/Noaw6Uny2oWPbSHMrY6vmJNVNC9hkw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cutive\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cutive/v17/NaPZcZ_fHOhV3Ip7T_hDoyqlZQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Cutive Mono\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/cutivemono/v14/m8JWjfRfY7WVjVi2E-K9H5RFRG-K3Mud.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"DM Mono\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/dmmono/v10/aFTR7PB1QTsUX8KYvrGyIYSnbKX9Rlk.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/dmmono/v10/aFTT7PB1QTsUX8KYth-orYataIf4VllXuA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/dmmono/v10/aFTU7PB1QTsUX8KYhh2aBYyMcKw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/dmmono/v10/aFTW7PB1QTsUX8KYth-QAa6JYKzkXw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/dmmono/v10/aFTR7PB1QTsUX8KYvumzIYSnbKX9Rlk.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/dmmono/v10/aFTT7PB1QTsUX8KYth-o9YetaIf4VllXuA.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"DM Sans\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dmsans/v11/rP2Hp2ywxg089UriOZSCHBeHFl0.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/dmsans/v11/rP2Fp2ywxg089UriCZaIGDWCBl0O8Q.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/dmsans/v11/rP2Cp2ywxg089UriAWCrOB-sClQX6Cg.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/dmsans/v11/rP2Ap2ywxg089UriCZaw7BymDnYS-Cjk6Q.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/dmsans/v11/rP2Cp2ywxg089UriASitOB-sClQX6Cg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/dmsans/v11/rP2Ap2ywxg089UriCZawpBqmDnYS-Cjk6Q.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"DM Serif Display\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dmserifdisplay/v11/-nFnOHM81r4j6k0gjAW3mujVU2B2K_d709jy92k.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/dmserifdisplay/v11/-nFhOHM81r4j6k0gjAW3mujVU2B2G_Vx1_r352np3Q.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"DM Serif Text\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dmseriftext/v11/rnCu-xZa_krGokauCeNq1wWyafOPXHIJErY.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/dmseriftext/v11/rnCw-xZa_krGokauCeNq1wWyWfGFWFAMArZKqQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Damion\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/damion/v14/hv-XlzJ3KEUe_YZUbWY3MTFgVg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dancing Script\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dancingscript/v24/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BMSoHTeB9ptDqpw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/dancingscript/v24/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BAyoHTeB9ptDqpw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/dancingscript/v24/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7B7y0HTeB9ptDqpw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/dancingscript/v24/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7B1i0HTeB9ptDqpw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dangrek\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dangrek/v26/LYjCdG30nEgoH8E2gCNqqVIuTN4.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Darker Grotesque\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/darkergrotesque/v7/U9MA6cuh-mLQlC4BKCtayOfARkSVoxr2AW8hTOsXsX0.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/darkergrotesque/v7/U9MH6cuh-mLQlC4BKCtayOfARkSVm7beJWcKUOI.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/darkergrotesque/v7/U9MA6cuh-mLQlC4BKCtayOfARkSVo0L3AW8hTOsXsX0.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/darkergrotesque/v7/U9MA6cuh-mLQlC4BKCtayOfARkSVo27wAW8hTOsXsX0.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/darkergrotesque/v7/U9MA6cuh-mLQlC4BKCtayOfARkSVowrxAW8hTOsXsX0.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/darkergrotesque/v7/U9MA6cuh-mLQlC4BKCtayOfARkSVoxbyAW8hTOsXsX0.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/darkergrotesque/v7/U9MA6cuh-mLQlC4BKCtayOfARkSVozLzAW8hTOsXsX0.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"David Libre\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/davidlibre/v13/snfus0W_99N64iuYSvp4W_l86p6TYS-Y.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/davidlibre/v13/snfzs0W_99N64iuYSvp4W8GIw7qbSjORSo9W.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/davidlibre/v13/snfzs0W_99N64iuYSvp4W8HAxbqbSjORSo9W.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dawning of a New Day\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dawningofanewday/v16/t5t_IQMbOp2SEwuncwLRjMfIg1yYit_nAz8bhWJGNoBE.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Days One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/daysone/v14/mem9YaCnxnKRiYZOCLYVeLkWVNBt.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dekko\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dekko/v19/46khlb_wWjfSrttFR0vsfl1B.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dela Gothic One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"greek\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/delagothicone/v10/~ChEKD0RlbGEgR290aGljIE9uZSAAKgQIARgB.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Delius\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/delius/v15/PN_xRfK0pW_9e1rtYcI-jT3L_w.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Delius Swash Caps\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/deliusswashcaps/v19/oY1E8fPLr7v4JWCExZpWebxVKORpXXedKmeBvEYs.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Delius Unicase\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/deliusunicase/v26/845BNMEwEIOVT8BmgfSzIr_6mmLHd-73LXWs.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/deliusunicase/v26/845CNMEwEIOVT8BmgfSzIr_6mlp7WMr_BmmlS5aw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Della Respira\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dellarespira/v18/RLp5K5v44KaueWI6iEJQBiGPRfkSu6EuTHo.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Denk One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/denkone/v15/dg4m_pzhrqcFb2IzROtHpbglShon.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Devonshire\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/devonshire/v21/46kqlbDwWirWr4gtBD2BX0Vq01lYAZM.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dhurjati\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"telugu\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dhurjati/v20/_6_8ED3gSeatXfFiFX3ySKQtuTA2.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Didact Gothic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/didactgothic/v19/ahcfv8qz1zt6hCC5G4F_P4ASpUySp0LlcyQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Diplomata\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/diplomata/v24/Cn-0JtiMXwhNwp-wKxyfYGxYrdM9Sg.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Diplomata SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/diplomatasc/v21/buExpoi3ecvs3kidKgBJo2kf-P5Oaiw4cw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Do Hyeon\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dohyeon/v16/TwMN-I8CRRU2zM86HFE3ZwaH__-C.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dokdo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dokdo/v15/esDf315XNuCBLxLo4NaMlKcH.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Domine\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/domine/v19/L0xhDFMnlVwD4h3Lt9JWnbX3jG-2X3LAI10VErGuW8Q.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/domine/v19/L0xhDFMnlVwD4h3Lt9JWnbX3jG-2X0DAI10VErGuW8Q.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/domine/v19/L0xhDFMnlVwD4h3Lt9JWnbX3jG-2X6zHI10VErGuW8Q.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/domine/v19/L0xhDFMnlVwD4h3Lt9JWnbX3jG-2X5XHI10VErGuW8Q.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Donegal One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/donegalone/v20/m8JWjfRYea-ZnFz6fsK9FZRFRG-K3Mud.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dongle\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/dongle/v8/sJoG3Ltdjt6VPkqeEcxrYjWNzXvVPA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/dongle/v8/sJoF3Ltdjt6VPkqmveRPah6RxA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/dongle/v8/sJoG3Ltdjt6VPkqeActrYjWNzXvVPA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Doppio One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/doppioone/v13/Gg8wN5gSaBfyBw2MqCh-lgshKGpe5Fg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dorsa\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dorsa/v23/yYLn0hjd0OGwqo493XCFxAnQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dosis\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v27\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/dosis/v27/HhyJU5sn9vOmLxNkIwRSjTVNWLEJt7MV3BkFTq4EPw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/dosis/v27/HhyJU5sn9vOmLxNkIwRSjTVNWLEJabMV3BkFTq4EPw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/dosis/v27/HhyJU5sn9vOmLxNkIwRSjTVNWLEJN7MV3BkFTq4EPw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/dosis/v27/HhyJU5sn9vOmLxNkIwRSjTVNWLEJBbMV3BkFTq4EPw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/dosis/v27/HhyJU5sn9vOmLxNkIwRSjTVNWLEJ6bQV3BkFTq4EPw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/dosis/v27/HhyJU5sn9vOmLxNkIwRSjTVNWLEJ0LQV3BkFTq4EPw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/dosis/v27/HhyJU5sn9vOmLxNkIwRSjTVNWLEJt7QV3BkFTq4EPw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"DotGothic16\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dotgothic16/v15/v6-QGYjBJFKgyw5nSoDAGE7L435YPFrT.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dr Sugiyama\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/drsugiyama/v22/HTxoL2k4N3O9n5I1boGI7abRM4-t-g7y.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Duru Sans\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/durusans/v19/xn7iYH8xwmSyTvEV_HOxT_fYdN-WZw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"DynaPuff\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dynapuff/v1/z7N5dRvsZDIVHbYPMhZJ3HQ83UaSu4uhr7-ZFeoYkgAr1x8RSxYu6YjrSRs4wn8.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/dynapuff/v1/z7N5dRvsZDIVHbYPMhZJ3HQ83UaSu4uhr7-ZFeoYkgAr1x8RSyQu6YjrSRs4wn8.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/dynapuff/v1/z7N5dRvsZDIVHbYPMhZJ3HQ83UaSu4uhr7-ZFeoYkgAr1x8RS8gp6YjrSRs4wn8.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/dynapuff/v1/z7N5dRvsZDIVHbYPMhZJ3HQ83UaSu4uhr7-ZFeoYkgAr1x8RS_Ep6YjrSRs4wn8.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Dynalight\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/dynalight/v18/1Ptsg8LOU_aOmQvTsF4ISotrDfGGxA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"EB Garamond\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/ebgaramond/v26/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-6_RUA4V-e6yHgQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ebgaramond/v26/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-2fRUA4V-e6yHgQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ebgaramond/v26/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-NfNUA4V-e6yHgQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ebgaramond/v26/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-DPNUA4V-e6yHgQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/ebgaramond/v26/SlGDmQSNjdsmc35JDF1K5E55YMjF_7DPuGi-a_NUA4V-e6yHgQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/ebgaramond/v26/SlGFmQSNjdsmc35JDF1K5GRwUjcdlttVFm-rI7e8QI96WamXgXFI.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/ebgaramond/v26/SlGFmQSNjdsmc35JDF1K5GRwUjcdlttVFm-rI7eOQI96WamXgXFI.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/ebgaramond/v26/SlGFmQSNjdsmc35JDF1K5GRwUjcdlttVFm-rI7diR496WamXgXFI.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/ebgaramond/v26/SlGFmQSNjdsmc35JDF1K5GRwUjcdlttVFm-rI7dbR496WamXgXFI.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/ebgaramond/v26/SlGFmQSNjdsmc35JDF1K5GRwUjcdlttVFm-rI7c8R496WamXgXFI.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Eagle Lake\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/eaglelake/v20/ptRMTiqbbuNJDOiKj9wG5O7yKQNute8.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"East Sea Dokdo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/eastseadokdo/v20/xfuo0Wn2V2_KanASqXSZp22m05_aGavYS18y.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Eater\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/eater/v21/mtG04_FCK7bOvpu2u3FwsXsR.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Economica\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/economica/v13/Qw3fZQZaHCLgIWa29ZBrMcgAAl1lfQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/economica/v13/Qw3ZZQZaHCLgIWa29ZBbM8IEIFh1fWUl.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/economica/v13/Qw3aZQZaHCLgIWa29ZBTjeckCnZ5dHw8iw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/economica/v13/Qw3EZQZaHCLgIWa29ZBbM_q4D3x9Vnksi4M7.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Eczar\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/eczar/v17/BXR2vF3Pi-DLmxcpJB-qbNTyTMDXHd6WqTIVKWJKWg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/eczar/v17/BXR2vF3Pi-DLmxcpJB-qbNTyTMDXL96WqTIVKWJKWg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/eczar/v17/BXR2vF3Pi-DLmxcpJB-qbNTyTMDXw9mWqTIVKWJKWg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/eczar/v17/BXR2vF3Pi-DLmxcpJB-qbNTyTMDX-tmWqTIVKWJKWg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/eczar/v17/BXR2vF3Pi-DLmxcpJB-qbNTyTMDXndmWqTIVKWJKWg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Edu NSW ACT Foundation\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/edunswactfoundation/v2/raxRHjqJtsNBFUi8WO0vUBgc9D-2lV_oQdCAYlt_QTQ0vUxJki9tovGLeC-sfguJ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/edunswactfoundation/v2/raxRHjqJtsNBFUi8WO0vUBgc9D-2lV_oQdCAYlt_QTQ0vUxJki9fovGLeC-sfguJ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/edunswactfoundation/v2/raxRHjqJtsNBFUi8WO0vUBgc9D-2lV_oQdCAYlt_QTQ0vUxJki-zpfGLeC-sfguJ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/edunswactfoundation/v2/raxRHjqJtsNBFUi8WO0vUBgc9D-2lV_oQdCAYlt_QTQ0vUxJki-KpfGLeC-sfguJ.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Edu QLD Beginner\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/eduqldbeginner/v2/AMOHz5iUuHLEMNXyohhc_Y56PR3A8dNLF_w3Ka4HKE4E3oebi6vyVWCN.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/eduqldbeginner/v2/AMOHz5iUuHLEMNXyohhc_Y56PR3A8dNLF_w3Ka4HKE423oebi6vyVWCN.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/eduqldbeginner/v2/AMOHz5iUuHLEMNXyohhc_Y56PR3A8dNLF_w3Ka4HKE7a2Yebi6vyVWCN.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/eduqldbeginner/v2/AMOHz5iUuHLEMNXyohhc_Y56PR3A8dNLF_w3Ka4HKE7j2Yebi6vyVWCN.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Edu SA Beginner\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/edusabeginner/v2/rnC_-xRb1x-1lHXnLaZZ2xOoLIGfU3L82irpr_3C9989fo1yBydUEDs.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/edusabeginner/v2/rnC_-xRb1x-1lHXnLaZZ2xOoLIGfU3L82irpr_3C9-09fo1yBydUEDs.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/edusabeginner/v2/rnC_-xRb1x-1lHXnLaZZ2xOoLIGfU3L82irpr_3C9wE6fo1yBydUEDs.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/edusabeginner/v2/rnC_-xRb1x-1lHXnLaZZ2xOoLIGfU3L82irpr_3C9zg6fo1yBydUEDs.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Edu TAS Beginner\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/edutasbeginner/v2/ZXuwe04WubHfGVY-1TcNg7AFUmshg8jIUTzK3r34f_HwemkrBWRhvk02.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/edutasbeginner/v2/ZXuwe04WubHfGVY-1TcNg7AFUmshg8jIUTzK3r34f_HCemkrBWRhvk02.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/edutasbeginner/v2/ZXuwe04WubHfGVY-1TcNg7AFUmshg8jIUTzK3r34f_EufWkrBWRhvk02.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/edutasbeginner/v2/ZXuwe04WubHfGVY-1TcNg7AFUmshg8jIUTzK3r34f_EXfWkrBWRhvk02.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Edu VIC WA NT Beginner\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/eduvicwantbeginner/v2/jiz2RF1BuW9OwcnNPxLl4KfZCHd9nFtd5Tu7stCpElYpvPfZZ-OXlPmFXwnpkeGR.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/eduvicwantbeginner/v2/jiz2RF1BuW9OwcnNPxLl4KfZCHd9nFtd5Tu7stCpElYpvPfZZ-OllPmFXwnpkeGR.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/eduvicwantbeginner/v2/jiz2RF1BuW9OwcnNPxLl4KfZCHd9nFtd5Tu7stCpElYpvPfZZ-NJk_mFXwnpkeGR.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/eduvicwantbeginner/v2/jiz2RF1BuW9OwcnNPxLl4KfZCHd9nFtd5Tu7stCpElYpvPfZZ-Nwk_mFXwnpkeGR.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"El Messiri\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"cyrillic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/elmessiri/v18/K2FhfZBRmr9vQ1pHEey6GIGo8_pv3myYjuXwe65ghj3OoapG.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/elmessiri/v18/K2FhfZBRmr9vQ1pHEey6GIGo8_pv3myYjuXCe65ghj3OoapG.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/elmessiri/v18/K2FhfZBRmr9vQ1pHEey6GIGo8_pv3myYjuUufK5ghj3OoapG.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/elmessiri/v18/K2FhfZBRmr9vQ1pHEey6GIGo8_pv3myYjuUXfK5ghj3OoapG.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Electrolize\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/electrolize/v14/cIf5Ma1dtE0zSiGSiED7AUEGso5tQafB.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Elsie\",\n      \"variants\": [\n        \"regular\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/elsie/v12/BCanqZABrez54yYu9slAeLgX.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/elsie/v12/BCaqqZABrez54x6q2-1IU6QeXSBk.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Elsie Swash Caps\",\n      \"variants\": [\n        \"regular\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/elsieswashcaps/v21/845DNN8xGZyVX5MVo_upKf7KnjK0ferVKGWsUo8.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/elsieswashcaps/v21/845ENN8xGZyVX5MVo_upKf7KnjK0RW74DG2HToawrdU.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Emblema One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/emblemaone/v21/nKKT-GQ0F5dSY8vzG0rOEIRBHl57G_f_.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Emilys Candy\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/emilyscandy/v13/2EbgL-1mD1Rnb0OGKudbk0y5r9xrX84JjA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Encode Sans\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/encodesans/v15/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGGHiZtWP7FJCt2c.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/encodesans/v15/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGOHjZtWP7FJCt2c.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/encodesans/v15/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGD_jZtWP7FJCt2c.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/encodesans/v15/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGGHjZtWP7FJCt2c.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/encodesans/v15/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGFPjZtWP7FJCt2c.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/encodesans/v15/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGL_kZtWP7FJCt2c.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/encodesans/v15/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGIbkZtWP7FJCt2c.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/encodesans/v15/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGOHkZtWP7FJCt2c.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/encodesans/v15/LDIcapOFNxEwR-Bd1O9uYNmnUQomAgE25imKSbHhROjLsZBWTSrQGMjkZtWP7FJCt2c.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Encode Sans Condensed\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/encodesanscondensed/v10/j8_76_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-5a-JLQoFI2KR.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-SY6pByQJKnuIFA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-LY2pByQJKnuIFA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/encodesanscondensed/v10/j8_16_LD37rqfuwxyIuaZhE6cRXOLtm2gfTGgaWNDw8VIw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-dYypByQJKnuIFA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-WYupByQJKnuIFA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-PYqpByQJKnuIFA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-IYmpByQJKnuIFA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/encodesanscondensed/v10/j8_46_LD37rqfuwxyIuaZhE6cRXOLtm2gfT-BYipByQJKnuIFA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Encode Sans Expanded\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/encodesansexpanded/v10/c4mx1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpJGKQNicoAbJlw.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/encodesansexpanded/v10/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpLqCCNIXIwSP0XD.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/encodesansexpanded/v10/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpKOCyNIXIwSP0XD.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/encodesansexpanded/v10/c4m_1mF4GcnstG_Jh1QH6ac4hNLeNyeYUqoiIwdAd5Ab.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/encodesansexpanded/v10/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpLWCiNIXIwSP0XD.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/encodesansexpanded/v10/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpL6DSNIXIwSP0XD.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/encodesansexpanded/v10/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpKeDCNIXIwSP0XD.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/encodesansexpanded/v10/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpKCDyNIXIwSP0XD.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/encodesansexpanded/v10/c4mw1mF4GcnstG_Jh1QH6ac4hNLeNyeYUpKmDiNIXIwSP0XD.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Encode Sans SC\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/encodesanssc/v8/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HHhn8c9NOEEClIc.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/encodesanssc/v8/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HPhm8c9NOEEClIc.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/encodesanssc/v8/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HCZm8c9NOEEClIc.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/encodesanssc/v8/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HHhm8c9NOEEClIc.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/encodesanssc/v8/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HEpm8c9NOEEClIc.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/encodesanssc/v8/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HKZh8c9NOEEClIc.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/encodesanssc/v8/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HJ9h8c9NOEEClIc.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/encodesanssc/v8/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HPhh8c9NOEEClIc.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/encodesanssc/v8/jVyp7nLwCGzQ9zE7ZyRg0QRXHPZc_uUA6Kb3VJWLE_Pdtm7lcD6qvXT1HNFh8c9NOEEClIc.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Encode Sans Semi Condensed\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT6oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1T19MFtQ9jpVUA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1RZ1eFHbdTgTFmr.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1Q91uFHbdTgTFmr.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT4oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG2yR_sVPRsjp.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1Rl1-FHbdTgTFmr.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1RJ0OFHbdTgTFmr.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1Qt0eFHbdTgTFmr.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1Qx0uFHbdTgTFmr.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/encodesanssemicondensed/v10/3qT7oiKqnDuUtQUEHMoXcmspmy55SFWrXFRp9FTOG1QV0-FHbdTgTFmr.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Encode Sans Semi Expanded\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/encodesanssemiexpanded/v18/ke8xOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TM-41KwrlKXeOEA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/encodesanssemiexpanded/v18/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TM0IUCyDLJX6XCWU.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/encodesanssemiexpanded/v18/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TMyYXCyDLJX6XCWU.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/encodesanssemiexpanded/v18/ke83OhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TC4o_LyjgOXc.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/encodesanssemiexpanded/v18/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TM34WCyDLJX6XCWU.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/encodesanssemiexpanded/v18/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TM1IRCyDLJX6XCWU.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/encodesanssemiexpanded/v18/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TMzYQCyDLJX6XCWU.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/encodesanssemiexpanded/v18/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TMyoTCyDLJX6XCWU.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/encodesanssemiexpanded/v18/ke8yOhAPMEZs-BDuzwftTNJ85JvwMOzE9d9Cca5TMw4SCyDLJX6XCWU.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Engagement\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/engagement/v22/x3dlckLDZbqa7RUs9MFVXNossybsHQI.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Englebert\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/englebert/v17/xn7iYH8w2XGrC8AR4HSxT_fYdN-WZw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Enriqueta\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/enriqueta/v15/goksH6L7AUFrRvV44HVTS0CjkP1Yog.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/enriqueta/v15/gokpH6L7AUFrRvV44HVrv2mHmNZEq6TTFw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/enriqueta/v15/gokpH6L7AUFrRvV44HVrk26HmNZEq6TTFw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/enriqueta/v15/gokpH6L7AUFrRvV44HVr92-HmNZEq6TTFw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Ephesis\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/ephesis/v7/uU9PCBUS8IerL2VG7xPb3vyHmlI.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Epilogue\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXMDLiDJXVigHPVA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXsDPiDJXVigHPVA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXbjPiDJXVigHPVA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXMDPiDJXVigHPVA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXAjPiDJXVigHPVA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZMFGj5hxF0EhjimngomvnCCtqb30OX7jTiDJXVigHPVA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZMFGj5hxF0EhjimngomvnCCtqb30OX1zTiDJXVigHPVA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXsDTiDJXVigHPVA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZMFGj5hxF0EhjimngomvnCCtqb30OXmTTiDJXVigHPVA.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HAKTp_RqATfVHNU.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HCKT5_RqATfVHNU.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HBUT5_RqATfVHNU.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HAKT5_RqATfVHNU.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HA4T5_RqATfVHNU.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HDUSJ_RqATfVHNU.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HDtSJ_RqATfVHNU.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HCKSJ_RqATfVHNU.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/epilogue/v13/O4ZCFGj5hxF0EhjimlIhqAYaY7EBcUSC-HCjSJ_RqATfVHNU.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Erica One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/ericaone/v23/WBLnrEXccV9VGrOKmGD1W0_MJMGxiQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Esteban\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/esteban/v14/r05bGLZE-bdGdN-GdOuD5jokU8E.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Estonia\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/estonia/v9/7Au_p_4ijSecA1yHCCL8zkwMIFg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Euphoria Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/euphoriascript/v16/mFTpWb0X2bLb_cx6To2B8GpKoD5ak_ZT1D8x7Q.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Ewert\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/ewert/v21/va9I4kzO2tFODYBvS-J3kbDP.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Exo\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/exo/v20/4UaZrEtFpBI4f1ZSIK9d4LjJ4lM2CwNsOl4p5Is.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/exo/v20/4UaZrEtFpBI4f1ZSIK9d4LjJ4tM3CwNsOl4p5Is.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/exo/v20/4UaZrEtFpBI4f1ZSIK9d4LjJ4g03CwNsOl4p5Is.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/exo/v20/4UaZrEtFpBI4f1ZSIK9d4LjJ4lM3CwNsOl4p5Is.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/exo/v20/4UaZrEtFpBI4f1ZSIK9d4LjJ4mE3CwNsOl4p5Is.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/exo/v20/4UaZrEtFpBI4f1ZSIK9d4LjJ4o0wCwNsOl4p5Is.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/exo/v20/4UaZrEtFpBI4f1ZSIK9d4LjJ4rQwCwNsOl4p5Is.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/exo/v20/4UaZrEtFpBI4f1ZSIK9d4LjJ4tMwCwNsOl4p5Is.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/exo/v20/4UaZrEtFpBI4f1ZSIK9d4LjJ4vowCwNsOl4p5Is.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/exo/v20/4UafrEtFpBISdmSt-MY2ehbO95t040FmPnws9Iu-uA.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/exo/v20/4UafrEtFpBISdmSt-MY2ehbO95t0Y0BmPnws9Iu-uA.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/exo/v20/4UafrEtFpBISdmSt-MY2ehbO95t0vUBmPnws9Iu-uA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/exo/v20/4UafrEtFpBISdmSt-MY2ehbO95t040BmPnws9Iu-uA.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/exo/v20/4UafrEtFpBISdmSt-MY2ehbO95t00UBmPnws9Iu-uA.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/exo/v20/4UafrEtFpBISdmSt-MY2ehbO95t0PUdmPnws9Iu-uA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/exo/v20/4UafrEtFpBISdmSt-MY2ehbO95t0BEdmPnws9Iu-uA.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/exo/v20/4UafrEtFpBISdmSt-MY2ehbO95t0Y0dmPnws9Iu-uA.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/exo/v20/4UafrEtFpBISdmSt-MY2ehbO95t0SkdmPnws9Iu-uA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Exo 2\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/exo2/v20/7cH1v4okm5zmbvwkAx_sfcEuiD8jvvOcPtq-rpvLpQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/exo2/v20/7cH1v4okm5zmbvwkAx_sfcEuiD8jPvKcPtq-rpvLpQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/exo2/v20/7cH1v4okm5zmbvwkAx_sfcEuiD8j4PKcPtq-rpvLpQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/exo2/v20/7cH1v4okm5zmbvwkAx_sfcEuiD8jvvKcPtq-rpvLpQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/exo2/v20/7cH1v4okm5zmbvwkAx_sfcEuiD8jjPKcPtq-rpvLpQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/exo2/v20/7cH1v4okm5zmbvwkAx_sfcEuiD8jYPWcPtq-rpvLpQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/exo2/v20/7cH1v4okm5zmbvwkAx_sfcEuiD8jWfWcPtq-rpvLpQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/exo2/v20/7cH1v4okm5zmbvwkAx_sfcEuiD8jPvWcPtq-rpvLpQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/exo2/v20/7cH1v4okm5zmbvwkAx_sfcEuiD8jF_WcPtq-rpvLpQ.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/exo2/v20/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drF0fNC6jJ7bpQBL.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/exo2/v20/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drH0fdC6jJ7bpQBL.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/exo2/v20/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drEqfdC6jJ7bpQBL.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/exo2/v20/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drF0fdC6jJ7bpQBL.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/exo2/v20/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drFGfdC6jJ7bpQBL.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/exo2/v20/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drGqetC6jJ7bpQBL.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/exo2/v20/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drGTetC6jJ7bpQBL.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/exo2/v20/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drH0etC6jJ7bpQBL.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/exo2/v20/7cH3v4okm5zmbtYtMeA0FKq0Jjg2drHdetC6jJ7bpQBL.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Expletus Sans\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/expletussans/v24/RLpqK5v5_bqufTYdnhFzDj2dX_IwS3my73zcDaSY2s1oFQTcXfMm.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/expletussans/v24/RLpqK5v5_bqufTYdnhFzDj2dX_IwS3my73zcDaSq2s1oFQTcXfMm.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/expletussans/v24/RLpqK5v5_bqufTYdnhFzDj2dX_IwS3my73zcDaRG3c1oFQTcXfMm.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/expletussans/v24/RLpqK5v5_bqufTYdnhFzDj2dX_IwS3my73zcDaR_3c1oFQTcXfMm.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/expletussans/v24/RLpoK5v5_bqufTYdnhFzDj2ddfsCtKHbhOZyCrFQmSUrHwD-WOMmKKY.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/expletussans/v24/RLpoK5v5_bqufTYdnhFzDj2ddfsCtKHbhOZyCrFQmRcrHwD-WOMmKKY.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/expletussans/v24/RLpoK5v5_bqufTYdnhFzDj2ddfsCtKHbhOZyCrFQmfssHwD-WOMmKKY.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/expletussans/v24/RLpoK5v5_bqufTYdnhFzDj2ddfsCtKHbhOZyCrFQmcIsHwD-WOMmKKY.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Explora\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cherokee\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/explora/v7/tsstApxFfjUH4wrvc1qPonC3vqc.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fahkwang\",\n      \"variants\": [\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa26Uj3zpmBOgbNpOJHmZlRFipxkwjx.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa06Uj3zpmBOgbNpOqNgHFQHC5Tlhjxdw4.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa26Uj3zpmBOgbNpOIjmplRFipxkwjx.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa06Uj3zpmBOgbNpOqNgBVTHC5Tlhjxdw4.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noax6Uj3zpmBOgbNpNqPsr1ZPTZ4.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa36Uj3zpmBOgbNpOqNuLl7OCZ4ihE.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa26Uj3zpmBOgbNpOJ7m5lRFipxkwjx.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa06Uj3zpmBOgbNpOqNgE1SHC5Tlhjxdw4.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa26Uj3zpmBOgbNpOJXnJlRFipxkwjx.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa06Uj3zpmBOgbNpOqNgGFVHC5Tlhjxdw4.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa26Uj3zpmBOgbNpOIznZlRFipxkwjx.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/fahkwang/v16/Noa06Uj3zpmBOgbNpOqNgAVUHC5Tlhjxdw4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Familjen Grotesk\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/familjengrotesk/v4/Qw3LZR9ZHiDnImG6-NEMQ41wby8WRnYsfkunR_eGfMGJaSztc1jcEYq2.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/familjengrotesk/v4/Qw3LZR9ZHiDnImG6-NEMQ41wby8WRnYsfkunR_eGfMG7aSztc1jcEYq2.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/familjengrotesk/v4/Qw3LZR9ZHiDnImG6-NEMQ41wby8WRnYsfkunR_eGfMFXbiztc1jcEYq2.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/familjengrotesk/v4/Qw3LZR9ZHiDnImG6-NEMQ41wby8WRnYsfkunR_eGfMFubiztc1jcEYq2.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/familjengrotesk/v4/Qw31ZR9ZHiDnImG6-NEMQ41wby8WbH8egZPOLG0oe9RBKsSueVz-FJq2Rv4.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/familjengrotesk/v4/Qw31ZR9ZHiDnImG6-NEMQ41wby8WbH8egZPOLG0oe9RBKvaueVz-FJq2Rv4.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/familjengrotesk/v4/Qw31ZR9ZHiDnImG6-NEMQ41wby8WbH8egZPOLG0oe9RBKhqpeVz-FJq2Rv4.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/familjengrotesk/v4/Qw31ZR9ZHiDnImG6-NEMQ41wby8WbH8egZPOLG0oe9RBKiOpeVz-FJq2Rv4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fanwood Text\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fanwoodtext/v15/3XFtErwl05Ad_vSCF6Fq7xXGRdbY1P1Sbg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/fanwoodtext/v15/3XFzErwl05Ad_vSCF6Fq7xX2R9zc9vhCblye.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Farro\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/farro/v14/i7dJIFl3byGNHa3hNJ6-WkJUQUq7.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/farro/v14/i7dEIFl3byGNHZVNHLq2cV5d.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/farro/v14/i7dJIFl3byGNHa25NZ6-WkJUQUq7.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/farro/v14/i7dJIFl3byGNHa3xM56-WkJUQUq7.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Farsan\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"gujarati\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/farsan/v18/VEMwRoJ0vY_zsyz62q-pxDX9rQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fascinate\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fascinate/v21/z7NWdRrufC8XJK0IIEli1LbQRPyNrw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fascinate Inline\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fascinateinline/v22/jVyR7mzzB3zc-jp6QCAu60poNqIy1g3CfRXxWZQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Faster One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fasterone/v17/H4ciBXCHmdfClFb-vWhfyLuShq63czE.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fasthand\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fasthand/v26/0yb9GDohyKTYn_ZEESkuYkw2rQg1.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fauna One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/faunaone/v13/wlpzgwTPBVpjpCuwkuEx2UxLYClOCg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Faustina\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/faustina/v16/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHls3IEvGVWWe8tbEg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/faustina/v16/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlsgoEvGVWWe8tbEg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/faustina/v16/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlssIEvGVWWe8tbEg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/faustina/v16/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlsXIYvGVWWe8tbEg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/faustina/v16/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlsZYYvGVWWe8tbEg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/faustina/v16/XLY4IZPxYpJfTbZAFXWzNT2SO8wpWHlsAoYvGVWWe8tbEg.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/faustina/v16/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsKZWl-SWc5LEnoF.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/faustina/v16/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsLHWl-SWc5LEnoF.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/faustina/v16/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsL1Wl-SWc5LEnoF.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/faustina/v16/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsIZXV-SWc5LEnoF.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/faustina/v16/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsIgXV-SWc5LEnoF.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/faustina/v16/XLY2IZPxYpJfTbZAFV-6B8JKUqez9n55SsJHXV-SWc5LEnoF.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Federant\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/federant/v25/2sDdZGNfip_eirT0_U0jRUG0AqUc.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Federo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/federo/v19/iJWFBX-cbD_ETsbmjVOe2WTG7Q.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Felipa\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/felipa/v19/FwZa7-owz1Eu4F_wSNSEwM2zpA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fenix\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fenix/v20/XoHo2YL_S7-g5ostKzAFvs8o.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Festive\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/festive/v7/cY9Ffj6KX1xcoDWhFtfgy9HTkak.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Figtree\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-11-18\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/figtree/v2/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_chQF5ewkEU4HTy.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/figtree/v2/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_d_QF5ewkEU4HTy.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/figtree/v2/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_dNQF5ewkEU4HTy.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/figtree/v2/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_ehR15ewkEU4HTy.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/figtree/v2/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_eYR15ewkEU4HTy.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/figtree/v2/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_f_R15ewkEU4HTy.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/figtree/v2/_Xmz-HUzqDCFdgfMsYiV_F7wfS-Bs_fWR15ewkEU4HTy.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/figtree/v2/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3A-gdyEU25WTybO8.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/figtree/v2/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3A7YdyEU25WTybO8.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/figtree/v2/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3A4QdyEU25WTybO8.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/figtree/v2/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3A2gayEU25WTybO8.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/figtree/v2/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3A1EayEU25WTybO8.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/figtree/v2/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3AzYayEU25WTybO8.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/figtree/v2/_Xm9-HUzqDCFdgfMm4GnA4aZFrUvtOK3Ax8ayEU25WTybO8.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Finger Paint\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fingerpaint/v15/0QInMXVJ-o-oRn_7dron8YWO85bS8ANesw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Finlandica\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/finlandica/v5/-nFsOGk-8vAc7lEtg0aSyZCty9GSsPBE19A7rEjx9i5ss3a3.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/finlandica/v5/-nFsOGk-8vAc7lEtg0aSyZCty9GSsPBE19AJrEjx9i5ss3a3.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/finlandica/v5/-nFsOGk-8vAc7lEtg0aSyZCty9GSsPBE19Dlq0jx9i5ss3a3.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/finlandica/v5/-nFsOGk-8vAc7lEtg0aSyZCty9GSsPBE19Dcq0jx9i5ss3a3.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/finlandica/v5/-nFuOGk-8vAc7lEtg0aS45mfNAn722rq0MXz76Cy_CpOtma3uNQ.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/finlandica/v5/-nFuOGk-8vAc7lEtg0aS45mfNAn722rq0MXz75Ky_CpOtma3uNQ.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/finlandica/v5/-nFuOGk-8vAc7lEtg0aS45mfNAn722rq0MXz7361_CpOtma3uNQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/finlandica/v5/-nFuOGk-8vAc7lEtg0aS45mfNAn722rq0MXz70e1_CpOtma3uNQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fira Code\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/firacode/v21/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_GNsFVfxN87gsj0.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/firacode/v21/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_D1sFVfxN87gsj0.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/firacode/v21/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_A9sFVfxN87gsj0.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/firacode/v21/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_ONrFVfxN87gsj0.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/firacode/v21/uU9eCBsR6Z2vfE9aq3bL0fxyUs4tcw4W_NprFVfxN87gsj0.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fira Mono\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/firamono/v14/N0bX2SlFPv1weGeLZDtQIfTTkdbJYA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/firamono/v14/N0bS2SlFPv1weGeLZDto1d33mf3VaZBRBQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/firamono/v14/N0bS2SlFPv1weGeLZDtondv3mf3VaZBRBQ.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fira Sans\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/firasans/v16/va9C4kDNxMZdWfMOD5Vn9IjOazP3dUTP.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/firasans/v16/va9A4kDNxMZdWfMOD5VvkrCqYTfVcFTPj0s.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/firasans/v16/va9B4kDNxMZdWfMOD5VnWKnuQR37fF3Wlg.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/firasans/v16/va9f4kDNxMZdWfMOD5VvkrAGQBf_XljGllLX.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/firasans/v16/va9B4kDNxMZdWfMOD5VnPKruQR37fF3Wlg.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/firasans/v16/va9f4kDNxMZdWfMOD5VvkrBiQxf_XljGllLX.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/firasans/v16/va9E4kDNxMZdWfMOD5VfkILKSTbndQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/firasans/v16/va9C4kDNxMZdWfMOD5VvkojOazP3dUTP.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/firasans/v16/va9B4kDNxMZdWfMOD5VnZKvuQR37fF3Wlg.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/firasans/v16/va9f4kDNxMZdWfMOD5VvkrA6Qhf_XljGllLX.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/firasans/v16/va9B4kDNxMZdWfMOD5VnSKzuQR37fF3Wlg.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/firasans/v16/va9f4kDNxMZdWfMOD5VvkrAWRRf_XljGllLX.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/firasans/v16/va9B4kDNxMZdWfMOD5VnLK3uQR37fF3Wlg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/firasans/v16/va9f4kDNxMZdWfMOD5VvkrByRBf_XljGllLX.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/firasans/v16/va9B4kDNxMZdWfMOD5VnMK7uQR37fF3Wlg.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/firasans/v16/va9f4kDNxMZdWfMOD5VvkrBuRxf_XljGllLX.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/firasans/v16/va9B4kDNxMZdWfMOD5VnFK_uQR37fF3Wlg.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/firasans/v16/va9f4kDNxMZdWfMOD5VvkrBKRhf_XljGllLX.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fira Sans Condensed\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOjEADFm8hSaQTFG18FErVhsC9x-tarWZXtqOlQfx9CjA.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOtEADFm8hSaQTFG18FErVhsC9x-tarUfPVzONUXRpSjJcu.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWTnMiMN-cxZblY4.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVYMJ0dzRehY43EA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWV3PiMN-cxZblY4.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVBMF0dzRehY43EA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOhEADFm8hSaQTFG18FErVhsC9x-tarYfHnrMtVbx8.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOjEADFm8hSaQTFG18FErVhsC9x-tarUfPtqOlQfx9CjA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWQXOiMN-cxZblY4.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVXMB0dzRehY43EA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWSnJiMN-cxZblY4.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVcMd0dzRehY43EA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWU3IiMN-cxZblY4.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVFMZ0dzRehY43EA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWVHLiMN-cxZblY4.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVCMV0dzRehY43EA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOsEADFm8hSaQTFG18FErVhsC9x-tarWXXKiMN-cxZblY4.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/firasanscondensed/v10/wEOuEADFm8hSaQTFG18FErVhsC9x-tarUfPVLMR0dzRehY43EA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fira Sans Extra Condensed\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPMcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3Zyuv1WarE9ncg.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPOcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqW21-ejkp3cn22.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3TCPn3-0oEZ-a2Q.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWd36-pGR7e2SvJQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3VSMn3-0oEZ-a2Q.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWE32-pGR7e2SvJQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPKcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda5fiku3efvE8.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPMcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fquv1WarE9ncg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3QyNn3-0oEZ-a2Q.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWS3y-pGR7e2SvJQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3SCKn3-0oEZ-a2Q.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWZ3u-pGR7e2SvJQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3USLn3-0oEZ-a2Q.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWA3q-pGR7e2SvJQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3ViIn3-0oEZ-a2Q.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWH3m-pGR7e2SvJQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPPcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda3XyJn3-0oEZ-a2Q.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/firasansextracondensed/v10/NaPxcYDaAO5dirw6IaFn7lPJFqXmS-M9Atn3wgda1fqWO3i-pGR7e2SvJQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fjalla One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fjallaone/v13/Yq6R-LCAWCX3-6Ky7FAFnOZwkxgtUb8.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fjord One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fjordone/v21/zOL-4pbEnKBY_9S1jNKr6e5As-FeiQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Flamenco\",\n      \"variants\": [\n        \"300\",\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/flamenco/v18/neIPzCehqYguo67ssZ0qNIkyepH9qGsf.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/flamenco/v18/neIIzCehqYguo67ssaWGHK06UY30.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Flavors\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/flavors/v22/FBV2dDrhxqmveJTpbkzlNqkG9UY.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fleur De Leah\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fleurdeleah/v7/AYCNpXX7ftYZWLhv9UmPJTMC5vat4I_Gdq0.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Flow Block\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/flowblock/v7/wlp0gwfPCEB65UmTk-d6-WZlbCBXE_I.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Flow Circular\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/flowcircular/v7/lJwB-pc4j2F-H8YKuyvfxdZ45ifpWdr2rIg.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Flow Rounded\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/flowrounded/v7/-zki91mtwsU9qlLiGwD4oQX3oZX-Xup87g.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fondamento\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fondamento/v16/4UaHrEJGsxNmFTPDnkaJx63j5pN1MwI.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/fondamento/v16/4UaFrEJGsxNmFTPDnkaJ96_p4rFwIwJePw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fontdiner Swanky\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fontdinerswanky/v19/ijwOs4XgRNsiaI5-hcVb4hQgMvCD4uEfKiGvxts.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Forum\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/forum/v16/6aey4Ky-Vb8Ew_IWMJMa3mnT.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fragment Mono\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fragmentmono/v1/4iCr6K5wfMRRjxp0DA6-2CLnN4RNh4UI_1U.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/fragmentmono/v1/4iC16K5wfMRRjxp0DA6-2CLnB4ZHg6cN71URtQ.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Francois One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/francoisone/v20/_Xmr-H4zszafZw3A-KPSZutNxgKQu_avAg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Frank Ruhl Libre\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2023-02-23\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/frankruhllibre/v17/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw6bYVqQPxR2EUR_.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/frankruhllibre/v17/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw7FYVqQPxR2EUR_.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/frankruhllibre/v17/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw73YVqQPxR2EUR_.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/frankruhllibre/v17/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw4bZlqQPxR2EUR_.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/frankruhllibre/v17/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw4iZlqQPxR2EUR_.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/frankruhllibre/v17/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw5FZlqQPxR2EUR_.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/frankruhllibre/v17/j8_96_fAw7jrcalD7oKYNX0QfAnPcbzNEEB7OoicBw5sZlqQPxR2EUR_.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fraunces\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/fraunces/v26/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIctxqjDvTShUtWNg.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/fraunces/v26/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIcNxujDvTShUtWNg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/fraunces/v26/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIc6RujDvTShUtWNg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/fraunces/v26/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIctxujDvTShUtWNg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/fraunces/v26/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIchRujDvTShUtWNg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/fraunces/v26/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIcaRyjDvTShUtWNg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/fraunces/v26/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIcUByjDvTShUtWNg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/fraunces/v26/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIcNxyjDvTShUtWNg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/fraunces/v26/6NUh8FyLNQOQZAnv9bYEvDiIdE9Ea92uemAk_WBq8U_9v0c2Wa0K7iN7hzFUPJH58nib1603gg7S2nfgRYIcHhyjDvTShUtWNg.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/fraunces/v26/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1hLTP7Wp05GNi3k.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/fraunces/v26/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1jLTf7Wp05GNi3k.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/fraunces/v26/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1gVTf7Wp05GNi3k.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/fraunces/v26/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1hLTf7Wp05GNi3k.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/fraunces/v26/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1h5Tf7Wp05GNi3k.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/fraunces/v26/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1iVSv7Wp05GNi3k.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/fraunces/v26/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1isSv7Wp05GNi3k.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/fraunces/v26/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1jLSv7Wp05GNi3k.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/fraunces/v26/6NVf8FyLNQOQZAnv9ZwNjucMHVn85Ni7emAe9lKqZTnbB-gzTK0K1ChJdt9vIVYX9G37lvd9sPEKsxx664UJf1jiSv7Wp05GNi3k.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Freckle Face\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/freckleface/v14/AMOWz4SXrmKHCvXTohxY-YI0U1K2w9lb4g.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fredericka the Great\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/frederickathegreat/v15/9Bt33CxNwt7aOctW2xjbCstzwVKsIBVV-9Skz7Ylch2L.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fredoka\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/fredoka/v9/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3OryLMFuOLlNldbw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/fredoka/v9/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3O8SLMFuOLlNldbw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/fredoka/v9/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3OwyLMFuOLlNldbw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/fredoka/v9/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3OLyXMFuOLlNldbw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/fredoka/v9/X7nP4b87HvSqjb_WIi2yDCRwoQ_k7367_B-i2yQag0-mac3OFiXMFuOLlNldbw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fredoka One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fredokaone/v13/k3kUo8kEI-tA1RRcTZGmTmHBA6aF8Bf_.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Freehand\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v27\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/freehand/v27/cIf-Ma5eqk01VjKTgAmBTmUOmZJk.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fresca\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fresca/v18/6ae94K--SKgCzbM2Gr0W13DKPA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Frijole\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/frijole/v14/uU9PCBUR8oakM2BQ7xPb3vyHmlI.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fruktur\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fruktur/v26/SZc53FHsOru5QYsMfz3GkUrS8DI.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/fruktur/v26/SZc73FHsOru5QYsMTz_MlWjX4DJXgQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fugaz One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fugazone/v15/rax_HiWKp9EAITukFslMBBJek0vA8A.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fuggles\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fuggles/v8/k3kQo8UEJOlD1hpOTd7iL0nAMaM.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Fuzzy Bubbles\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/fuzzybubbles/v5/6qLGKZMbrgv9pwtjPEVNV0F2NnP5Zxsreko.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/fuzzybubbles/v5/6qLbKZMbrgv9pwtjPEVNV0F2Ds_WQxMAZkM1pn4.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"GFS Didot\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"greek\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gfsdidot/v15/Jqzh5TybZ9vZMWFssvwiF-fGFSCGAA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"GFS Neohellenic\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"greek\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gfsneohellenic/v25/8QIRdiDOrfiq0b7R8O1Iw9WLcY5TLahP46UDUw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/gfsneohellenic/v25/8QITdiDOrfiq0b7R8O1Iw9WLcY5jL6JLwaATU91X.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gfsneohellenic/v25/8QIUdiDOrfiq0b7R8O1Iw9WLcY5rkYdr644fWsRO9w.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/gfsneohellenic/v25/8QIWdiDOrfiq0b7R8O1Iw9WLcY5jL5r37oQbeMFe985V.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gabriela\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gabriela/v14/qkBWXvsO6sreR8E-b_m-zrpHmRzC.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gaegu\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/gaegu/v15/TuGSUVB6Up9NU57nifw74sdtBk0x.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/gaegu/v15/TuGfUVB6Up9NU6ZLodgzydtk.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gaegu/v15/TuGSUVB6Up9NU573jvw74sdtBk0x.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gafata\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gafata/v16/XRXV3I6Cn0VJKon4MuyAbsrVcA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gajraj One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2023-02-16\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gajrajone/v1/1cX2aUDCDpXsuWVb1jIjr1GqhcitzeM.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Galada\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"bengali\",\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/galada/v14/H4cmBXyGmcjXlUX-8iw-4Lqggw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Galdeano\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/galdeano/v22/uU9MCBoQ4YOqOW1boDPx8PCOg0uX.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Galindo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/galindo/v20/HI_KiYMeLqVKqwyuQ5HiRp-dhpQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gamja Flower\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gamjaflower/v20/6NUR8FiKJg-Pa0rM6uN40Z4kyf9Fdty2ew.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gantari\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/gantari/v1/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g0gOz3wa5GD2qnm.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/gantari/v1/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g2gOj3wa5GD2qnm.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/gantari/v1/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g1-Oj3wa5GD2qnm.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/gantari/v1/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g0gOj3wa5GD2qnm.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/gantari/v1/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g0SOj3wa5GD2qnm.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/gantari/v1/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g3-PT3wa5GD2qnm.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gantari/v1/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g3HPT3wa5GD2qnm.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/gantari/v1/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g2gPT3wa5GD2qnm.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/gantari/v1/jVyV7nvyB2HL8iZyDk4GVvSZ5MtC9g2JPT3wa5GD2qnm.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/gantari/v1/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoedWyYZWh37nmpWc.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/gantari/v1/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeVWzYZWh37nmpWc.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/gantari/v1/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeYuzYZWh37nmpWc.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/gantari/v1/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoedWzYZWh37nmpWc.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/gantari/v1/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeeezYZWh37nmpWc.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/gantari/v1/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeQu0YZWh37nmpWc.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/gantari/v1/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeTK0YZWh37nmpWc.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/gantari/v1/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeVW0YZWh37nmpWc.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/gantari/v1/jVyb7nvyB2HL8iZyJEc0qSzwj1Hs8RjoeXy0YZWh37nmpWc.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gayathri\",\n      \"variants\": [\n        \"100\",\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"malayalam\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/gayathri/v15/MCoWzAb429DbBilWLLhc-pvSA_gA2W8.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/gayathri/v15/MCoQzAb429DbBilWLIA48J_wBugA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gayathri/v15/MCoXzAb429DbBilWLLiE37v4LfQJwHbn.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gelasio\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gelasio/v10/cIf9MaFfvUQxTTqSxCmrYGkHgIs.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/gelasio/v10/cIf_MaFfvUQxTTqS9CuhZEsCkIt9QQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/gelasio/v10/cIf4MaFfvUQxTTqS_N2CRGEsnIJkWL4.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/gelasio/v10/cIf6MaFfvUQxTTqS9CuZkGImmKBhSL7Y1Q.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/gelasio/v10/cIf4MaFfvUQxTTqS_PGFRGEsnIJkWL4.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/gelasio/v10/cIf6MaFfvUQxTTqS9CuZvGUmmKBhSL7Y1Q.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gelasio/v10/cIf4MaFfvUQxTTqS_JWERGEsnIJkWL4.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/gelasio/v10/cIf6MaFfvUQxTTqS9CuZ2GQmmKBhSL7Y1Q.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gemunu Libre\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"sinhala\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/gemunulibre/v8/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp05iJPvSLeMXPIWA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/gemunulibre/v8/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp00aJPvSLeMXPIWA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/gemunulibre/v8/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp0xiJPvSLeMXPIWA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/gemunulibre/v8/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp0yqJPvSLeMXPIWA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/gemunulibre/v8/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp08aOPvSLeMXPIWA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gemunulibre/v8/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp0_-OPvSLeMXPIWA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/gemunulibre/v8/X7n34bQ6Cfy7jKGXVE_YlqnbEQAFP-PIuTCp05iOPvSLeMXPIWA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Genos\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cherokee\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v6\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/genos/v6/SlGNmQqPqpUOYTYjacb0Hc91fTwVqknorUK6K7ZsAg.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/genos/v6/SlGNmQqPqpUOYTYjacb0Hc91fTwVKkjorUK6K7ZsAg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/genos/v6/SlGNmQqPqpUOYTYjacb0Hc91fTwV9EjorUK6K7ZsAg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/genos/v6/SlGNmQqPqpUOYTYjacb0Hc91fTwVqkjorUK6K7ZsAg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/genos/v6/SlGNmQqPqpUOYTYjacb0Hc91fTwVmEjorUK6K7ZsAg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/genos/v6/SlGNmQqPqpUOYTYjacb0Hc91fTwVdE_orUK6K7ZsAg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/genos/v6/SlGNmQqPqpUOYTYjacb0Hc91fTwVTU_orUK6K7ZsAg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/genos/v6/SlGNmQqPqpUOYTYjacb0Hc91fTwVKk_orUK6K7ZsAg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/genos/v6/SlGNmQqPqpUOYTYjacb0Hc91fTwVA0_orUK6K7ZsAg.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/genos/v6/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgsA70i-CbN8Ard7.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/genos/v6/SlGPmQqPqpUOYRwqWzksdKTv0zsAYguA7ki-CbN8Ard7.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/genos/v6/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgte7ki-CbN8Ard7.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/genos/v6/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgsA7ki-CbN8Ard7.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/genos/v6/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgsy7ki-CbN8Ard7.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/genos/v6/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgve6Ui-CbN8Ard7.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/genos/v6/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgvn6Ui-CbN8Ard7.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/genos/v6/SlGPmQqPqpUOYRwqWzksdKTv0zsAYguA6Ui-CbN8Ard7.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/genos/v6/SlGPmQqPqpUOYRwqWzksdKTv0zsAYgup6Ui-CbN8Ard7.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gentium Book Basic\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gentiumbookbasic/v16/pe0zMJCbPYBVokB1LHA9bbyaQb8ZGjcIV7t7w6bE2A.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/gentiumbookbasic/v16/pe0xMJCbPYBVokB1LHA9bbyaQb8ZGjc4VbF_4aPU2Ec9.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gentiumbookbasic/v16/pe0wMJCbPYBVokB1LHA9bbyaQb8ZGjcw65Rfy43Y0V4kvg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/gentiumbookbasic/v16/pe0-MJCbPYBVokB1LHA9bbyaQb8ZGjc4VYnDzofc81s0voO3.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gentium Book Plus\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gentiumbookplus/v1/vEFL2-RHBgUK5fbjKxRpbBtJPyRpofKfdbLOrdPV.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/gentiumbookplus/v1/vEFN2-RHBgUK5fbjKxRpbBtJPyRpocKdf7bsqMPVZb4.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gentiumbookplus/v1/vEFO2-RHBgUK5fbjKxRpbBtJPyRpocojWpbGhs_cfKe1.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/gentiumbookplus/v1/vEFA2-RHBgUK5fbjKxRpbBtJPyRpocKdRwrDjMv-ebe1Els.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gentium Plus\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gentiumplus/v1/Iurd6Ytw-oSPaZ00r2bNe8VpjJtM6G0t9w.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/gentiumplus/v1/IurD6Ytw-oSPaZ00r2bNe8VZjpFIymg9957e.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gentiumplus/v1/IurC6Ytw-oSPaZ00r2bNe8VRMLRo4EYx_ofHsw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/gentiumplus/v1/IurA6Ytw-oSPaZ00r2bNe8VZjqn05Uw13ILXs-h6.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Geo\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/geo/v19/CSRz4zRZlufVL3BmQjlCbQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/geo/v19/CSRx4zRZluflLXpiYDxSbf8r.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Georama\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/georama/v8/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5GvktmQsL5_tgbg.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/georama/v8/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5mvgtmQsL5_tgbg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/georama/v8/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5RPgtmQsL5_tgbg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/georama/v8/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5GvgtmQsL5_tgbg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/georama/v8/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5KPgtmQsL5_tgbg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/georama/v8/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5xP8tmQsL5_tgbg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/georama/v8/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5_f8tmQsL5_tgbg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/georama/v8/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5mv8tmQsL5_tgbg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/georama/v8/MCo5zAn438bIEyxFf6swMnNpvPcUwW4u4yRcDh-ZjxApn9K5s_8tmQsL5_tgbg.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/georama/v8/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rvF2wEPxf5wbh3T.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/georama/v8/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rtF2gEPxf5wbh3T.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/georama/v8/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rub2gEPxf5wbh3T.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/georama/v8/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rvF2gEPxf5wbh3T.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/georama/v8/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rv32gEPxf5wbh3T.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/georama/v8/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rsb3QEPxf5wbh3T.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/georama/v8/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rsi3QEPxf5wbh3T.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/georama/v8/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rtF3QEPxf5wbh3T.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/georama/v8/MCo_zAn438bIEyxFVaIC0ZMQ72G6xnvmodYVPOBB5nuzMdWs0rts3QEPxf5wbh3T.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Geostar\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/geostar/v22/sykz-yx4n701VLOftSq9-trEvlQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Geostar Fill\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/geostarfill/v22/AMOWz4SWuWiXFfjEohxQ9os0U1K2w9lb4g.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Germania One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/germaniaone/v20/Fh4yPjrqIyv2ucM2qzBjeS3ezAJONau6ew.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gideon Roman\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gideonroman/v7/e3tmeuGrVOys8sxzZgWlmXoge0PWovdU4w.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gidugu\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"telugu\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gidugu/v21/L0x8DFMkk1Uf6w3RvPCmRSlUig.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gilda Display\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2023-02-16\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gildadisplay/v14/t5tmIRoYMoaYG0WEOh7HwMeR7TnFrpOHYh4.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Girassol\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/girassol/v16/JTUUjIo_-DK48laaNC9Nz2pJzxbi.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Give You Glory\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/giveyouglory/v15/8QIQdiHOgt3vv4LR7ahjw9-XYc1zB4ZD6rwa.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Glass Antiqua\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/glassantiqua/v20/xfu30Wr0Wn3NOQM2piC0uXOjnL_wN6fRUkY.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Glegoo\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/glegoo/v14/_Xmt-HQyrTKWaw2Ji6mZAI91xw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/glegoo/v14/_Xmu-HQyrTKWaw2xN4a9CKRpzimMsg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gloock\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2023-02-16\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gloock/v1/Iurb6YFw84WUY4N5jxylBrdRjQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gloria Hallelujah\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gloriahallelujah/v17/LYjYdHv3kUk9BMV96EIswT9DIbW-MLSy3TKEvkCF.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Glory\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/glory/v9/q5uasoi9Lf1w5t3Est24nq9blIRQwIiDpn-dDi9EOQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/glory/v9/q5uasoi9Lf1w5t3Est24nq9blIRQQImDpn-dDi9EOQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/glory/v9/q5uasoi9Lf1w5t3Est24nq9blIRQnomDpn-dDi9EOQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/glory/v9/q5uasoi9Lf1w5t3Est24nq9blIRQwImDpn-dDi9EOQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/glory/v9/q5uasoi9Lf1w5t3Est24nq9blIRQ8omDpn-dDi9EOQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/glory/v9/q5uasoi9Lf1w5t3Est24nq9blIRQHo6Dpn-dDi9EOQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/glory/v9/q5uasoi9Lf1w5t3Est24nq9blIRQJ46Dpn-dDi9EOQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/glory/v9/q5uasoi9Lf1w5t3Est24nq9blIRQQI6Dpn-dDi9EOQ.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/glory/v9/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMpr5HWZLCpUOaM6.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/glory/v9/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMrr5XWZLCpUOaM6.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/glory/v9/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMo15XWZLCpUOaM6.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/glory/v9/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMpr5XWZLCpUOaM6.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/glory/v9/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMpZ5XWZLCpUOaM6.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/glory/v9/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMq14nWZLCpUOaM6.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/glory/v9/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMqM4nWZLCpUOaM6.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/glory/v9/q5uYsoi9Lf1w5vfNgCJg98TBOoNFCMrr4nWZLCpUOaM6.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gluten\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/gluten/v9/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Vb7B1Luni7ciJh.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/gluten/v9/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Xb7R1Luni7ciJh.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/gluten/v9/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8UF7R1Luni7ciJh.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/gluten/v9/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Vb7R1Luni7ciJh.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/gluten/v9/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Vp7R1Luni7ciJh.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/gluten/v9/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8WF6h1Luni7ciJh.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gluten/v9/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8W86h1Luni7ciJh.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/gluten/v9/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Xb6h1Luni7ciJh.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/gluten/v9/Hhy_U5gk9fW7OUdVIPh2zD_RSqQJ__A15jgJsn-Bhb_yI8Xy6h1Luni7ciJh.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Goblin One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/goblinone/v22/CSR64z1ZnOqZRjRCBVY_TOcATNt_pOU.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gochi Hand\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gochihand/v19/hES06XlsOjtJsgCkx1PkTo71-n0nXWA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Goldman\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/goldman/v15/pe0uMIWbN4JFplR2LDJ4Bt-7G98.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/goldman/v15/pe0rMIWbN4JFplR2FI5XIteQB9Zra1U.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Golos Text\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2023-02-23\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/golostext/v3/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plVRRQ5cEr8zXcyx.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/golostext/v3/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plVjRQ5cEr8zXcyx.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/golostext/v3/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plWPQg5cEr8zXcyx.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/golostext/v3/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plW2Qg5cEr8zXcyx.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/golostext/v3/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plXRQg5cEr8zXcyx.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/golostext/v3/q5uXsoe9Lv5t7Meb31EcOR9UdVTNs822plX4Qg5cEr8zXcyx.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gorditas\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gorditas/v20/ll8_K2aTVD26DsPEtQDoDa4AlxYb.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gorditas/v20/ll84K2aTVD26DsPEtThUIooIvAoShA1i.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gothic A1\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/gothica1/v13/CSR74z5ZnPydRjlCCwlCCMcqYtd2vfwk.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/gothica1/v13/CSR44z5ZnPydRjlCCwlCpOYKSPl6tOU9Eg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/gothica1/v13/CSR44z5ZnPydRjlCCwlCwOUKSPl6tOU9Eg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/gothica1/v13/CSR94z5ZnPydRjlCCwl6bM0uQNJmvQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/gothica1/v13/CSR44z5ZnPydRjlCCwlCmOQKSPl6tOU9Eg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/gothica1/v13/CSR44z5ZnPydRjlCCwlCtOMKSPl6tOU9Eg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gothica1/v13/CSR44z5ZnPydRjlCCwlC0OIKSPl6tOU9Eg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/gothica1/v13/CSR44z5ZnPydRjlCCwlCzOEKSPl6tOU9Eg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/gothica1/v13/CSR44z5ZnPydRjlCCwlC6OAKSPl6tOU9Eg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gotu\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gotu/v14/o-0FIpksx3QOlH0Lioh6-hU.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Goudy Bookletter 1911\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/goudybookletter1911/v15/sykt-z54laciWfKv-kX8krex0jDiD2HbY6I5tRbXZ4IXAA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gowun Batang\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gowunbatang/v7/ijwSs5nhRMIjYsdSgcMa3wRhXLH-yuAtLw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gowunbatang/v7/ijwNs5nhRMIjYsdSgcMa3wRZ4J7awssxJii23w.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gowun Dodum\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gowundodum/v7/3Jn5SD_00GqwlBnWc1TUJF0FfORL0fNy.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Graduate\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/graduate/v13/C8cg4cs3o2n15t_2YxgR6X2NZAn2.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Grand Hotel\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/grandhotel/v13/7Au7p_IgjDKdCRWuR1azpmQNEl0O0kEx.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Grandstander\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD1-_D3jWttFGmQk.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD9--D3jWttFGmQk.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQDwG-D3jWttFGmQk.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD1--D3jWttFGmQk.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD22-D3jWttFGmQk.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD4G5D3jWttFGmQk.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD7i5D3jWttFGmQk.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD9-5D3jWttFGmQk.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6fawtA-GpSsTWrnNHPCSIMZhhKpFjyNZIQD_a5D3jWttFGmQk.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf95zrcsvNDiQlBYQ.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9ZzvcsvNDiQlBYQ.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9uTvcsvNDiQlBYQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf95zvcsvNDiQlBYQ.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf91TvcsvNDiQlBYQ.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9OTzcsvNDiQlBYQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9ADzcsvNDiQlBYQ.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9ZzzcsvNDiQlBYQ.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/grandstander/v11/ga6ZawtA-GpSsTWrnNHPCSImbyq1fDGZrzwXGpf9TjzcsvNDiQlBYQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Grape Nuts\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/grapenuts/v2/syk2-yF4iLM2RfKj4F7k3tLvol2RN1E.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gravitas One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gravitasone/v15/5h1diZ4hJ3cblKy3LWakKQmaDWRNr3DzbQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Great Vibes\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/greatvibes/v14/RWmMoKWR9v4ksMfaWd_JN-XCg6UKDXlq.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Grechen Fuemen\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/grechenfuemen/v7/vEFI2_tHEQ4d5ObgKxBzZh0MAWgc-NaXXq7H.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Grenze\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZRFGb7hR12BxqPm2IjuAkalnmd.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZXFGb7hR12BxqH_VpHsg04k2md0kI.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZQFGb7hR12BxqPN0MDkicWn2CEyw.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZWFGb7hR12BxqH_Vrrky0SvWWUy1uW.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZQFGb7hR12BxqPU0ADkicWn2CEyw.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZWFGb7hR12BxqH_VqPkC0SvWWUy1uW.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZTFGb7hR12Bxq3_2gnmgwKlg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZRFGb7hR12BxqH_WIjuAkalnmd.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZQFGb7hR12BxqPC0EDkicWn2CEyw.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZWFGb7hR12BxqH_VrXkS0SvWWUy1uW.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZQFGb7hR12BxqPJ0YDkicWn2CEyw.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZWFGb7hR12BxqH_Vr7li0SvWWUy1uW.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZQFGb7hR12BxqPQ0cDkicWn2CEyw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZWFGb7hR12BxqH_Vqfly0SvWWUy1uW.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZQFGb7hR12BxqPX0QDkicWn2CEyw.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZWFGb7hR12BxqH_VqDlC0SvWWUy1uW.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZQFGb7hR12BxqPe0UDkicWn2CEyw.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/grenze/v14/O4ZWFGb7hR12BxqH_VqnlS0SvWWUy1uW.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Grenze Gotisch\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/grenzegotisch/v12/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5Lz5UcICdYPSd_w.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/grenzegotisch/v12/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5rz9UcICdYPSd_w.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/grenzegotisch/v12/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5cT9UcICdYPSd_w.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/grenzegotisch/v12/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5Lz9UcICdYPSd_w.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/grenzegotisch/v12/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5HT9UcICdYPSd_w.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/grenzegotisch/v12/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i58ThUcICdYPSd_w.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/grenzegotisch/v12/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5yDhUcICdYPSd_w.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/grenzegotisch/v12/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5rzhUcICdYPSd_w.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/grenzegotisch/v12/Fh4hPjjqNDz1osh_jX9YfjudpBJBNV5y5wf_k1i5hjhUcICdYPSd_w.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Grey Qo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/greyqo/v7/BXRrvF_Nmv_TyXxNDOtQ9Wf0QcE.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Griffy\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/griffy/v21/FwZa7-ox2FQh9kfwSNSEwM2zpA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gruppo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gruppo/v16/WwkfxPmzE06v_ZWFWXDAOIEQUQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gudea\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gudea/v15/neIFzCqgsI0mp-CP9IGON7Ez.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/gudea/v15/neILzCqgsI0mp9CN_oWsMqEzSJQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gudea/v15/neIIzCqgsI0mp9gz26WGHK06UY30.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gugi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gugi/v13/A2BVn5dXywshVA6A9DEfgqM.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gulzar\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v6\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gulzar/v6/Wnz6HAc9eB3HB2ILYTwZqg_MPQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gupter\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gupter/v14/2-cm9JNmxJqPO1QUYZa_Wu_lpA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/gupter/v14/2-cl9JNmxJqPO1Qslb-bUsT5rZhaZg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gupter/v14/2-cl9JNmxJqPO1Qs3bmbUsT5rZhaZg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gurajada\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"telugu\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gurajada/v15/FwZY7-Qx308m-l-0Kd6A4sijpFu_.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Gwendolyn\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/gwendolyn/v5/qkBXXvoO_M3CSss-d7ee5JRLkAXbMQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/gwendolyn/v5/qkBSXvoO_M3CSss-d7emWLtvmC7HONiSFQ.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Habibi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/habibi/v21/CSR-4zFWkuqcTTNCShJeZOYySQ.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hachi Maru Pop\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/hachimarupop/v17/HI_TiYoRLqpLrEiMAuO9Ysfz7rW1EM_btd8u.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hahmlet\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/hahmlet/v9/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RhKOdjobsO-aVxn.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/hahmlet/v9/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RjKONjobsO-aVxn.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/hahmlet/v9/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RgUONjobsO-aVxn.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/hahmlet/v9/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RhKONjobsO-aVxn.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/hahmlet/v9/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4Rh4ONjobsO-aVxn.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/hahmlet/v9/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RiUP9jobsO-aVxn.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/hahmlet/v9/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RitP9jobsO-aVxn.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/hahmlet/v9/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RjKP9jobsO-aVxn.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/hahmlet/v9/BngXUXpCQ3nKpIo0TfPyfCdXfaeU4RjjP9jobsO-aVxn.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Halant\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/halant/v13/u-490qaujRI2Pbsvc_pCmwZqcwdRXg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/halant/v13/u-4-0qaujRI2PbsX39Jmky12eg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/halant/v13/u-490qaujRI2PbsvK_tCmwZqcwdRXg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/halant/v13/u-490qaujRI2PbsvB_xCmwZqcwdRXg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/halant/v13/u-490qaujRI2PbsvY_1CmwZqcwdRXg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hammersmith One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/hammersmithone/v17/qWcyB624q4L_C4jGQ9IK0O_dFlnbshsks4MRXw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hanalei\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/hanalei/v23/E21n_dD8iufIjBRHXzgmVydREus.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hanalei Fill\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/hanaleifill/v21/fC1mPYtObGbfyQznIaQzPQiMVwLBplm9aw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Handlee\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/handlee/v14/-F6xfjBsISg9aMakDmr6oilJ3ik.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hanken Grotesk\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2023-01-18\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_Ncs2da4fpNzXhRKA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcM2Za4fpNzXhRKA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_Nc7WZa4fpNzXhRKA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_Ncs2Za4fpNzXhRKA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcgWZa4fpNzXhRKA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcbWFa4fpNzXhRKA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcVGFa4fpNzXhRKA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcM2Fa4fpNzXhRKA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVq2YZDLWuGJpnzaiwFXS9tYvBRzyFLlZg_f_NcGmFa4fpNzXhRKA.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyWyo_BJ731BKMSK.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyUyovBJ731BKMSK.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyXsovBJ731BKMSK.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyWyovBJ731BKMSK.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyWAovBJ731BKMSK.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyVspfBJ731BKMSK.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyVVpfBJ731BKMSK.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyUypfBJ731BKMSK.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/hankengrotesk/v5/ieVo2YZDLWuGJpnzaiwFXS9tYtpY_d6T_POl0fRJeyUbpfBJ731BKMSK.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hanuman\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-04-21\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/hanuman/v22/VuJzdNvD15HhpJJBQMLdPKNiaRpFvg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/hanuman/v22/VuJ0dNvD15HhpJJBQAr_HIlMZRNcp0o.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/hanuman/v22/VuJxdNvD15HhpJJBeKbXOIFneRo.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/hanuman/v22/VuJ0dNvD15HhpJJBQBr4HIlMZRNcp0o.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/hanuman/v22/VuJ0dNvD15HhpJJBQCL6HIlMZRNcp0o.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Happy Monkey\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/happymonkey/v14/K2F2fZZcl-9SXwl5F_C4R_OABwD2bWqVjw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Harmattan\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/harmattan/v17/goksH6L2DkFvVvRp9XpTS0CjkP1Yog.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/harmattan/v17/gokpH6L2DkFvVvRp9Xpr92-HmNZEq6TTFw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Headland One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/headlandone/v15/yYLu0hHR2vKnp89Tk1TCq3Tx0PlTeZ3mJA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Heebo\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/heebo/v21/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EiS2cckOnz02SXQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/heebo/v21/NGSpv5_NC0k9P_v6ZUCbLRAHxK1ECSycckOnz02SXQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/heebo/v21/NGSpv5_NC0k9P_v6ZUCbLRAHxK1E1yycckOnz02SXQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/heebo/v21/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EiSycckOnz02SXQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/heebo/v21/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EuyycckOnz02SXQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/heebo/v21/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EVyucckOnz02SXQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/heebo/v21/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EbiucckOnz02SXQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/heebo/v21/NGSpv5_NC0k9P_v6ZUCbLRAHxK1ECSucckOnz02SXQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/heebo/v21/NGSpv5_NC0k9P_v6ZUCbLRAHxK1EICucckOnz02SXQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Henny Penny\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/hennypenny/v17/wXKvE3UZookzsxz_kjGSfMQqt3M7tMDT.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hepta Slab\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/heptaslab/v17/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvkV5jfbY5B0NBkz.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/heptaslab/v17/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvmV5zfbY5B0NBkz.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/heptaslab/v17/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvlL5zfbY5B0NBkz.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/heptaslab/v17/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvkV5zfbY5B0NBkz.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/heptaslab/v17/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5Hvkn5zfbY5B0NBkz.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/heptaslab/v17/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvnL4DfbY5B0NBkz.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/heptaslab/v17/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5Hvny4DfbY5B0NBkz.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/heptaslab/v17/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5HvmV4DfbY5B0NBkz.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/heptaslab/v17/ea8JadoyU_jkHdalebHvyWVNdYoIsHe5Hvm84DfbY5B0NBkz.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Herr Von Muellerhoff\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/herrvonmuellerhoff/v15/WBL6rFjRZkREW8WqmCWYLgCkQKXb4CAft3c6_qJY3QPQ.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hi Melody\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/himelody/v13/46ktlbP8Vnz0pJcqCTbEf29E31BBGA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hina Mincho\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/hinamincho/v8/2sDaZGBRhpXa2Jjz5w5LAGW8KbkVZTHR.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hind\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/hind/v16/5aU19_a8oxmIfMJaIRuYjDpf5Vw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/hind/v16/5aU69_a8oxmIRG5yBROzkDM.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/hind/v16/5aU19_a8oxmIfJpbIRuYjDpf5Vw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/hind/v16/5aU19_a8oxmIfLZcIRuYjDpf5Vw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/hind/v16/5aU19_a8oxmIfNJdIRuYjDpf5Vw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hind Guntur\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"telugu\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/hindguntur/v12/wXKyE3UZrok56nvamSuJd_yGn1czn9zaj5Ju.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/hindguntur/v12/wXKvE3UZrok56nvamSuJd8Qqt3M7tMDT.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/hindguntur/v12/wXKyE3UZrok56nvamSuJd_zenlczn9zaj5Ju.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/hindguntur/v12/wXKyE3UZrok56nvamSuJd_zymVczn9zaj5Ju.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/hindguntur/v12/wXKyE3UZrok56nvamSuJd_yWmFczn9zaj5Ju.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hind Madurai\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tamil\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/hindmadurai/v11/f0Xu0e2p98ZvDXdZQIOcpqjfXaUnecsoMJ0b_g.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/hindmadurai/v11/f0Xx0e2p98ZvDXdZQIOcpqjn8Y0DceA0OQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/hindmadurai/v11/f0Xu0e2p98ZvDXdZQIOcpqjfBaQnecsoMJ0b_g.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/hindmadurai/v11/f0Xu0e2p98ZvDXdZQIOcpqjfKaMnecsoMJ0b_g.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/hindmadurai/v11/f0Xu0e2p98ZvDXdZQIOcpqjfTaInecsoMJ0b_g.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hind Siliguri\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"bengali\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/hindsiliguri/v12/ijwOs5juQtsyLLR5jN4cxBEoRDf44uEfKiGvxts.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/hindsiliguri/v12/ijwTs5juQtsyLLR5jN4cxBEofJvQxuk0Nig.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/hindsiliguri/v12/ijwOs5juQtsyLLR5jN4cxBEoRG_54uEfKiGvxts.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/hindsiliguri/v12/ijwOs5juQtsyLLR5jN4cxBEoREP-4uEfKiGvxts.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/hindsiliguri/v12/ijwOs5juQtsyLLR5jN4cxBEoRCf_4uEfKiGvxts.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hind Vadodara\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"gujarati\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/hindvadodara/v12/neIQzCKvrIcn5pbuuuriV9tTSDn3iXM0oSOL2Yw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/hindvadodara/v12/neINzCKvrIcn5pbuuuriV9tTcJXfrXsfvSo.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/hindvadodara/v12/neIQzCKvrIcn5pbuuuriV9tTSGH2iXM0oSOL2Yw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/hindvadodara/v12/neIQzCKvrIcn5pbuuuriV9tTSE3xiXM0oSOL2Yw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/hindvadodara/v12/neIQzCKvrIcn5pbuuuriV9tTSCnwiXM0oSOL2Yw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Holtwood One SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/holtwoodonesc/v16/yYLx0hLR0P-3vMFSk1TCq3Txg5B3cbb6LZttyg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Homemade Apple\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/homemadeapple/v18/Qw3EZQFXECDrI2q789EKQZJob3x9Vnksi4M7.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Homenaje\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/homenaje/v16/FwZY7-Q-xVAi_l-6Ld6A4sijpFu_.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hubballi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"kannada\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v4\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/hubballi/v4/o-0JIpUj3WIZ1RFN56B7yBBNYuSF.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Hurricane\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/hurricane/v5/pe0sMIuULZxTolZ5YldyAv2-C99ycg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Mono\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6pfjptAgt5VM-kVkqdyU8n3kwq0n1hj-sNFQ.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6rfjptAgt5VM-kVkqdyU8n1ioStndlre4dFcFh.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6qfjptAgt5VM-kVkqdyU8n3uAL8ldPg-IUDNg.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6sfjptAgt5VM-kVkqdyU8n1ioSGlZFh8ARHNh4zg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6qfjptAgt5VM-kVkqdyU8n3oQI8ldPg-IUDNg.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6sfjptAgt5VM-kVkqdyU8n1ioSflVFh8ARHNh4zg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F63fjptAgt5VM-kVkqdyU8n5igg1l9kn-s.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6pfjptAgt5VM-kVkqdyU8n1ioq0n1hj-sNFQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6qfjptAgt5VM-kVkqdyU8n3twJ8ldPg-IUDNg.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6sfjptAgt5VM-kVkqdyU8n1ioSJlRFh8ARHNh4zg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6qfjptAgt5VM-kVkqdyU8n3vAO8ldPg-IUDNg.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6sfjptAgt5VM-kVkqdyU8n1ioSClNFh8ARHNh4zg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6qfjptAgt5VM-kVkqdyU8n3pQP8ldPg-IUDNg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/ibmplexmono/v15/-F6sfjptAgt5VM-kVkqdyU8n1ioSblJFh8ARHNh4zg.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Sans\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX-KVElMYYaJe8bpLHnCwDKjbLeEKxIedbzDw.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX8KVElMYYaJe8bpLHnCwDKhdTmdKZMW9PjD3N8.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX9KVElMYYaJe8bpLHnCwDKjR7_MIZmdd_qFmo.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX7KVElMYYaJe8bpLHnCwDKhdTm2Idscf3vBmpl8A.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX9KVElMYYaJe8bpLHnCwDKjXr8MIZmdd_qFmo.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX7KVElMYYaJe8bpLHnCwDKhdTmvIRscf3vBmpl8A.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYXgKVElMYYaJe8bpLHnCwDKtdbUFI5NadY.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX-KVElMYYaJe8bpLHnCwDKhdTeEKxIedbzDw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX9KVElMYYaJe8bpLHnCwDKjSL9MIZmdd_qFmo.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX7KVElMYYaJe8bpLHnCwDKhdTm5IVscf3vBmpl8A.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX9KVElMYYaJe8bpLHnCwDKjQ76MIZmdd_qFmo.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX7KVElMYYaJe8bpLHnCwDKhdTmyIJscf3vBmpl8A.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX9KVElMYYaJe8bpLHnCwDKjWr7MIZmdd_qFmo.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/ibmplexsans/v14/zYX7KVElMYYaJe8bpLHnCwDKhdTmrINscf3vBmpl8A.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Sans Arabic\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexsansarabic/v9/Qw3MZRtWPQCuHme67tEYUIx3Kh0PHR9N6YNe3PC5eMlAMg0.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexsansarabic/v9/Qw3NZRtWPQCuHme67tEYUIx3Kh0PHR9N6YPy_dCTVsVJKxTs.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexsansarabic/v9/Qw3NZRtWPQCuHme67tEYUIx3Kh0PHR9N6YOW_tCTVsVJKxTs.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexsansarabic/v9/Qw3CZRtWPQCuHme67tEYUIx3Kh0PHR9N6bs61vSbfdlA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexsansarabic/v9/Qw3NZRtWPQCuHme67tEYUIx3Kh0PHR9N6YPO_9CTVsVJKxTs.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexsansarabic/v9/Qw3NZRtWPQCuHme67tEYUIx3Kh0PHR9N6YPi-NCTVsVJKxTs.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexsansarabic/v9/Qw3NZRtWPQCuHme67tEYUIx3Kh0PHR9N6YOG-dCTVsVJKxTs.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Sans Condensed\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8nN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY7KyKvBgYsMDhM.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8hN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8M_LhakJHhOgBg.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8gN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY5m6Yvrr4cFFwq5.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8iN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8GPqpYMnEhq5H1w.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8gN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY4C6ovrr4cFFwq5.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8iN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8AfppYMnEhq5H1w.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8lN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHbauwq_jhJsM.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8nN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYasyKvBgYsMDhM.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8gN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY5a64vrr4cFFwq5.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8iN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8F_opYMnEhq5H1w.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8gN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY527Ivrr4cFFwq5.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8iN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8HPvpYMnEhq5H1w.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8gN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHY4S7Yvrr4cFFwq5.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/ibmplexsanscondensed/v13/Gg8iN4UfRSqiPg7Jn2ZI12V4DCEwkj1E4LVeHYas8BfupYMnEhq5H1w.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Sans Devanagari\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexsansdevanagari/v9/XRXB3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_HMUjwUcjwCEQq.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexsansdevanagari/v9/XRXA3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_HnWnQe-b8AV0z0w.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexsansdevanagari/v9/XRXA3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_H-WrQe-b8AV0z0w.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexsansdevanagari/v9/XRXH3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O__VUL0c83gCA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexsansdevanagari/v9/XRXA3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_HoWvQe-b8AV0z0w.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexsansdevanagari/v9/XRXA3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_HjWzQe-b8AV0z0w.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexsansdevanagari/v9/XRXA3JCMvG4IDoS9SubXB6W-UX5iehIMBFR2-O_H6W3Qe-b8AV0z0w.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Sans Hebrew\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexsanshebrew/v10/BCa4qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEXB-l0VqDaM7C4.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexsanshebrew/v10/BCa5qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEVt230_hjqF9Tc2.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexsanshebrew/v10/BCa5qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEUJ2H0_hjqF9Tc2.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexsanshebrew/v10/BCa2qYENg9Kw1mpLpO0bGM5lfHAAZHhDXH2l8Fk3rSaM.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexsanshebrew/v10/BCa5qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEVR2X0_hjqF9Tc2.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexsanshebrew/v10/BCa5qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEV93n0_hjqF9Tc2.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexsanshebrew/v10/BCa5qYENg9Kw1mpLpO0bGM5lfHAAZHhDXEUZ330_hjqF9Tc2.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Sans JP\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexsansjp/v3/Z9XLDn9KbTDf6_f7dISNqYf_tvPT7E7yjPB7twdmHQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexsansjp/v3/Z9XKDn9KbTDf6_f7dISNqYf_tvPT7OLTrNpVuw5_BAM.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexsansjp/v3/Z9XKDn9KbTDf6_f7dISNqYf_tvPT7IbQrNpVuw5_BAM.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexsansjp/v3/Z9XNDn9KbTDf6_f7dISNqYf_tvPT1Cr4iNJ-pwc.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexsansjp/v3/Z9XKDn9KbTDf6_f7dISNqYf_tvPT7N7RrNpVuw5_BAM.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexsansjp/v3/Z9XKDn9KbTDf6_f7dISNqYf_tvPT7PLWrNpVuw5_BAM.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexsansjp/v3/Z9XKDn9KbTDf6_f7dISNqYf_tvPT7JbXrNpVuw5_BAM.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Sans KR\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexsanskr/v9/vEFM2-VJISZe3O_rc3ZVYh4aTwNOyra_X5zCpMrMfA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexsanskr/v9/vEFN2-VJISZe3O_rc3ZVYh4aTwNOyhqef7bsqMPVZb4.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexsanskr/v9/vEFN2-VJISZe3O_rc3ZVYh4aTwNOyn6df7bsqMPVZb4.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexsanskr/v9/vEFK2-VJISZe3O_rc3ZVYh4aTwNO8tK1W77HtMo.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexsanskr/v9/vEFN2-VJISZe3O_rc3ZVYh4aTwNOyiacf7bsqMPVZb4.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexsanskr/v9/vEFN2-VJISZe3O_rc3ZVYh4aTwNOygqbf7bsqMPVZb4.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexsanskr/v9/vEFN2-VJISZe3O_rc3ZVYh4aTwNOym6af7bsqMPVZb4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Sans Thai\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"thai\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexsansthai/v9/m8JNje1VVIzcq1HzJq2AEdo2Tj_qvLqEatYlR8ZKUqcX.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexsansthai/v9/m8JMje1VVIzcq1HzJq2AEdo2Tj_qvLqExvcFbehGW74OXw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexsansthai/v9/m8JMje1VVIzcq1HzJq2AEdo2Tj_qvLqEovQFbehGW74OXw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexsansthai/v9/m8JPje1VVIzcq1HzJq2AEdo2Tj_qvLq8DtwhZcNaUg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexsansthai/v9/m8JMje1VVIzcq1HzJq2AEdo2Tj_qvLqE-vUFbehGW74OXw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexsansthai/v9/m8JMje1VVIzcq1HzJq2AEdo2Tj_qvLqE1vIFbehGW74OXw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexsansthai/v9/m8JMje1VVIzcq1HzJq2AEdo2Tj_qvLqEsvMFbehGW74OXw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Sans Thai Looped\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"thai\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexsansthailooped/v9/tss5AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_HaKpHOtFCQ76Q.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexsansthailooped/v9/tss6AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_NqrhFmDGC0i8Cc.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexsansthailooped/v9/tss6AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_L6ohFmDGC0i8Cc.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexsansthailooped/v9/tss_AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30LxBKAoFGoBCQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexsansthailooped/v9/tss6AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_OaphFmDGC0i8Cc.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexsansthailooped/v9/tss6AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_MquhFmDGC0i8Cc.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexsansthailooped/v9/tss6AoJJRAhL3BTrK3r2xxbFhvKfyBB6l7hHT30L_K6vhFmDGC0i8Cc.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IBM Plex Serif\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizBREVNn1dOx-zrZ2X3pZvkTi182zIZj1bIkNo.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizHREVNn1dOx-zrZ2X3pZvkTiUa41YTi3TNgNq55w.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizAREVNn1dOx-zrZ2X3pZvkTi3Q-hIzoVrBicOg.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizGREVNn1dOx-zrZ2X3pZvkTiUa4_oyq17jjNOg_oc.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizAREVNn1dOx-zrZ2X3pZvkTi20-RIzoVrBicOg.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizGREVNn1dOx-zrZ2X3pZvkTiUa454xq17jjNOg_oc.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizDREVNn1dOx-zrZ2X3pZvkThUY0TY7ikbI.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizBREVNn1dOx-zrZ2X3pZvkTiUa2zIZj1bIkNo.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizAREVNn1dOx-zrZ2X3pZvkTi3s-BIzoVrBicOg.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizGREVNn1dOx-zrZ2X3pZvkTiUa48Ywq17jjNOg_oc.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizAREVNn1dOx-zrZ2X3pZvkTi3A_xIzoVrBicOg.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizGREVNn1dOx-zrZ2X3pZvkTiUa4-o3q17jjNOg_oc.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizAREVNn1dOx-zrZ2X3pZvkTi2k_hIzoVrBicOg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/ibmplexserif/v15/jizGREVNn1dOx-zrZ2X3pZvkTiUa4442q17jjNOg_oc.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IM Fell DW Pica\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imfelldwpica/v16/2sDGZGRQotv9nbn2qSl0TxXVYNw9ZAPUvi88MQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/imfelldwpica/v16/2sDEZGRQotv9nbn2qSl0TxXVYNwNZgnQnCosMXm0.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IM Fell DW Pica SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imfelldwpicasc/v21/0ybjGCAu5PfqkvtGVU15aBhXz3EUrnTW-BiKEUiBGA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IM Fell Double Pica\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imfelldoublepica/v14/3XF2EqMq_94s9PeKF7Fg4gOKINyMtZ8rT0S1UL5Ayp0.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/imfelldoublepica/v14/3XF0EqMq_94s9PeKF7Fg4gOKINyMtZ8rf0a_VJxF2p2G8g.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IM Fell Double Pica SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imfelldoublepicasc/v21/neIazDmuiMkFo6zj_sHpQ8teNbWlwBB_hXjJ4Y0Eeru2dGg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IM Fell English\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imfellenglish/v14/Ktk1ALSLW8zDe0rthJysWrnLsAz3F6mZVY9Y5w.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/imfellenglish/v14/Ktk3ALSLW8zDe0rthJysWrnLsAzHFaOdd4pI59zg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IM Fell English SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imfellenglishsc/v16/a8IENpD3CDX-4zrWfr1VY879qFF05pZLO4gOg0shzA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IM Fell French Canon\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imfellfrenchcanon/v21/-F6ufiNtDWYfYc-tDiyiw08rrghJszkK6coVPt1ozoPz.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/imfellfrenchcanon/v21/-F6gfiNtDWYfYc-tDiyiw08rrghJszkK6foXNNlKy5PzzrU.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IM Fell French Canon SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imfellfrenchcanonsc/v22/FBVmdCru5-ifcor2bgq9V89khWcmQghEURY7H3c0UBCVIVqH.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IM Fell Great Primer\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imfellgreatprimer/v21/bx6aNwSJtayYxOkbYFsT6hMsLzX7u85rJorXvDo3SQY1.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/imfellgreatprimer/v21/bx6UNwSJtayYxOkbYFsT6hMsLzX7u85rJrrVtj4VTBY1N6U.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"IM Fell Great Primer SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imfellgreatprimersc/v21/ga6daxBOxyt6sCqz3fjZCTFCTUDMHagsQKdDTLf9BXz0s8FG.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Ibarra Real Nova\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/ibarrarealnova/v20/sZlSdQiA-DBIDCcaWtQzL4BZHoiDundw4ATyjed3EXdg5MDtVT9TWIvS.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/ibarrarealnova/v20/sZlSdQiA-DBIDCcaWtQzL4BZHoiDundw4ATyjed3EXdS5MDtVT9TWIvS.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/ibarrarealnova/v20/sZlSdQiA-DBIDCcaWtQzL4BZHoiDundw4ATyjed3EXe-48DtVT9TWIvS.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/ibarrarealnova/v20/sZlSdQiA-DBIDCcaWtQzL4BZHoiDundw4ATyjed3EXeH48DtVT9TWIvS.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/ibarrarealnova/v20/sZlsdQiA-DBIDCcaWtQzL4BZHoiDkH5CH9yb5n3ZFmKopyiuXztxXZvSkTo.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/ibarrarealnova/v20/sZlsdQiA-DBIDCcaWtQzL4BZHoiDkH5CH9yb5n3ZFmKopxquXztxXZvSkTo.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/ibarrarealnova/v20/sZlsdQiA-DBIDCcaWtQzL4BZHoiDkH5CH9yb5n3ZFmKop_apXztxXZvSkTo.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/ibarrarealnova/v20/sZlsdQiA-DBIDCcaWtQzL4BZHoiDkH5CH9yb5n3ZFmKop8-pXztxXZvSkTo.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Iceberg\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/iceberg/v20/8QIJdijAiM7o-qnZuIgOq7jkAOw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Iceland\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/iceland/v16/rax9HiuFsdMNOnWPWKxGADBbg0s.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Imbue\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/imbue/v21/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP8iWfOsNNK-Q4xY.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/imbue/v21/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP0iXfOsNNK-Q4xY.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/imbue/v21/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP5aXfOsNNK-Q4xY.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/imbue/v21/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP8iXfOsNNK-Q4xY.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/imbue/v21/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP_qXfOsNNK-Q4xY.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/imbue/v21/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoPxaQfOsNNK-Q4xY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/imbue/v21/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoPy-QfOsNNK-Q4xY.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/imbue/v21/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP0iQfOsNNK-Q4xY.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/imbue/v21/RLpXK5P16Ki3fXhj5cvGrqjocPk4n-gVX3M93TnrnvhoP2GQfOsNNK-Q4xY.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Imperial Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imperialscript/v3/5DCPAKrpzy_H98IV2ISnZBbGrVNvPenlvttWNg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Imprima\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/imprima/v16/VEMxRoN7sY3yuy-7-oWHyDzktPo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Inconsolata\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v31\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/inconsolata/v31/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7LppwU8aRr8lleY2co.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/inconsolata/v31/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp9s8aRr8lleY2co.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/inconsolata/v31/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp4U8aRr8lleY2co.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/inconsolata/v31/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp7c8aRr8lleY2co.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/inconsolata/v31/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp1s7aRr8lleY2co.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/inconsolata/v31/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lpp2I7aRr8lleY2co.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/inconsolata/v31/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7LppwU7aRr8lleY2co.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/inconsolata/v31/QldgNThLqRwH-OJ1UHjlKENVzkWGVkL3GZQmAwLYxYWI2qfdm7Lppyw7aRr8lleY2co.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Inder\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/inder/v14/w8gUH2YoQe8_4vq6pw-P3U4O.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Indie Flower\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/indieflower/v17/m8JVjfNVeKWVnh3QMuKkFcZlbkGG1dKEDw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Ingrid Darling\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/ingriddarling/v2/LDIrapaJNxUtSuFdw-9yf4rCPsLOub458jGL.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Inika\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/inika/v21/rnCm-x5X3QP-phTHRcc2s2XH.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/inika/v21/rnCr-x5X3QP-pix7auM-mHnOSOuk.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Inknut Antiqua\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/inknutantiqua/v14/Y4GRYax7VC4ot_qNB4nYpBdaKU2vwrj5bBoIYJNf.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/inknutantiqua/v14/Y4GSYax7VC4ot_qNB4nYpBdaKXUD6pzxRwYB.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/inknutantiqua/v14/Y4GRYax7VC4ot_qNB4nYpBdaKU33w7j5bBoIYJNf.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/inknutantiqua/v14/Y4GRYax7VC4ot_qNB4nYpBdaKU3bxLj5bBoIYJNf.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/inknutantiqua/v14/Y4GRYax7VC4ot_qNB4nYpBdaKU2_xbj5bBoIYJNf.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/inknutantiqua/v14/Y4GRYax7VC4ot_qNB4nYpBdaKU2jxrj5bBoIYJNf.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/inknutantiqua/v14/Y4GRYax7VC4ot_qNB4nYpBdaKU2Hx7j5bBoIYJNf.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Inria Sans\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/inriasans/v14/ptRPTiqXYfZMCOiVj9kQ3ELaDQtFqeY3fX4.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/inriasans/v14/ptRRTiqXYfZMCOiVj9kQ1OzAgQlPrcQybX4pQA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/inriasans/v14/ptRMTiqXYfZMCOiVj9kQ5O7yKQNute8.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/inriasans/v14/ptROTiqXYfZMCOiVj9kQ1Oz4LSFrpe8uZA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/inriasans/v14/ptRPTiqXYfZMCOiVj9kQ3FLdDQtFqeY3fX4.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/inriasans/v14/ptRRTiqXYfZMCOiVj9kQ1OzAkQ5PrcQybX4pQA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Inria Serif\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/inriaserif/v14/fC14PYxPY3rXxEndZJAzN3wAVQjFhFyta3xN.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/inriaserif/v14/fC16PYxPY3rXxEndZJAzN3SuT4THjliPbmxN0_E.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/inriaserif/v14/fC1lPYxPY3rXxEndZJAzN0SsfSzNr0Ck.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/inriaserif/v14/fC1nPYxPY3rXxEndZJAzN3SudyjvqlCkcmU.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/inriaserif/v14/fC14PYxPY3rXxEndZJAzN3wQUgjFhFyta3xN.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/inriaserif/v14/fC16PYxPY3rXxEndZJAzN3SuT5TAjliPbmxN0_E.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Inspiration\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/inspiration/v3/x3dkckPPZa6L4wIg5cZOEvoGnSrlBBsy.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Inter\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/inter/v12/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuLyeMZhrib2Bg-4.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/inter/v12/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuDyfMZhrib2Bg-4.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/inter/v12/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuOKfMZhrib2Bg-4.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/inter/v12/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuLyfMZhrib2Bg-4.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/inter/v12/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuI6fMZhrib2Bg-4.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/inter/v12/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuGKYMZhrib2Bg-4.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/inter/v12/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuFuYMZhrib2Bg-4.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/inter/v12/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuDyYMZhrib2Bg-4.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/inter/v12/UcCO3FwrK3iLTeHuS_fvQtMwCp50KnMw2boKoduKmMEVuBWYMZhrib2Bg-4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Inter Tight\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2023-01-10\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/intertight/v2/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjDw6qXCRToK8EPg.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/intertight/v2/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjjw-qXCRToK8EPg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/intertight/v2/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjUQ-qXCRToK8EPg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/intertight/v2/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjDw-qXCRToK8EPg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/intertight/v2/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjPQ-qXCRToK8EPg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/intertight/v2/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mj0QiqXCRToK8EPg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/intertight/v2/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mj6AiqXCRToK8EPg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/intertight/v2/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjjwiqXCRToK8EPg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/intertight/v2/NGSnv5HMAFg6IuGlBNMjxJEL2VmU3NS7Z2mjpgiqXCRToK8EPg.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/intertight/v2/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0xCHi5XgqoUPvi5.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/intertight/v2/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0zCHy5XgqoUPvi5.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/intertight/v2/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0wcHy5XgqoUPvi5.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/intertight/v2/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0xCHy5XgqoUPvi5.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/intertight/v2/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0xwHy5XgqoUPvi5.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/intertight/v2/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0ycGC5XgqoUPvi5.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/intertight/v2/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0ylGC5XgqoUPvi5.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/intertight/v2/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0zCGC5XgqoUPvi5.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/intertight/v2/NGShv5HMAFg6IuGlBNMjxLsC66ZMtb8hyW62x0zrGC5XgqoUPvi5.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Irish Grover\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/irishgrover/v23/buExpoi6YtLz2QW7LA4flVgf-P5Oaiw4cw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Island Moments\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/islandmoments/v3/NaPBcZfVGvBdxIt7Ar0qzkXJF-TGIohbZ6SY.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Istok Web\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/istokweb/v20/3qTvojGmgSyUukBzKslZAWF-9kIIaQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/istokweb/v20/3qTpojGmgSyUukBzKslpA2t61EcYaQ7F.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/istokweb/v20/3qTqojGmgSyUukBzKslhvU5a_mkUYBfcMw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/istokweb/v20/3qT0ojGmgSyUukBzKslpA1PG-2MQQhLMMygN.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Italiana\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/italiana/v16/QldNNTtLsx4E__B0XTmRY31Wx7Vv.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Italianno\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/italianno/v16/dg4n_p3sv6gCJkwzT6Rnj5YpQwM-gg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Itim\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/itim/v10/0nknC9ziJOYewARKkc7ZdwU.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jacques Francois\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/jacquesfrancois/v20/ZXu9e04ZvKeOOHIe1TMahbcIU2cgmcPqoeRWfbs.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jacques Francois Shadow\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/jacquesfrancoisshadow/v21/KR1FBtOz8PKTMk-kqdkLVrvR0ECFrB6Pin-2_q8VsHuV5ULS.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jaldi\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/jaldi/v12/or3sQ67z0_CI30NUZpD_B6g8.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/jaldi/v12/or3hQ67z0_CI33voSbT3LLQ1niPn.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"JetBrains Mono\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8yK1jPVmUsaaDhw.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8SKxjPVmUsaaDhw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8lqxjPVmUsaaDhw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8yKxjPVmUsaaDhw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8-qxjPVmUsaaDhw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8FqtjPVmUsaaDhw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8L6tjPVmUsaaDhw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDbY2o-flEEny0FZhsfKu5WU4zr3E_BX0PnT8RD8SKtjPVmUsaaDhw.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO-Lf1OQk6OThxPA.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO8LflOQk6OThxPA.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO_VflOQk6OThxPA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO-LflOQk6OThxPA.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO-5flOQk6OThxPA.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO9VeVOQk6OThxPA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO9seVOQk6OThxPA.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/jetbrainsmono/v13/tDba2o-flEEny0FZhsfKu5WU4xD-IQ-PuZJJXxfpAO8LeVOQk6OThxPA.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jim Nightshade\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/jimnightshade/v20/PlIkFlu9Pb08Q8HLM1PxmB0g-OS4V3qKaMxD.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Joan\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/joan/v1/ZXupe1oZsqWRbRdH8X1p_Ng.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jockey One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/jockeyone/v15/HTxpL2g2KjCFj4x8WI6ArIb7HYOk4xc.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jolly Lodger\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/jollylodger/v20/BXRsvFTAh_bGkA1uQ48dlB3VWerT3ZyuqA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jomhuria\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/jomhuria/v18/Dxxp8j-TMXf-llKur2b1MOGbC3Dh.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jomolhari\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"tibetan\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/jomolhari/v14/EvONzA1M1Iw_CBd2hsQCF1IZKq5INg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Josefin Sans\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_DjRXMFrLgTsQV0.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_LjQXMFrLgTsQV0.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_GbQXMFrLgTsQV0.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_DjQXMFrLgTsQV0.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_ArQXMFrLgTsQV0.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_ObXXMFrLgTsQV0.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3PZQNVED7rKGKxtqIqX5E-AVSJrOCfjY46_N_XXMFrLgTsQV0.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCTtINhKibpUV3MEQ.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCTNIJhKibpUV3MEQ.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCT6oJhKibpUV3MEQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCTtIJhKibpUV3MEQ.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCThoJhKibpUV3MEQ.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCTaoVhKibpUV3MEQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/josefinsans/v25/Qw3JZQNVED7rKGKxtqIqX5EUCGZ2dIn0FyA96fCTU4VhKibpUV3MEQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Josefin Slab\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-07-12\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W71mtd3k3K6CcEyI.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W79msd3k3K6CcEyI.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W7wesd3k3K6CcEyI.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W71msd3k3K6CcEyI.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W72usd3k3K6CcEyI.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W74erd3k3K6CcEyI.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-swjwOK3Ps5GSJlNNkMalNpiZe_ldbOR4W776rd3k3K6CcEyI.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvnzs9L4KZAyK43w.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvHzo9L4KZAyK43w.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvwTo9L4KZAyK43w.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvnzo9L4KZAyK43w.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvrTo9L4KZAyK43w.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHvQT09L4KZAyK43w.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/josefinslab/v20/lW-qwjwOK3Ps5GSJlNNkMalnrxShJj4wo7AR-pHveD09L4KZAyK43w.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jost\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/jost/v14/92zPtBhPNqw79Ij1E865zBUv7myjJAVGPokMmuHL.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/jost/v14/92zPtBhPNqw79Ij1E865zBUv7mwjJQVGPokMmuHL.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/jost/v14/92zPtBhPNqw79Ij1E865zBUv7mz9JQVGPokMmuHL.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/jost/v14/92zPtBhPNqw79Ij1E865zBUv7myjJQVGPokMmuHL.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/jost/v14/92zPtBhPNqw79Ij1E865zBUv7myRJQVGPokMmuHL.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/jost/v14/92zPtBhPNqw79Ij1E865zBUv7mx9IgVGPokMmuHL.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/jost/v14/92zPtBhPNqw79Ij1E865zBUv7mxEIgVGPokMmuHL.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/jost/v14/92zPtBhPNqw79Ij1E865zBUv7mwjIgVGPokMmuHL.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/jost/v14/92zPtBhPNqw79Ij1E865zBUv7mwKIgVGPokMmuHL.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/jost/v14/92zJtBhPNqw73oHH7BbQp4-B6XlrZu0ENI0un_HLMEo.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/jost/v14/92zJtBhPNqw73oHH7BbQp4-B6XlrZm0FNI0un_HLMEo.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/jost/v14/92zJtBhPNqw73oHH7BbQp4-B6XlrZrMFNI0un_HLMEo.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/jost/v14/92zJtBhPNqw73oHH7BbQp4-B6XlrZu0FNI0un_HLMEo.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/jost/v14/92zJtBhPNqw73oHH7BbQp4-B6XlrZt8FNI0un_HLMEo.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/jost/v14/92zJtBhPNqw73oHH7BbQp4-B6XlrZjMCNI0un_HLMEo.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/jost/v14/92zJtBhPNqw73oHH7BbQp4-B6XlrZgoCNI0un_HLMEo.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/jost/v14/92zJtBhPNqw73oHH7BbQp4-B6XlrZm0CNI0un_HLMEo.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/jost/v14/92zJtBhPNqw73oHH7BbQp4-B6XlrZkQCNI0un_HLMEo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Joti One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/jotione/v21/Z9XVDmdJQAmWm9TwaYTe4u2El6GC.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jua\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/jua/v13/co3KmW9ljjAjc-DZCsKgsg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Judson\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/judson/v18/FeVRS0Fbvbc14VxRD7N01bV7kg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/judson/v18/FeVTS0Fbvbc14VxhDblw97BrknZf.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/judson/v18/FeVSS0Fbvbc14Vxps5xQ3Z5nm29Gww.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Julee\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/julee/v22/TuGfUVB3RpZPQ6ZLodgzydtk.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Julius Sans One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/juliussansone/v14/1Pt2g8TAX_SGgBGUi0tGOYEga5W-xXEW6aGXHw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Junge\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/junge/v20/gokgH670Gl1lUqAdvhB7SnKm.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Jura\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"kayah-li\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/jura/v24/z7NOdRfiaC4Vd8hhoPzfb5vBTP0D7auhTfmrH_rt.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/jura/v24/z7NOdRfiaC4Vd8hhoPzfb5vBTP1d7auhTfmrH_rt.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/jura/v24/z7NOdRfiaC4Vd8hhoPzfb5vBTP1v7auhTfmrH_rt.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/jura/v24/z7NOdRfiaC4Vd8hhoPzfb5vBTP2D6quhTfmrH_rt.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/jura/v24/z7NOdRfiaC4Vd8hhoPzfb5vBTP266quhTfmrH_rt.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Just Another Hand\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/justanotherhand/v19/845CNN4-AJyIGvIou-6yJKyptyOpOcr_BmmlS5aw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Just Me Again Down Here\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/justmeagaindownhere/v24/MwQmbgXtz-Wc6RUEGNMc0QpRrfUh2hSdBBMoAuwHvqDwc_fg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"K2D\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/k2d/v9/J7aRnpF2V0ErE6UpvrIw74NL.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/k2d/v9/J7afnpF2V0EjdZ1NtLYS6pNLAjk.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/k2d/v9/J7aenpF2V0Erv4QJlJw85ppSGw.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/k2d/v9/J7acnpF2V0EjdZ3hlZY4xJ9CGyAa.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/k2d/v9/J7aenpF2V0Er24cJlJw85ppSGw.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/k2d/v9/J7acnpF2V0EjdZ2FlpY4xJ9CGyAa.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/k2d/v9/J7aTnpF2V0ETd68tnLcg7w.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/k2d/v9/J7aRnpF2V0EjdaUpvrIw74NL.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/k2d/v9/J7aenpF2V0Erg4YJlJw85ppSGw.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/k2d/v9/J7acnpF2V0EjdZ3dl5Y4xJ9CGyAa.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/k2d/v9/J7aenpF2V0Err4EJlJw85ppSGw.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/k2d/v9/J7acnpF2V0EjdZ3xkJY4xJ9CGyAa.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/k2d/v9/J7aenpF2V0Ery4AJlJw85ppSGw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/k2d/v9/J7acnpF2V0EjdZ2VkZY4xJ9CGyAa.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/k2d/v9/J7aenpF2V0Er14MJlJw85ppSGw.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/k2d/v9/J7acnpF2V0EjdZ2JkpY4xJ9CGyAa.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kadwa\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kadwa/v10/rnCm-x5V0g7iphTHRcc2s2XH.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kadwa/v10/rnCr-x5V0g7ipix7auM-mHnOSOuk.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kaisei Decol\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kaiseidecol/v8/bMrwmSqP45sidWf3QmfFW6iyW1EP22OjoA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kaiseidecol/v8/bMrvmSqP45sidWf3QmfFW6iKr3gr00i_qb57kA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kaiseidecol/v8/bMrvmSqP45sidWf3QmfFW6iK534r00i_qb57kA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kaisei HarunoUmi\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kaiseiharunoumi/v8/HI_RiZQSLqBQoAHhK_C6N_nzy_jcGsv5sM8u3mk.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kaiseiharunoumi/v8/HI_WiZQSLqBQoAHhK_C6N_nzy_jcIj_QlMcFwmC9FAU.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kaiseiharunoumi/v8/HI_WiZQSLqBQoAHhK_C6N_nzy_jcInfWlMcFwmC9FAU.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kaisei Opti\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kaiseiopti/v8/QldKNThJphYb8_g6c2nlIFle7KlmxuHx.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kaiseiopti/v8/QldXNThJphYb8_g6c2nlIGGqxY1u7f34DYwn.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kaiseiopti/v8/QldXNThJphYb8_g6c2nlIGHiw41u7f34DYwn.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kaisei Tokumin\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kaiseitokumin/v8/Gg8sN5wdZg7xCwuMsylww2ZiQkJf1l0pj946.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kaiseitokumin/v8/Gg8vN5wdZg7xCwuMsylww2ZiQnqr_3khpMIzeI6v.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kaiseitokumin/v8/Gg8vN5wdZg7xCwuMsylww2ZiQnrj-XkhpMIzeI6v.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/kaiseitokumin/v8/Gg8vN5wdZg7xCwuMsylww2ZiQnr_-nkhpMIzeI6v.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kalam\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/kalam/v16/YA9Qr0Wd4kDdMtD6GgLLmCUItqGt.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/kalam/v16/YA9dr0Wd4kDdMuhWMibDszkB.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kalam/v16/YA9Qr0Wd4kDdMtDqHQLLmCUItqGt.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kameron\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kameron/v15/vm82dR7vXErQxuznsL4wL-XIYH8.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kameron/v15/vm8zdR7vXErQxuzniAIfC-3jfHb--NY.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kanit\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/kanit/v12/nKKX-Go6G5tXcr72GwWKcaxALFs.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/kanit/v12/nKKV-Go6G5tXcraQI2GAdY5FPFtrGw.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/kanit/v12/nKKU-Go6G5tXcr5aOiWgX6BJNUJy.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/kanit/v12/nKKS-Go6G5tXcraQI82hVaRrMFJyAu4.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/kanit/v12/nKKU-Go6G5tXcr4-OSWgX6BJNUJy.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/kanit/v12/nKKS-Go6G5tXcraQI6miVaRrMFJyAu4.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/kanit/v12/nKKZ-Go6G5tXcoaSEQGodLxA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/kanit/v12/nKKX-Go6G5tXcraQGwWKcaxALFs.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kanit/v12/nKKU-Go6G5tXcr5mOCWgX6BJNUJy.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/kanit/v12/nKKS-Go6G5tXcraQI_GjVaRrMFJyAu4.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/kanit/v12/nKKU-Go6G5tXcr5KPyWgX6BJNUJy.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/kanit/v12/nKKS-Go6G5tXcraQI92kVaRrMFJyAu4.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kanit/v12/nKKU-Go6G5tXcr4uPiWgX6BJNUJy.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/kanit/v12/nKKS-Go6G5tXcraQI7mlVaRrMFJyAu4.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/kanit/v12/nKKU-Go6G5tXcr4yPSWgX6BJNUJy.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/kanit/v12/nKKS-Go6G5tXcraQI6WmVaRrMFJyAu4.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/kanit/v12/nKKU-Go6G5tXcr4WPCWgX6BJNUJy.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/kanit/v12/nKKS-Go6G5tXcraQI4GnVaRrMFJyAu4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kantumruy\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"khmer\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/kantumruy/v21/syk0-yJ0m7wyVb-f4FOPUtDlpn-UJ1H6Uw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/kantumruy/v21/sykx-yJ0m7wyVb-f4FO3_vjBrlSILg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kantumruy/v21/syk0-yJ0m7wyVb-f4FOPQtflpn-UJ1H6Uw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kantumruy Pro\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg1urUs0M34dR6dW.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg3urEs0M34dR6dW.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg0wrEs0M34dR6dW.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg1urEs0M34dR6dW.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg1crEs0M34dR6dW.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg2wq0s0M34dR6dW.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2TY5aECkp34vEBSPFOmJxwvk_pilU8OGNfyg2Jq0s0M34dR6dW.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim76N2OXo_QrdWlcU.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim7yN3OXo_QrdWlcU.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim7_13OXo_QrdWlcU.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim76N3OXo_QrdWlcU.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim75F3OXo_QrdWlcU.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim731wOXo_QrdWlcU.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/kantumruypro/v3/1q2RY5aECkp34vEBSPFOmJxwlEbbdY1VU_nxzRim70RwOXo_QrdWlcU.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Karantina\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/karantina/v11/buExpo24ccnh31GVMABxXCgf-P5Oaiw4cw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/karantina/v11/buE0po24ccnh31GVMABJ8AA78NVSYw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/karantina/v11/buExpo24ccnh31GVMABxTC8f-P5Oaiw4cw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Karla\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/karla/v23/qkBIXvYC6trAT55ZBi1ueQVIjQTDeJqqFENLR7fHGw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/karla/v23/qkBIXvYC6trAT55ZBi1ueQVIjQTDppqqFENLR7fHGw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/karla/v23/qkBIXvYC6trAT55ZBi1ueQVIjQTD-JqqFENLR7fHGw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/karla/v23/qkBIXvYC6trAT55ZBi1ueQVIjQTDypqqFENLR7fHGw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/karla/v23/qkBIXvYC6trAT55ZBi1ueQVIjQTDJp2qFENLR7fHGw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/karla/v23/qkBIXvYC6trAT55ZBi1ueQVIjQTDH52qFENLR7fHGw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/karla/v23/qkBIXvYC6trAT55ZBi1ueQVIjQTDeJ2qFENLR7fHGw.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/karla/v23/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNnCV0lPZbLXGxGR.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/karla/v23/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNkcV0lPZbLXGxGR.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/karla/v23/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNlCV0lPZbLXGxGR.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/karla/v23/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNlwV0lPZbLXGxGR.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/karla/v23/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNmcUElPZbLXGxGR.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/karla/v23/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNmlUElPZbLXGxGR.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/karla/v23/qkBKXvYC6trAT7RQNNK2EG7SIwPWMNnCUElPZbLXGxGR.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Karma\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/karma/v16/va9F4kzAzMZRGLjDY8Z_uqzGQC_-.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/karma/v16/va9I4kzAzMZRGIBvS-J3kbDP.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/karma/v16/va9F4kzAzMZRGLibYsZ_uqzGQC_-.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/karma/v16/va9F4kzAzMZRGLi3ZcZ_uqzGQC_-.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/karma/v16/va9F4kzAzMZRGLjTZMZ_uqzGQC_-.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Katibeh\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/katibeh/v17/ZGjXol5MQJog4bxDaC1RVDNdGDs.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kaushan Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kaushanscript/v14/vm8vdRfvXFLG3OLnsO15WYS5DF7_ytN3M48a.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kavivanar\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tamil\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kavivanar/v18/o-0IIpQgyXYSwhxP7_Jb4j5Ba_2c7A.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kavoon\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kavoon/v21/pxiFyp4_scRYhlU4NLr6f1pdEQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kdam Thmor Pro\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kdamthmorpro/v1/EJRPQgAzVdcI-Qdvt34jzurnGA7_j89I8ZWb.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Keania One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/keaniaone/v20/zOL54pXJk65E8pXardnuycRuv-hHkOs.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kelly Slab\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kellyslab/v15/-W_7XJX0Rz3cxUnJC5t6TkMBf50kbiM.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kenia\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kenia/v24/jizURE5PuHQH9qCONUGswfGM.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Khand\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/khand/v17/TwMN-IINQlQQ0bL5cFE3ZwaH__-C.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/khand/v17/TwMA-IINQlQQ0YpVWHU_TBqO.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/khand/v17/TwMN-IINQlQQ0bKhcVE3ZwaH__-C.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/khand/v17/TwMN-IINQlQQ0bKNdlE3ZwaH__-C.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/khand/v17/TwMN-IINQlQQ0bLpd1E3ZwaH__-C.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Khmer\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/khmer/v25/MjQImit_vPPwpF-BpN2EeYmD.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Khula\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/khula/v12/OpNPnoEOns3V7G-ljCvUrC59XwXD.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/khula/v12/OpNCnoEOns3V7FcJpA_chzJ0.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/khula/v12/OpNPnoEOns3V7G_RiivUrC59XwXD.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/khula/v12/OpNPnoEOns3V7G-1iyvUrC59XwXD.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/khula/v12/OpNPnoEOns3V7G-piCvUrC59XwXD.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kings\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kings/v5/8AtnGsK4O5CYXU_Iq6GSPaHS.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kirang Haerang\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kiranghaerang/v20/E21-_dn_gvvIjhYON1lpIU4-bcqvWPaJq4no.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kite One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kiteone/v20/70lQu7shLnA_E02vyq1b6HnGO4uA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kiwi Maru\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/kiwimaru/v14/R70djykGkuuDep-hRg6gNCi0Vxn9R5ShnA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/kiwimaru/v14/R70YjykGkuuDep-hRg6YmACQXzLhTg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kiwimaru/v14/R70djykGkuuDep-hRg6gbCm0Vxn9R5ShnA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Klee One\",\n      \"variants\": [\n        \"regular\",\n        \"600\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"greek-ext\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kleeone/v7/LDIxapCLNRc6A8oT4q4AOeekWPrP.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/kleeone/v7/LDI2apCLNRc6A8oT4pbYF8Osc-bGkqIw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Knewave\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/knewave/v14/sykz-yx0lLcxQaSItSq9-trEvlQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"KoHo\",\n      \"variants\": [\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/koho/v16/K2FxfZ5fmddNPuE1WJ75JoKhHys.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/koho/v16/K2FzfZ5fmddNNisssJ_zIqCkDyvqZA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/koho/v16/K2FxfZ5fmddNPoU2WJ75JoKhHys.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/koho/v16/K2FzfZ5fmddNNiss1JzzIqCkDyvqZA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/koho/v16/K2F-fZ5fmddNBikefJbSOos.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/koho/v16/K2FwfZ5fmddNNisUeLTXKou4Bg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/koho/v16/K2FxfZ5fmddNPt03WJ75JoKhHys.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/koho/v16/K2FzfZ5fmddNNissjJ3zIqCkDyvqZA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/koho/v16/K2FxfZ5fmddNPvEwWJ75JoKhHys.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/koho/v16/K2FzfZ5fmddNNissoJrzIqCkDyvqZA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/koho/v16/K2FxfZ5fmddNPpUxWJ75JoKhHys.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/koho/v16/K2FzfZ5fmddNNissxJvzIqCkDyvqZA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kodchasan\",\n      \"variants\": [\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cX0aUPOAJv9sG4I-DJeR1Cggeqo3eMeoA.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cXqaUPOAJv9sG4I-DJWjUlIgOCs_-YOoIgN.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cX0aUPOAJv9sG4I-DJeI1Oggeqo3eMeoA.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cXqaUPOAJv9sG4I-DJWjUksg-Cs_-YOoIgN.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cXxaUPOAJv9sG4I-DJmj3uEicG01A.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cX3aUPOAJv9sG4I-DJWjXGAq8Sk1PoH.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cX0aUPOAJv9sG4I-DJee1Kggeqo3eMeoA.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cXqaUPOAJv9sG4I-DJWjUl0guCs_-YOoIgN.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cX0aUPOAJv9sG4I-DJeV1Wggeqo3eMeoA.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cXqaUPOAJv9sG4I-DJWjUlYheCs_-YOoIgN.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cX0aUPOAJv9sG4I-DJeM1Sggeqo3eMeoA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/kodchasan/v16/1cXqaUPOAJv9sG4I-DJWjUk8hOCs_-YOoIgN.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Koh Santepheap\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/kohsantepheap/v9/gNMfW3p6SJbwyGj2rBZyeOrTjNuFHVyTtjNJUWU.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/kohsantepheap/v9/gNMeW3p6SJbwyGj2rBZyeOrTjNtNP3y5mD9ASHz5.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/kohsantepheap/v9/gNMdW3p6SJbwyGj2rBZyeOrTjOPhF1ixsyNJ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kohsantepheap/v9/gNMeW3p6SJbwyGj2rBZyeOrTjNtdOHy5mD9ASHz5.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/kohsantepheap/v9/gNMeW3p6SJbwyGj2rBZyeOrTjNtlOny5mD9ASHz5.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kolker Brush\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kolkerbrush/v3/iJWDBXWRZjfKWdvmzwvvog3-7KJ6x8qNUQ.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kosugi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kosugi/v14/pxiFyp4_v8FCjlI4NLr6f1pdEQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kosugi Maru\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kosugimaru/v14/0nksC9PgP_wGh21A2KeqGiTqivr9iBq_.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kotta One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kottaone/v20/S6u_w41LXzPc_jlfNWqPHA3s5dwt7w.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Koulen\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/koulen/v25/AMOQz46as3KIBPeWgnA9kuYMUg.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kranky\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kranky/v24/hESw6XVgJzlPsFnMpheEZo_H_w.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kreon\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v32\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/kreon/v32/t5t9IRIUKY-TFF_LW5lnMR3v2DnvPNimejUfp2dWNg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/kreon/v32/t5t9IRIUKY-TFF_LW5lnMR3v2DnvYtimejUfp2dWNg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kreon/v32/t5t9IRIUKY-TFF_LW5lnMR3v2DnvUNimejUfp2dWNg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/kreon/v32/t5t9IRIUKY-TFF_LW5lnMR3v2DnvvN-mejUfp2dWNg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kreon/v32/t5t9IRIUKY-TFF_LW5lnMR3v2Dnvhd-mejUfp2dWNg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kristi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kristi/v17/uK_y4ricdeU6zwdRCh0TMv6EXw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Krona One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kronaone/v14/jAnEgHdjHcjgfIb1ZcUCMY-h3cWkWg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Krub\",\n      \"variants\": [\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/krub/v9/sZlEdRyC6CRYZo47KLF4R6gWaf8.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/krub/v9/sZlGdRyC6CRYbkQiwLByQ4oTef_6gQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/krub/v9/sZlEdRyC6CRYZuo4KLF4R6gWaf8.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/krub/v9/sZlGdRyC6CRYbkQipLNyQ4oTef_6gQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/krub/v9/sZlLdRyC6CRYXkYQDLlTW6E.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/krub/v9/sZlFdRyC6CRYbkQaCJtWS6EPcA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/krub/v9/sZlEdRyC6CRYZrI5KLF4R6gWaf8.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/krub/v9/sZlGdRyC6CRYbkQi_LJyQ4oTef_6gQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/krub/v9/sZlEdRyC6CRYZp4-KLF4R6gWaf8.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/krub/v9/sZlGdRyC6CRYbkQi0LVyQ4oTef_6gQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/krub/v9/sZlEdRyC6CRYZvo_KLF4R6gWaf8.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/krub/v9/sZlGdRyC6CRYbkQitLRyQ4oTef_6gQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kufam\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kufam/v20/C8c-4cY7pG7w_oSJDszBXsKCcBH3lqk7qQCJHvIwYg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kufam/v20/C8c-4cY7pG7w_oSJDszBXsKCcBH3pKk7qQCJHvIwYg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/kufam/v20/C8c-4cY7pG7w_oSJDszBXsKCcBH3SK47qQCJHvIwYg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kufam/v20/C8c-4cY7pG7w_oSJDszBXsKCcBH3ca47qQCJHvIwYg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/kufam/v20/C8c-4cY7pG7w_oSJDszBXsKCcBH3Fq47qQCJHvIwYg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/kufam/v20/C8c-4cY7pG7w_oSJDszBXsKCcBH3P647qQCJHvIwYg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/kufam/v20/C8c84cY7pG7w_q6APDMZN6kY3hbiXurT6gqNPPcgYp0i.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/kufam/v20/C8c84cY7pG7w_q6APDMZN6kY3hbiXurh6gqNPPcgYp0i.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/kufam/v20/C8c84cY7pG7w_q6APDMZN6kY3hbiXuoN7QqNPPcgYp0i.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/kufam/v20/C8c84cY7pG7w_q6APDMZN6kY3hbiXuo07QqNPPcgYp0i.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/kufam/v20/C8c84cY7pG7w_q6APDMZN6kY3hbiXupT7QqNPPcgYp0i.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/kufam/v20/C8c84cY7pG7w_q6APDMZN6kY3hbiXup67QqNPPcgYp0i.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kulim Park\",\n      \"variants\": [\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/kulimpark/v14/fdN49secq3hflz1Uu3IwjJYNwa5aZbUvGjU.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/kulimpark/v14/fdNm9secq3hflz1Uu3IwhFwUKa9QYZcqCjVVUA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/kulimpark/v14/fdN49secq3hflz1Uu3IwjPIOwa5aZbUvGjU.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/kulimpark/v14/fdNm9secq3hflz1Uu3IwhFwUTaxQYZcqCjVVUA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/kulimpark/v14/fdN79secq3hflz1Uu3IwtF4m5aZxebw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/kulimpark/v14/fdN59secq3hflz1Uu3IwhFws4YR0abw2Aw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/kulimpark/v14/fdN49secq3hflz1Uu3IwjIYIwa5aZbUvGjU.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/kulimpark/v14/fdNm9secq3hflz1Uu3IwhFwUOapQYZcqCjVVUA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kulimpark/v14/fdN49secq3hflz1Uu3IwjOIJwa5aZbUvGjU.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/kulimpark/v14/fdNm9secq3hflz1Uu3IwhFwUXatQYZcqCjVVUA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kumar One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"gujarati\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kumarone/v17/bMr1mS-P958wYi6YaGeGNO6WU3oT0g.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kumar One Outline\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"gujarati\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kumaroneoutline/v17/Noao6VH62pyLP0fsrZ-v18wlUEcX9zDwRQu8EGKF.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kumbh Sans\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/kumbhsans/v12/c4mw1n92AsfhuCq6tVsaoIx1CHIi4kToNorqSyNIXIwSP0XD.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/kumbhsans/v12/c4mw1n92AsfhuCq6tVsaoIx1CHIi4kToNopqSiNIXIwSP0XD.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/kumbhsans/v12/c4mw1n92AsfhuCq6tVsaoIx1CHIi4kToNoq0SiNIXIwSP0XD.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/kumbhsans/v12/c4mw1n92AsfhuCq6tVsaoIx1CHIi4kToNorqSiNIXIwSP0XD.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/kumbhsans/v12/c4mw1n92AsfhuCq6tVsaoIx1CHIi4kToNorYSiNIXIwSP0XD.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/kumbhsans/v12/c4mw1n92AsfhuCq6tVsaoIx1CHIi4kToNoo0TSNIXIwSP0XD.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/kumbhsans/v12/c4mw1n92AsfhuCq6tVsaoIx1CHIi4kToNooNTSNIXIwSP0XD.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/kumbhsans/v12/c4mw1n92AsfhuCq6tVsaoIx1CHIi4kToNopqTSNIXIwSP0XD.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/kumbhsans/v12/c4mw1n92AsfhuCq6tVsaoIx1CHIi4kToNopDTSNIXIwSP0XD.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Kurale\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/kurale/v11/4iCs6KV9e9dXjho6eAT3v02QFg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"La Belle Aurore\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/labelleaurore/v16/RrQIbot8-mNYKnGNDkWlocovHeIIG-eFNVmULg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Labrada\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2023-02-16\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/labrada/v1/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9VTSgM4QPdUej17.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/labrada/v1/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9XTSwM4QPdUej17.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/labrada/v1/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9UNSwM4QPdUej17.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/labrada/v1/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9VTSwM4QPdUej17.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/labrada/v1/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9VhSwM4QPdUej17.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/labrada/v1/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9WNTAM4QPdUej17.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/labrada/v1/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9W0TAM4QPdUej17.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/labrada/v1/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9XTTAM4QPdUej17.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/labrada/v1/ieVh2Y9HLWefIpOyF1Vi3ZqDss1Px9X6TAM4QPdUej17.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/labrada/v1/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCOt6SvN2fy17-dE.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/labrada/v1/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCGt7SvN2fy17-dE.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/labrada/v1/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCLV7SvN2fy17-dE.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/labrada/v1/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCOt7SvN2fy17-dE.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/labrada/v1/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCNl7SvN2fy17-dE.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/labrada/v1/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCDV8SvN2fy17-dE.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/labrada/v1/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCAx8SvN2fy17-dE.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/labrada/v1/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCGt8SvN2fy17-dE.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/labrada/v1/ieVv2Y9HLWefIpOyPVxQIkLq2VfhwMCbCEJ8SvN2fy17-dE.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lacquer\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lacquer/v15/EYqzma1QwqpG4_BBB7-AXhttQ5I.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Laila\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/laila/v13/LYjBdG_8nE8jDLzxogNAh14nVcfe.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/laila/v13/LYjMdG_8nE8jDIRdiidIrEIu.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/laila/v13/LYjBdG_8nE8jDLypowNAh14nVcfe.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/laila/v13/LYjBdG_8nE8jDLyFpANAh14nVcfe.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/laila/v13/LYjBdG_8nE8jDLzhpQNAh14nVcfe.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lakki Reddy\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"telugu\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lakkireddy/v19/S6u5w49MUSzD9jlCPmvLZQfox9k97-xZ.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lalezar\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lalezar/v14/zrfl0HLVx-HwTP82UaDyIiL0RCg.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lancelot\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lancelot/v22/J7acnppxBGtQEulG4JY4xJ9CGyAa.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Langar\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"gurmukhi\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/langar/v26/kJEyBukW7AIlgjGVrTVZ99sqrQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lateef\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v27\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/lateef/v27/hESz6XVnNCxEvkb0bjygbqTb9nQ-RA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/lateef/v27/hESz6XVnNCxEvkb0Cj-gbqTb9nQ-RA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lateef/v27/hESw6XVnNCxEvkbMpheEZo_H_w.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lateef/v27/hESz6XVnNCxEvkb0Uj6gbqTb9nQ-RA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lateef/v27/hESz6XVnNCxEvkb0fjmgbqTb9nQ-RA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lateef/v27/hESz6XVnNCxEvkb0GjigbqTb9nQ-RA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/lateef/v27/hESz6XVnNCxEvkb0BjugbqTb9nQ-RA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lato\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/lato/v23/S6u8w4BMUTPHh30wWyWrFCbw7A.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/lato/v23/S6u-w4BMUTPHjxsIPy-vNiPg7MU0.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/lato/v23/S6u9w4BMUTPHh7USew-FGC_p9dw.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/lato/v23/S6u_w4BMUTPHjxsI9w2PHA3s5dwt7w.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lato/v23/S6uyw4BMUTPHvxk6XweuBCY.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/lato/v23/S6u8w4BMUTPHjxswWyWrFCbw7A.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lato/v23/S6u9w4BMUTPHh6UVew-FGC_p9dw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/lato/v23/S6u_w4BMUTPHjxsI5wqPHA3s5dwt7w.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/lato/v23/S6u9w4BMUTPHh50Xew-FGC_p9dw.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/lato/v23/S6u_w4BMUTPHjxsI3wiPHA3s5dwt7w.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lavishly Yours\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lavishlyyours/v2/jizDREVIvGwH5OjiZmX9r5z_WxUY0TY7ikbI.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"League Gothic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v6\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/leaguegothic/v6/qFdR35CBi4tvBz81xy7WG7ep-BQAY7Krj7feObpH_-amidQ6Q9hn.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"League Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/leaguescript/v24/CSR54zpSlumSWj9CGVsoBZdeaNNUuOwkC2s.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"League Spartan\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v6\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/leaguespartan/v6/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvM_oXpBMdcFguczA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/leaguespartan/v6/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMfoTpBMdcFguczA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/leaguespartan/v6/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMoITpBMdcFguczA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/leaguespartan/v6/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvM_oTpBMdcFguczA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/leaguespartan/v6/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMzITpBMdcFguczA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/leaguespartan/v6/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMIIPpBMdcFguczA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/leaguespartan/v6/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMGYPpBMdcFguczA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/leaguespartan/v6/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMfoPpBMdcFguczA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/leaguespartan/v6/kJEnBuEW6A0lliaV_m88ja5Twtx8BWhtkDVmjZvMV4PpBMdcFguczA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Leckerli One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/leckerlione/v16/V8mCoQH8VCsNttEnxnGQ-1itLZxcBtItFw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Ledger\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/ledger/v16/j8_q6-HK1L3if_sxm8DwHTBhHw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lekton\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lekton/v17/SZc43FDmLaWmWpBeXxfonUPL6Q.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/lekton/v17/SZc63FDmLaWmWpBuXR3sv0bb6StO.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lekton/v17/SZc73FDmLaWmWpBm4zjMlWjX4DJXgQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lemon\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lemon/v14/HI_EiYEVKqRMq0jBSZXAQ4-d.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lemonada\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/lemonada/v22/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGJOt2mfWc3Z2pTg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lemonada/v22/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGeut2mfWc3Z2pTg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lemonada/v22/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGSOt2mfWc3Z2pTg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lemonada/v22/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGpOx2mfWc3Z2pTg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lemonada/v22/0QI-MXFD9oygTWy_R-FFlwV-bgfR7QJGnex2mfWc3Z2pTg.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lexend\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/lexend/v17/wlptgwvFAVdoq2_F94zlCfv0bz1WCzsX_LBte6KuGEo.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/lexend/v17/wlptgwvFAVdoq2_F94zlCfv0bz1WC7sW_LBte6KuGEo.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/lexend/v17/wlptgwvFAVdoq2_F94zlCfv0bz1WC2UW_LBte6KuGEo.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lexend/v17/wlptgwvFAVdoq2_F94zlCfv0bz1WCzsW_LBte6KuGEo.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lexend/v17/wlptgwvFAVdoq2_F94zlCfv0bz1WCwkW_LBte6KuGEo.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lexend/v17/wlptgwvFAVdoq2_F94zlCfv0bz1WC-UR_LBte6KuGEo.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lexend/v17/wlptgwvFAVdoq2_F94zlCfv0bz1WC9wR_LBte6KuGEo.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/lexend/v17/wlptgwvFAVdoq2_F94zlCfv0bz1WC7sR_LBte6KuGEo.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/lexend/v17/wlptgwvFAVdoq2_F94zlCfv0bz1WC5IR_LBte6KuGEo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lexend Deca\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/lexenddeca/v17/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U48MxArBPCqLNflg.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/lexenddeca/v17/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4cM1ArBPCqLNflg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/lexenddeca/v17/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4rs1ArBPCqLNflg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lexenddeca/v17/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U48M1ArBPCqLNflg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lexenddeca/v17/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4ws1ArBPCqLNflg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lexenddeca/v17/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4LspArBPCqLNflg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lexenddeca/v17/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4F8pArBPCqLNflg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/lexenddeca/v17/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4cMpArBPCqLNflg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/lexenddeca/v17/K2FifZFYk-dHSE0UPPuwQ7CrD94i-NCKm-U4WcpArBPCqLNflg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lexend Exa\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/lexendexa/v24/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9r7T6bHHJ8BRq0b.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/lexendexa/v24/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9p7TqbHHJ8BRq0b.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/lexendexa/v24/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9qlTqbHHJ8BRq0b.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lexendexa/v24/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9r7TqbHHJ8BRq0b.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lexendexa/v24/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9rJTqbHHJ8BRq0b.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lexendexa/v24/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9olSabHHJ8BRq0b.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lexendexa/v24/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9ocSabHHJ8BRq0b.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/lexendexa/v24/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9p7SabHHJ8BRq0b.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/lexendexa/v24/UMBCrPdOoHOnxExyjdBeQCH18mulUxBvI9pSSabHHJ8BRq0b.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lexend Giga\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/lexendgiga/v24/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRC2LmE68oo6eepYQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/lexendgiga/v24/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRCWLiE68oo6eepYQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/lexendgiga/v24/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRChriE68oo6eepYQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lexendgiga/v24/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRC2LiE68oo6eepYQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lexendgiga/v24/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRC6riE68oo6eepYQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lexendgiga/v24/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRCBr-E68oo6eepYQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lexendgiga/v24/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRCP7-E68oo6eepYQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/lexendgiga/v24/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRCWL-E68oo6eepYQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/lexendgiga/v24/PlIuFl67Mah5Y8yMHE7lkUZPlTBo4MWFfNRCcb-E68oo6eepYQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lexend Mega\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/lexendmega/v24/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDL8fivveyiq9EqQw.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/lexendmega/v24/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLcfmvveyiq9EqQw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/lexendmega/v24/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLr_mvveyiq9EqQw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lexendmega/v24/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDL8fmvveyiq9EqQw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lexendmega/v24/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLw_mvveyiq9EqQw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lexendmega/v24/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLL_6vveyiq9EqQw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lexendmega/v24/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLFv6vveyiq9EqQw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/lexendmega/v24/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLcf6vveyiq9EqQw.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/lexendmega/v24/qFdX35aBi5JtHD41zSTFEuTByuvYFuE9IbDLWP6vveyiq9EqQw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lexend Peta\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/lexendpeta/v24/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgR6SFyW1YuRTsnfw.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/lexendpeta/v24/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRaSByW1YuRTsnfw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/lexendpeta/v24/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRtyByW1YuRTsnfw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lexendpeta/v24/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgR6SByW1YuRTsnfw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lexendpeta/v24/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgR2yByW1YuRTsnfw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lexendpeta/v24/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRNydyW1YuRTsnfw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lexendpeta/v24/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRDidyW1YuRTsnfw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/lexendpeta/v24/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRaSdyW1YuRTsnfw.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/lexendpeta/v24/BXR4vFPGjeLPh0kCfI4OkFX-UTQHSCaxvBgRQCdyW1YuRTsnfw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lexend Tera\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/lexendtera/v24/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiM5zITdpz0fYxcrQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/lexendtera/v24/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMZzMTdpz0fYxcrQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/lexendtera/v24/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMuTMTdpz0fYxcrQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lexendtera/v24/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiM5zMTdpz0fYxcrQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lexendtera/v24/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiM1TMTdpz0fYxcrQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lexendtera/v24/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMOTQTdpz0fYxcrQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lexendtera/v24/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMADQTdpz0fYxcrQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/lexendtera/v24/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMZzQTdpz0fYxcrQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/lexendtera/v24/RrQDbo98_jt_IXnBPwCWtYJLZ3P4hnaGKFiMTjQTdpz0fYxcrQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lexend Zetta\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/lexendzetta/v24/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy9bH0z5jbs8qbts.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/lexendzetta/v24/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy1bG0z5jbs8qbts.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/lexendzetta/v24/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy4jG0z5jbs8qbts.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/lexendzetta/v24/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy9bG0z5jbs8qbts.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lexendzetta/v24/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy-TG0z5jbs8qbts.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lexendzetta/v24/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCywjB0z5jbs8qbts.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lexendzetta/v24/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCyzHB0z5jbs8qbts.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/lexendzetta/v24/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy1bB0z5jbs8qbts.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/lexendzetta/v24/ll8uK2KYXje7CdOFnEWcU8synQbuVYjYB3BCy3_B0z5jbs8qbts.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Barcode 128\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librebarcode128/v26/cIfnMbdUsUoiW3O_hVviCwVjuLtXeJ_A_gMk0izH.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Barcode 128 Text\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librebarcode128text/v26/fdNv9tubt3ZEnz1Gu3I4-zppwZ9CWZ16Z0w5cV3Y6M90w4k.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Barcode 39\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librebarcode39/v19/-nFnOHM08vwC6h8Li1eQnP_AHzI2K_d709jy92k.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Barcode 39 Extended\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librebarcode39extended/v25/8At7Gt6_O5yNS0-K4Nf5U922qSzhJ3dUdfJpwNUgfNRCOZ1GOBw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Barcode 39 Extended Text\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librebarcode39extendedtext/v25/eLG1P_rwIgOiDA7yrs9LoKaYRVLQ1YldrrOnnL7xPO4jNP68fLIiPopNNA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Barcode 39 Text\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librebarcode39text/v26/sJoa3KhViNKANw_E3LwoDXvs5Un0HQ1vT-031RRL-9rYaw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Barcode EAN13 Text\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librebarcodeean13text/v19/wlpigxXFDU1_oCu9nfZytgIqSG0XRcJm_OQiB96PAGEki52WfA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Baskerville\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librebaskerville/v14/kmKnZrc3Hgbbcjq75U4uslyuy4kn0pNeYRI4CN2V.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/librebaskerville/v14/kmKhZrc3Hgbbcjq75U4uslyuy4kn0qNcaxYaDc2V2ro.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/librebaskerville/v14/kmKiZrc3Hgbbcjq75U4uslyuy4kn0qviTjYwI8Gcw6Oi.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Bodoni\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librebodoni/v3/_Xm--H45qDWDYULr5OfyZudXzSBgY2oMBGte6I1fwWzZcOb3U3s.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/librebodoni/v3/_Xm--H45qDWDYULr5OfyZudXzSBgY2oMBGte6L9fwWzZcOb3U3s.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/librebodoni/v3/_Xm--H45qDWDYULr5OfyZudXzSBgY2oMBGte6FNYwWzZcOb3U3s.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/librebodoni/v3/_Xm--H45qDWDYULr5OfyZudXzSBgY2oMBGte6GpYwWzZcOb3U3s.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/librebodoni/v3/_Xm4-H45qDWDYULr5OfyZud9xBKfuwNnnsVZ_UUcKS_TdMTyQ3syLg.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/librebodoni/v3/_Xm4-H45qDWDYULr5OfyZud9xBKfuwNnnsVZ_UUcGy_TdMTyQ3syLg.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/librebodoni/v3/_Xm4-H45qDWDYULr5OfyZud9xBKfuwNnnsVZ_UUc9yjTdMTyQ3syLg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/librebodoni/v3/_Xm4-H45qDWDYULr5OfyZud9xBKfuwNnnsVZ_UUczijTdMTyQ3syLg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Caslon Display\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librecaslondisplay/v14/TuGOUUFxWphYQ6YI6q9Xp61FQzxDRKmzr2lRdRhtCC4d.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Caslon Text\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/librecaslontext/v3/DdT878IGsGw1aF1JU10PUbTvNNaDMcq_3eNrHgO1.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/librecaslontext/v3/DdT678IGsGw1aF1JU10PUbTvNNaDMfq91-dJGxO1q9o.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/librecaslontext/v3/DdT578IGsGw1aF1JU10PUbTvNNaDMfID8sdjNR-8ssPt.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Libre Franklin\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhLsSUB9rIb-JH1g.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhrsWUB9rIb-JH1g.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhcMWUB9rIb-JH1g.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhLsWUB9rIb-JH1g.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhHMWUB9rIb-JH1g.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduh8MKUB9rIb-JH1g.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhycKUB9rIb-JH1g.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhrsKUB9rIb-JH1g.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizOREVItHgc8qDIbSTKq4XkRg8T88bjFuXOnduhh8KUB9rIb-JH1g.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oZ8RdDMTedX1sGE.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05ob8RNDMTedX1sGE.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oYiRNDMTedX1sGE.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oZ8RNDMTedX1sGE.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oZORNDMTedX1sGE.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oaiQ9DMTedX1sGE.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05oabQ9DMTedX1sGE.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05ob8Q9DMTedX1sGE.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/librefranklin/v13/jizMREVItHgc8qDIbSTKq4XkRiUawTk7f45UM9y05obVQ9DMTedX1sGE.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Licorice\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/licorice/v3/t5tjIR8TMomTCAyjNk23hqLgzCHu.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Life Savers\",\n      \"variants\": [\n        \"regular\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lifesavers/v18/ZXuie1UftKKabUQMgxAal_lrFgpbuNvB.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lifesavers/v18/ZXu_e1UftKKabUQMgxAal8HXOS5Tk8fIpPRW.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/lifesavers/v18/ZXu_e1UftKKabUQMgxAal8HLOi5Tk8fIpPRW.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lilita One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lilitaone/v13/i7dPIFZ9Zz-WBtRtedDbUEZ2RFq7AwU.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lily Script One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lilyscriptone/v15/LhW9MV7ZMfIPdMxeBjBvFN8SXLS4gsSjQNsRMg.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Limelight\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/limelight/v16/XLYkIZL7aopJVbZJHDuYPeNGrnY2TA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Linden Hill\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lindenhill/v22/-F61fjxoKSg9Yc3hZgO8ygFI7CwC009k.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/lindenhill/v22/-F63fjxoKSg9Yc3hZgO8yjFK5igg1l9kn-s.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Literata\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v30\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/literata/v30/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbJG_F_bcTWCWp8g.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/literata/v30/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbE-_F_bcTWCWp8g.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/literata/v30/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbBG_F_bcTWCWp8g.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/literata/v30/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbCO_F_bcTWCWp8g.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/literata/v30/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbM-4F_bcTWCWp8g.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/literata/v30/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbPa4F_bcTWCWp8g.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/literata/v30/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbJG4F_bcTWCWp8g.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/literata/v30/or3PQ6P12-iJxAIgLa78DkrbXsDgk0oVDaDPYLanFLHpPf2TbLi4F_bcTWCWp8g.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/literata/v30/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8f7XWSUKTt8iVow.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/literata/v30/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8obXWSUKTt8iVow.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/literata/v30/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8_7XWSUKTt8iVow.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/literata/v30/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8zbXWSUKTt8iVow.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/literata/v30/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8IbLWSUKTt8iVow.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/literata/v30/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8GLLWSUKTt8iVow.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/literata/v30/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8f7LWSUKTt8iVow.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/literata/v30/or3NQ6P12-iJxAIgLYT1PLs1Zd0nfUwAbeGVKoRYzNiCp1OUedn8VrLWSUKTt8iVow.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Liu Jian Mao Cao\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"chinese-simplified\",\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/liujianmaocao/v15/~ChIKEExpdSBKaWFuIE1hbyBDYW8gACoECAEYAQ==.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Livvic\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/livvic/v13/rnCr-x1S2hzjrlffC-M-mHnOSOuk.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/livvic/v13/rnCt-x1S2hzjrlfXbdtakn3sTfukQHs.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/livvic/v13/rnCq-x1S2hzjrlffp8IeslfCQfK9WQ.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/livvic/v13/rnCs-x1S2hzjrlfXbdv2s13GY_etWWIJ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/livvic/v13/rnCq-x1S2hzjrlffw8EeslfCQfK9WQ.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/livvic/v13/rnCs-x1S2hzjrlfXbduSsF3GY_etWWIJ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/livvic/v13/rnCp-x1S2hzjrlfnb-k6unzeSA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/livvic/v13/rnCr-x1S2hzjrlfXbeM-mHnOSOuk.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/livvic/v13/rnCq-x1S2hzjrlffm8AeslfCQfK9WQ.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/livvic/v13/rnCs-x1S2hzjrlfXbdvKsV3GY_etWWIJ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/livvic/v13/rnCq-x1S2hzjrlfft8ceslfCQfK9WQ.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/livvic/v13/rnCs-x1S2hzjrlfXbdvmtl3GY_etWWIJ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/livvic/v13/rnCq-x1S2hzjrlff08YeslfCQfK9WQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/livvic/v13/rnCs-x1S2hzjrlfXbduCt13GY_etWWIJ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/livvic/v13/rnCq-x1S2hzjrlff68QeslfCQfK9WQ.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/livvic/v13/rnCs-x1S2hzjrlfXbdu6tV3GY_etWWIJ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lobster\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v28\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lobster/v28/neILzCirqoswsqX9_oWsMqEzSJQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lobster Two\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lobstertwo/v18/BngMUXZGTXPUvIoyV6yN59fK7KSJ4ACD.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/lobstertwo/v18/BngOUXZGTXPUvIoyV6yN5-fI5qCr5RCDY_k.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lobstertwo/v18/BngRUXZGTXPUvIoyV6yN5-92w4CByxyKeuDp.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/lobstertwo/v18/BngTUXZGTXPUvIoyV6yN5-fI3hyEwRiof_DpXMY.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Londrina Outline\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/londrinaoutline/v23/C8c44dM8vmb14dfsZxhetg3pDH-SfuoxrSKMDvI.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Londrina Shadow\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/londrinashadow/v22/oPWX_kB4kOQoWNJmjxLV5JuoCUlXRlaSxkrMCQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Londrina Sketch\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/londrinasketch/v21/c4m41npxGMTnomOHtRU68eIJn8qfWWn5Pos6CA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Londrina Solid\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/londrinasolid/v15/flUjRq6sw40kQEJxWNgkLuudGfs9KBYesZHhV64.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/londrinasolid/v15/flUiRq6sw40kQEJxWNgkLuudGfv1CjY0n53oTrcL.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/londrinasolid/v15/flUhRq6sw40kQEJxWNgkLuudGcNZIhI8tIHh.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/londrinasolid/v15/flUiRq6sw40kQEJxWNgkLuudGfvdDzY0n53oTrcL.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Long Cang\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"chinese-simplified\",\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/longcang/v17/LYjAdGP8kkgoTec8zkRgrXArXN7HWQ.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lora\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v32\",\n      \"lastModified\": \"2023-02-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lora/v32/0QI6MX1D_JOuGQbT0gvTJPa787weuyJGmKxemMeZ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/lora/v32/0QI6MX1D_JOuGQbT0gvTJPa787wsuyJGmKxemMeZ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/lora/v32/0QI6MX1D_JOuGQbT0gvTJPa787zAvCJGmKxemMeZ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lora/v32/0QI6MX1D_JOuGQbT0gvTJPa787z5vCJGmKxemMeZ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/lora/v32/0QI8MX1D_JOuMw_hLdO6T2wV9KnW-MoFkqh8ndeZzZ0.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/lora/v32/0QI8MX1D_JOuMw_hLdO6T2wV9KnW-PgFkqh8ndeZzZ0.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/lora/v32/0QI8MX1D_JOuMw_hLdO6T2wV9KnW-BQCkqh8ndeZzZ0.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/lora/v32/0QI8MX1D_JOuMw_hLdO6T2wV9KnW-C0Ckqh8ndeZzZ0.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Love Light\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lovelight/v3/t5tlIR0TNJyZWimpNAXDjKbCyTHuspo.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Love Ya Like A Sister\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/loveyalikeasister/v16/R70EjzUBlOqPeouhFDfR80-0FhOqJubN-Be78nZcsGGycA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Loved by the King\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lovedbytheking/v17/Gw6gwdP76VDVJNXerebZxUMeRXUF2PiNlXFu2R64.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lovers Quarrel\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/loversquarrel/v21/Yq6N-LSKXTL-5bCy8ksBzpQ_-zAsY7pO6siz.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Luckiest Guy\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/luckiestguy/v18/_gP_1RrxsjcxVyin9l9n_j2RStR3qDpraA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lusitana\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lusitana/v13/CSR84z9ShvucWzsMKxhaRuMiSct_.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/lusitana/v13/CSR74z9ShvucWzsMKyDmaccqYtd2vfwk.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Lustria\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/lustria/v13/9oRONYodvDEyjuhOrCg5MtPyAcg.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Luxurious Roman\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/luxuriousroman/v3/buEupou_ZcP1w0yTKxJJokVSmbpqYgckeo9RMw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Luxurious Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/luxuriousscript/v5/ahcCv9e7yydulT32KZ0rBIoD7DzMg0rOby1JtYk.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"M PLUS 1\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v6\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/mplus1/v6/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5VSe78nZcsGGycA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/mplus1/v6/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW51Sa78nZcsGGycA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mplus1/v6/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5Cya78nZcsGGycA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mplus1/v6/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5VSa78nZcsGGycA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mplus1/v6/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5Zya78nZcsGGycA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mplus1/v6/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5iyG78nZcsGGycA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mplus1/v6/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5siG78nZcsGGycA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/mplus1/v6/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW51SG78nZcsGGycA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/mplus1/v6/R70EjygA28ymD4HgBUGzkN5Eyoj-WpW5_CG78nZcsGGycA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"M PLUS 1 Code\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/mplus1code/v7/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7iN0XHpapwmdZhY.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/mplus1code/v7/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7gN0HHpapwmdZhY.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mplus1code/v7/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7jT0HHpapwmdZhY.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mplus1code/v7/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7iN0HHpapwmdZhY.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mplus1code/v7/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7i_0HHpapwmdZhY.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mplus1code/v7/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7hT13HpapwmdZhY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mplus1code/v7/ypvMbXOOx2xFpzmYJS3N2_J2hBN6RZ5oIp8m_7hq13HpapwmdZhY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"M PLUS 1p\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"hebrew\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v27\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/mplus1p/v27/e3tleuShHdiFyPFzBRrQnDQAUW3aq-5N.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mplus1p/v27/e3tmeuShHdiFyPFzBRrQVBYge0PWovdU4w.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mplus1p/v27/e3tjeuShHdiFyPFzBRro-D4Ec2jKqw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mplus1p/v27/e3tmeuShHdiFyPFzBRrQDBcge0PWovdU4w.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mplus1p/v27/e3tmeuShHdiFyPFzBRrQRBEge0PWovdU4w.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/mplus1p/v27/e3tmeuShHdiFyPFzBRrQWBIge0PWovdU4w.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/mplus1p/v27/e3tmeuShHdiFyPFzBRrQfBMge0PWovdU4w.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"M PLUS 2\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v6\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/mplus2/v6/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwOa-VxlqHrzNgAw.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/mplus2/v6/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwua6VxlqHrzNgAw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mplus2/v6/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwZ66VxlqHrzNgAw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mplus2/v6/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwOa6VxlqHrzNgAw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mplus2/v6/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwC66VxlqHrzNgAw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mplus2/v6/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkw56mVxlqHrzNgAw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mplus2/v6/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkw3qmVxlqHrzNgAw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/mplus2/v6/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwuamVxlqHrzNgAw.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/mplus2/v6/7Auhp_Eq3gO_OGbGGhjdwrDdpeIBxlkwkKmVxlqHrzNgAw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"M PLUS Code Latin\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/mpluscodelatin/v7/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1EbB6i5MqF9TRwg.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/mpluscodelatin/v7/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1MbA6i5MqF9TRwg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mpluscodelatin/v7/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1BjA6i5MqF9TRwg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mpluscodelatin/v7/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1EbA6i5MqF9TRwg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mpluscodelatin/v7/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1HTA6i5MqF9TRwg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mpluscodelatin/v7/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1JjH6i5MqF9TRwg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mpluscodelatin/v7/hv-ylyV-aXg7x7tULiNXXBA0Np4WMS8fDIymHY8fy8wn4_ifLAtrObKDO0Xf1KHH6i5MqF9TRwg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"M PLUS Rounded 1c\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"hebrew\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/mplusrounded1c/v15/VdGCAYIAV6gnpUpoWwNkYvrugw9RuM3ixLsg6-av1x0.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mplusrounded1c/v15/VdGBAYIAV6gnpUpoWwNkYvrugw9RuM0q5psKxeqmzgRK.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mplusrounded1c/v15/VdGEAYIAV6gnpUpoWwNkYvrugw9RuPWGzr8C7vav.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mplusrounded1c/v15/VdGBAYIAV6gnpUpoWwNkYvrugw9RuM1y55sKxeqmzgRK.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mplusrounded1c/v15/VdGBAYIAV6gnpUpoWwNkYvrugw9RuM064ZsKxeqmzgRK.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/mplusrounded1c/v15/VdGBAYIAV6gnpUpoWwNkYvrugw9RuM0m4psKxeqmzgRK.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/mplusrounded1c/v15/VdGBAYIAV6gnpUpoWwNkYvrugw9RuM0C45sKxeqmzgRK.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Ma Shan Zheng\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"chinese-simplified\",\n        \"latin\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mashanzheng/v10/NaPecZTRCLxvwo41b4gvzkXaRMTsDIRSfr0.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Macondo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/macondo/v21/RrQQboN9-iB1IXmOS2XO0LBBd4Y.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Macondo Swash Caps\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/macondoswashcaps/v20/6NUL8EaAJgGKZA7lpt941Z9s6ZYgDq6Oekoa_mm5bA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mada\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/mada/v18/7Au_p_0qnzeSdf3nCCL8zkwMIFg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mada/v18/7Au_p_0qnzeSdZnkCCL8zkwMIFg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mada/v18/7Auwp_0qnzeSTTXMLCrX0kU.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mada/v18/7Au_p_0qnzeSdcHlCCL8zkwMIFg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mada/v18/7Au_p_0qnzeSde3iCCL8zkwMIFg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mada/v18/7Au_p_0qnzeSdYnjCCL8zkwMIFg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/mada/v18/7Au_p_0qnzeSdbHhCCL8zkwMIFg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Magra\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/magra/v14/uK_94ruaZus72k5xIDMfO-ed.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/magra/v14/uK_w4ruaZus72nbNDxcXEPuUX1ow.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Maiden Orange\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/maidenorange/v25/kJE1BuIX7AUmhi2V4m08kb1XjOZdCZS8FY8.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Maitree\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/maitree/v10/MjQDmil5tffhpBrklhGNWJGovLdh6OE.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/maitree/v10/MjQDmil5tffhpBrklnWOWJGovLdh6OE.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/maitree/v10/MjQGmil5tffhpBrkrtmmfJmDoL4.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/maitree/v10/MjQDmil5tffhpBrkli2PWJGovLdh6OE.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/maitree/v10/MjQDmil5tffhpBrklgGIWJGovLdh6OE.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/maitree/v10/MjQDmil5tffhpBrklmWJWJGovLdh6OE.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Major Mono Display\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/majormonodisplay/v12/RWmVoLyb5fEqtsfBX9PDZIGr2tFubRhLCn2QIndPww.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mako\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mako/v18/H4coBX6Mmc_Z0ST09g478Lo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mali\",\n      \"variants\": [\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/mali/v9/N0bV2SRONuN4QOLlKlRaJdbWgdY.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/mali/v9/N0bX2SRONuN4SCj8wlVQIfTTkdbJYA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mali/v9/N0bV2SRONuN4QIbmKlRaJdbWgdY.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/mali/v9/N0bX2SRONuN4SCj8plZQIfTTkdbJYA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mali/v9/N0ba2SRONuN4eCrODlxxOd8.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/mali/v9/N0bU2SRONuN4SCjECn50Kd_PmA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mali/v9/N0bV2SRONuN4QN7nKlRaJdbWgdY.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/mali/v9/N0bX2SRONuN4SCj8_ldQIfTTkdbJYA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mali/v9/N0bV2SRONuN4QPLgKlRaJdbWgdY.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/mali/v9/N0bX2SRONuN4SCj80lBQIfTTkdbJYA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mali/v9/N0bV2SRONuN4QJbhKlRaJdbWgdY.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/mali/v9/N0bX2SRONuN4SCj8tlFQIfTTkdbJYA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mallanna\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"telugu\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mallanna/v13/hv-Vlzx-KEQb84YaDGwzEzRwVvJ-.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mandali\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"telugu\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mandali/v14/LhWlMVbYOfASNfNUVFk1ZPdcKtA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Manjari\",\n      \"variants\": [\n        \"100\",\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"malayalam\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/manjari/v9/k3kSo8UPMOBO2w1UdbroK2vFIaOV8A.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/manjari/v9/k3kQo8UPMOBO2w1UTd7iL0nAMaM.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/manjari/v9/k3kVo8UPMOBO2w1UdWLNC0HrLaqM6Q4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Manrope\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/manrope/v13/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk59FO_F87jxeN7B.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/manrope/v13/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk6jFO_F87jxeN7B.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/manrope/v13/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk79FO_F87jxeN7B.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/manrope/v13/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk7PFO_F87jxeN7B.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/manrope/v13/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk4jE-_F87jxeN7B.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/manrope/v13/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk4aE-_F87jxeN7B.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/manrope/v13/xn7_YHE41ni1AdIRqAuZuw1Bx9mbZk59E-_F87jxeN7B.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mansalva\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"greek\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mansalva/v12/aWB4m0aacbtDfvq5NJllI47vdyBg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Manuale\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeG6e7wD1TB_JHHY.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeHke7wD1TB_JHHY.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeHWe7wD1TB_JHHY.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeE6fLwD1TB_JHHY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeEDfLwD1TB_JHHY.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xp0eas_8Z-TFZdHv3mMxFaSqASeeFkfLwD1TB_JHHY.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsOApA3zRdIWHYr8M.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsOFRA3zRdIWHYr8M.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsOGZA3zRdIWHYr8M.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsOIpH3zRdIWHYr8M.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsOLNH3zRdIWHYr8M.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/manuale/v23/f0Xn0eas_8Z-TFZdNPTUzMkzITq8fvQsONRH3zRdIWHYr8M.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Marcellus\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/marcellus/v13/wEO_EBrOk8hQLDvIAF8FUfAL3EsHiA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Marcellus SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/marcellussc/v13/ke8iOgUHP1dg-Rmi6RWjbLEPgdydGKikhA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Marck Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/marckscript/v16/nwpTtK2oNgBA3Or78gapdwuCzyI-aMPF7Q.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Margarine\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/margarine/v21/qkBXXvoE6trLT9Y7YLye5JRLkAXbMQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Marhey\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/marhey/v3/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBZVwO2cXiGevOMw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/marhey/v3/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBctwO2cXiGevOMw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/marhey/v3/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBflwO2cXiGevOMw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/marhey/v3/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBRV3O2cXiGevOMw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/marhey/v3/x3d8ck7Laq-T7wl7mqfVrEe9sDvtBSx3O2cXiGevOMw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Markazi Text\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/markazitext/v22/sykh-ydym6AtQaiEtX7yhqb_rV1k_81ZVYYZtfSQT4MlBekmJLo.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/markazitext/v22/sykh-ydym6AtQaiEtX7yhqb_rV1k_81ZVYYZtcaQT4MlBekmJLo.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/markazitext/v22/sykh-ydym6AtQaiEtX7yhqb_rV1k_81ZVYYZtSqXT4MlBekmJLo.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/markazitext/v22/sykh-ydym6AtQaiEtX7yhqb_rV1k_81ZVYYZtROXT4MlBekmJLo.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Marko One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/markoone/v22/9Btq3DFG0cnVM5lw1haaKpUfrHPzUw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Marmelad\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/marmelad/v17/Qw3eZQdSHj_jK2e-8tFLG-YMC0R8.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Martel\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/martel/v10/PN_yRfK9oXHga0XVqekahRbX9vnDzw.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/martel/v10/PN_yRfK9oXHga0XVzeoahRbX9vnDzw.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/martel/v10/PN_xRfK9oXHga0XtYcI-jT3L_w.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/martel/v10/PN_yRfK9oXHga0XVuewahRbX9vnDzw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/martel/v10/PN_yRfK9oXHga0XV3e0ahRbX9vnDzw.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/martel/v10/PN_yRfK9oXHga0XVwe4ahRbX9vnDzw.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/martel/v10/PN_yRfK9oXHga0XV5e8ahRbX9vnDzw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Martel Sans\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/martelsans/v12/h0GxssGi7VdzDgKjM-4d8hAX5suHFUknqMxQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/martelsans/v12/h0GxssGi7VdzDgKjM-4d8hBz5cuHFUknqMxQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/martelsans/v12/h0GsssGi7VdzDgKjM-4d8ijfze-PPlUu.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/martelsans/v12/h0GxssGi7VdzDgKjM-4d8hAH48uHFUknqMxQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/martelsans/v12/h0GxssGi7VdzDgKjM-4d8hBj4suHFUknqMxQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/martelsans/v12/h0GxssGi7VdzDgKjM-4d8hB_4cuHFUknqMxQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/martelsans/v12/h0GxssGi7VdzDgKjM-4d8hBb4MuHFUknqMxQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Martian Mono\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2023-02-23\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/martianmono/v3/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY1qus6WD75kdpF2.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/martianmono/v3/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY3qu86WD75kdpF2.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/martianmono/v3/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY00u86WD75kdpF2.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/martianmono/v3/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY1qu86WD75kdpF2.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/martianmono/v3/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY1Yu86WD75kdpF2.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/martianmono/v3/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY20vM6WD75kdpF2.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/martianmono/v3/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY2NvM6WD75kdpF2.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/martianmono/v3/2V08KIcADoYhV6w87xrTKjs4CYElh_VS9YA4TlTnQzaVMIE6j15dYY3qvM6WD75kdpF2.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Marvel\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/marvel/v14/nwpVtKeoNgBV0qaIkV7ED366zg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/marvel/v14/nwpXtKeoNgBV0qa4k1TALXuqzhA7.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/marvel/v14/nwpWtKeoNgBV0qawLXHgB1WmxwkiYQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/marvel/v14/nwpQtKeoNgBV0qa4k2x8Al-i5QwyYdrc.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mate\",\n      \"variants\": [\n        \"regular\",\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mate/v14/m8JdjftRd7WZ2z28WoXSaLU.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/mate/v14/m8JTjftRd7WZ6z-2XqfXeLVdbw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mate SC\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/matesc/v21/-nF8OGQ1-uoVr2wKyiXZ95OkJwA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Maven Pro\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v32\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mavenpro/v32/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8SX25nCpozp5GvU.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mavenpro/v32/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8Rf25nCpozp5GvU.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mavenpro/v32/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8fvx5nCpozp5GvU.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mavenpro/v32/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8cLx5nCpozp5GvU.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/mavenpro/v32/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8aXx5nCpozp5GvU.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/mavenpro/v32/7Auup_AqnyWWAxW2Wk3swUz56MS91Eww8Yzx5nCpozp5GvU.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"McLaren\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mclaren/v13/2EbnL-ZuAXFqZFXISYYf8z2Yt_c.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mea Culpa\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/meaculpa/v3/AMOTz4GcuWbEIuza8jsZms0QW3mqyg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Meddon\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/meddon/v20/kmK8ZqA2EgDNeHTZhBdB3y_Aow.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"MedievalSharp\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/medievalsharp/v24/EvOJzAlL3oU5AQl2mP5KdgptAq96MwvXLDk.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Medula One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/medulaone/v19/YA9Wr0qb5kjJM6l2V0yukiEqs7GtlvY.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Meera Inimai\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"tamil\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/meerainimai/v12/845fNMM5EIqOW5MPuvO3ILep_2jDVevnLQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Megrim\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/megrim/v16/46kulbz5WjvLqJZlbWXgd0RY1g.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Meie Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/meiescript/v21/_LOImzDK7erRjhunIspaMjxn5IXg0WDz.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Meow Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v5\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/meowscript/v5/0FlQVPqanlaJrtr8AnJ0ESch0_0CfDf1.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Merienda\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/merienda/v17/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5JHhoSU78QGBV0A.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/merienda/v17/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5enhoSU78QGBV0A.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/merienda/v17/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5SHhoSU78QGBV0A.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/merienda/v17/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5pH9oSU78QGBV0A.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/merienda/v17/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5nX9oSU78QGBV0A.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/merienda/v17/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5-n9oSU78QGBV0A.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/merienda/v17/gNMaW3x8Qoy5_mf8uUkJGHtiYXjmKFy5039oSU78QGBV0A.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Merienda One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/meriendaone/v16/H4cgBXaMndbflEq6kyZ1ht6YgoyyYzFzFw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Merriweather\",\n      \"variants\": [\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v30\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/merriweather/v30/u-4n0qyriQwlOrhSvowK_l521wRpX837pvjxPA.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/merriweather/v30/u-4l0qyriQwlOrhSvowK_l5-eR7lXcf_hP3hPGWH.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/merriweather/v30/u-440qyriQwlOrhSvowK_l5OeyxNV-bnrw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/merriweather/v30/u-4m0qyriQwlOrhSvowK_l5-eSZJdeP3r-Ho.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/merriweather/v30/u-4n0qyriQwlOrhSvowK_l52xwNpX837pvjxPA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/merriweather/v30/u-4l0qyriQwlOrhSvowK_l5-eR71Wsf_hP3hPGWH.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/merriweather/v30/u-4n0qyriQwlOrhSvowK_l52_wFpX837pvjxPA.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/merriweather/v30/u-4l0qyriQwlOrhSvowK_l5-eR7NWMf_hP3hPGWH.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Merriweather Sans\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZ_O4ljuEG7xFHnQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZou4ljuEG7xFHnQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZkO4ljuEG7xFHnQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZfOkljuEG7xFHnQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZRekljuEG7xFHnQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cO9IRs1JiJN1FRAMjTN5zd9vgsFF_5asQTb6hZ2JKZIukljuEG7xFHnQ.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq2TzesCzRRXnaur.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq3NzesCzRRXnaur.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq3_zesCzRRXnaur.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq0TyusCzRRXnaur.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq0qyusCzRRXnaur.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/merriweathersans/v22/2-cM9IRs1JiJN1FRAMjTN5zd9vgsFHXwWDvLBsPDdpWMaq1NyusCzRRXnaur.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Metal\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v28\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/metal/v28/lW-wwjUJIXTo7i3nnoQAUdN2.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Metal Mania\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/metalmania/v22/RWmMoKWb4e8kqMfBUdPFJeXCg6UKDXlq.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Metamorphous\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/metamorphous/v18/Wnz8HA03aAXcC39ZEX5y1330PCCthTsmaQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Metrophobic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/metrophobic/v19/sJoA3LZUhMSAPV_u0qwiAT-J737FPEEL.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Michroma\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/michroma/v16/PN_zRfy9qWD8fEagAMg6rzjb_-Da.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Milonga\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/milonga/v20/SZc53FHnIaK9W5kffz3GkUrS8DI.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Miltonian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/miltonian/v26/zOL-4pbPn6Ne9JqTg9mr6e5As-FeiQ.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Miltonian Tattoo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v28\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/miltoniantattoo/v28/EvOUzBRL0o0kCxF-lcMCQxlpVsA_FwP8MDBku-s.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mina\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"bengali\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mina/v11/-nFzOGc18vARrz9j7i3y65o.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mina/v11/-nF8OGc18vARl4NMyiXZ95OkJwA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mingzat\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"lepcha\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mingzat/v2/0QIgMX5C-o-oWWyvBttkm_mv670.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Miniver\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/miniver/v21/eLGcP-PxIg-5H0vC770Cy8r8fWA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Miriam Libre\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/miriamlibre/v13/DdTh798HsHwubBAqfkcBTL_vYJn_Teun9g.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/miriamlibre/v13/DdT-798HsHwubBAqfkcBTL_X3LbbRcC7_-Z7Hg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mirza\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mirza/v15/co3ImWlikiN5EurdKMewsrvI.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mirza/v15/co3FmWlikiN5EtIpAeO4mafBomDi.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mirza/v15/co3FmWlikiN5EtIFBuO4mafBomDi.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mirza/v15/co3FmWlikiN5EtJhB-O4mafBomDi.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Miss Fajardose\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/missfajardose/v22/E21-_dn5gvrawDdPFVl-N0Ajb8qvWPaJq4no.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mitr\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v11\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/mitr/v11/pxiEypw5ucZF8fMZFJDUc1NECPY.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mitr/v11/pxiEypw5ucZF8ZcaFJDUc1NECPY.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mitr/v11/pxiLypw5ucZFyTsyMJj_b1o.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mitr/v11/pxiEypw5ucZF8c8bFJDUc1NECPY.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mitr/v11/pxiEypw5ucZF8eMcFJDUc1NECPY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mitr/v11/pxiEypw5ucZF8YcdFJDUc1NECPY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mochiy Pop One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"japanese\",\n        \"latin\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mochiypopone/v7/QdVPSTA9Jh-gg-5XZP2UmU4O9kwwD3s6ZKAi.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mochiy Pop P One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"japanese\",\n        \"latin\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mochiypoppone/v7/Ktk2AKuPeY_td1-h9LayHYWCjAqyN4O3WYZB_sU.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Modak\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/modak/v18/EJRYQgs1XtIEsnMH8BVZ76KU.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Modern Antiqua\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/modernantiqua/v22/NGStv5TIAUg6Iq_RLNo_2dp1sI1Ea2u0c3Gi.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mogra\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"gujarati\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mogra/v19/f0X40eSs8c95TBo4DvLmxtnG.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mohave\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v8\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/mohave/v8/7cH0v4ksjJunKqMVAOPIMOeSmiojdif_HvCQopLSvBk.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mohave/v8/7cH0v4ksjJunKqMVAOPIMOeSmiojdnn_HvCQopLSvBk.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mohave/v8/7cH0v4ksjJunKqMVAOPIMOeSmiojdkv_HvCQopLSvBk.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mohave/v8/7cH0v4ksjJunKqMVAOPIMOeSmiojdqf4HvCQopLSvBk.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mohave/v8/7cH0v4ksjJunKqMVAOPIMOeSmiojdp74HvCQopLSvBk.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/mohave/v8/7cH2v4ksjJunKqM_CdE36I75AIQkY7G8qLOaprDXrBlSVw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/mohave/v8/7cH2v4ksjJunKqM_CdE36I75AIQkY7G89rOaprDXrBlSVw.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/mohave/v8/7cH2v4ksjJunKqM_CdE36I75AIQkY7G8xLOaprDXrBlSVw.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/mohave/v8/7cH2v4ksjJunKqM_CdE36I75AIQkY7G8KLSaprDXrBlSVw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/mohave/v8/7cH2v4ksjJunKqM_CdE36I75AIQkY7G8EbSaprDXrBlSVw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Molengo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/molengo/v16/I_uuMpWeuBzZNBtQbbRQkiCvs5Y.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Molle\",\n      \"variants\": [\n        \"italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"italic\": \"http://fonts.gstatic.com/s/molle/v21/E21n_dL5hOXFhWEsXzgmVydREus.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Monda\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/monda/v16/TK3tWkYFABsmjvpmNBsLvPdG.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/monda/v16/TK3gWkYFABsmjsLaGz8Dl-tPKo2t.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Monofett\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/monofett/v22/mFTyWbofw6zc9NtnW43SuRwr0VJ7.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Monoton\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/monoton/v15/5h1aiZUrOngCibe4fkbBQ2S7FU8.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Monsieur La Doulaise\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/monsieurladoulaise/v14/_Xmz-GY4rjmCbQfc-aPRaa4pqV340p7EZl5ewkEU4HTy.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Montaga\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/montaga/v13/H4cnBX2Ml8rCkEO_0gYQ7LO5mqc.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Montagu Slab\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v6\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/montaguslab/v6/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkDbE3P9Fs7bOSO7.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/montaguslab/v6/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkBbEnP9Fs7bOSO7.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/montaguslab/v6/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkCFEnP9Fs7bOSO7.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/montaguslab/v6/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkDbEnP9Fs7bOSO7.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/montaguslab/v6/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkDpEnP9Fs7bOSO7.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/montaguslab/v6/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkAFFXP9Fs7bOSO7.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/montaguslab/v6/6qLhKZIQtB_zv0xUaXRDWkY_HXsphdLRZF40vm_jzR2jhk_n3T6ACkA8FXP9Fs7bOSO7.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"MonteCarlo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v7\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/montecarlo/v7/buEzpo6-f9X01GadLA0G0CoV_NxLeiw.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Montez\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/montez/v18/845ZNMk5GoGIX8lm1LDeSd-R_g.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Montserrat\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCtr6Uw-Y3tcoqK5.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCvr6Ew-Y3tcoqK5.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCs16Ew-Y3tcoqK5.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCtr6Ew-Y3tcoqK5.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCtZ6Ew-Y3tcoqK5.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCu170w-Y3tcoqK5.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCuM70w-Y3tcoqK5.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCvr70w-Y3tcoqK5.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUHjIg1_i6t8kCHKm4532VJOt5-QNFgpCvC70w-Y3tcoqK5.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq6R8aX9-p7K5ILg.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jqyR9aX9-p7K5ILg.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq_p9aX9-p7K5ILg.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq6R9aX9-p7K5ILg.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq5Z9aX9-p7K5ILg.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq3p6aX9-p7K5ILg.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jq0N6aX9-p7K5ILg.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jqyR6aX9-p7K5ILg.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/montserrat/v25/JTUFjIg1_i6t8kCHKm459Wx7xQYXK0vOoz6jqw16aX9-p7K5ILg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Montserrat Alternates\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFThWacfw6zH4dthXcyms1lPpC8I_b0juU0xiKfVKphL03l4.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTjWacfw6zH4dthXcyms1lPpC8I_b0juU057p-xIJxp1ml4imo.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xJIb1ALZH2mBhkw.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p8dAbxD-GVxk3Nd.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xQIX1ALZH2mBhkw.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p95ArxD-GVxk3Nd.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTvWacfw6zH4dthXcyms1lPpC8I_b0juU0J7K3RCJ1b0w.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFThWacfw6zH4dthXcyms1lPpC8I_b0juU057qfVKphL03l4.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xGIT1ALZH2mBhkw.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p8hA7xD-GVxk3Nd.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xNIP1ALZH2mBhkw.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p8NBLxD-GVxk3Nd.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xUIL1ALZH2mBhkw.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p9pBbxD-GVxk3Nd.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xTIH1ALZH2mBhkw.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p91BrxD-GVxk3Nd.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTiWacfw6zH4dthXcyms1lPpC8I_b0juU0xaID1ALZH2mBhkw.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/montserratalternates/v17/mFTkWacfw6zH4dthXcyms1lPpC8I_b0juU057p9RB7xD-GVxk3Nd.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Montserrat Subrayada\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/montserratsubrayada/v17/U9MD6c-o9H7PgjlTHThBnNHGVUORwteQQE8LYuceqGT-.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/montserratsubrayada/v17/U9MM6c-o9H7PgjlTHThBnNHGVUORwteQQHe3TcMWg3j36Ebz.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Moo Lah Lah\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/moolahlah/v3/dg4h_p_opKZOA0w1AYcm55wtYQYugjW4.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Moon Dance\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/moondance/v3/WBLgrEbUbFlYW9ekmGawe2XiKMiokE4.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Moul\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/moul/v25/nuF2D__FSo_3E-RYiJCy-00.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Moulpali\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v28\",\n      \"lastModified\": \"2022-04-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/moulpali/v28/H4ckBXKMl9HagUWymyY6wr-wg763.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mountains of Christmas\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mountainsofchristmas/v20/3y9w6a4zcCnn5X0FDyrKi2ZRUBIy8uxoUo7ePNamMPNpJpc.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mountainsofchristmas/v20/3y9z6a4zcCnn5X0FDyrKi2ZRUBIy8uxoUo7eBGqJFPtCOp6IaEA.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mouse Memoirs\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mousememoirs/v13/t5tmIRoSNJ-PH0WNNgDYxdSb7TnFrpOHYh4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mr Bedfort\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mrbedfort/v21/MQpR-WCtNZSWAdTMwBicliq0XZe_Iy8.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mr Dafoe\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mrdafoe/v14/lJwE-pIzkS5NXuMMrGiqg7MCxz_C.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mr De Haviland\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mrdehaviland/v14/OpNVnooIhJj96FdB73296ksbOj3C4ULVNTlB.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mrs Saint Delafield\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mrssaintdelafield/v13/v6-IGZDIOVXH9xtmTZfRagunqBw5WC62cK4tLsubB2w.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mrs Sheppards\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mrssheppards/v21/PN_2Rfm9snC0XUGoEZhb91ig3vjxynMix4Y.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Ms Madi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/msmadi/v2/HTxsL2UxNnOji5E1N-DPiI7QAYo.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mukta\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/mukta/v13/iJWHBXyXfDDVXbEOjFma-2HW7ZB_.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mukta/v13/iJWHBXyXfDDVXbFqj1ma-2HW7ZB_.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mukta/v13/iJWKBXyXfDDVXYnGp32S0H3f.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mukta/v13/iJWHBXyXfDDVXbEyjlma-2HW7ZB_.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mukta/v13/iJWHBXyXfDDVXbEeiVma-2HW7ZB_.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mukta/v13/iJWHBXyXfDDVXbF6iFma-2HW7ZB_.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/mukta/v13/iJWHBXyXfDDVXbFmi1ma-2HW7ZB_.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mukta Mahee\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"gurmukhi\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/muktamahee/v15/XRXN3IOIi0hcP8iVU67hA9MFcBoHJndqZCsW.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/muktamahee/v15/XRXN3IOIi0hcP8iVU67hA9NhcxoHJndqZCsW.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/muktamahee/v15/XRXQ3IOIi0hcP8iVU67hA-vNWz4PDWtj.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/muktamahee/v15/XRXN3IOIi0hcP8iVU67hA9M5choHJndqZCsW.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/muktamahee/v15/XRXN3IOIi0hcP8iVU67hA9MVdRoHJndqZCsW.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/muktamahee/v15/XRXN3IOIi0hcP8iVU67hA9NxdBoHJndqZCsW.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/muktamahee/v15/XRXN3IOIi0hcP8iVU67hA9NtdxoHJndqZCsW.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mukta Malar\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tamil\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/muktamalar/v12/MCoKzAXyz8LOE2FpJMxZqIMwBtAB62ruoAZW.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/muktamalar/v12/MCoKzAXyz8LOE2FpJMxZqINUBdAB62ruoAZW.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/muktamalar/v12/MCoXzAXyz8LOE2FpJMxZqLv4LfQJwHbn.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/muktamalar/v12/MCoKzAXyz8LOE2FpJMxZqIMMBNAB62ruoAZW.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/muktamalar/v12/MCoKzAXyz8LOE2FpJMxZqIMgA9AB62ruoAZW.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/muktamalar/v12/MCoKzAXyz8LOE2FpJMxZqINEAtAB62ruoAZW.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/muktamalar/v12/MCoKzAXyz8LOE2FpJMxZqINYAdAB62ruoAZW.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mukta Vaani\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"gujarati\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v13\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/muktavaani/v13/3JnkSD_-ynaxmxnEfVHPIGXNV8BD-u97MW1a.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/muktavaani/v13/3JnkSD_-ynaxmxnEfVHPIGWpVMBD-u97MW1a.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/muktavaani/v13/3Jn5SD_-ynaxmxnEfVHPIF0FfORL0fNy.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/muktavaani/v13/3JnkSD_-ynaxmxnEfVHPIGXxVcBD-u97MW1a.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/muktavaani/v13/3JnkSD_-ynaxmxnEfVHPIGXdUsBD-u97MW1a.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/muktavaani/v13/3JnkSD_-ynaxmxnEfVHPIGW5U8BD-u97MW1a.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/muktavaani/v13/3JnkSD_-ynaxmxnEfVHPIGWlUMBD-u97MW1a.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mulish\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v12\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptyg83HX_SGhgqO0yLcmjzUAuWexRNRwaClGrw-PTY.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptyg83HX_SGhgqO0yLcmjzUAuWexc1RwaClGrw-PTY.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptyg83HX_SGhgqO0yLcmjzUAuWexZNRwaClGrw-PTY.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptyg83HX_SGhgqO0yLcmjzUAuWexaFRwaClGrw-PTY.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptyg83HX_SGhgqO0yLcmjzUAuWexU1WwaClGrw-PTY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptyg83HX_SGhgqO0yLcmjzUAuWexXRWwaClGrw-PTY.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptyg83HX_SGhgqO0yLcmjzUAuWexRNWwaClGrw-PTY.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptyg83HX_SGhgqO0yLcmjzUAuWexTpWwaClGrw-PTY.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSqeOvHp47LTZFwA.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSd-OvHp47LTZFwA.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSKeOvHp47LTZFwA.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSG-OvHp47LTZFwA.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsS9-SvHp47LTZFwA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSzuSvHp47LTZFwA.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSqeSvHp47LTZFwA.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/mulish/v12/1Ptwg83HX_SGhgqk2hAjQlW_mEuZ0FsSgOSvHp47LTZFwA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Murecho\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v6\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/murecho/v6/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMpr5HWZLCpUOaM6.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/murecho/v6/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMrr5XWZLCpUOaM6.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/murecho/v6/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMo15XWZLCpUOaM6.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/murecho/v6/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMpr5XWZLCpUOaM6.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/murecho/v6/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMpZ5XWZLCpUOaM6.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/murecho/v6/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMq14nWZLCpUOaM6.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/murecho/v6/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMqM4nWZLCpUOaM6.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/murecho/v6/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMrr4nWZLCpUOaM6.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/murecho/v6/q5uYsoq3NOBn_I-ggCJg98TBOoNFCMrC4nWZLCpUOaM6.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"MuseoModerno\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMlZFuewajeKlCdo.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMtZEuewajeKlCdo.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMghEuewajeKlCdo.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMlZEuewajeKlCdo.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMmREuewajeKlCdo.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMohDuewajeKlCdo.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMrFDuewajeKlCdo.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMtZDuewajeKlCdo.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrf30HnU0_7wWdMrFcWqSEXPVyEaWJ55pTleMv9DuewajeKlCdo.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54HUa4QicCgGdrS3g.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54H0a8QicCgGdrS3g.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54HD68QicCgGdrS3g.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54HUa8QicCgGdrS3g.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54HY68QicCgGdrS3g.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54Hj6gQicCgGdrS3g.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54HtqgQicCgGdrS3g.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54H0agQicCgGdrS3g.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/museomoderno/v22/zrfx0HnU0_7wWdMrFcWqSEXlXhPlgPcSP5dZJ54H-KgQicCgGdrS3g.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"My Soul\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mysoul/v2/3XFqErcuy945_u6KF_Ulk2nnXf0.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mynerve\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"greek\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2023-02-16\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mynerve/v1/P5sCzZKPdNjb4jt7xCRuiZ-uydg.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Mystery Quest\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/mysteryquest/v20/-nF6OG414u0E6k0wynSGlujRHwElD_9Qz9E.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"NTR\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"telugu\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/ntr/v15/RLpzK5Xy0ZjiGGhs5TA4bg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nabla\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"math\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v9\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nabla/v9/j8_D6-LI0Lvpe7Makz5UhJt9C3uqg_X_75gyGS4jAxsNIjrRNRBUFFR_198.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nanum Brush Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nanumbrushscript/v22/wXK2E2wfpokopxzthSqPbcR5_gVaxazyjqBr1lO97Q.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nanum Gothic\",\n      \"variants\": [\n        \"regular\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nanumgothic/v21/PN_3Rfi-oW3hYwmKDpxS7F_z_tLfxno73g.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/nanumgothic/v21/PN_oRfi-oW3hYwmKDpxS7F_LQv37zlEn14YEUQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/nanumgothic/v21/PN_oRfi-oW3hYwmKDpxS7F_LXv77zlEn14YEUQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nanum Gothic Coding\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nanumgothiccoding/v19/8QIVdjzHisX_8vv59_xMxtPFW4IXROwsy6QxVs1X7tc.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/nanumgothiccoding/v19/8QIYdjzHisX_8vv59_xMxtPFW4IXROws8xgecsV88t5V9r4.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nanum Myeongjo\",\n      \"variants\": [\n        \"regular\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nanummyeongjo/v20/9Btx3DZF0dXLMZlywRbVRNhxy1LreHQ8juyl.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/nanummyeongjo/v20/9Bty3DZF0dXLMZlywRbVRNhxy2pXV1A0pfCs5Kos.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/nanummyeongjo/v20/9Bty3DZF0dXLMZlywRbVRNhxy2pLVFA0pfCs5Kos.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nanum Pen Script\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nanumpenscript/v19/daaDSSYiLGqEal3MvdA_FOL_3FkN2z7-aMFCcTU.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Neonderthaw\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v3\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/neonderthaw/v3/Iure6Yx5-oWVZI0r-17AeZZJprVA4XQ0.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nerko One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nerkoone/v15/m8JQjfZSc7OXlB3ZMOjzcJ5BZmqa3A.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Neucha\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"latin\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/neucha/v17/q5uGsou0JOdh94bvugNsCxVEgA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Neuton\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"800\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/neuton/v18/UMBQrPtMoH62xUZKAKkfegD5Drog6Q.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/neuton/v18/UMBQrPtMoH62xUZKZKofegD5Drog6Q.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/neuton/v18/UMBTrPtMoH62xUZyyII7civlBw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/neuton/v18/UMBRrPtMoH62xUZCyog_UC71B6M5.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/neuton/v18/UMBQrPtMoH62xUZKdK0fegD5Drog6Q.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/neuton/v18/UMBQrPtMoH62xUZKaK4fegD5Drog6Q.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"New Rocker\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/newrocker/v16/MwQzbhjp3-HImzcCU_cJkGMViblPtXs.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"New Tegomin\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"japanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/newtegomin/v10/SLXMc1fV7Gd9USdBAfPlqfN0Q3ptkDMN.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"News Cycle\",\n      \"variants\": [\n        \"regular\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/newscycle/v22/CSR64z1Qlv-GDxkbKVQ_TOcATNt_pOU.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/newscycle/v22/CSR54z1Qlv-GDxkbKVQ_dFsvaNNUuOwkC2s.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Newsreader\",\n      \"variants\": [\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438w-I_ADOxEPjCggA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438wJo_ADOxEPjCggA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438weI_ADOxEPjCggA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438wSo_ADOxEPjCggA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438wpojADOxEPjCggA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438wn4jADOxEPjCggA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9qfjOCX1hbuyalUrK49dLac06G1ZGsZBtoBCzBDXXD9JVF438w-IjADOxEPjCggA.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMyoT-ZAHDWwgECi.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMx2T-ZAHDWwgECi.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMwoT-ZAHDWwgECi.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMwaT-ZAHDWwgECi.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMz2SOZAHDWwgECi.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMzPSOZAHDWwgECi.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/newsreader/v19/cY9kfjOCX1hbuyalUrK439vogqC9yFZCYg7oRZaLP4obnf7fTXglsMyoSOZAHDWwgECi.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Niconne\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/niconne/v15/w8gaH2QvRug1_rTfrQut2F4OuOo.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Niramit\",\n      \"variants\": [\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"thai\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v10\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"200\": \"http://fonts.gstatic.com/s/niramit/v10/I_urMpWdvgLdNxVLVXx7tiiEr5_BdZ8.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/niramit/v10/I_upMpWdvgLdNxVLXbZiXimOq73EZZ_f6w.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/niramit/v10/I_urMpWdvgLdNxVLVRh4tiiEr5_BdZ8.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/niramit/v10/I_upMpWdvgLdNxVLXbZiOiqOq73EZZ_f6w.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/niramit/v10/I_uuMpWdvgLdNxVLbbRQkiCvs5Y.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/niramit/v10/I_usMpWdvgLdNxVLXbZalgKqo5bYbA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/niramit/v10/I_urMpWdvgLdNxVLVUB5tiiEr5_BdZ8.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/niramit/v10/I_upMpWdvgLdNxVLXbZiYiuOq73EZZ_f6w.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/niramit/v10/I_urMpWdvgLdNxVLVWx-tiiEr5_BdZ8.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/niramit/v10/I_upMpWdvgLdNxVLXbZiTiyOq73EZZ_f6w.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/niramit/v10/I_urMpWdvgLdNxVLVQh_tiiEr5_BdZ8.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/niramit/v10/I_upMpWdvgLdNxVLXbZiKi2Oq73EZZ_f6w.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nixie One\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nixieone/v16/lW-8wjkKLXjg5y2o2uUoUOFzpS-yLw.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nobile\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nobile/v17/m8JTjflSeaOVl1i2XqfXeLVdbw.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/nobile/v17/m8JRjflSeaOVl1iGXK3TWrBNb3OD.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/nobile/v17/m8JQjflSeaOVl1iOqo7zcJ5BZmqa3A.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/nobile/v17/m8JWjflSeaOVl1iGXJUnc5RFRG-K3Mud.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/nobile/v17/m8JQjflSeaOVl1iO4ojzcJ5BZmqa3A.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/nobile/v17/m8JWjflSeaOVl1iGXJVvdZRFRG-K3Mud.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nokora\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\"\n      ],\n      \"version\": \"v30\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/nokora/v30/~CgoKBk5va29yYRhkIAAqBAgBGAE=.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/nokora/v30/~CgsKBk5va29yYRisAiAAKgQIARgB.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/nokora/v30/~CggKBk5va29yYSAAKgQIARgB.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/nokora/v30/~CgsKBk5va29yYRi8BSAAKgQIARgB.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/nokora/v30/~CgsKBk5va29yYRiEByAAKgQIARgB.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Norican\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/norican/v14/MwQ2bhXp1eSBqjkPGJJRtGs-lbA.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nosifer\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nosifer/v20/ZGjXol5JTp0g5bxZaC1RVDNdGDs.ttf\"\n      },\n      \"category\": \"display\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Notable\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notable/v14/gNMEW3N_SIqx-WX9-HMoFIez5MI.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Nothing You Could Do\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/nothingyoucoulddo/v15/oY1B8fbBpaP5OX3DtrRYf_Q2BPB1SnfZb0OJl1ol2Ymo.ttf\"\n      },\n      \"category\": \"handwriting\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noticia Text\",\n      \"variants\": [\n        \"regular\",\n        \"italic\",\n        \"700\",\n        \"700italic\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/noticiatext/v15/VuJ2dNDF2Yv9qppOePKYRP1GYTFZt0rNpQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/noticiatext/v15/VuJodNDF2Yv9qppOePKYRP12YztdlU_dpSjt.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/noticiatext/v15/VuJpdNDF2Yv9qppOePKYRP1-3R59v2HRrDH0eA.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/noticiatext/v15/VuJrdNDF2Yv9qppOePKYRP12YwPhumvVjjTkeMnz.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Color Emoji\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"emoji\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-26\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notocoloremoji/v24/Yq6P-KqIXTD0t4D9z1ESnKM3-HpFab5s79iz64w.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Emoji\",\n      \"variants\": [\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"emoji\"\n      ],\n      \"version\": \"v34\",\n      \"lastModified\": \"2022-09-26\",\n      \"files\": {\n        \"300\": \"http://fonts.gstatic.com/s/notoemoji/v34/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob_10jwvS-FGJCMY.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notoemoji/v34/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob-r0jwvS-FGJCMY.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notoemoji/v34/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob-Z0jwvS-FGJCMY.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notoemoji/v34/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob911TwvS-FGJCMY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notoemoji/v34/bMrnmSyK7YY-MEu6aWjPDs-ar6uWaGWuob9M1TwvS-FGJCMY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Kufi Arabic\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"arabic\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notokufiarabic/v15/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh5v3obPnLSmf5yD.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notokufiarabic/v15/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh7v34bPnLSmf5yD.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notokufiarabic/v15/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh4x34bPnLSmf5yD.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notokufiarabic/v15/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh5v34bPnLSmf5yD.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notokufiarabic/v15/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh5d34bPnLSmf5yD.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notokufiarabic/v15/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh6x2IbPnLSmf5yD.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notokufiarabic/v15/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh6I2IbPnLSmf5yD.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notokufiarabic/v15/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh7v2IbPnLSmf5yD.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notokufiarabic/v15/CSRp4ydQnPyaDxEXLFF6LZVLKrodhu8t57o1kDc5Wh7G2IbPnLSmf5yD.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Music\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"music\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notomusic/v17/pe0rMIiSN5pO63htf1sxIteQB9Zra1U.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Naskh Arabic\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v25\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notonaskharabic/v25/RrQ5bpV-9Dd1b1OAGA6M9PkyDuVBePeKNaxcsss0Y7bwvc5krK0z9_Mnuw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notonaskharabic/v25/RrQ5bpV-9Dd1b1OAGA6M9PkyDuVBePeKNaxcsss0Y7bwj85krK0z9_Mnuw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notonaskharabic/v25/RrQ5bpV-9Dd1b1OAGA6M9PkyDuVBePeKNaxcsss0Y7bwY8lkrK0z9_Mnuw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notonaskharabic/v25/RrQ5bpV-9Dd1b1OAGA6M9PkyDuVBePeKNaxcsss0Y7bwWslkrK0z9_Mnuw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Nastaliq Urdu\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"arabic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notonastaliqurdu/v14/LhWNMUPbN-oZdNFcBy1-DJYsEoTq5pudQ9L940pGPkB3Qt_-DK2f2-_8mEw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notonastaliqurdu/v14/LhWNMUPbN-oZdNFcBy1-DJYsEoTq5pudQ9L940pGPkB3Qu3-DK2f2-_8mEw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notonastaliqurdu/v14/LhWNMUPbN-oZdNFcBy1-DJYsEoTq5pudQ9L940pGPkB3QgH5DK2f2-_8mEw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notonastaliqurdu/v14/LhWNMUPbN-oZdNFcBy1-DJYsEoTq5pudQ9L940pGPkB3Qjj5DK2f2-_8mEw.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Rashi Hebrew\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notorashihebrew/v21/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZB-DkRyq6Nf2pfA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notorashihebrew/v21/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZh-HkRyq6Nf2pfA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notorashihebrew/v21/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZWeHkRyq6Nf2pfA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notorashihebrew/v21/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZB-HkRyq6Nf2pfA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notorashihebrew/v21/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZNeHkRyq6Nf2pfA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notorashihebrew/v21/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZ2ebkRyq6Nf2pfA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notorashihebrew/v21/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZ4ObkRyq6Nf2pfA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notorashihebrew/v21/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZh-bkRyq6Nf2pfA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notorashihebrew/v21/EJR_Qh82XsIK-QFmqXk4zvLwFVya0vFL-HlKM5e6C6HZrubkRyq6Nf2pfA.ttf\"\n      },\n      \"category\": \"serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans\",\n      \"variants\": [\n        \"100\",\n        \"100italic\",\n        \"200\",\n        \"200italic\",\n        \"300\",\n        \"300italic\",\n        \"regular\",\n        \"italic\",\n        \"500\",\n        \"500italic\",\n        \"600\",\n        \"600italic\",\n        \"700\",\n        \"700italic\",\n        \"800\",\n        \"800italic\",\n        \"900\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"devanagari\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v27\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosans/v27/o-0OIpQlx3QUlC5A4PNjhjRFSfiM7HBj.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/notosans/v27/o-0MIpQlx3QUlC5A4PNr4AwhQ_yu6WBjJLE.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosans/v27/o-0NIpQlx3QUlC5A4PNjKhVlY9aA5Wl6PQ.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/notosans/v27/o-0TIpQlx3QUlC5A4PNr4AyNYtyEx2xqPaif.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosans/v27/o-0NIpQlx3QUlC5A4PNjThZlY9aA5Wl6PQ.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/notosans/v27/o-0TIpQlx3QUlC5A4PNr4AzpYdyEx2xqPaif.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosans/v27/o-0IIpQlx3QUlC5A4PNb4j5Ba_2c7A.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/notosans/v27/o-0OIpQlx3QUlC5A4PNr4DRFSfiM7HBj.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosans/v27/o-0NIpQlx3QUlC5A4PNjFhdlY9aA5Wl6PQ.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/notosans/v27/o-0TIpQlx3QUlC5A4PNr4AyxYNyEx2xqPaif.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosans/v27/o-0NIpQlx3QUlC5A4PNjOhBlY9aA5Wl6PQ.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/notosans/v27/o-0TIpQlx3QUlC5A4PNr4AydZ9yEx2xqPaif.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosans/v27/o-0NIpQlx3QUlC5A4PNjXhFlY9aA5Wl6PQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/notosans/v27/o-0TIpQlx3QUlC5A4PNr4Az5ZtyEx2xqPaif.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosans/v27/o-0NIpQlx3QUlC5A4PNjQhJlY9aA5Wl6PQ.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/notosans/v27/o-0TIpQlx3QUlC5A4PNr4AzlZdyEx2xqPaif.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosans/v27/o-0NIpQlx3QUlC5A4PNjZhNlY9aA5Wl6PQ.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/notosans/v27/o-0TIpQlx3QUlC5A4PNr4AzBZNyEx2xqPaif.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Adlam\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"adlam\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansadlam/v21/neIczCCpqp0s5pPusPamd81eMfjPonvqdbYxxpgufnv0TGnBZLwhuvk.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansadlam/v21/neIczCCpqp0s5pPusPamd81eMfjPonvqdbYxxpgufkn0TGnBZLwhuvk.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansadlam/v21/neIczCCpqp0s5pPusPamd81eMfjPonvqdbYxxpgufqXzTGnBZLwhuvk.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansadlam/v21/neIczCCpqp0s5pPusPamd81eMfjPonvqdbYxxpgufpzzTGnBZLwhuvk.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Adlam Unjoined\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"adlam\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansadlamunjoined/v21/P5sszY2MYsLRsB5_ildkzPPDsLQXcOEmaFOqOGcaYrzFTIjsPam_Ye35PMEe-E3slUg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansadlamunjoined/v21/P5sszY2MYsLRsB5_ildkzPPDsLQXcOEmaFOqOGcaYrzFTIjsPam_Yd_5PMEe-E3slUg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansadlamunjoined/v21/P5sszY2MYsLRsB5_ildkzPPDsLQXcOEmaFOqOGcaYrzFTIjsPam_YTP-PMEe-E3slUg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansadlamunjoined/v21/P5sszY2MYsLRsB5_ildkzPPDsLQXcOEmaFOqOGcaYrzFTIjsPam_YQr-PMEe-E3slUg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Anatolian Hieroglyphs\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"anatolian-hieroglyphs\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansanatolianhieroglyphs/v14/ijw9s4roRME5LLRxjsRb8A0gKPSWq4BbDmHHu6j2pEtUJzZWXybIymc5QYo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Arabic\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"arabic\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-06-01\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansarabic/v18/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfyG2vu3CBFQLaig.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansarabic/v18/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfSGyvu3CBFQLaig.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansarabic/v18/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCflmyvu3CBFQLaig.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansarabic/v18/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfyGyvu3CBFQLaig.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansarabic/v18/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCf-myvu3CBFQLaig.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansarabic/v18/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfFmuvu3CBFQLaig.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansarabic/v18/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfL2uvu3CBFQLaig.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansarabic/v18/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfSGuvu3CBFQLaig.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansarabic/v18/nwpxtLGrOAZMl5nJ_wfgRg3DrWFZWsnVBJ_sS6tlqHHFlhQ5l3sQWIHPqzCfYWuvu3CBFQLaig.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Armenian\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"armenian\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v39\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansarmenian/v39/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLorxbq0iYy6zF3Eg.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansarmenian/v39/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLopxb60iYy6zF3Eg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansarmenian/v39/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLoqvb60iYy6zF3Eg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansarmenian/v39/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLorxb60iYy6zF3Eg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansarmenian/v39/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLorDb60iYy6zF3Eg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansarmenian/v39/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLoovaK0iYy6zF3Eg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansarmenian/v39/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLooWaK0iYy6zF3Eg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansarmenian/v39/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLopxaK0iYy6zF3Eg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansarmenian/v39/ZgN0jOZKPa7CHqq0h37c7ReDUubm2SEdFXp7ig73qtTY5idb74R9UdM3y2nZLopYaK0iYy6zF3Eg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Avestan\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"avestan\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansavestan/v17/bWti7ejKfBziStx7lIzKOLQZKhIJkyu9SASLji8U.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Balinese\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"balinese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansbalinese/v18/NaPwcYvSBuhTirw6IaFn6UrRDaqje-lpbbRtYf-Fwu2Ov7fdhE5Vd222PPY.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansbalinese/v18/NaPwcYvSBuhTirw6IaFn6UrRDaqje-lpbbRtYf-Fwu2Ov4XdhE5Vd222PPY.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansbalinese/v18/NaPwcYvSBuhTirw6IaFn6UrRDaqje-lpbbRtYf-Fwu2Ov2nahE5Vd222PPY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansbalinese/v18/NaPwcYvSBuhTirw6IaFn6UrRDaqje-lpbbRtYf-Fwu2Ov1DahE5Vd222PPY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Bamum\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"bamum\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansbamum/v26/uk-0EGK3o6EruUbnwovcbBTkkklK_Ya_PBHfNGTPEddO-_gLykxEkxA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansbamum/v26/uk-0EGK3o6EruUbnwovcbBTkkklK_Ya_PBHfNGTPEeVO-_gLykxEkxA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansbamum/v26/uk-0EGK3o6EruUbnwovcbBTkkklK_Ya_PBHfNGTPEQlJ-_gLykxEkxA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansbamum/v26/uk-0EGK3o6EruUbnwovcbBTkkklK_Ya_PBHfNGTPETBJ-_gLykxEkxA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Bassa Vah\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"bassa-vah\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansbassavah/v17/PN_bRee-r3f7LnqsD5sax12gjZn7mBpL5YwUpA2MBdcFn4MaAc6p34gH-GD7.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansbassavah/v17/PN_bRee-r3f7LnqsD5sax12gjZn7mBpL5YwUpA2MBdcFn4MoAc6p34gH-GD7.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansbassavah/v17/PN_bRee-r3f7LnqsD5sax12gjZn7mBpL5YwUpA2MBdcFn4PEBs6p34gH-GD7.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansbassavah/v17/PN_bRee-r3f7LnqsD5sax12gjZn7mBpL5YwUpA2MBdcFn4P9Bs6p34gH-GD7.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Batak\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"batak\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansbatak/v16/gok2H6TwAEdtF9N8-mdTCQvT-Zdgo4_PHuk74A.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Bengali\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"bengali\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansbengali/v20/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsolKudCk8izI0lc.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansbengali/v20/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsglLudCk8izI0lc.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansbengali/v20/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmstdLudCk8izI0lc.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansbengali/v20/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsolLudCk8izI0lc.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansbengali/v20/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsrtLudCk8izI0lc.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansbengali/v20/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsldMudCk8izI0lc.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansbengali/v20/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6Kmsm5MudCk8izI0lc.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansbengali/v20/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsglMudCk8izI0lc.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansbengali/v20/Cn-SJsCGWQxOjaGwMQ6fIiMywrNJIky6nvd8BjzVMvJx2mcSPVFpVEqE-6KmsiBMudCk8izI0lc.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Bhaiksuki\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"bhaiksuki\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansbhaiksuki/v15/UcC63EosKniBH4iELXATsSBWdvUHXxhj8rLUdU4wh9U.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Brahmi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"brahmi\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansbrahmi/v15/vEFK2-VODB8RrNDvZSUmQQIIByV18tK1W77HtMo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Buginese\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"buginese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansbuginese/v17/esDM30ldNv-KYGGJpKGk18phe_7Da6_gtfuEXLmNtw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Buhid\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"buhid\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansbuhid/v17/Dxxy8jiXMW75w3OmoDXVWJD7YwzAe6tgnaFoGA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Canadian Aboriginal\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"canadian-aboriginal\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanscanadianaboriginal/v21/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigWLj_yAsg0q0uhQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosanscanadianaboriginal/v21/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzig2Ln_yAsg0q0uhQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanscanadianaboriginal/v21/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigBrn_yAsg0q0uhQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanscanadianaboriginal/v21/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigWLn_yAsg0q0uhQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanscanadianaboriginal/v21/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigarn_yAsg0q0uhQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanscanadianaboriginal/v21/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzighr7_yAsg0q0uhQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanscanadianaboriginal/v21/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzigv77_yAsg0q0uhQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosanscanadianaboriginal/v21/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzig2L7_yAsg0q0uhQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanscanadianaboriginal/v21/4C_TLjTuEqPj-8J01CwaGkiZ9os0iGVkezM1mUT-j_Lmlzda6uH_nnX1bzig8b7_yAsg0q0uhQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Carian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"carian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanscarian/v15/LDIpaoiONgYwA9Yc6f0gUILeMIOgs7ob9yGLmfI.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Caucasian Albanian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"caucasian-albanian\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanscaucasianalbanian/v16/nKKA-HM_FYFRJvXzVXaANsU0VzsAc46QGOkWytlTs-TXrYDmoVmRSZo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Chakma\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"chakma\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanschakma/v17/Y4GQYbJ8VTEp4t3MKJSMjg5OIzhi4JjTQhYBeYo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Cham\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"cham\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v23\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanscham/v23/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcER0cv7GykboaLg.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosanscham/v23/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfckRwcv7GykboaLg.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanscham/v23/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcTxwcv7GykboaLg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanscham/v23/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcERwcv7GykboaLg.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanscham/v23/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcIxwcv7GykboaLg.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanscham/v23/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfczxscv7GykboaLg.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanscham/v23/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfc9hscv7GykboaLg.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosanscham/v23/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfckRscv7GykboaLg.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanscham/v23/pe06MIySN5pO62Z5YkFyQb_bbuRhe6D4yip43qfcuBscv7GykboaLg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Cherokee\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"cherokee\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanscherokee/v19/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWi5ODkm5rAffjl0.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosanscherokee/v19/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWq5PDkm5rAffjl0.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanscherokee/v19/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWnBPDkm5rAffjl0.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanscherokee/v19/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWi5PDkm5rAffjl0.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanscherokee/v19/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWhxPDkm5rAffjl0.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanscherokee/v19/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWvBIDkm5rAffjl0.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanscherokee/v19/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWslIDkm5rAffjl0.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosanscherokee/v19/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWq5IDkm5rAffjl0.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanscherokee/v19/KFOPCm6Yu8uF-29fiz9vQF9YWK6Z8O10cHNA0cSkZCHYWodIDkm5rAffjl0.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Coptic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"coptic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanscoptic/v17/iJWfBWmUZi_OHPqn4wq6kgqumOEd78u_VG0xR4Y.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Cuneiform\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cuneiform\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanscuneiform/v15/bMrrmTWK7YY-MF22aHGGd7H8PhJtvBDWgb9JlRQueeQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Cypriot\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"cypriot\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanscypriot/v15/8AtzGta9PYqQDjyp79a6f8Cj-3a3cxIsK5MPpahF.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Deseret\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"deseret\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansdeseret/v15/MwQsbgPp1eKH6QsAVuFb9AZM6MMr2Vq9ZnJSZtQG.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Devanagari\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"devanagari\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansdevanagari/v19/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlXQky-AzoFoW4Ow.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansdevanagari/v19/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlfQly-AzoFoW4Ow.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansdevanagari/v19/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlSoly-AzoFoW4Ow.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansdevanagari/v19/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlXQly-AzoFoW4Ow.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansdevanagari/v19/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlUYly-AzoFoW4Ow.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansdevanagari/v19/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08Alaoiy-AzoFoW4Ow.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansdevanagari/v19/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlZMiy-AzoFoW4Ow.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansdevanagari/v19/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08AlfQiy-AzoFoW4Ow.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansdevanagari/v19/TuGoUUFzXI5FBtUq5a8bjKYTZjtRU6Sgv3NaV_SNmI0b8QQCQmHn6B2OHjbL_08Ald0iy-AzoFoW4Ow.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Display\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\",\n        \"100italic\",\n        \"200italic\",\n        \"300italic\",\n        \"italic\",\n        \"500italic\",\n        \"600italic\",\n        \"700italic\",\n        \"800italic\",\n        \"900italic\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_3cLVTGQ2iHrvWM.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp__cKVTGQ2iHrvWM.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_ykKVTGQ2iHrvWM.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_3cKVTGQ2iHrvWM.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_0UKVTGQ2iHrvWM.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_6kNVTGQ2iHrvWM.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_5ANVTGQ2iHrvWM.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp__cNVTGQ2iHrvWM.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpbK4fy6r6tOBEJg0IAKzqdFZVZxpMkXJMhnB9XjO1o90LuV-PT4Doq_AKp_94NVTGQ2iHrvWM.ttf\",\n        \"100italic\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JvXOa3gPurWM9uQ.ttf\",\n        \"200italic\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JPXKa3gPurWM9uQ.ttf\",\n        \"300italic\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9J43Ka3gPurWM9uQ.ttf\",\n        \"italic\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JvXKa3gPurWM9uQ.ttf\",\n        \"500italic\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9Jj3Ka3gPurWM9uQ.ttf\",\n        \"600italic\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JY3Wa3gPurWM9uQ.ttf\",\n        \"700italic\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JWnWa3gPurWM9uQ.ttf\",\n        \"800italic\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JPXWa3gPurWM9uQ.ttf\",\n        \"900italic\": \"http://fonts.gstatic.com/s/notosansdisplay/v20/RLpZK4fy6r6tOBEJg0IAKzqdFZVZxrktbnDB5UzBIup9PwAcHtEsOFNBZqyu6r9JFHWa3gPurWM9uQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Duployan\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"duployan\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansduployan/v16/gokzH7nwAEdtF9N8-mdTDx_X9JM5wsvrFsIn6WYDvA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Egyptian Hieroglyphs\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"egyptian-hieroglyphs\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansegyptianhieroglyphs/v26/vEF42-tODB8RrNDvZSUmRhcQHzx1s7y_F9-j3qSzEcbEYindSVK8xRg7iw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Elbasan\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"elbasan\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanselbasan/v15/-F6rfiZqLzI2JPCgQBnw400qp1trvHdlre4dFcFh.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Elymaic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"elymaic\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanselymaic/v15/UqyKK9YTJW5liNMhTMqe9vUFP65ZD4AjWOT0zi2V.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Ethiopic\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"ethiopic\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v42\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansethiopic/v42/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T35OKqDjwmfeaY9u.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansethiopic/v42/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T37OK6DjwmfeaY9u.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansethiopic/v42/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T34QK6DjwmfeaY9u.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansethiopic/v42/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T35OK6DjwmfeaY9u.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansethiopic/v42/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T358K6DjwmfeaY9u.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansethiopic/v42/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T36QLKDjwmfeaY9u.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansethiopic/v42/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T36pLKDjwmfeaY9u.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansethiopic/v42/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T37OLKDjwmfeaY9u.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansethiopic/v42/7cHPv50vjIepfJVOZZgcpQ5B9FBTH9KGNfhSTgtoow1KVnIvyBoMSzUMacb-T37nLKDjwmfeaY9u.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Georgian\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"georgian\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v36\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansgeorgian/v36/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpvnzVj-f5WK0OQV.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansgeorgian/v36/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdptnzFj-f5WK0OQV.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansgeorgian/v36/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpu5zFj-f5WK0OQV.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansgeorgian/v36/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpvnzFj-f5WK0OQV.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansgeorgian/v36/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpvVzFj-f5WK0OQV.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansgeorgian/v36/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdps5y1j-f5WK0OQV.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansgeorgian/v36/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdpsAy1j-f5WK0OQV.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansgeorgian/v36/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdptny1j-f5WK0OQV.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansgeorgian/v36/PlIaFke5O6RzLfvNNVSitxkr76PRHBC4Ytyq-Gof7PUs4S7zWn-8YDB09HFNdptOy1j-f5WK0OQV.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Glagolitic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"glagolitic\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansglagolitic/v15/1q2ZY4-BBFBst88SU_tOj4J-4yuNF_HI4ERK4Amu7nM1.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Gothic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"gothic\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansgothic/v15/TuGKUUVzXI5FBtUq5a8bj6wRbzxTFMX40kFQRx0.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Grantha\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"grantha\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansgrantha/v17/3y976akwcCjmsU8NDyrKo3IQfQ4o-r8cFeulHc6N.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Gujarati\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"gujarati\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansgujarati/v19/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_ypFgPM_OdiEH0s.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansgujarati/v19/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_wpFwPM_OdiEH0s.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansgujarati/v19/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_z3FwPM_OdiEH0s.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansgujarati/v19/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_ypFwPM_OdiEH0s.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansgujarati/v19/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_ybFwPM_OdiEH0s.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansgujarati/v19/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_x3EAPM_OdiEH0s.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansgujarati/v19/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_xOEAPM_OdiEH0s.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansgujarati/v19/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_wpEAPM_OdiEH0s.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansgujarati/v19/wlpWgx_HC1ti5ViekvcxnhMlCVo3f5pv17ivlzsUB14gg1TMR2Gw4VceEl7MA_wAEAPM_OdiEH0s.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Gunjala Gondi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"gunjala-gondi\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansgunjalagondi/v15/bWto7e7KfBziStx7lIzKPrcSMwcEnCv6DW7n5hcVXYMTK4q1.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Gurmukhi\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"gurmukhi\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansgurmukhi/v20/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG1Oe3bxZ_trdp7h.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansgurmukhi/v20/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG3OenbxZ_trdp7h.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansgurmukhi/v20/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG0QenbxZ_trdp7h.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansgurmukhi/v20/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG1OenbxZ_trdp7h.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansgurmukhi/v20/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG18enbxZ_trdp7h.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansgurmukhi/v20/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG2QfXbxZ_trdp7h.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansgurmukhi/v20/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG2pfXbxZ_trdp7h.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansgurmukhi/v20/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG3OfXbxZ_trdp7h.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansgurmukhi/v20/w8g9H3EvQP81sInb43inmyN9zZ7hb7ATbSWo4q8dJ74a3cVrYFQ_bogT0-gPeG3nfXbxZ_trdp7h.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans HK\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"chinese-hongkong\",\n        \"latin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanshk/v21/nKKO-GM_FYFRJvXzVXaAPe9ZUHp1MOv2ObB7.otf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanshk/v21/nKKP-GM_FYFRJvXzVXaAPe9ZmFhTHMX6MKliqQ.otf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanshk/v21/nKKQ-GM_FYFRJvXzVXaAPe9hMnB3Eu7mOQ.otf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanshk/v21/nKKP-GM_FYFRJvXzVXaAPe9ZwFlTHMX6MKliqQ.otf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanshk/v21/nKKP-GM_FYFRJvXzVXaAPe9ZiF9THMX6MKliqQ.otf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanshk/v21/nKKP-GM_FYFRJvXzVXaAPe9ZsF1THMX6MKliqQ.otf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Hanifi Rohingya\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"hanifi-rohingya\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanshanifirohingya/v22/5h17iYsoOmIC3Yu3MDXLDw3UZCgghyOEBBY7hhLNyo3tiaiuSIAqrIYY4j6vvcudK8rN.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanshanifirohingya/v22/5h17iYsoOmIC3Yu3MDXLDw3UZCgghyOEBBY7hhLNyo3tiaiuSIAqrIYq4j6vvcudK8rN.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanshanifirohingya/v22/5h17iYsoOmIC3Yu3MDXLDw3UZCgghyOEBBY7hhLNyo3tiaiuSIAqrIbG5T6vvcudK8rN.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanshanifirohingya/v22/5h17iYsoOmIC3Yu3MDXLDw3UZCgghyOEBBY7hhLNyo3tiaiuSIAqrIb_5T6vvcudK8rN.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Hanunoo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"hanunoo\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanshanunoo/v17/f0Xs0fCv8dxkDWlZSoXOj6CphMloFsEsEpgL_ix2.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Hatran\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"hatran\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanshatran/v15/A2BBn4Ne0RgnVF3Lnko-0sOBIfL_mM83r1nwzDs.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Hebrew\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"hebrew\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v38\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanshebrew/v38/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXd4utoiJltutR2g.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosanshebrew/v38/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiX94qtoiJltutR2g.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanshebrew/v38/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXKYqtoiJltutR2g.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanshebrew/v38/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXd4qtoiJltutR2g.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanshebrew/v38/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXRYqtoiJltutR2g.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanshebrew/v38/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXqY2toiJltutR2g.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanshebrew/v38/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiXkI2toiJltutR2g.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosanshebrew/v38/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiX942toiJltutR2g.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanshebrew/v38/or3HQ7v33eiDljA1IufXTtVf7V6RvEEdhQlk0LlGxCyaeNKYZC0sqk3xXGiX3o2toiJltutR2g.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Imperial Aramaic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"imperial-aramaic\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansimperialaramaic/v15/a8IMNpjwKmHXpgXbMIsbTc_kvks91LlLetBr5itQrtdml3YfPNno.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Indic Siyaq Numbers\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"indic-siyaq-numbers\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansindicsiyaqnumbers/v15/6xK5dTJFKcWIu4bpRBjRZRpsIYHabOeZ8UZLubTzpXNHKx2WPOpVd5Iu.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Inscriptional Pahlavi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"inscriptional-pahlavi\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansinscriptionalpahlavi/v15/ll8UK3GaVDuxR-TEqFPIbsR79Xxz9WEKbwsjpz7VklYlC7FCVtqVOAYK0QA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Inscriptional Parthian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"inscriptional-parthian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansinscriptionalparthian/v15/k3k7o-IMPvpLmixcA63oYi-yStDkgXuXncL7dzfW3P4TAJ2yklBJ2jNkLlLr.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans JP\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"japanese\",\n        \"latin\"\n      ],\n      \"version\": \"v42\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansjp/v42/-F6ofjtqLzI2JPCgQBnw7HFQoggM-FNthvIU.otf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansjp/v42/-F6pfjtqLzI2JPCgQBnw7HFQaioq1H1hj-sNFQ.otf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansjp/v42/-F62fjtqLzI2JPCgQBnw7HFowAIO2lZ9hg.otf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansjp/v42/-F6pfjtqLzI2JPCgQBnw7HFQMisq1H1hj-sNFQ.otf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansjp/v42/-F6pfjtqLzI2JPCgQBnw7HFQei0q1H1hj-sNFQ.otf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansjp/v42/-F6pfjtqLzI2JPCgQBnw7HFQQi8q1H1hj-sNFQ.otf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Javanese\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"javanese\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansjavanese/v19/2V01KJkDAIA6Hp4zoSScDjV0Y-eoHAHT-Z3MngEefiidxJnkFFliZYWj4O8.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansjavanese/v19/2V01KJkDAIA6Hp4zoSScDjV0Y-eoHAHT-Z3MngEefiidxKvkFFliZYWj4O8.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansjavanese/v19/2V01KJkDAIA6Hp4zoSScDjV0Y-eoHAHT-Z3MngEefiidxEfjFFliZYWj4O8.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansjavanese/v19/2V01KJkDAIA6Hp4zoSScDjV0Y-eoHAHT-Z3MngEefiidxH7jFFliZYWj4O8.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans KR\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"korean\",\n        \"latin\"\n      ],\n      \"version\": \"v27\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanskr/v27/Pby6FmXiEBPT4ITbgNA5CgmOsn7uwpYcuH8y.otf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanskr/v27/Pby7FmXiEBPT4ITbgNA5CgmOelzI7rgQsWYrzw.otf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanskr/v27/PbykFmXiEBPT4ITbgNA5Cgm20HTs4JMMuA.otf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanskr/v27/Pby7FmXiEBPT4ITbgNA5CgmOIl3I7rgQsWYrzw.otf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanskr/v27/Pby7FmXiEBPT4ITbgNA5CgmOalvI7rgQsWYrzw.otf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanskr/v27/Pby7FmXiEBPT4ITbgNA5CgmOUlnI7rgQsWYrzw.otf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Kaithi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"kaithi\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanskaithi/v16/buEtppS9f8_vkXadMBJJu0tWjLwjQi0KdoZIKlo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Kannada\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"kannada\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanskannada/v21/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrDvMzSIMLsPKrkY.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosanskannada/v21/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrLvNzSIMLsPKrkY.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanskannada/v21/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrGXNzSIMLsPKrkY.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanskannada/v21/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrDvNzSIMLsPKrkY.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanskannada/v21/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrAnNzSIMLsPKrkY.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanskannada/v21/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrOXKzSIMLsPKrkY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanskannada/v21/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrNzKzSIMLsPKrkY.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosanskannada/v21/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrLvKzSIMLsPKrkY.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanskannada/v21/8vIs7xs32H97qzQKnzfeXycxXZyUmySvZWItmf1fe6TVmgop9ndpS-BqHEyGrJLKzSIMLsPKrkY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Kayah Li\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"kayah-li\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanskayahli/v20/B50nF61OpWTRcGrhOVJJwOMXdca6Yecki3E06x2jVTX3WCc3CZH4EXLuKVM.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanskayahli/v20/B50nF61OpWTRcGrhOVJJwOMXdca6Yecki3E06x2jVTX3WBU3CZH4EXLuKVM.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanskayahli/v20/B50nF61OpWTRcGrhOVJJwOMXdca6Yecki3E06x2jVTX3WPkwCZH4EXLuKVM.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanskayahli/v20/B50nF61OpWTRcGrhOVJJwOMXdca6Yecki3E06x2jVTX3WMAwCZH4EXLuKVM.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Kharoshthi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"kharoshthi\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanskharoshthi/v15/Fh4qPiLjKS30-P4-pGMMXCCfvkc5Vd7KE5z4rFyx5mR1.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Khmer\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"khmer\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanskhmer/v18/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYuNAZz4kAbrddiA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosanskhmer/v18/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYsNAJz4kAbrddiA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanskhmer/v18/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYvTAJz4kAbrddiA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanskhmer/v18/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYuNAJz4kAbrddiA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanskhmer/v18/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYu_AJz4kAbrddiA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanskhmer/v18/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYtTB5z4kAbrddiA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanskhmer/v18/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYtqB5z4kAbrddiA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosanskhmer/v18/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYsNB5z4kAbrddiA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanskhmer/v18/ijw3s5roRME5LLRxjsRb-gssOenAyendxrgV2c-Zw-9vbVUti_Z_dWgtWYskB5z4kAbrddiA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Khojki\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khojki\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanskhojki/v16/-nFnOHM29Oofr2wohFbTuPPKVWpmK_d709jy92k.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Khudawadi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"khudawadi\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanskhudawadi/v16/fdNi9t6ZsWBZ2k5ltHN73zZ5hc8HANlHIjRnVVXz9MY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Lao\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"lao\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v24\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanslao/v24/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4ccfdf5MK3riB2w.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosanslao/v24/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt48cbdf5MK3riB2w.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanslao/v24/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4L8bdf5MK3riB2w.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanslao/v24/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4ccbdf5MK3riB2w.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanslao/v24/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4Q8bdf5MK3riB2w.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanslao/v24/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4r8Hdf5MK3riB2w.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanslao/v24/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt4lsHdf5MK3riB2w.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosanslao/v24/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt48cHdf5MK3riB2w.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanslao/v24/bx6lNx2Ol_ixgdYWLm9BwxM3NW6BOkuf763Clj73CiQ_J1Djx9pidOt42MHdf5MK3riB2w.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Lao Looped\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"lao\",\n        \"latin\",\n        \"latin-ext\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanslaolooped/v2/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomPr2M-Zw5V_T71k.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosanslaolooped/v2/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomHr3M-Zw5V_T71k.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanslaolooped/v2/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomKT3M-Zw5V_T71k.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanslaolooped/v2/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomPr3M-Zw5V_T71k.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanslaolooped/v2/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomMj3M-Zw5V_T71k.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanslaolooped/v2/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomCTwM-Zw5V_T71k.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanslaolooped/v2/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomB3wM-Zw5V_T71k.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosanslaolooped/v2/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomHrwM-Zw5V_T71k.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanslaolooped/v2/a8IgNpbwKmHXpgXbMIsbSMP7-3U72qUOX5gBg6LRXExhqHIX9YPTpvqkW4UthhjomFPwM-Zw5V_T71k.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Lepcha\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"lepcha\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanslepcha/v16/0QI7MWlB_JWgA166SKhu05TekNS32AJstqBXgd4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Limbu\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"limbu\"\n      ],\n      \"version\": \"v22\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanslimbu/v22/3JnlSDv90Gmq2mrzckOBBRRoNJVj0MF3OHRDnA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Linear A\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"linear-a\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanslineara/v16/oPWS_l16kP4jCuhpgEGmwJOiA18FZj22zmHQAGQicw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Linear B\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"linear-b\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanslinearb/v15/HhyJU4wt9vSgfHoORYOiXOckKNB737IV3BkFTq4EPw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Lisu\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"lisu\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanslisu/v21/uk-3EGO3o6EruUbnwovcYhz6kh57_nqbcTdjJnHP2Vwt29IlxkVdig.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanslisu/v21/uk-3EGO3o6EruUbnwovcYhz6kh57_nqbcTdjJnHP61wt29IlxkVdig.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanslisu/v21/uk-3EGO3o6EruUbnwovcYhz6kh57_nqbcTdjJnHPB1st29IlxkVdig.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanslisu/v21/uk-3EGO3o6EruUbnwovcYhz6kh57_nqbcTdjJnHPPlst29IlxkVdig.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Lycian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"lycian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanslycian/v15/QldVNSNMqAsHtsJ7UmqxBQA9r8wA5_naCJwn00E.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Lydian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"lydian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanslydian/v15/c4m71mVzGN7s8FmIukZJ1v4ZlcPReUPXMoIjEQI.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Mahajani\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"mahajani\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmahajani/v15/-F6sfiVqLzI2JPCgQBnw60Agp0JrvD5Fh8ARHNh4zg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Malayalam\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"malayalam\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-22\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansmalayalam/v21/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_RuH9BFzEr6HxEA.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansmalayalam/v21/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_xuD9BFzEr6HxEA.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansmalayalam/v21/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_GOD9BFzEr6HxEA.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmalayalam/v21/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_RuD9BFzEr6HxEA.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansmalayalam/v21/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_dOD9BFzEr6HxEA.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansmalayalam/v21/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_mOf9BFzEr6HxEA.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansmalayalam/v21/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_oef9BFzEr6HxEA.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansmalayalam/v21/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_xuf9BFzEr6HxEA.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansmalayalam/v21/sJoi3K5XjsSdcnzn071rL37lpAOsUThnDZIfPdbeSNzVakglNM-Qw8EaeB8Nss-_7-f9BFzEr6HxEA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Mandaic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"mandaic\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmandaic/v15/cIfnMbdWt1w_HgCcilqhKQBo_OsMI5_A_gMk0izH.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Manichaean\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"manichaean\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmanichaean/v15/taiVGntiC4--qtsfi4Jp9-_GkPZZCcrfekqCNTtFCtdX.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Marchen\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"marchen\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-02\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmarchen/v17/aFTO7OZ_Y282EP-WyG6QTOX_C8WZMHhPk652ZaHk.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Masaram Gondi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"masaram-gondi\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmasaramgondi/v17/6xK_dThFKcWIu4bpRBjRYRV7KZCbUq6n_1kPnuGe7RI9WSWX.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Math\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"math\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmath/v15/7Aump_cpkSecTWaHRlH2hyV5UHkG-V048PW0.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Mayan Numerals\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"mayan-numerals\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmayannumerals/v15/PlIuFk25O6RzLfvNNVSivR09_KqYMwvvDKYjfIiE68oo6eepYQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Medefaidrin\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"medefaidrin\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmedefaidrin/v21/WwkzxOq6Dk-wranENynkfeVsNbRZtbOIdLb1exeM4ZeuabBfmErWlT318e5A3rw.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansmedefaidrin/v21/WwkzxOq6Dk-wranENynkfeVsNbRZtbOIdLb1exeM4ZeuabBfmHjWlT318e5A3rw.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansmedefaidrin/v21/WwkzxOq6Dk-wranENynkfeVsNbRZtbOIdLb1exeM4ZeuabBfmJTRlT318e5A3rw.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansmedefaidrin/v21/WwkzxOq6Dk-wranENynkfeVsNbRZtbOIdLb1exeM4ZeuabBfmK3RlT318e5A3rw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Meetei Mayek\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"meetei-mayek\"\n      ],\n      \"version\": \"v14\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansmeeteimayek/v14/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1TJ__TW5PgeFYVa.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansmeeteimayek/v14/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1RJ_vTW5PgeFYVa.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansmeeteimayek/v14/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1SX_vTW5PgeFYVa.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmeeteimayek/v14/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1TJ_vTW5PgeFYVa.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansmeeteimayek/v14/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1T7_vTW5PgeFYVa.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansmeeteimayek/v14/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1QX-fTW5PgeFYVa.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansmeeteimayek/v14/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1Qu-fTW5PgeFYVa.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansmeeteimayek/v14/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1RJ-fTW5PgeFYVa.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansmeeteimayek/v14/HTxAL3QyKieByqY9eZPFweO0be7M21uSphSdhqILnmrRfJ8t_1Rg-fTW5PgeFYVa.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Mende Kikakui\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"mende-kikakui\"\n      ],\n      \"version\": \"v28\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmendekikakui/v28/11hRGoLHz17aKjQCWj-JHcLvu2Q5zZrnkbNCLUx_aDJLAHer.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Meroitic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"meroitic\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmeroitic/v16/IFS5HfRJndhE3P4b5jnZ3ITPvC6i00UDgDhTiKY9KQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Miao\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"miao\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmiao/v17/Dxxz8jmXMW75w3OmoDXVV4zyZUjgUYVslLhx.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Modi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"modi\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmodi/v20/pe03MIySN5pO62Z5YkFyT7jeav5qWVAgVol-.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Mongolian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"mongolian\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmongolian/v17/VdGCAYADGIwE0EopZx8xQfHlgEAMsrToxLsg6-av1x0.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Mono\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"cyrillic\",\n        \"cyrillic-ext\",\n        \"greek\",\n        \"greek-ext\",\n        \"latin\",\n        \"latin-ext\",\n        \"vietnamese\"\n      ],\n      \"version\": \"v21\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansmono/v21/BngrUXNETWXI6LwhGYvaxZikqZqK6fBq6kPvUce2oAZcdthSBUsYck4-_FNI49rXVEQQL8Y.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansmono/v21/BngrUXNETWXI6LwhGYvaxZikqZqK6fBq6kPvUce2oAZcdthSBUsYck4-_NNJ49rXVEQQL8Y.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansmono/v21/BngrUXNETWXI6LwhGYvaxZikqZqK6fBq6kPvUce2oAZcdthSBUsYck4-_A1J49rXVEQQL8Y.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmono/v21/BngrUXNETWXI6LwhGYvaxZikqZqK6fBq6kPvUce2oAZcdthSBUsYck4-_FNJ49rXVEQQL8Y.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansmono/v21/BngrUXNETWXI6LwhGYvaxZikqZqK6fBq6kPvUce2oAZcdthSBUsYck4-_GFJ49rXVEQQL8Y.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansmono/v21/BngrUXNETWXI6LwhGYvaxZikqZqK6fBq6kPvUce2oAZcdthSBUsYck4-_I1O49rXVEQQL8Y.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansmono/v21/BngrUXNETWXI6LwhGYvaxZikqZqK6fBq6kPvUce2oAZcdthSBUsYck4-_LRO49rXVEQQL8Y.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansmono/v21/BngrUXNETWXI6LwhGYvaxZikqZqK6fBq6kPvUce2oAZcdthSBUsYck4-_NNO49rXVEQQL8Y.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansmono/v21/BngrUXNETWXI6LwhGYvaxZikqZqK6fBq6kPvUce2oAZcdthSBUsYck4-_PpO49rXVEQQL8Y.ttf\"\n      },\n      \"category\": \"monospace\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Mro\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"mro\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmro/v18/qWcsB6--pZv9TqnUQMhe9b39WDzRtjkho4M.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Multani\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"multani\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmultani/v20/9Bty3ClF38_RfOpe1gCaZ8p30BOFO1A0pfCs5Kos.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Myanmar\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"myanmar\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansmyanmar/v20/AlZs_y1ZtY3ymOryg38hOCSdOnFq0HGS1uEapkAC3AY.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansmyanmar/v20/AlZv_y1ZtY3ymOryg38hOCSdOnFq0HE-98EwiEwLxR-r.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansmyanmar/v20/AlZv_y1ZtY3ymOryg38hOCSdOnFq0HFa9MEwiEwLxR-r.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansmyanmar/v20/AlZq_y1ZtY3ymOryg38hOCSdOnFq0En23OU4o1AC.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansmyanmar/v20/AlZv_y1ZtY3ymOryg38hOCSdOnFq0HEC9cEwiEwLxR-r.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansmyanmar/v20/AlZv_y1ZtY3ymOryg38hOCSdOnFq0HEu8sEwiEwLxR-r.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansmyanmar/v20/AlZv_y1ZtY3ymOryg38hOCSdOnFq0HFK88EwiEwLxR-r.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansmyanmar/v20/AlZv_y1ZtY3ymOryg38hOCSdOnFq0HFW8MEwiEwLxR-r.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansmyanmar/v20/AlZv_y1ZtY3ymOryg38hOCSdOnFq0HFy8cEwiEwLxR-r.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans NKo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"nko\"\n      ],\n      \"version\": \"v2\",\n      \"lastModified\": \"2023-01-25\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansnko/v2/esDX31ZdNv-KYGGJpKGk2_RpMpCMHMLBrdA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Nabataean\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"nabataean\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansnabataean/v15/IFS4HfVJndhE3P4b5jnZ34DfsjO330dNoBJ9hK8kMK4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans New Tai Lue\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"new-tai-lue\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansnewtailue/v17/H4cKBW-Pl9DZ0Xe_nHUapt7PovLXAhAnY7wqaLy-OJgU3p_pdeXAYUbghFPKzeY.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansnewtailue/v17/H4cKBW-Pl9DZ0Xe_nHUapt7PovLXAhAnY7wqaLy-OJgU3p_pddfAYUbghFPKzeY.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansnewtailue/v17/H4cKBW-Pl9DZ0Xe_nHUapt7PovLXAhAnY7wqaLy-OJgU3p_pdTvHYUbghFPKzeY.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansnewtailue/v17/H4cKBW-Pl9DZ0Xe_nHUapt7PovLXAhAnY7wqaLy-OJgU3p_pdQLHYUbghFPKzeY.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Newa\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"newa\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansnewa/v16/7r3fqXp6utEsO9pI4f8ok8sWg8n_qN4R5lNU.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Nushu\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"nushu\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansnushu/v18/rnCw-xRQ3B7652emAbAe_Ai1IYaFWFAMArZKqQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Ogham\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"ogham\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansogham/v15/kmKlZqk1GBDGN0mY6k5lmEmww4hrt5laQxcoCA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Ol Chiki\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"ol-chiki\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansolchiki/v20/N0b92TJNOPt-eHmFZCdQbrL32r-4CvhzDzRwlxOQYuVALWk267I6gVrz5gQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansolchiki/v20/N0b92TJNOPt-eHmFZCdQbrL32r-4CvhzDzRwlxOQYuVALVs267I6gVrz5gQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansolchiki/v20/N0b92TJNOPt-eHmFZCdQbrL32r-4CvhzDzRwlxOQYuVALbcx67I6gVrz5gQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansolchiki/v20/N0b92TJNOPt-eHmFZCdQbrL32r-4CvhzDzRwlxOQYuVALY4x67I6gVrz5gQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Old Hungarian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"old-hungarian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansoldhungarian/v15/E213_cD6hP3GwCJPEUssHEM0KqLaHJXg2PiIgRfjbg5nCYXt.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Old Italic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"old-italic\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansolditalic/v15/TuGOUUFzXI5FBtUq5a8bh68BJxxEVam7tWlRdRhtCC4d.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Old North Arabian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"old-north-arabian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansoldnortharabian/v15/esDF30BdNv-KYGGJpKGk2tNiMt7Jar6olZDyNdr81zBQmUo_xw4ABw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Old Permic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"old-permic\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansoldpermic/v16/snf1s1q1-dF8pli1TesqcbUY4Mr-ElrwKLdXgv_dKYB5.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Old Persian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"old-persian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansoldpersian/v15/wEOjEAbNnc5caQTFG18FHrZr9Bp6-8CmIJ_tqOlQfx9CjA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Old Sogdian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"old-sogdian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansoldsogdian/v15/3JnjSCH90Gmq2mrzckOBBhFhdrMst48aURt7neIqM-9uyg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Old South Arabian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"old-south-arabian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansoldsoutharabian/v15/3qT5oiOhnSyU8TNFIdhZTice3hB_HWKsEnF--0XCHiKx1OtDT9HwTA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Old Turkic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"old-turkic\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansoldturkic/v15/yMJNMJVya43H0SUF_WmcGEQVqoEMKDKbsE2RjEw-Vyws.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Oriya\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"oriya\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosansoriya/v19/AYCppXfzfccDCstK_hrjDyADv5e9748vhj3CJBLHIARtgD6TJQS0dJT5Ivj0fq_c6LhHBRe-.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosansoriya/v19/AYCppXfzfccDCstK_hrjDyADv5e9748vhj3CJBLHIARtgD6TJQS0dJT5Ivh0f6_c6LhHBRe-.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosansoriya/v19/AYCppXfzfccDCstK_hrjDyADv5e9748vhj3CJBLHIARtgD6TJQS0dJT5Iviqf6_c6LhHBRe-.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosansoriya/v19/AYCppXfzfccDCstK_hrjDyADv5e9748vhj3CJBLHIARtgD6TJQS0dJT5Ivj0f6_c6LhHBRe-.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosansoriya/v19/AYCppXfzfccDCstK_hrjDyADv5e9748vhj3CJBLHIARtgD6TJQS0dJT5IvjGf6_c6LhHBRe-.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosansoriya/v19/AYCppXfzfccDCstK_hrjDyADv5e9748vhj3CJBLHIARtgD6TJQS0dJT5IvgqeK_c6LhHBRe-.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosansoriya/v19/AYCppXfzfccDCstK_hrjDyADv5e9748vhj3CJBLHIARtgD6TJQS0dJT5IvgTeK_c6LhHBRe-.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosansoriya/v19/AYCppXfzfccDCstK_hrjDyADv5e9748vhj3CJBLHIARtgD6TJQS0dJT5Ivh0eK_c6LhHBRe-.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosansoriya/v19/AYCppXfzfccDCstK_hrjDyADv5e9748vhj3CJBLHIARtgD6TJQS0dJT5IvhdeK_c6LhHBRe-.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Osage\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"osage\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansosage/v18/oPWX_kB6kP4jCuhpgEGmw4mtAVtXRlaSxkrMCQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Osmanya\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"osmanya\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansosmanya/v18/8vIS7xs32H97qzQKnzfeWzUyUpOJmz6kR47NCV5Z.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Pahawh Hmong\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"pahawh-hmong\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanspahawhhmong/v17/bWtp7e_KfBziStx7lIzKKaMUOBEA3UPQDW7krzc_c48aMpM.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Palmyrene\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"palmyrene\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanspalmyrene/v15/ZgNPjOdKPa7CHqq0h37c_ASCWvH93SFCPnK5ZpdNtcA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Pau Cin Hau\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"pau-cin-hau\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanspaucinhau/v19/x3d-cl3IZKmUqiMg_9wBLLtzl22EayN7ehIdjEWqKMxsKw.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Phags Pa\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"phags-pa\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansphagspa/v15/pxiZyoo6v8ZYyWh5WuPeJzMkd4SrGChkqkSsrvNXiA.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Phoenician\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"phoenician\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansphoenician/v15/jizFRF9Ksm4Bt9PvcTaEkIHiTVtxmFtS5X7Jot-p5561.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Psalter Pahlavi\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"psalter-pahlavi\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanspsalterpahlavi/v15/rP2Vp3K65FkAtHfwd-eISGznYihzggmsicPfud3w1G3KsUQBct4.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Rejang\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"rejang\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansrejang/v18/Ktk2AKuMeZjqPnXgyqrib7DIogqwN4O3WYZB_sU.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Runic\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"runic\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansrunic/v15/H4c_BXWPl9DZ0Xe_nHUaus7W68WWaxpvHtgIYg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans SC\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"chinese-simplified\",\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanssc/v26/k3kJo84MPvpLmixcA63oeALZTYKL2wv287Sb.otf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanssc/v26/k3kIo84MPvpLmixcA63oeALZhaCt9yX6-q2CGg.otf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssc/v26/k3kXo84MPvpLmixcA63oeALhL4iJ-Q7m8w.otf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanssc/v26/k3kIo84MPvpLmixcA63oeALZ3aGt9yX6-q2CGg.otf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanssc/v26/k3kIo84MPvpLmixcA63oeALZlaet9yX6-q2CGg.otf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanssc/v26/k3kIo84MPvpLmixcA63oeALZraWt9yX6-q2CGg.otf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Samaritan\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"samaritan\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssamaritan/v15/buEqppe9f8_vkXadMBJJo0tSmaYjFkxOUo5jNlOVMzQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Saurashtra\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"saurashtra\"\n      ],\n      \"version\": \"v18\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssaurashtra/v18/ea8GacQ0Wfz_XKWXe6OtoA8w8zvmYwTef9ndjhPTSIx9.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Sharada\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"sharada\"\n      ],\n      \"version\": \"v16\",\n      \"lastModified\": \"2022-11-18\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssharada/v16/gok0H7rwAEdtF9N8-mdTGALG6p0kwoXLPOwr4H8a.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Shavian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"shavian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosansshavian/v15/CHy5V_HZE0jxJBQlqAeCKjJvQBNF4EFQSplv2Cwg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Siddham\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"siddham\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssiddham/v17/OZpZg-FwqiNLe9PELUikxTWDoCCeGqndk3Ic92ZH.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans SignWriting\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"signwriting\"\n      ],\n      \"version\": \"v1\",\n      \"lastModified\": \"2023-01-06\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssignwriting/v1/Noas6VX_wIWFbTTCrYmvy9A2UnkL-2SZAWiUEVCARYQemg.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Sinhala\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"sinhala\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanssinhala/v26/yMJ2MJBya43H0SUF_WmcBEEf4rQVO2P524V5N_MxQzQtb-tf5dJbC30Fu9zUwg2b5lgLpJwbQRM.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosanssinhala/v26/yMJ2MJBya43H0SUF_WmcBEEf4rQVO2P524V5N_MxQzQtb-tf5dJbC30Fu9zUwo2a5lgLpJwbQRM.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanssinhala/v26/yMJ2MJBya43H0SUF_WmcBEEf4rQVO2P524V5N_MxQzQtb-tf5dJbC30Fu9zUwlOa5lgLpJwbQRM.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssinhala/v26/yMJ2MJBya43H0SUF_WmcBEEf4rQVO2P524V5N_MxQzQtb-tf5dJbC30Fu9zUwg2a5lgLpJwbQRM.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanssinhala/v26/yMJ2MJBya43H0SUF_WmcBEEf4rQVO2P524V5N_MxQzQtb-tf5dJbC30Fu9zUwj-a5lgLpJwbQRM.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanssinhala/v26/yMJ2MJBya43H0SUF_WmcBEEf4rQVO2P524V5N_MxQzQtb-tf5dJbC30Fu9zUwtOd5lgLpJwbQRM.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanssinhala/v26/yMJ2MJBya43H0SUF_WmcBEEf4rQVO2P524V5N_MxQzQtb-tf5dJbC30Fu9zUwuqd5lgLpJwbQRM.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosanssinhala/v26/yMJ2MJBya43H0SUF_WmcBEEf4rQVO2P524V5N_MxQzQtb-tf5dJbC30Fu9zUwo2d5lgLpJwbQRM.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanssinhala/v26/yMJ2MJBya43H0SUF_WmcBEEf4rQVO2P524V5N_MxQzQtb-tf5dJbC30Fu9zUwqSd5lgLpJwbQRM.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Sogdian\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"sogdian\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssogdian/v15/taiQGn5iC4--qtsfi4Jp6eHPnfxQBo--Pm6KHidM.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Sora Sompeng\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"sora-sompeng\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssorasompeng/v19/PlIRFkO5O6RzLfvNNVSioxM2_OTrEhPyDLolKvCsHzCxWuGkYHR818DpZXJQd4Mu.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanssorasompeng/v19/PlIRFkO5O6RzLfvNNVSioxM2_OTrEhPyDLolKvCsHzCxWuGkYHRO18DpZXJQd4Mu.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanssorasompeng/v19/PlIRFkO5O6RzLfvNNVSioxM2_OTrEhPyDLolKvCsHzCxWuGkYHSi0MDpZXJQd4Mu.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanssorasompeng/v19/PlIRFkO5O6RzLfvNNVSioxM2_OTrEhPyDLolKvCsHzCxWuGkYHSb0MDpZXJQd4Mu.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Soyombo\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"soyombo\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssoyombo/v15/RWmSoL-Y6-8q5LTtXs6MF6q7xsxgY0FrIFOcK25W.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Sundanese\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"sundanese\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssundanese/v19/FwZw7_84xUkosG2xJo2gm7nFwSLQkdymq2mkz3Gz1_b6ctxpNNHCizv7fQES.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanssundanese/v19/FwZw7_84xUkosG2xJo2gm7nFwSLQkdymq2mkz3Gz1_b6ctxbNNHCizv7fQES.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanssundanese/v19/FwZw7_84xUkosG2xJo2gm7nFwSLQkdymq2mkz3Gz1_b6cty3M9HCizv7fQES.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanssundanese/v19/FwZw7_84xUkosG2xJo2gm7nFwSLQkdymq2mkz3Gz1_b6ctyOM9HCizv7fQES.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Syloti Nagri\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"syloti-nagri\"\n      ],\n      \"version\": \"v20\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssylotinagri/v20/uU9eCAQZ75uhfF9UoWDRiY3q7Sf_VFV3m4dGFVfxN87gsj0.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Symbols\",\n      \"variants\": [\n        \"100\",\n        \"200\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\",\n        \"800\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"symbols\"\n      ],\n      \"version\": \"v36\",\n      \"lastModified\": \"2022-09-28\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanssymbols/v36/rP2up3q65FkAtHfwd-eIS2brbDN6gxP34F9jRRCe4W3gfQ4gavVFRkzrbQ.ttf\",\n        \"200\": \"http://fonts.gstatic.com/s/notosanssymbols/v36/rP2up3q65FkAtHfwd-eIS2brbDN6gxP34F9jRRCe4W3g_Q8gavVFRkzrbQ.ttf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanssymbols/v36/rP2up3q65FkAtHfwd-eIS2brbDN6gxP34F9jRRCe4W3gIw8gavVFRkzrbQ.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssymbols/v36/rP2up3q65FkAtHfwd-eIS2brbDN6gxP34F9jRRCe4W3gfQ8gavVFRkzrbQ.ttf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanssymbols/v36/rP2up3q65FkAtHfwd-eIS2brbDN6gxP34F9jRRCe4W3gTw8gavVFRkzrbQ.ttf\",\n        \"600\": \"http://fonts.gstatic.com/s/notosanssymbols/v36/rP2up3q65FkAtHfwd-eIS2brbDN6gxP34F9jRRCe4W3gowggavVFRkzrbQ.ttf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanssymbols/v36/rP2up3q65FkAtHfwd-eIS2brbDN6gxP34F9jRRCe4W3gmgggavVFRkzrbQ.ttf\",\n        \"800\": \"http://fonts.gstatic.com/s/notosanssymbols/v36/rP2up3q65FkAtHfwd-eIS2brbDN6gxP34F9jRRCe4W3g_QggavVFRkzrbQ.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanssymbols/v36/rP2up3q65FkAtHfwd-eIS2brbDN6gxP34F9jRRCe4W3g1AggavVFRkzrbQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Symbols 2\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"symbols\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-12-08\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssymbols2/v17/I_uyMoGduATTei9eI8daxVHDyfisHr71ypPqfX71-AI.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Syriac\",\n      \"variants\": [\n        \"100\",\n        \"regular\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"syriac\"\n      ],\n      \"version\": \"v15\",\n      \"lastModified\": \"2022-05-10\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanssyriac/v15/KtkwAKuMeZjqPnXgyqribqzQqgW0D-e9XaRE7sX5Cg.ttf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanssyriac/v15/Ktk2AKuMeZjqPnXgyqribqzQqgW0N4O3WYZB_sU.ttf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanssyriac/v15/KtkxAKuMeZjqPnXgyqribqzQqgW0DweafY5q4szgE-Q.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans TC\",\n      \"variants\": [\n        \"100\",\n        \"300\",\n        \"regular\",\n        \"500\",\n        \"700\",\n        \"900\"\n      ],\n      \"subsets\": [\n        \"chinese-traditional\",\n        \"latin\"\n      ],\n      \"version\": \"v26\",\n      \"lastModified\": \"2022-09-27\",\n      \"files\": {\n        \"100\": \"http://fonts.gstatic.com/s/notosanstc/v26/-nFlOG829Oofr2wohFbTp9i9WyEJIfNZ1sjy.otf\",\n        \"300\": \"http://fonts.gstatic.com/s/notosanstc/v26/-nFkOG829Oofr2wohFbTp9i9kwMvDd1V39Hr7g.otf\",\n        \"regular\": \"http://fonts.gstatic.com/s/notosanstc/v26/-nF7OG829Oofr2wohFbTp9iFOSsLA_ZJ1g.otf\",\n        \"500\": \"http://fonts.gstatic.com/s/notosanstc/v26/-nFkOG829Oofr2wohFbTp9i9ywIvDd1V39Hr7g.otf\",\n        \"700\": \"http://fonts.gstatic.com/s/notosanstc/v26/-nFkOG829Oofr2wohFbTp9i9gwQvDd1V39Hr7g.otf\",\n        \"900\": \"http://fonts.gstatic.com/s/notosanstc/v26/-nFkOG829Oofr2wohFbTp9i9uwYvDd1V39Hr7g.otf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Tagalog\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tagalog\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanstagalog/v17/J7aFnoNzCnFcV9ZI-sUYuvote1R0wwEAA8jHexnL.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Tagbanwa\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tagbanwa\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanstagbanwa/v17/Y4GWYbB8VTEp4t3MKJSMmQdIKjRtt_nZRjQEaYpGoQ.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Tai Le\",\n      \"variants\": [\n        \"regular\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tai-le\"\n      ],\n      \"version\": \"v17\",\n      \"lastModified\": \"2022-11-09\",\n      \"files\": {\n        \"regular\": \"http://fonts.gstatic.com/s/notosanstaile/v17/vEFK2-VODB8RrNDvZSUmVxEATwR58tK1W77HtMo.ttf\"\n      },\n      \"category\": \"sans-serif\",\n      \"kind\": \"webfonts#webfont\"\n    },\n    {\n      \"family\": \"Noto Sans Tai Tham\",\n      \"variants\": [\n        \"regular\",\n        \"500\",\n        \"600\",\n        \"700\"\n      ],\n      \"subsets\": [\n        \"latin\",\n        \"latin-ext\",\n        \"tai-tham\"\n      ],\n      \"version\": \"v19\",\n      \"lastModified\": \"2022-11-09\",\n    